/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.jboss.logmanager.Configurator;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.config.ErrorManagerConfiguration;
import org.jboss.logmanager.config.FilterConfiguration;
import org.jboss.logmanager.config.FormatterConfiguration;
import org.jboss.logmanager.config.HandlerConfiguration;
import org.jboss.logmanager.config.LogContextConfiguration;
import org.jboss.logmanager.config.LoggerConfiguration;
import org.jboss.logmanager.config.PojoConfiguration;
import org.jboss.logmanager.config.PropertyConfigurable;

public final class PropertyConfigurator
implements Configurator {
    private static final String[] EMPTY_STRINGS = new String[0];
    private static final String ENCODING = "utf-8";
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile(".*\\$\\{.*\\}.*");
    private final LogContextConfiguration config;

    public PropertyConfigurator() {
        this(LogContext.getSystemLogContext());
    }

    public PropertyConfigurator(LogContext context) {
        this.config = LogContextConfiguration.Factory.create(context);
    }

    public LogContextConfiguration getLogContextConfiguration() {
        return this.config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        try {
            properties.load(new InputStreamReader(inputStream, ENCODING));
            inputStream.close();
        }
        finally {
            PropertyConfigurator.safeClose(inputStream);
        }
        this.configure(properties);
    }

    public void writeConfiguration(OutputStream outputStream) throws IOException {
        this.writeConfiguration(outputStream, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeConfiguration(OutputStream outputStream, boolean writeExpressions) throws IOException {
        try {
            PrintStream out = new PrintStream(outputStream, true, ENCODING);
            try {
                HashSet<String> implicitHandlers = new HashSet<String>();
                HashSet<String> implicitFilters = new HashSet<String>();
                HashSet<String> implicitFormatters = new HashSet<String>();
                HashSet<String> implicitErrorManagers = new HashSet<String>();
                List<String> loggerNames = this.config.getLoggerNames();
                PropertyConfigurator.writePropertyComment(out, "Additional loggers to configure (the root logger is always configured)");
                PropertyConfigurator.writeProperty(out, "loggers", PropertyConfigurator.toCsvString(loggerNames));
                LoggerConfiguration rootLogger = this.config.getLoggerConfiguration("");
                PropertyConfigurator.writeLoggerConfiguration(out, rootLogger, implicitHandlers, implicitFilters, writeExpressions);
                loggerNames.remove("");
                for (String loggerName : loggerNames) {
                    PropertyConfigurator.writeLoggerConfiguration(out, this.config.getLoggerConfiguration(loggerName), implicitHandlers, implicitFilters, writeExpressions);
                }
                List<String> allHandlerNames = this.config.getHandlerNames();
                ArrayList<String> explicitHandlerNames = new ArrayList<String>(allHandlerNames);
                explicitHandlerNames.removeAll(implicitHandlers);
                if (!explicitHandlerNames.isEmpty()) {
                    PropertyConfigurator.writePropertyComment(out, "Additional handlers to configure");
                    PropertyConfigurator.writeProperty(out, "handlers", PropertyConfigurator.toCsvString(explicitHandlerNames));
                    out.println();
                }
                for (String handlerName : allHandlerNames) {
                    PropertyConfigurator.writeHandlerConfiguration(out, this.config.getHandlerConfiguration(handlerName), implicitHandlers, implicitFilters, implicitFormatters, implicitErrorManagers, writeExpressions);
                }
                List<String> allFilterNames = this.config.getFilterNames();
                ArrayList<String> explicitFilterNames = new ArrayList<String>(allFilterNames);
                explicitFilterNames.removeAll(implicitFilters);
                if (!explicitFilterNames.isEmpty()) {
                    PropertyConfigurator.writePropertyComment(out, "Additional filters to configure");
                    PropertyConfigurator.writeProperty(out, "filters", PropertyConfigurator.toCsvString(explicitFilterNames));
                    out.println();
                }
                for (String filterName : allFilterNames) {
                    PropertyConfigurator.writeFilterConfiguration(out, this.config.getFilterConfiguration(filterName), writeExpressions);
                }
                List<String> allFormatterNames = this.config.getFormatterNames();
                ArrayList<String> explicitFormatterNames = new ArrayList<String>(allFormatterNames);
                explicitFormatterNames.removeAll(implicitFormatters);
                if (!explicitFormatterNames.isEmpty()) {
                    PropertyConfigurator.writePropertyComment(out, "Additional formatters to configure");
                    PropertyConfigurator.writeProperty(out, "formatters", PropertyConfigurator.toCsvString(explicitFormatterNames));
                    out.println();
                }
                for (String formatterName : allFormatterNames) {
                    PropertyConfigurator.writeFormatterConfiguration(out, this.config.getFormatterConfiguration(formatterName), writeExpressions);
                }
                List<String> allErrorManagerNames = this.config.getErrorManagerNames();
                ArrayList<String> explicitErrorManagerNames = new ArrayList<String>(allErrorManagerNames);
                explicitErrorManagerNames.removeAll(implicitErrorManagers);
                if (!explicitErrorManagerNames.isEmpty()) {
                    PropertyConfigurator.writePropertyComment(out, "Additional errorManagers to configure");
                    PropertyConfigurator.writeProperty(out, "errorManagers", PropertyConfigurator.toCsvString(explicitErrorManagerNames));
                    out.println();
                }
                for (String errorManagerName : allErrorManagerNames) {
                    PropertyConfigurator.writeErrorManagerConfiguration(out, this.config.getErrorManagerConfiguration(errorManagerName), writeExpressions);
                }
                List<String> pojoNames = this.config.getPojoNames();
                if (!pojoNames.isEmpty()) {
                    PropertyConfigurator.writePropertyComment(out, "POJOs to configure");
                    PropertyConfigurator.writeProperty(out, "pojos", PropertyConfigurator.toCsvString(pojoNames));
                    for (String pojoName : pojoNames) {
                        PropertyConfigurator.writePojoConfiguration(out, this.config.getPojoConfiguration(pojoName), writeExpressions);
                    }
                }
                out.close();
            }
            finally {
                PropertyConfigurator.safeClose(out);
            }
            outputStream.close();
        }
        finally {
            PropertyConfigurator.safeClose(outputStream);
        }
    }

    private static void writeLoggerConfiguration(PrintStream out, LoggerConfiguration logger2, Set<String> implicitHandlers, Set<String> implicitFilters, boolean writeExpressions) {
        if (logger2 != null) {
            List<String> handlerNames;
            String useParentHandlersValue;
            String filterName;
            String level;
            out.println();
            String name = logger2.getName();
            String prefix = name.isEmpty() ? "logger." : "logger." + name + ".";
            String string = level = writeExpressions ? logger2.getLevelValueExpression().getValue() : logger2.getLevel();
            if (level != null) {
                PropertyConfigurator.writeProperty(out, prefix, "level", level);
            }
            String string2 = filterName = writeExpressions ? logger2.getFilterValueExpression().getValue() : logger2.getFilter();
            if (filterName != null) {
                PropertyConfigurator.writeProperty(out, prefix, "filter", filterName);
                implicitFilters.add(logger2.getFilter());
            }
            Boolean useParentHandlers = logger2.getUseParentHandlers();
            String string3 = writeExpressions ? logger2.getUseParentHandlersValueExpression().getValue() : (useParentHandlersValue = useParentHandlers == null ? null : useParentHandlers.toString());
            if (useParentHandlersValue != null) {
                PropertyConfigurator.writeProperty(out, prefix, "useParentHandlers", useParentHandlersValue);
            }
            if (!(handlerNames = logger2.getHandlerNames()).isEmpty()) {
                PropertyConfigurator.writeProperty(out, prefix, "handlers", PropertyConfigurator.toCsvString(handlerNames));
                for (String handlerName : handlerNames) {
                    implicitHandlers.add(handlerName);
                }
            }
        }
    }

    private static void writeHandlerConfiguration(PrintStream out, HandlerConfiguration handler, Set<String> implicitHandlers, Set<String> implicitFilters, Set<String> implicitFormatters, Set<String> implicitErrorManagers, boolean writeExpressions) {
        if (handler != null) {
            List<String> postConfigurationMethods;
            List<String> handlerNames;
            String errorManagerName;
            String formatterName;
            String filter;
            String encoding;
            String level;
            out.println();
            String name = handler.getName();
            String prefix = "handler." + name + ".";
            String className = handler.getClassName();
            PropertyConfigurator.writeProperty(out, "handler.", name, className);
            String moduleName = handler.getModuleName();
            if (moduleName != null) {
                PropertyConfigurator.writeProperty(out, prefix, "module", moduleName);
            }
            String string = level = writeExpressions ? handler.getLevelValueExpression().getValue() : handler.getLevel();
            if (level != null) {
                PropertyConfigurator.writeProperty(out, prefix, "level", level);
            }
            String string2 = encoding = writeExpressions ? handler.getEncodingValueExpression().getValue() : handler.getEncoding();
            if (encoding != null) {
                PropertyConfigurator.writeProperty(out, prefix, "encoding", encoding);
            }
            String string3 = filter = writeExpressions ? handler.getFilterValueExpression().getValue() : handler.getFilter();
            if (filter != null) {
                PropertyConfigurator.writeProperty(out, prefix, "filter", filter);
                implicitFilters.add(handler.getFilter());
            }
            String string4 = formatterName = writeExpressions ? handler.getFormatterNameValueExpression().getValue() : handler.getFormatterName();
            if (formatterName != null) {
                PropertyConfigurator.writeProperty(out, prefix, "formatter", formatterName);
                implicitFormatters.add(handler.getFormatterName());
            }
            String string5 = errorManagerName = writeExpressions ? handler.getErrorManagerNameValueExpression().getValue() : handler.getErrorManagerName();
            if (errorManagerName != null) {
                PropertyConfigurator.writeProperty(out, prefix, "errorManager", errorManagerName);
                implicitErrorManagers.add(handler.getErrorManagerName());
            }
            if (!(handlerNames = handler.getHandlerNames()).isEmpty()) {
                PropertyConfigurator.writeProperty(out, prefix, "handlers", PropertyConfigurator.toCsvString(handlerNames));
                for (String handlerName : handlerNames) {
                    implicitHandlers.add(handlerName);
                }
            }
            if (!(postConfigurationMethods = handler.getPostConfigurationMethods()).isEmpty()) {
                PropertyConfigurator.writeProperty(out, prefix, "postConfiguration", PropertyConfigurator.toCsvString(postConfigurationMethods));
            }
            PropertyConfigurator.writeProperties(out, prefix, handler, writeExpressions);
        }
    }

    private static void writeFilterConfiguration(PrintStream out, FilterConfiguration filter, boolean writeExpressions) {
        if (filter != null) {
            List<String> postConfigurationMethods;
            out.println();
            String name = filter.getName();
            String prefix = "filter." + name + ".";
            String className = filter.getClassName();
            PropertyConfigurator.writeProperty(out, "filter.", name, className);
            String moduleName = filter.getModuleName();
            if (moduleName != null) {
                PropertyConfigurator.writeProperty(out, prefix, "module", moduleName);
            }
            if (!(postConfigurationMethods = filter.getPostConfigurationMethods()).isEmpty()) {
                PropertyConfigurator.writeProperty(out, prefix, "postConfiguration", PropertyConfigurator.toCsvString(postConfigurationMethods));
            }
            PropertyConfigurator.writeProperties(out, prefix, filter, writeExpressions);
        }
    }

    private static void writeFormatterConfiguration(PrintStream out, FormatterConfiguration formatter, boolean writeExpressions) {
        if (formatter != null) {
            List<String> postConfigurationMethods;
            out.println();
            String name = formatter.getName();
            String prefix = "formatter." + name + ".";
            String className = formatter.getClassName();
            PropertyConfigurator.writeProperty(out, "formatter.", name, className);
            String moduleName = formatter.getModuleName();
            if (moduleName != null) {
                PropertyConfigurator.writeProperty(out, prefix, "module", moduleName);
            }
            if (!(postConfigurationMethods = formatter.getPostConfigurationMethods()).isEmpty()) {
                PropertyConfigurator.writeProperty(out, prefix, "postConfiguration", PropertyConfigurator.toCsvString(postConfigurationMethods));
            }
            PropertyConfigurator.writeProperties(out, prefix, formatter, writeExpressions);
        }
    }

    private static void writeErrorManagerConfiguration(PrintStream out, ErrorManagerConfiguration errorManager, boolean writeExpressions) {
        if (errorManager != null) {
            List<String> postConfigurationMethods;
            out.println();
            String name = errorManager.getName();
            String prefix = "errorManager." + name + ".";
            String className = errorManager.getClassName();
            PropertyConfigurator.writeProperty(out, "errorManager.", name, className);
            String moduleName = errorManager.getModuleName();
            if (moduleName != null) {
                PropertyConfigurator.writeProperty(out, prefix, "module", moduleName);
            }
            if (!(postConfigurationMethods = errorManager.getPostConfigurationMethods()).isEmpty()) {
                PropertyConfigurator.writeProperty(out, prefix, "postConfiguration", PropertyConfigurator.toCsvString(postConfigurationMethods));
            }
            PropertyConfigurator.writeProperties(out, prefix, errorManager, writeExpressions);
        }
    }

    private static void writePojoConfiguration(PrintStream out, PojoConfiguration pojo, boolean writeExpressions) {
        if (pojo != null) {
            List<String> postConfigurationMethods;
            out.println();
            String name = pojo.getName();
            String prefix = "pojo." + name + ".";
            String className = pojo.getClassName();
            PropertyConfigurator.writeProperty(out, "pojo.", name, className);
            String moduleName = pojo.getModuleName();
            if (moduleName != null) {
                PropertyConfigurator.writeProperty(out, prefix, "module", moduleName);
            }
            if (!(postConfigurationMethods = pojo.getPostConfigurationMethods()).isEmpty()) {
                PropertyConfigurator.writeProperty(out, prefix, "postConfiguration", PropertyConfigurator.toCsvString(postConfigurationMethods));
            }
            PropertyConfigurator.writeProperties(out, prefix, pojo, writeExpressions);
        }
    }

    private static void writePropertyComment(PrintStream out, String comment) {
        out.printf("%n# %s%n", comment);
    }

    private static void writeProperty(PrintStream out, String name, String value) {
        PropertyConfigurator.writeProperty(out, null, name, value);
    }

    private static void writeProperty(PrintStream out, String prefix, String name, String value) {
        if (prefix == null) {
            PropertyConfigurator.writeKey(out, name);
        } else {
            PropertyConfigurator.writeKey(out, String.format("%s%s", prefix, name));
        }
        PropertyConfigurator.writeValue(out, value);
        out.println();
    }

    private static void writeProperties(PrintStream out, String prefix, PropertyConfigurable propertyConfigurable, boolean writeExpression) {
        block8: {
            List<String> names = propertyConfigurable.getPropertyNames();
            if (names.isEmpty()) break block8;
            List<String> ctorProps = propertyConfigurable.getConstructorProperties();
            if (prefix == null) {
                PropertyConfigurator.writeProperty(out, "properties", PropertyConfigurator.toCsvString(names));
                if (!ctorProps.isEmpty()) {
                    PropertyConfigurator.writeProperty(out, "constructorProperties", PropertyConfigurator.toCsvString(ctorProps));
                }
                for (String name : names) {
                    if (writeExpression) {
                        PropertyConfigurator.writeProperty(out, name, propertyConfigurable.getPropertyValueExpression(name).getValue());
                        continue;
                    }
                    PropertyConfigurator.writeProperty(out, name, propertyConfigurable.getPropertyValueString(name));
                }
            } else {
                PropertyConfigurator.writeProperty(out, prefix, "properties", PropertyConfigurator.toCsvString(names));
                if (!ctorProps.isEmpty()) {
                    PropertyConfigurator.writeProperty(out, prefix, "constructorProperties", PropertyConfigurator.toCsvString(ctorProps));
                }
                for (String name : names) {
                    if (writeExpression) {
                        PropertyConfigurator.writeProperty(out, prefix, name, propertyConfigurable.getPropertyValueExpression(name).getValue());
                        continue;
                    }
                    PropertyConfigurator.writeProperty(out, prefix, name, propertyConfigurable.getPropertyValueString(name));
                }
            }
        }
    }

    private static String toCsvString(List<String> names) {
        StringBuilder result = new StringBuilder(1024);
        Iterator<String> iterator = names.iterator();
        while (iterator.hasNext()) {
            String name = iterator.next();
            if (name.isEmpty()) continue;
            result.append(name);
            if (!iterator.hasNext()) continue;
            result.append(",");
        }
        return result.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Properties properties) throws IOException {
        try {
            this.configureLogger(properties, "");
            for (String loggerName : PropertyConfigurator.getStringCsvArray(properties, "loggers")) {
                this.configureLogger(properties, loggerName);
            }
            for (String handlerName : PropertyConfigurator.getStringCsvArray(properties, "handlers")) {
                this.configureHandler(properties, handlerName);
            }
            for (String filterName : PropertyConfigurator.getStringCsvArray(properties, "filters")) {
                this.configureFilter(properties, filterName);
            }
            for (String formatterName : PropertyConfigurator.getStringCsvArray(properties, "formatters")) {
                this.configureFormatter(properties, formatterName);
            }
            for (String errorManagerName : PropertyConfigurator.getStringCsvArray(properties, "errorManagers")) {
                this.configureErrorManager(properties, errorManagerName);
            }
            for (String pojoName : PropertyConfigurator.getStringCsvArray(properties, "pojos")) {
                this.configurePojos(properties, pojoName);
            }
            this.config.commit();
        }
        finally {
            this.config.forget();
        }
    }

    private void configureLogger(Properties properties, String loggerName) {
        String filterName;
        if (this.config.getLoggerConfiguration(loggerName) != null) {
            return;
        }
        LoggerConfiguration loggerConfiguration = this.config.addLoggerConfiguration(loggerName);
        String levelName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("logger", loggerName, "level"));
        if (levelName != null) {
            loggerConfiguration.setLevel(levelName);
        }
        if ((filterName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("logger", loggerName, "filter"))) != null) {
            loggerConfiguration.setFilter(filterName);
            String resolvedFilter = loggerConfiguration.getFilterValueExpression().getResolvedValue();
            String filterClassName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("filter", resolvedFilter));
            if (filterClassName != null) {
                this.configureFilter(properties, resolvedFilter);
            }
        }
        String[] handlerNames = PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("logger", loggerName, "handlers"));
        loggerConfiguration.setHandlerNames(handlerNames);
        for (String name : handlerNames) {
            this.configureHandler(properties, name);
        }
        String useParentHandlersString = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("logger", loggerName, "useParentHandlers"));
        if (useParentHandlersString != null) {
            if (EXPRESSION_PATTERN.matcher(useParentHandlersString).matches()) {
                loggerConfiguration.setUseParentHandlers(useParentHandlersString);
            } else {
                loggerConfiguration.setUseParentHandlers(Boolean.parseBoolean(useParentHandlersString));
            }
        }
    }

    private void configureFilter(Properties properties, String filterName) {
        if (this.config.getFilterConfiguration(filterName) != null) {
            return;
        }
        FilterConfiguration configuration = this.config.addFilterConfiguration(PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("filter", filterName, "module")), PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("filter", filterName)), filterName, PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("filter", filterName, "constructorProperties")));
        String[] postConfigurationMethods = PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("filter", filterName, "postConfiguration"));
        configuration.setPostConfigurationMethods(postConfigurationMethods);
        this.configureProperties(properties, configuration, PropertyConfigurator.getKey("filter", filterName));
    }

    private void configureFormatter(Properties properties, String formatterName) {
        if (this.config.getFormatterConfiguration(formatterName) != null) {
            return;
        }
        FormatterConfiguration configuration = this.config.addFormatterConfiguration(PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("formatter", formatterName, "module")), PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("formatter", formatterName)), formatterName, PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("formatter", formatterName, "constructorProperties")));
        String[] postConfigurationMethods = PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("formatter", formatterName, "postConfiguration"));
        configuration.setPostConfigurationMethods(postConfigurationMethods);
        this.configureProperties(properties, configuration, PropertyConfigurator.getKey("formatter", formatterName));
    }

    private void configureErrorManager(Properties properties, String errorManagerName) {
        if (this.config.getErrorManagerConfiguration(errorManagerName) != null) {
            return;
        }
        ErrorManagerConfiguration configuration = this.config.addErrorManagerConfiguration(PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("errorManager", errorManagerName, "module")), PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("errorManager", errorManagerName)), errorManagerName, PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("errorManager", errorManagerName, "constructorProperties")));
        String[] postConfigurationMethods = PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("errorManager", errorManagerName, "postConfiguration"));
        configuration.setPostConfigurationMethods(postConfigurationMethods);
        this.configureProperties(properties, configuration, PropertyConfigurator.getKey("errorManager", errorManagerName));
    }

    private void configureHandler(Properties properties, String handlerName) {
        String errorManagerName;
        String encoding;
        String formatterName;
        String levelName;
        if (this.config.getHandlerConfiguration(handlerName) != null) {
            return;
        }
        HandlerConfiguration configuration = this.config.addHandlerConfiguration(PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("handler", handlerName, "module")), PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("handler", handlerName)), handlerName, PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("handler", handlerName, "constructorProperties")));
        String filter = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("handler", handlerName, "filter"));
        if (filter != null) {
            configuration.setFilter(filter);
            String resolvedFilter = configuration.getFilterValueExpression().getResolvedValue();
            String filterClassName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("filter", resolvedFilter));
            if (filterClassName != null) {
                this.configureFilter(properties, resolvedFilter);
            }
        }
        if ((levelName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("handler", handlerName, "level"))) != null) {
            configuration.setLevel(levelName);
        }
        if ((formatterName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("handler", handlerName, "formatter"))) != null) {
            configuration.setFormatterName(formatterName);
            this.configureFormatter(properties, configuration.getFormatterNameValueExpression().getResolvedValue());
        }
        if ((encoding = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("handler", handlerName, "encoding"))) != null) {
            configuration.setEncoding(encoding);
        }
        if ((errorManagerName = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("handler", handlerName, "errorManager"))) != null) {
            configuration.setErrorManagerName(errorManagerName);
            this.configureErrorManager(properties, configuration.getErrorManagerNameValueExpression().getResolvedValue());
        }
        String[] handlerNames = PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("handler", handlerName, "handlers"));
        configuration.setHandlerNames(handlerNames);
        for (String name : handlerNames) {
            this.configureHandler(properties, name);
        }
        String[] postConfigurationMethods = PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("handler", handlerName, "postConfiguration"));
        configuration.setPostConfigurationMethods(postConfigurationMethods);
        this.configureProperties(properties, configuration, PropertyConfigurator.getKey("handler", handlerName));
    }

    private void configurePojos(Properties properties, String pojoName) {
        if (this.config.getPojoConfiguration(pojoName) != null) {
            return;
        }
        PojoConfiguration configuration = this.config.addPojoConfiguration(PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("pojo", pojoName, "module")), PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey("pojo", pojoName)), pojoName, PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("pojo", pojoName, "constructorProperties")));
        String[] postConfigurationMethods = PropertyConfigurator.getStringCsvArray(properties, PropertyConfigurator.getKey("pojo", pojoName, "postConfiguration"));
        configuration.setPostConfigurationMethods(postConfigurationMethods);
        this.configureProperties(properties, configuration, PropertyConfigurator.getKey("pojo", pojoName));
    }

    private void configureProperties(Properties properties, PropertyConfigurable configurable, String prefix) {
        List<String> propertyNames = PropertyConfigurator.getStringCsvList(properties, PropertyConfigurator.getKey(prefix, "properties"));
        for (String propertyName : propertyNames) {
            String valueString = PropertyConfigurator.getStringProperty(properties, PropertyConfigurator.getKey(prefix, propertyName));
            if (valueString == null) continue;
            configurable.setPropertyValueString(propertyName, valueString);
        }
    }

    private static String getKey(String prefix, String objectName) {
        return objectName.length() > 0 ? prefix + "." + objectName : prefix;
    }

    private static String getKey(String prefix, String objectName, String key) {
        return objectName.length() > 0 ? prefix + "." + objectName + "." + key : prefix + "." + key;
    }

    private static String getStringProperty(Properties properties, String key) {
        return properties.getProperty(key);
    }

    private static String[] getStringCsvArray(Properties properties, String key) {
        String property = properties.getProperty(key, "");
        if (property == null) {
            return EMPTY_STRINGS;
        }
        String value = property.trim();
        if (value.length() == 0) {
            return EMPTY_STRINGS;
        }
        return value.split("\\s*,\\s*");
    }

    private static List<String> getStringCsvList(Properties properties, String key) {
        return new ArrayList<String>(Arrays.asList(PropertyConfigurator.getStringCsvArray(properties, key)));
    }

    private static void writeValue(PrintStream out, String value) {
        PropertyConfigurator.writeSanitized(out, value, false);
    }

    private static void writeKey(PrintStream out, String key) {
        PropertyConfigurator.writeSanitized(out, key, true);
        out.append('=');
    }

    private static void writeSanitized(PrintStream out, String string, boolean escapeSpaces) {
        block8: for (int x = 0; x < string.length(); ++x) {
            char c = string.charAt(x);
            switch (c) {
                case ' ': {
                    if (x == 0 || escapeSpaces) {
                        out.append('\\');
                    }
                    out.append(c);
                    continue block8;
                }
                case '\t': {
                    out.append('\\').append('t');
                    continue block8;
                }
                case '\n': {
                    out.append('\\').append('n');
                    continue block8;
                }
                case '\r': {
                    out.append('\\').append('r');
                    continue block8;
                }
                case '\f': {
                    out.append('\\').append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    out.append('\\').append(c);
                    continue block8;
                }
                default: {
                    out.append(c);
                }
            }
        }
    }

    private static void safeClose(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

