/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.portland.dmdb;

import com.cisco.dcbu.dm.AbstractPort;
import com.cisco.dcbu.dm.DeviceManager;
import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.dm.PhysicalElement;
import com.cisco.dcbu.dm.PhysicalView;
import com.cisco.dcbu.dmdb.andiamo.elements.EthernetPort;
import com.cisco.dcbu.dmdb.andiamo.elements.SatChassisIf;
import com.cisco.dcbu.dmdb.andiamo.elements.SatUplinkPort;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.mds.FRUConstants;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.IntArray;
import com.cisco.dcbu.lib.util.vsif.VSifObj;
import com.cisco.dcbu.portland.dmdb.elements.N5KEthPort;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public final class N5KPostPollUpdater {
    private static N5KPostPollUpdater INSTANCE;
    Map<Integer, Integer> mVSifIfIndexToStatusHash;
    Map<Integer, IntArray> mEthPortIfIndexToViglessVSifIfIndicesMap = new TreeMap<Integer, IntArray>();
    Map<String, Integer> mSatUplinkPortConnectivityMap;
    Map<Integer, String> mReverseSatUplinkPortConnectivityMap;
    Map<Integer, EthernetPort> mSatUplinkPortToEthPEMap;
    TreeMap<Integer, Integer> mVsifIfIndexToModeMap = new TreeMap();
    private static String FEX_STR;
    private static String ETH_STR;
    private static String PORT_STR;

    private N5KPostPollUpdater() {
    }

    public static synchronized N5KPostPollUpdater getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new N5KPostPollUpdater();
        }
        return INSTANCE;
    }

    public void update(IfIndexIf pIfIndexIf) {
        this.updateVSif(pIfIndexIf);
        this.updateSatUplinkPortInfo(pIfIndexIf);
        this.updatePhysicalView(pIfIndexIf);
    }

    public void updateVSif(IfIndexIf pIfIndexIf) {
        block2: {
            try {
                VSifObj lvsifObj = null;
                lvsifObj = VSifObj.get((SnmpPeer)Discover.getPeer(), (IfIndexIf)pIfIndexIf, (byte[])new byte[]{4, 2, 9});
                this.mEthPortIfIndexToViglessVSifIfIndicesMap = lvsifObj.getEthPortIfIndexToVSifIfIndicesMap();
                this.mVSifIfIndexToStatusHash = lvsifObj.getVSifIndexToStatusMap();
                this.mVsifIfIndexToModeMap = lvsifObj.getVSifIndexToModeMap();
            }
            catch (Exception ex) {
                DefaultLogger._DefLogger.debug((Object)ex);
                if (!SnmpSession.isTrace()) break block2;
                DefaultLogger._DefLogger.debug((Object)("Failed to get vigs/vsifs: " + ex));
            }
        }
    }

    public void updateSatUplinkPortInfo(IfIndexIf pIfIndexIf) {
        block5: {
            try {
                if (this.mSatUplinkPortConnectivityMap == null) {
                    this.mSatUplinkPortConnectivityMap = new HashMap<String, Integer>();
                    this.mReverseSatUplinkPortConnectivityMap = new HashMap<Integer, String>();
                    this.mSatUplinkPortToEthPEMap = new HashMap<Integer, EthernetPort>();
                } else {
                    this.mSatUplinkPortConnectivityMap.clear();
                    this.mReverseSatUplinkPortConnectivityMap.clear();
                    this.mSatUplinkPortToEthPEMap.clear();
                }
                VarBindList vbl = new VarBindList(1);
                vbl.add(MibNode.get((String)"entPhysicalDescr").getOid());
                SnmpPDU rspPdu = SnmpFetch.getBulkWithStartIndexFix((SnmpPeer)Discover.getPeer(), (VarBindList)vbl, (int)0, (int[])new int[]{FRUConstants.getCableOffset((boolean)Discover.isSysVersionGreaterThanEqual((String)"5.0(0)")) - 1}, (int[])new int[]{FRUConstants.getCableStopOffset((boolean)Discover.isSysVersionGreaterThanEqual((String)"5.0(0)"))});
                VarBindList rspVbl = rspPdu.getVariables();
                int size = rspVbl.size();
                for (int i = 0; i < size; ++i) {
                    String value = rspVbl.stringValue(i);
                    String key = value.substring(0, value.indexOf(" to Core Port"));
                    String ethPortStr = value.substring(value.indexOf(ETH_STR), value.indexOf(" Cable"));
                    int ethPortIfIndex = pIfIndexIf.nameToIfIndex(ethPortStr);
                    this.mSatUplinkPortConnectivityMap.put(key, ethPortIfIndex);
                    this.mReverseSatUplinkPortConnectivityMap.put(ethPortIfIndex, key);
                }
            }
            catch (SnmpException ex) {
                DefaultLogger._DefLogger.debug((Object)ex);
                if (!SnmpSession.isTrace()) break block5;
                DefaultLogger._DefLogger.debug((Object)("Failed to get Uplink Port info: " + (Object)((Object)ex)));
            }
        }
    }

    public Set<Integer> getEthIfIndicesAttachedToFex(IfIndexIf pIfIndexIf) {
        this.updateSatUplinkPortInfo(pIfIndexIf);
        return this.mReverseSatUplinkPortConnectivityMap != null ? this.mReverseSatUplinkPortConnectivityMap.keySet() : Collections.EMPTY_SET;
    }

    public Map<Integer, Integer> getVSifIndexStatusMap() {
        return this.mVSifIfIndexToStatusHash;
    }

    public Map<Integer, Integer> getVSifIndexToModeMap() {
        return this.mVsifIfIndexToModeMap;
    }

    private String getConnectedSatPort(int pEthPortIfIndex) {
        return this.mReverseSatUplinkPortConnectivityMap != null ? this.mReverseSatUplinkPortConnectivityMap.get(pEthPortIfIndex) : null;
    }

    private int getConnectedEthPort(String pSatPort) {
        return this.mSatUplinkPortConnectivityMap != null && this.mSatUplinkPortConnectivityMap.containsKey(pSatPort) ? this.mSatUplinkPortConnectivityMap.get(pSatPort) : 0;
    }

    private int[] getVsifsForEthPort(int pEthPortIfIndex, IfIndexIf pIfIndexIf) {
        int[] vsifsIfIndices = null;
        if (this.mEthPortIfIndexToViglessVSifIfIndicesMap.containsKey(pEthPortIfIndex)) {
            IntArray vsifs = this.mEthPortIfIndexToViglessVSifIfIndicesMap.get(pEthPortIfIndex);
            vsifsIfIndices = vsifs.toArray();
            Arrays.sort(vsifsIfIndices);
        }
        return vsifsIfIndices;
    }

    void updatePhysicalView(IfIndexIf pIfIndexIf) {
        PhysicalView view = DeviceManager.getInstance().getView();
        Array elements = view.getElements();
        for (int i = 0; i < elements.size(); ++i) {
            PhysicalElement elem;
            PhysicalElement e = (PhysicalElement)elements.elementAt(i);
            if (e instanceof N5KEthPort) {
                int index = e.getIndex()[0];
                int[] vsifsIfIndices = this.getVsifsForEthPort(index, pIfIndexIf);
                String satPortKey = this.getConnectedSatPort(index);
                ((N5KEthPort)e).update(vsifsIfIndices, this.mVSifIfIndexToStatusHash, this.mVsifIfIndexToModeMap, satPortKey);
                if (satPortKey == null) continue;
                this.mSatUplinkPortToEthPEMap.put(new Integer(index), (EthernetPort)e);
                continue;
            }
            if (!(e instanceof SatUplinkPort) || !((elem = e.getParent().getParent()) instanceof SatChassisIf)) continue;
            String key = FEX_STR + ((SatChassisIf)elem).getSatSwitchId() + PORT_STR + e.getIndex()[0];
            int ethPortIfIndex = this.getConnectedEthPort(key);
            ((SatUplinkPort)e).update(view, ethPortIfIndex, (AbstractPort)this.mSatUplinkPortToEthPEMap.get(ethPortIfIndex));
        }
    }

    static {
        FEX_STR = "Fex-";
        ETH_STR = "eth";
        PORT_STR = " Port ";
    }
}

