/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.portland.dmdb.elements;

import com.cisco.dcbu.dm.Discover;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.portland.dmdb.elements.N5KCard;
import com.cisco.dcbu.portland.dmdb.elements.N5KPort;
import com.cisco.dcbu.portland.dmdb.elements.N6KEthPort;

public abstract class N6KCard
extends N5KCard {
    @Override
    protected Class[] discoverPorts() throws Exception {
        this._PortClass = new Class[this.getNumPorts()];
        int slot = this.getIndex()[0] - 22;
        int[] vendorType = MibNode.get((String)"entPhysicalVendorType").getOid();
        VarBindList lVbl = new VarBindList(1);
        lVbl.add(vendorType);
        int portStartIndex = 4949 + 256 * (slot - 1);
        int portEndIndex = portStartIndex + this.getNumPorts() + 1;
        try {
            SnmpPDU resp = SnmpFetch.getBulkWithStartIndexFix((SnmpPeer)Discover.getPeer(), (VarBindList)lVbl, (int)0, (int[])new int[]{portStartIndex}, (int[])new int[]{portEndIndex});
            if (resp.getVariables().size() == 0 || resp.getVariables().size() < this.getNumPorts()) {
                return null;
            }
            for (int i = 0; i < resp.getVariables().size(); ++i) {
                SnmpVarBind vb = resp.getVariables().get(i);
                if (!vb.getOid().startsWith(vendorType)) continue;
                SnmpOID oid = (SnmpOID)vb.getVar();
                int[] entityVendorType = oid.getValue();
                this._PortClass[i] = this.isFCPortType(entityVendorType) ? N5KPort.class : N6KEthPort.class;
            }
        }
        catch (SnmpException ex) {
            throw new Exception("discoverPorts: " + (Object)((Object)ex));
        }
        return this._PortClass;
    }

    public int[] getStatusIndex(int[] index) {
        int[] cardIndex = new int[]{index[0] - 1};
        return cardIndex;
    }

    @Override
    public abstract int getNumPorts();
}

