/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.bus;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkConnector;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvPolyPointsInterface;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.graphlayout.bus.IlvBusLayout;
import ilog.views.graphlayout.internalutil.LayoutUtil;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import ilog.views.linkconnector.IlvClippingLinkConnector;
import ilog.views.linkconnector.IlvFreeLinkConnector;
import java.io.IOException;

public class IlvBusLinkConnector
extends IlvLinkConnector {
    private float a = 10.0f;
    private int b = 0;
    private IlvPoint c = new IlvPoint();

    public IlvBusLinkConnector() {
    }

    public IlvBusLinkConnector(IlvPolyPointsInterface ilvPolyPointsInterface) {
        super((IlvGraphic)ilvPolyPointsInterface);
    }

    public IlvBusLinkConnector(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        this.setMargin(ilvInputStream.readFloat("margin"));
        try {
            this.a(ilvInputStream.readInt("nodePosition"));
        }
        catch (IlvReadFileException ilvReadFileException) {
            // empty catch block
        }
    }

    public boolean isPersistent() {
        return true;
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("margin", this.getMargin());
        ilvOutputStream.write("nodePosition", this.a());
    }

    public synchronized void attach(IlvGraphic ilvGraphic, boolean bl) {
        if (ilvGraphic == null) {
            throw new IllegalArgumentException("busNode must not be null");
        }
        if (!(ilvGraphic instanceof IlvPolyPointsInterface)) {
            throw new IllegalArgumentException("the bus object is not an instance of IlvPolyPointsInterface");
        }
        super.attach(ilvGraphic, bl);
    }

    final void a(IlvBusLayout ilvBusLayout) {
        if (ilvBusLayout != null) {
            ilvBusLayout.setConnectionOnBusMargin(this.getMargin());
        }
    }

    public IlvPoint getConnectionPoint(IlvLinkImage ilvLinkImage, boolean bl, IlvTransformer ilvTransformer) {
        boolean bl2;
        IlvPoint ilvPoint;
        IlvPolyPointsInterface ilvPolyPointsInterface = (IlvPolyPointsInterface)this.getNode();
        IlvGraphic ilvGraphic = ilvLinkImage.getOpposite(this.getNode());
        if (ilvGraphic == ilvPolyPointsInterface) {
            IlvRect ilvRect = ilvGraphic.boundingBox(ilvTransformer);
            this.c.move(ilvRect.x + ilvRect.width * 0.5f, ilvRect.y + ilvRect.height * 0.5f);
            return this.c;
        }
        IlvRect ilvRect = LayoutUtil.BoundingBox((IlvGraphic)ilvPolyPointsInterface, ilvTransformer);
        IlvRect ilvRect2 = LayoutUtil.BoundingBox(ilvGraphic, ilvTransformer);
        IlvRect ilvRect3 = ilvGraphic.boundingBox(ilvTransformer);
        this.c.move(ilvRect3.x + ilvRect3.width * 0.5f, ilvRect3.y + ilvRect3.height * 0.5f);
        IlvLinkConnector ilvLinkConnector = IlvLinkConnector.Get((IlvLinkImage)ilvLinkImage, (!bl ? 1 : 0) != 0);
        if (ilvLinkConnector instanceof IlvClippingLinkConnector) {
            ilvPoint = ((IlvClippingLinkConnector)ilvLinkConnector).getUnclippedConnectionPoint(ilvLinkImage, !bl, ilvTransformer);
            this.c.x = ilvPoint.x;
        } else if (ilvLinkConnector instanceof IlvFreeLinkConnector && (ilvPoint = ((IlvFreeLinkConnector)ilvLinkConnector).getConnectionPoint(ilvLinkImage, !bl, ilvTransformer)) != null) {
            this.c.x = ilvPoint.x;
        }
        boolean bl3 = bl2 = ilvTransformer == null || ilvTransformer.isIdentity();
        if (!bl2) {
            ilvTransformer.inverse(this.c);
        }
        float f = this.c.x;
        float f2 = this.getMargin();
        if (2.0f * f2 >= ilvRect.width) {
            f2 = ilvRect.width * 0.5f;
        }
        f = Math.max(ilvRect.x + f2, f);
        f = Math.min(ilvRect.x + ilvRect.width - f2, f);
        int n = ilvPolyPointsInterface.getPointsCardinal();
        int n2 = this.a();
        for (int i = 0; i < n; i += 2) {
            IlvPoint ilvPoint2 = ilvPolyPointsInterface.getPointAt(i, null);
            if (!(ilvRect2.y < ilvPoint2.y)) continue;
            if (i >= 2 && n2 == 1) {
                ilvPoint2 = ilvPolyPointsInterface.getPointAt(i - 2, null);
            }
            ilvPoint2.move(f, ilvPoint2.y);
            if (!bl2) {
                ilvTransformer.apply(ilvPoint2);
            }
            return ilvPoint2;
        }
        this.c.move(f, ilvPolyPointsInterface.getPointAt((int)(n - 1), null).y);
        if (!bl2) {
            ilvTransformer.apply(this.c);
        }
        return this.c;
    }

    protected boolean zoomable() {
        return true;
    }

    public IlvPoint getClosestConnectionPoint(IlvPoint ilvPoint, Object object, Object object2, Object object3, boolean bl, IlvTransformer ilvTransformer) {
        IlvRect ilvRect = this.getNode().boundingBox(ilvTransformer);
        this.c.move(ilvRect.x + ilvRect.width * 0.5f, ilvRect.y + ilvRect.height * 0.5f);
        return this.c;
    }

    public void connectLink(IlvLinkImage ilvLinkImage, IlvPoint ilvPoint, boolean bl, IlvTransformer ilvTransformer) {
    }

    public final synchronized void setMargin(float f) {
        if (this.a != f && this.getNode() != null && this.getNode().getGraphicBag() != null && this.getNode().getGraphicBag() instanceof IlvManager) {
            final float f2 = f;
            ((IlvManager)this.getNode().getGraphicBag()).applyToObject(this.getNode(), new IlvApplyObject(){

                public void apply(IlvGraphic ilvGraphic, Object object) {
                    IlvBusLinkConnector.this.a = f2;
                }
            }, null, false);
        }
        this.a = f;
    }

    public final float getMargin() {
        return this.a;
    }

    final void a(int n) {
        this.b = n;
    }

    final int a() {
        return this.b;
    }

    public IlvRect getGhostBoundingBox(IlvTransformer ilvTransformer) {
        return new IlvRect();
    }
}

