/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.hierarchical;

import ilog.views.graphlayout.hierarchical.CalcCrossings;
import ilog.views.graphlayout.hierarchical.HGraph;
import ilog.views.graphlayout.hierarchical.HLevel;
import ilog.views.graphlayout.hierarchical.HLevelIterator;
import ilog.views.graphlayout.hierarchical.HLevelSweepAlgorithm;
import ilog.views.graphlayout.hierarchical.HNode;
import ilog.views.graphlayout.hierarchical.HNodeIterator;
import ilog.views.graphlayout.hierarchical.HNodeSort;
import ilog.views.graphlayout.hierarchical.HSegment;
import ilog.views.graphlayout.hierarchical.HSegmentIterator;
import ilog.views.graphlayout.hierarchical.IlvHierarchicalLayout;
import ilog.views.graphlayout.hierarchical.relpositioning.HRPGraph;
import ilog.views.graphlayout.hierarchical.relpositioning.HRPSolving;
import ilog.views.util.collections.IlvUnsynchronizedStack;

class CrossingReductionAlgorithm
extends HLevelSweepAlgorithm {
    protected HNodeSort _nodeSortAlg;
    private HRPSolving a;
    protected boolean _usePortBaryCenter = false;
    private boolean b;
    private CalcCrossings c = new CalcCrossings();
    protected int _numberOfSweeps;
    protected boolean _checkBestPositions;
    private int d;
    private int e;

    CrossingReductionAlgorithm(HGraph hGraph) {
        super.init(hGraph);
        IlvHierarchicalLayout ilvHierarchicalLayout = hGraph.k();
        this._nodeSortAlg = new HNodeSort();
        this.a = new HRPSolving(null, ilvHierarchicalLayout, hGraph.a7());
        this._numberOfSweeps = ilvHierarchicalLayout.getNumberOfLinkCrossingSweeps();
        this._checkBestPositions = ilvHierarchicalLayout.isBacktrackCrossingReductionEnabled();
        this.b = ilvHierarchicalLayout.isMedianCrossingValueEnabled();
    }

    void a() {
        super.a();
        this._nodeSortAlg = null;
    }

    public void run() {
        HGraph hGraph = this.getGraph();
        int n = (this._numberOfSweeps + 3) * (hGraph.o() - 1) + 2;
        if (hGraph.a2() || hGraph.a3()) {
            n += 2 * (hGraph.o() - 1);
        }
        this.b().startStep(hGraph.ao, n);
        this.d();
        this.updateInfoInLevels();
        this.d = Integer.MAX_VALUE;
        boolean bl = false;
        if (hGraph.a2() || hGraph.a3()) {
            this._usePortBaryCenter = true;
            this.sweepForward();
            bl = true;
            if (!this.f()) {
                this.sweepBackward();
            }
        }
        this._usePortBaryCenter = false;
        if (hGraph.o() == 1) {
            this.treatForwardLevel(null, hGraph.w());
        } else {
            for (int i = 0; !(i >= this._numberOfSweeps || bl && this.f()); ++i) {
                if (i % 2 == 0) {
                    this.sweepForward();
                } else {
                    this.sweepBackward();
                }
                bl = true;
            }
        }
        this.h();
        this.calcCrossings(true);
        this.storeLevelPositionsInNodes();
    }

    private void d() {
        this.e = 1;
        HGraph hGraph = this.getGraph();
        HNodeIterator hNodeIterator = hGraph.p();
        while (hNodeIterator.hasNext()) {
            hNodeIterator.next().a(-1.0f);
        }
        hNodeIterator = hGraph.p();
        while (hNodeIterator.hasNext()) {
            HNode hNode = hNodeIterator.next();
            if (!(hNode.al() < 0.0f)) continue;
            this.a(hNode);
        }
        HLevelIterator hLevelIterator = this.getGraph().s();
        while (hLevelIterator.hasNext()) {
            HLevel hLevel = hLevelIterator.next();
            if (hLevel.c() != null) {
                this._nodeSortAlg.sort(hLevel.c());
            }
            this.c();
        }
    }

    private void a(HNode hNode) {
        IlvUnsynchronizedStack ilvUnsynchronizedStack = new IlvUnsynchronizedStack();
        hNode.a((float)this.e++);
        ilvUnsynchronizedStack.push((Object)hNode);
        while (!ilvUnsynchronizedStack.isEmpty()) {
            HNode hNode2;
            HSegment hSegment;
            hNode = (HNode)ilvUnsynchronizedStack.pop();
            HSegmentIterator hSegmentIterator = hNode.c();
            while (hSegmentIterator.hasNext()) {
                hSegment = hSegmentIterator.next();
                hNode2 = hSegment.d();
                if (!(hNode2.al() < 0.0f)) continue;
                hNode2.a((float)this.e++);
                ilvUnsynchronizedStack.push((Object)hNode2);
            }
            hSegmentIterator = hNode.e();
            while (hSegmentIterator.hasNext()) {
                hSegment = hSegmentIterator.next();
                hNode2 = hSegment.c();
                if (!(hNode2.al() < 0.0f)) continue;
                hNode2.a((float)this.e++);
                ilvUnsynchronizedStack.push((Object)hNode2);
            }
        }
    }

    protected final void sweepForward() {
        super.sweepForward();
        this.e();
    }

    protected final void sweepBackward() {
        super.sweepBackward();
        this.e();
    }

    private final void a(HLevel hLevel) {
        int n = hLevel.g();
        if (n > 0 && hLevel.p()) {
            HNodeIterator hNodeIterator = hLevel.e();
            int n2 = 0;
            int n3 = hLevel.g() + 1;
            while (hNodeIterator.hasNext()) {
                HNode hNode = hNodeIterator.next();
                int n4 = hNode.aj();
                for (int i = n3; n4 != n2 && n4 >= 0 && n4 < n && i > 0; --i) {
                    HNode hNode2 = hLevel.c()[n4];
                    hLevel.c()[n4] = hNode;
                    hLevel.c()[n2] = hNode2;
                    hNode = hNode2;
                    n4 = hNode.aj();
                }
                ++n2;
            }
        }
    }

    private final void b(HLevel hLevel) {
        int n = hLevel.g();
        HNodeIterator hNodeIterator = hLevel.e();
        if (this._usePortBaryCenter) {
            while (hNodeIterator.hasNext()) {
                hNodeIterator.next().m();
            }
        } else {
            while (hNodeIterator.hasNext()) {
                hNodeIterator.next().a(n);
            }
        }
        if (this.b) {
            double d = n > 0 ? 1.0E-5 / (double)n : 1.0E-5;
            hNodeIterator = hLevel.e();
            while (hNodeIterator.hasNext()) {
                hNodeIterator.next().a((double)n);
            }
        }
        if (hLevel != this.getGraph().w()) {
            HNode hNode;
            hNodeIterator = hLevel.e();
            float f = 0.0f;
            while (hNodeIterator.hasNext()) {
                hNode = hNodeIterator.next();
                if (hNode.j() == 0) {
                    hNode.a(f);
                    continue;
                }
                f = hNode.al();
            }
            hNodeIterator = hLevel.f();
            while (hNodeIterator.hasNext()) {
                hNode = hNodeIterator.next();
                if (hNode.j() == 0) {
                    hNode.a((f + hNode.al()) / 2.0f);
                    continue;
                }
                f = hNode.al();
            }
        }
    }

    private final void c(HLevel hLevel) {
        int n = hLevel.g();
        HNodeIterator hNodeIterator = hLevel.e();
        if (this._usePortBaryCenter) {
            while (hNodeIterator.hasNext()) {
                hNodeIterator.next().n();
            }
        } else {
            while (hNodeIterator.hasNext()) {
                hNodeIterator.next().b(n);
            }
        }
        if (this.b) {
            double d = n > 0 ? 1.0E-5 / (double)n : 1.0E-5;
            hNodeIterator = hLevel.e();
            while (hNodeIterator.hasNext()) {
                hNodeIterator.next().b((double)n);
            }
        }
        if (hLevel != this.getGraph().x()) {
            HNode hNode;
            hNodeIterator = hLevel.e();
            float f = 0.0f;
            while (hNodeIterator.hasNext()) {
                hNode = hNodeIterator.next();
                if (hNode.i() == 0) {
                    hNode.a(f);
                    continue;
                }
                f = hNode.al();
            }
            hNodeIterator = hLevel.f();
            while (hNodeIterator.hasNext()) {
                hNode = hNodeIterator.next();
                if (hNode.i() == 0) {
                    hNode.a((f + hNode.al()) / 2.0f);
                    continue;
                }
                f = hNode.al();
            }
        }
    }

    private final void d(HLevel hLevel) {
        HNode hNode;
        HGraph hGraph = this.getGraph();
        HRPGraph hRPGraph = hLevel.q();
        if (hRPGraph == null) {
            return;
        }
        this.a.init(hRPGraph);
        HNodeIterator hNodeIterator = hLevel.e();
        while (hNodeIterator.hasNext()) {
            hNode = hNodeIterator.next();
            hGraph.c(hNode).setBarycenter(hNode.al(), 1.0f);
        }
        this.a.run();
        hNodeIterator = hLevel.e();
        while (hNodeIterator.hasNext()) {
            hNode = hNodeIterator.next();
            hNode.a((float)hGraph.c(hNode).getPositionNumber());
        }
    }

    protected void initForwardFirstLevel(HLevel hLevel) {
        if (hLevel.q() != null) {
            this.e(hLevel);
            this.d(hLevel);
            if (hLevel.c() != null) {
                this._nodeSortAlg.sort(hLevel.c());
            }
        }
        this.a(hLevel);
        hLevel.b(1, false);
    }

    protected void initBackwardFirstLevel(HLevel hLevel) {
        if (hLevel.q() != null) {
            this.e(hLevel);
            this.d(hLevel);
            if (hLevel.c() != null) {
                this._nodeSortAlg.sort(hLevel.c());
            }
        }
        this.a(hLevel);
        hLevel.b(1, false);
    }

    private void e(HLevel hLevel) {
        HNodeIterator hNodeIterator = hLevel.e();
        int n = 1;
        while (hNodeIterator.hasNext()) {
            hNodeIterator.next().a((float)n++);
        }
    }

    protected void treatForwardLevel(HLevel hLevel, HLevel hLevel2) {
        this.b(hLevel2);
        this.d(hLevel2);
        if (hLevel2.c() != null) {
            this._nodeSortAlg.sort(hLevel2.c());
        }
        this.a(hLevel2);
        hLevel2.b(1, false);
    }

    protected void treatBackwardLevel(HLevel hLevel, HLevel hLevel2) {
        this.c(hLevel2);
        this.d(hLevel2);
        if (hLevel2.c() != null) {
            this._nodeSortAlg.sort(hLevel2.c());
        }
        this.a(hLevel2);
        hLevel2.b(1, false);
    }

    private final void e() {
        if (!this._checkBestPositions) {
            return;
        }
        int n = this.calcCrossings(false);
        if (n < this.d) {
            this.g();
            this.d = n;
        }
    }

    private final boolean f() {
        return this._checkBestPositions && this.d == 0;
    }

    private final void g() {
        HNodeIterator hNodeIterator = this.getGraph().p();
        while (hNodeIterator.hasNext()) {
            hNodeIterator.next().aq();
        }
    }

    private final void h() {
        if (!this._checkBestPositions) {
            return;
        }
        HNodeIterator hNodeIterator = this.getGraph().p();
        while (hNodeIterator.hasNext()) {
            hNodeIterator.next().ar();
        }
        HLevelIterator hLevelIterator = this.getGraph().s();
        while (hLevelIterator.hasNext()) {
            HLevel hLevel = hLevelIterator.next();
            if (hLevel.c() != null) {
                this._nodeSortAlg.sort(hLevel.c());
            }
            hLevel.b(1, false);
        }
    }

    protected final void storeLevelPositionsInNodes() {
        HLevelIterator hLevelIterator = this.getGraph().s();
        while (hLevelIterator.hasNext()) {
            hLevelIterator.next().b(0, false);
            this.b().addPoints(1);
            this.c();
        }
    }

    protected final void updateInfoInLevels() {
        HLevelIterator hLevelIterator = this.getGraph().s();
        while (hLevelIterator.hasNext()) {
            hLevelIterator.next().b();
            this.b().addPoints(1);
            this.c();
        }
    }

    protected int calcCrossings(boolean bl) {
        HLevelIterator hLevelIterator = this.getGraph().s();
        HLevel hLevel = null;
        int n = 0;
        while (hLevelIterator.hasNext()) {
            HLevel hLevel2 = hLevelIterator.next();
            if (hLevel != null) {
                int n2 = this.c.getNumberOfCrossings(hLevel, hLevel2);
                n += n2;
                if (bl) {
                    hLevel.i(n2);
                }
            }
            hLevel = hLevel2;
        }
        return n;
    }
}

