/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.graphlayout.hierarchical.graphbase;

import ilog.views.graphlayout.hierarchical.graphbase.HTBaseEdge;
import ilog.views.graphlayout.hierarchical.graphbase.HTBaseNode;

public class HTBaseGraph {
    protected HTBaseNode _firstNode = null;
    protected HTBaseNode _lastNode = null;
    protected HTBaseEdge _firstEdge = null;
    protected HTBaseEdge _lastEdge = null;
    private int a = 0;
    private int b = 0;

    public void addNode(HTBaseNode hTBaseNode) {
        if (this._lastNode != null) {
            hTBaseNode.insertAfter(this, this._lastNode);
            this._lastNode = hTBaseNode;
        } else {
            hTBaseNode.insertBefore(this, null);
            this._firstNode = this._lastNode = hTBaseNode;
        }
        ++this.a;
    }

    public void addEdge(HTBaseEdge hTBaseEdge, HTBaseNode hTBaseNode, HTBaseNode hTBaseNode2) {
        if (this._lastEdge != null) {
            hTBaseEdge.insertAfter(this, this._lastEdge);
            this._lastEdge = hTBaseEdge;
        } else {
            hTBaseEdge.insertBefore(this, null);
            this._firstEdge = this._lastEdge = hTBaseEdge;
        }
        hTBaseNode.addOutEdge(hTBaseEdge);
        hTBaseNode2.addInEdge(hTBaseEdge);
        ++this.b;
    }

    public final void addEdge(HTBaseEdge hTBaseEdge) {
        this.addEdge(hTBaseEdge, hTBaseEdge._source, hTBaseEdge._target);
    }

    public void removeNode(HTBaseNode hTBaseNode) {
        this.removeInEdges(hTBaseNode);
        this.removeOutEdges(hTBaseNode);
        if (this._firstNode == hTBaseNode) {
            this._firstNode = (HTBaseNode)hTBaseNode._next;
        }
        if (this._lastNode == hTBaseNode) {
            this._lastNode = (HTBaseNode)hTBaseNode._prev;
        }
        hTBaseNode.remove();
        --this.a;
    }

    public void removeEdge(HTBaseEdge hTBaseEdge) {
        hTBaseEdge._source.removeOutEdge(hTBaseEdge);
        hTBaseEdge._target.removeInEdge(hTBaseEdge);
        if (this._firstEdge == hTBaseEdge) {
            this._firstEdge = (HTBaseEdge)hTBaseEdge._next;
        }
        if (this._lastEdge == hTBaseEdge) {
            this._lastEdge = (HTBaseEdge)hTBaseEdge._prev;
        }
        hTBaseEdge.remove();
        --this.b;
    }

    public final void removeInEdges(HTBaseNode hTBaseNode) {
        HTBaseEdge hTBaseEdge = hTBaseNode._firstInEdge;
        while (hTBaseEdge != null) {
            HTBaseEdge hTBaseEdge2 = hTBaseEdge._nextInEdge;
            this.removeEdge(hTBaseEdge);
            hTBaseEdge = hTBaseEdge2;
        }
    }

    public final void removeOutEdges(HTBaseNode hTBaseNode) {
        HTBaseEdge hTBaseEdge = hTBaseNode._firstOutEdge;
        while (hTBaseEdge != null) {
            HTBaseEdge hTBaseEdge2 = hTBaseEdge._nextOutEdge;
            this.removeEdge(hTBaseEdge);
            hTBaseEdge = hTBaseEdge2;
        }
    }

    public final int getNumberOfNodes() {
        return this.a;
    }

    public final int getNumberOfEdges() {
        return this.b;
    }

    public final boolean containsNode(HTBaseNode hTBaseNode) {
        return hTBaseNode == null ? false : hTBaseNode.isContainedIn(this._firstNode);
    }

    public final boolean containsEdge(HTBaseEdge hTBaseEdge) {
        return hTBaseEdge == null ? false : hTBaseEdge.isContainedIn(this._firstEdge);
    }

    public final HTBaseEdge getEdgeBetween(HTBaseNode hTBaseNode, HTBaseNode hTBaseNode2, boolean bl) {
        if (hTBaseNode.getOutdegree() <= hTBaseNode2.getIndegree()) {
            HTBaseEdge hTBaseEdge = hTBaseNode._firstOutEdge;
            while (hTBaseEdge != null) {
                if (hTBaseEdge._target == hTBaseNode2) {
                    return hTBaseEdge;
                }
                hTBaseEdge = hTBaseEdge._nextOutEdge;
            }
        } else {
            HTBaseEdge hTBaseEdge = hTBaseNode2._firstInEdge;
            while (hTBaseEdge != null) {
                if (hTBaseEdge._source == hTBaseNode) {
                    return hTBaseEdge;
                }
                hTBaseEdge = hTBaseEdge._nextInEdge;
            }
        }
        if (!bl) {
            return this.getEdgeBetween(hTBaseNode2, hTBaseNode, true);
        }
        return null;
    }
}

