/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.hypergraph.edgeconnector;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicBag;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvNamedProperty;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.hypergraph.IlvHyperEdge;
import ilog.views.hypergraph.IlvHyperEdgeEnd;
import ilog.views.hypergraph.IlvHyperGrapher;
import ilog.views.internal.IlvBoundingBoxCache;
import ilog.views.io.IlvInputStream;
import ilog.views.io.IlvOutputStream;
import ilog.views.io.IlvReadFileException;
import java.awt.Graphics;
import java.io.IOException;
import java.io.Serializable;
import java.util.Iterator;

public abstract class IlvHyperEdgeConnector
extends IlvGraphic {
    private static final String a = "_HyperEdgeConnector";
    public static final int IN_NODE_LAYER = 0;
    public static final int IN_FRONT = 1;
    public static final int IN_BACK = 2;
    public static final int IN_FIXED_LAYER = 3;
    private IlvGraphic b;
    private IlvBoundingBoxCache c;
    private transient boolean d;
    private transient boolean e;
    private int f = 0;
    private int g = 0;
    private boolean h;

    public IlvHyperEdgeConnector() {
        if (this.isGraphic()) {
            this.c = new IlvBoundingBoxCache(3);
        }
        this.d = false;
        this.e = false;
        this.h = true;
    }

    public IlvHyperEdgeConnector(IlvGraphic ilvGraphic) {
        this();
        this.attach(ilvGraphic, true);
    }

    public IlvHyperEdgeConnector(IlvHyperEdgeConnector ilvHyperEdgeConnector) {
        super((IlvGraphic)ilvHyperEdgeConnector);
        if (this.isGraphic()) {
            this.c = new IlvBoundingBoxCache(3);
        }
        this.d = false;
        this.e = false;
        this.f = ilvHyperEdgeConnector.f;
        this.g = ilvHyperEdgeConnector.g;
        this.h = ilvHyperEdgeConnector.h;
    }

    public IlvHyperEdgeConnector(IlvInputStream ilvInputStream) throws IlvReadFileException {
        super(ilvInputStream);
        if (this.isGraphic()) {
            this.c = new IlvBoundingBoxCache(3);
            this.d = true;
        } else {
            this.d = false;
        }
        this.e = false;
        this.setLayerMode(ilvInputStream.readInt("layerMode"));
        this.setFixedLayer(ilvInputStream.readInt("fixedLayer"));
        this.setConnectionPointMoveAllowed(ilvInputStream.readBoolean("allowMoving"));
    }

    public void write(IlvOutputStream ilvOutputStream) throws IOException {
        super.write(ilvOutputStream);
        ilvOutputStream.write("layerMode", this.getLayerMode());
        ilvOutputStream.write("fixedLayer", this.getFixedLayer());
        ilvOutputStream.write("allowMoving", this.h);
    }

    public boolean isGraphic() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void attach(IlvGraphic ilvGraphic, boolean bl) {
        IlvManager ilvManager;
        if (this.isGraphic() && ilvGraphic instanceof IlvHyperEdge) {
            throw new IllegalArgumentException("This connector cannot be attached to a hyperedge, only to nodes");
        }
        if (ilvGraphic == null) {
            throw new IllegalArgumentException("nodeOrEdge cannot be null");
        }
        if (ilvGraphic instanceof IlvLinkImage) {
            throw new IllegalArgumentException("Not a node or hyperedge");
        }
        IlvHyperEdgeConnector ilvHyperEdgeConnector = IlvHyperEdgeConnector.GetAttached(ilvGraphic);
        if (ilvHyperEdgeConnector == this && this.b == ilvGraphic) {
            return;
        }
        IlvGraphicBag ilvGraphicBag = ilvGraphic.getGraphicBag();
        IlvManager ilvManager2 = ilvManager = ilvGraphicBag instanceof IlvManager ? (IlvManager)ilvGraphicBag : null;
        if (bl && ilvManager != null) {
            ilvManager.initReDraws();
        }
        try {
            if (ilvHyperEdgeConnector != null) {
                ilvHyperEdgeConnector.detach(bl);
            }
            this.detach(bl);
            if (ilvGraphicBag == null) {
                this.attachImpl(ilvGraphic);
            } else {
                ilvGraphicBag.applyToObject(ilvGraphic, new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic, Object object) {
                        IlvHyperEdgeConnector.this.attachImpl(ilvGraphic);
                    }
                }, null, bl);
            }
            if (this.isGraphic() && ilvManager != null) {
                ilvManager.addObject((IlvGraphic)this, this.a(ilvGraphic), bl);
                ilvManager.setMovable((IlvGraphic)this, false);
                ilvManager.setEditable((IlvGraphic)this, true);
                ilvManager.setSelectable((IlvGraphic)this, true);
            }
        }
        finally {
            if (bl && ilvManager != null) {
                ilvManager.reDrawViews();
            }
        }
    }

    protected void attachImpl(IlvGraphic ilvGraphic) {
        this.b = ilvGraphic;
        HyperEdgeConnectorProperty hyperEdgeConnectorProperty = new HyperEdgeConnectorProperty(this);
        ilvGraphic.setNamedProperty((IlvNamedProperty)hyperEdgeConnectorProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void detach(boolean bl) {
        IlvManager ilvManager;
        if (this.b == null) {
            return;
        }
        final IlvGraphic ilvGraphic = this.b;
        boolean bl2 = this.e;
        this.e = true;
        IlvGraphicBag ilvGraphicBag = this.b.getGraphicBag();
        IlvManager ilvManager2 = ilvManager = ilvGraphicBag instanceof IlvManager ? (IlvManager)ilvGraphicBag : null;
        if (bl && ilvManager != null) {
            ilvManager.initReDraws();
        }
        try {
            if (ilvGraphicBag == null) {
                this.detachImpl();
                ilvGraphic.removeNamedProperty(a);
            } else {
                ilvGraphicBag.applyToObject(this.b, new IlvApplyObject(){

                    public void apply(IlvGraphic ilvGraphic2, Object object) {
                        IlvHyperEdgeConnector.this.detachImpl();
                        ilvGraphic.removeNamedProperty(IlvHyperEdgeConnector.a);
                    }
                }, null, bl);
            }
            if (this.isGraphic() && this.getGraphicBag() != null) {
                this.getGraphicBag().removeObject((IlvGraphic)this, bl);
            }
        }
        finally {
            this.e = bl2;
            if (bl && ilvManager != null) {
                ilvManager.reDrawViews();
            }
        }
    }

    protected void detachImpl() {
        this.b = null;
    }

    public boolean allowRemoval() {
        return this.e;
    }

    public void setConnectionPointMoveAllowed(boolean bl) {
        this.h = bl;
    }

    public boolean isConnectionPointMoveAllowed() {
        return this.h;
    }

    public boolean allowsConnectionPointMove(IlvHyperEdgeEnd ilvHyperEdgeEnd) {
        return this.h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actOnOwnerInserted(IlvGraphic ilvGraphic, boolean bl) {
        IlvManager ilvManager;
        if (!this.isGraphic()) {
            return;
        }
        if (this.getGraphicBag() != null) {
            ilvManager = (IlvManager)this.getGraphicBag();
            boolean bl2 = this.e;
            this.e = true;
            try {
                ilvManager.removeObject((IlvGraphic)this, bl);
            }
            finally {
                this.e = bl2;
            }
            this.d = false;
        }
        if (this.b != null && this.b != ilvGraphic) {
            throw new RuntimeException("connector wrongly attached");
        }
        this.attachImpl(ilvGraphic);
        if (!this.d) {
            ilvManager = (IlvManager)ilvGraphic.getGraphicBag();
            ilvManager.addObject((IlvGraphic)this, this.a(ilvGraphic), bl);
            ilvManager.setMovable((IlvGraphic)this, false);
            ilvManager.setEditable((IlvGraphic)this, true);
            ilvManager.setSelectable((IlvGraphic)this, true);
        }
        this.d = false;
    }

    public void actOnOwnerRead(IlvGraphic ilvGraphic) {
        this.attachImpl(ilvGraphic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actOnOwnerRemoved(IlvGraphic ilvGraphic, boolean bl) {
        boolean bl2 = this.e;
        this.e = true;
        try {
            this.detachImpl();
            if (this.getGraphicBag() != null) {
                this.getGraphicBag().removeObject((IlvGraphic)this, bl);
            }
        }
        finally {
            this.e = bl2;
        }
    }

    public void actAfterOwnerTransform(boolean bl) {
        this.actAfterLayerChanged(this.getOwner(), bl);
    }

    public void actAfterLayerChanged(IlvGraphic ilvGraphic, boolean bl) {
        int n;
        if (!this.isGraphic()) {
            return;
        }
        if (this.getGraphicBag() == null) {
            return;
        }
        if (this.getOwner() == null) {
            return;
        }
        if (this.getOwner() != ilvGraphic) {
            return;
        }
        if (ilvGraphic.getGraphicBag() == null) {
            return;
        }
        IlvManager ilvManager = (IlvManager)this.getGraphicBag();
        int n2 = ilvManager.getLayer((IlvGraphic)this);
        if (n2 != (n = this.a(ilvGraphic))) {
            ilvManager.setLayer((IlvGraphic)this, n, bl);
        }
    }

    public IlvGraphic getOwner() {
        return this.b;
    }

    public boolean connect(IlvHyperEdgeEnd ilvHyperEdgeEnd, IlvPoint ilvPoint, IlvTransformer ilvTransformer) {
        IlvHyperEdgeConnector ilvHyperEdgeConnector = IlvHyperEdgeConnector.Get(ilvHyperEdgeEnd);
        if (ilvHyperEdgeConnector != this) {
            return false;
        }
        IlvPoint ilvPoint2 = this.getClosestConnectionPoint(ilvHyperEdgeEnd, ilvPoint, ilvTransformer);
        ilvHyperEdgeEnd.setPosition(ilvPoint2, ilvTransformer);
        return true;
    }

    public boolean disconnect(IlvHyperEdgeEnd ilvHyperEdgeEnd) {
        return true;
    }

    public abstract IlvPoint getConnectionPoint(IlvHyperEdgeEnd var1, IlvTransformer var2);

    public abstract IlvPoint getClosestConnectionPoint(IlvHyperEdgeEnd var1, IlvPoint var2, IlvTransformer var3);

    public void adjustAll() {
        block8: {
            IlvHyperEdgeConnector ilvHyperEdgeConnector;
            IlvHyperEdgeEnd ilvHyperEdgeEnd;
            IlvHyperGrapher ilvHyperGrapher;
            block7: {
                IlvHyperEdgeEnd ilvHyperEdgeEnd2;
                if (this.getOwner() == null) {
                    return;
                }
                IlvGraphicBag ilvGraphicBag = this.getOwner().getGraphicBag();
                if (ilvGraphicBag == null) {
                    return;
                }
                if (!(ilvGraphicBag instanceof IlvHyperGrapher)) {
                    return;
                }
                ilvHyperGrapher = (IlvHyperGrapher)ilvGraphicBag;
                if (!(this.getOwner() instanceof IlvHyperEdge)) break block7;
                IlvHyperEdge ilvHyperEdge = (IlvHyperEdge)this.getOwner();
                Iterator iterator = ilvHyperEdge.getFromEnds();
                while (iterator.hasNext()) {
                    ilvHyperEdgeEnd2 = (IlvHyperEdgeEnd)iterator.next();
                    this.adjust(ilvHyperEdgeEnd2);
                }
                iterator = ilvHyperEdge.getToEnds();
                while (iterator.hasNext()) {
                    ilvHyperEdgeEnd2 = (IlvHyperEdgeEnd)iterator.next();
                    this.adjust(ilvHyperEdgeEnd2);
                }
                break block8;
            }
            if (!ilvHyperGrapher.isNode(this.getOwner())) break block8;
            IlvGraphic ilvGraphic = this.getOwner();
            Iterator iterator = ilvHyperGrapher.getHyperEdgeEndsFrom(ilvGraphic);
            while (iterator.hasNext()) {
                ilvHyperEdgeEnd = (IlvHyperEdgeEnd)iterator.next();
                ilvHyperEdgeConnector = IlvHyperEdgeConnector.Get(ilvHyperEdgeEnd);
                if (ilvHyperEdgeConnector != this) continue;
                this.adjust(ilvHyperEdgeEnd);
            }
            iterator = ilvHyperGrapher.getHyperEdgeEndsTo(ilvGraphic);
            while (iterator.hasNext()) {
                ilvHyperEdgeEnd = (IlvHyperEdgeEnd)iterator.next();
                ilvHyperEdgeConnector = IlvHyperEdgeConnector.Get(ilvHyperEdgeEnd);
                if (ilvHyperEdgeConnector != this) continue;
                this.adjust(ilvHyperEdgeEnd);
            }
        }
    }

    public void adjust(IlvHyperEdgeEnd ilvHyperEdgeEnd) {
        ilvHyperEdgeEnd.positionChanged();
    }

    public void actOnWrite(IlvHyperEdgeEnd ilvHyperEdgeEnd, IlvOutputStream ilvOutputStream) throws IOException {
    }

    public void actOnRead(IlvHyperEdgeEnd ilvHyperEdgeEnd, IlvInputStream ilvInputStream) throws IlvReadFileException {
    }

    public void setLayerMode(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3) {
            throw new IllegalArgumentException("Unknown layer mode " + n);
        }
        this.f = n;
        if (this.getOwner() != null) {
            IlvManager ilvManager;
            int n2;
            int n3 = this.a(this.getOwner());
            if (this.getGraphicBag() instanceof IlvManager && (n2 = (ilvManager = (IlvManager)this.getGraphicBag()).getLayer((IlvGraphic)this)) != n3) {
                ilvManager.setLayer((IlvGraphic)this, n3, true);
            }
        }
    }

    public int getLayerMode() {
        return this.f;
    }

    public void setFixedLayer(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Layer must be a positive number");
        }
        this.g = n;
    }

    public int getFixedLayer() {
        return this.g;
    }

    private int a(IlvGraphic ilvGraphic) {
        IlvManager ilvManager = (IlvManager)ilvGraphic.getGraphicBag();
        if (ilvManager == null) {
            return 0;
        }
        switch (this.getLayerMode()) {
            case 0: {
                return ilvManager.getLayer(ilvGraphic);
            }
            case 1: {
                return ilvManager.getLayer(ilvGraphic) + 1;
            }
            case 2: {
                return Math.max(0, ilvManager.getLayer(ilvGraphic) - 1);
            }
        }
        return this.getFixedLayer();
    }

    public boolean connectionsZoomable() {
        return false;
    }

    public boolean zoomable() {
        return false;
    }

    public void draw(Graphics graphics, IlvTransformer ilvTransformer) {
    }

    public IlvRect boundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect;
        if (this.c == null) {
            this.c = new IlvBoundingBoxCache(3);
        }
        if ((ilvRect = this.c.get(ilvTransformer)) == null) {
            ilvRect = this.calcBoundingBox(ilvTransformer);
            this.c.put(ilvTransformer, ilvRect);
        }
        return new IlvRect(ilvRect);
    }

    protected IlvRect calcBoundingBox(IlvTransformer ilvTransformer) {
        IlvRect ilvRect;
        if (this.b == null) {
            float f = 1.0E-7f;
            ilvRect = new IlvRect(0.0f, 0.0f, f, f);
        } else {
            ilvRect = this.b.boundingBox(ilvTransformer);
        }
        return ilvRect;
    }

    public void clearBoundingBoxCache() {
        if (this.c != null) {
            this.c.setInvalid();
        }
    }

    public void applyTransform(IlvTransformer ilvTransformer) {
    }

    public boolean contains(IlvPoint ilvPoint, IlvPoint ilvPoint2, IlvTransformer ilvTransformer) {
        return false;
    }

    public void move(float f, float f2) {
    }

    public void moveResize(IlvRect ilvRect) {
    }

    public void translate(float f, float f2) {
    }

    public void rotate(IlvPoint ilvPoint, double d) {
    }

    public void scale(double d, double d2) {
    }

    public void resize(float f, float f2) {
    }

    public static IlvHyperEdgeConnector GetAttached(IlvGraphic ilvGraphic) {
        if (ilvGraphic == null) {
            return null;
        }
        IlvNamedProperty ilvNamedProperty = ilvGraphic.getNamedProperty(a);
        if (ilvNamedProperty == null) {
            return null;
        }
        HyperEdgeConnectorProperty hyperEdgeConnectorProperty = (HyperEdgeConnectorProperty)ilvNamedProperty;
        return hyperEdgeConnectorProperty.getHyperEdgeConnector();
    }

    public static IlvHyperEdgeConnector Get(IlvHyperEdgeEnd ilvHyperEdgeEnd) {
        if (ilvHyperEdgeEnd == null) {
            return null;
        }
        IlvHyperEdge ilvHyperEdge = ilvHyperEdgeEnd.getHyperEdge();
        if (ilvHyperEdge == null) {
            return null;
        }
        IlvHyperEdgeConnector ilvHyperEdgeConnector = IlvHyperEdgeConnector.GetAttached(ilvHyperEdge);
        if (ilvHyperEdgeConnector != null) {
            return ilvHyperEdgeConnector;
        }
        return IlvHyperEdgeConnector.GetAttached(ilvHyperEdge.getVisibleEndNode(ilvHyperEdgeEnd.getNode()));
    }

    public static IlvHyperEdgeConnector GetLocal(IlvHyperEdgeEnd ilvHyperEdgeEnd) {
        if (ilvHyperEdgeEnd == null) {
            return null;
        }
        IlvHyperEdge ilvHyperEdge = ilvHyperEdgeEnd.getHyperEdge();
        if (ilvHyperEdge == null) {
            return null;
        }
        IlvHyperEdgeConnector ilvHyperEdgeConnector = IlvHyperEdgeConnector.GetAttached(ilvHyperEdge);
        if (ilvHyperEdgeConnector != null) {
            return ilvHyperEdgeConnector;
        }
        return IlvHyperEdgeConnector.GetAttached(ilvHyperEdgeEnd.getNode());
    }

    public static class HyperEdgeConnectorProperty
    extends IlvNamedProperty
    implements Serializable {
        static final long serialVersionUID = -8374859604836598987L;
        private IlvHyperEdgeConnector a;

        public HyperEdgeConnectorProperty(IlvHyperEdgeConnector ilvHyperEdgeConnector) {
            super(IlvHyperEdgeConnector.a);
            if (ilvHyperEdgeConnector == null) {
                throw new IllegalArgumentException("null connector");
            }
            this.a = ilvHyperEdgeConnector;
        }

        public HyperEdgeConnectorProperty(IlvInputStream ilvInputStream) throws IOException, IlvReadFileException {
            super(ilvInputStream);
            this.a = (IlvHyperEdgeConnector)ilvInputStream.readObject("connector");
        }

        public IlvHyperEdgeConnector getHyperEdgeConnector() {
            return this.a;
        }

        public IlvNamedProperty copy() {
            IlvHyperEdgeConnector ilvHyperEdgeConnector = (IlvHyperEdgeConnector)this.a.copy();
            return new HyperEdgeConnectorProperty(ilvHyperEdgeConnector);
        }

        public boolean isPersistent() {
            return true;
        }

        public void write(IlvOutputStream ilvOutputStream) throws IOException {
            super.write(ilvOutputStream);
            ilvOutputStream.write("connector", (IlvGraphic)this.a);
        }
    }
}

