/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.graphic.util;

import java.awt.BasicStroke;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;

public class WaveStroke
implements Stroke {
    private AffineTransform a = new AffineTransform();
    private static final float b = 1.0f;
    private static final float c = 12.0f;
    private static final float d = 4.0f;
    private static final float e = 1.0f;
    private float[] f = new float[]{1.0f, 2.0f, 3.0f, 2.0f, 5.0f, 2.0f, 6.0f, 0.0f, 7.0f, -2.0f, 9.0f, -2.0f, 11.0f, -2.0f, 12.0f, 0.0f};
    private float[] g = new float[]{1.0f, -2.0f, 3.0f, -2.0f, 5.0f, -2.0f, 6.0f, 0.0f, 7.0f, 2.0f, 9.0f, 2.0f, 11.0f, 2.0f, 12.0f, 0.0f};
    private float h = 12.0f;
    private float i = 4.0f;
    private float j = 1.0f;
    private BasicStroke k;

    public WaveStroke(float f) {
        this(f, 12.0f, 4.0f);
    }

    public WaveStroke(float f, float f2, float f3) {
        if (f2 <= 0.0f || f3 <= 0.0f || f <= 0.0f) {
            throw new IllegalArgumentException("Arguments should be greater than zero");
        }
        this.k = new BasicStroke(f, 0, 2);
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToScale(f2 / 12.0f, f3 / 4.0f);
        affineTransform.transform(this.f, 0, this.f, 0, this.f.length / 2);
        affineTransform.transform(this.g, 0, this.g, 0, this.g.length / 2);
        this.h = f2;
        this.i = f3;
        this.j = f;
    }

    public Shape createStrokedShape(Shape shape) {
        return this.k.createStrokedShape(this.createWavyOutline(shape));
    }

    public Shape createWavyOutline(Shape shape) {
        GeneralPath generalPath;
        PathIterator pathIterator = shape.getPathIterator(null, 1.0);
        float[] fArray = new float[6];
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        AddSegmentControl addSegmentControl = new AddSegmentControl();
        addSegmentControl.i = generalPath = new GeneralPath();
        while (!pathIterator.isDone()) {
            n = pathIterator.currentSegment(fArray);
            switch (n) {
                case 0: {
                    addSegmentControl.a = fArray[0];
                    addSegmentControl.b = fArray[1];
                    addSegmentControl.e = addSegmentControl.a;
                    addSegmentControl.f = addSegmentControl.b;
                    addSegmentControl.j = true;
                    break;
                }
                case 1: {
                    addSegmentControl.c = fArray[0];
                    addSegmentControl.d = fArray[1];
                    addSegmentControl.m = addSegmentControl.c == addSegmentControl.e && addSegmentControl.d == addSegmentControl.f;
                    this.a(addSegmentControl);
                    addSegmentControl.j = false;
                    addSegmentControl.a = addSegmentControl.c;
                    addSegmentControl.b = addSegmentControl.d;
                    break;
                }
                case 4: {
                    addSegmentControl.m = true;
                    addSegmentControl.c = addSegmentControl.e;
                    addSegmentControl.d = addSegmentControl.f;
                    this.a(addSegmentControl);
                    addSegmentControl.j = false;
                    addSegmentControl.a = addSegmentControl.e;
                    addSegmentControl.b = addSegmentControl.f;
                    break;
                }
                default: {
                    throw new Error("Illegal seg type : " + n);
                }
            }
            pathIterator.next();
        }
        return generalPath;
    }

    private void a(AddSegmentControl addSegmentControl) {
        float f;
        float f2 = addSegmentControl.a;
        float f3 = addSegmentControl.b;
        float f4 = addSegmentControl.c;
        float f5 = addSegmentControl.d;
        GeneralPath generalPath = addSegmentControl.i;
        if (!addSegmentControl.j && addSegmentControl.l) {
            f2 = addSegmentControl.g;
            f3 = addSegmentControl.h;
        }
        if (addSegmentControl.j) {
            addSegmentControl.i.moveTo(f2, f3);
        }
        float[] fArray = this.f;
        if (addSegmentControl.k) {
            fArray = this.g;
        }
        if (f2 == f4 && f3 == f5) {
            return;
        }
        float f6 = (float)Point2D.distance(f2, f3, f4, f5);
        double d = Math.atan2(f5 - f3, f4 - f2);
        float f7 = f6 / this.h;
        int n = (int)Math.floor(f7);
        this.a.setToScale(1.0, 1.0);
        this.a.translate(f2, f3);
        float[] fArray2 = new float[fArray.length];
        this.a.rotate(d);
        if (n > 1 && (double)(f7 - (float)n) < 0.5) {
            f = f7 / (float)n;
            this.a.scale(f, 1.0);
            f7 = n;
        }
        this.a.transform(fArray, 0, fArray2, 0, fArray.length / 2);
        f = (f4 - f2) / f7;
        float f8 = (f5 - f3) / f7;
        int n2 = fArray2.length / 4;
        this.a.setToTranslation(f, f8);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                generalPath.quadTo(fArray2[4 * j], fArray2[4 * j + 1], fArray2[4 * j + 2], fArray2[4 * j + 3]);
            }
            this.a.transform(fArray2, 0, fArray2, 0, fArray2.length / 2);
        }
        if (addSegmentControl.m) {
            if ((double)(f7 - (float)n) > 0.75) {
                generalPath.quadTo(fArray2[0], fArray2[1], fArray2[2], fArray2[3]);
                generalPath.quadTo(fArray2[4], fArray2[5], fArray2[6], fArray2[7]);
                generalPath.quadTo(fArray2[8], fArray2[9], fArray2[10], fArray2[11]);
                generalPath.quadTo(fArray2[12], fArray2[13], f4, f5);
                addSegmentControl.l = false;
            } else if ((double)(f7 - (float)n) > 0.25) {
                generalPath.quadTo(fArray2[0], fArray2[1], fArray2[2], fArray2[3]);
                generalPath.quadTo(fArray2[4], fArray2[5], f4, f5);
                addSegmentControl.k = !addSegmentControl.k;
                addSegmentControl.l = false;
            } else {
                generalPath.lineTo(f4, f5);
                addSegmentControl.l = false;
            }
        } else if ((double)(f7 - (float)n) >= 0.5) {
            generalPath.quadTo(fArray2[0], fArray2[1], fArray2[2], fArray2[3]);
            generalPath.quadTo(fArray2[4], fArray2[5], fArray2[6], fArray2[7]);
            addSegmentControl.k = !addSegmentControl.k;
            addSegmentControl.l = true;
            addSegmentControl.g = f2 + ((float)n + 0.5f) * f;
            addSegmentControl.h = f3 + ((float)n + 0.5f) * f8;
        } else {
            addSegmentControl.l = true;
            addSegmentControl.g = f2 + (float)n * f;
            addSegmentControl.h = f3 + (float)n * f8;
        }
    }

    public float getWidth() {
        return this.j;
    }

    public float getWaveLength() {
        return this.h;
    }

    public float getWaveAmplitude() {
        return this.i;
    }

    static class AddSegmentControl {
        float a;
        float b;
        float c;
        float d;
        float e;
        float f;
        float g;
        float h;
        GeneralPath i;
        boolean j;
        boolean k;
        boolean l;
        boolean m;

        AddSegmentControl() {
        }
    }
}

