/*
 * Decompiled with CFR 0.152.
 */
package ilog.views.sdm.renderer.maps;

import ilog.views.IlvGrapher;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvManagerLayer;
import ilog.views.IlvNamedProperty;
import ilog.views.event.ManagerLayerEvent;
import ilog.views.event.ManagerLayerInsertedEvent;
import ilog.views.event.ManagerLayerListener;
import ilog.views.event.ManagerLayerMovedEvent;
import ilog.views.event.ManagerLayerRemovedEvent;
import ilog.views.maps.IlvMapLayerTreeProperty;
import ilog.views.maps.IlvMapUtil;
import ilog.views.maps.beans.IlvMapLayer;
import ilog.views.maps.beans.IlvMapLayerTreeModel;
import ilog.views.maps.graphic.style.IlvMapStyle;
import ilog.views.sdm.IlvSDMEngine;
import ilog.views.sdm.renderer.IlvRendererUtil;
import ilog.views.sdm.renderer.IlvStyleSheetRenderer;
import java.util.Enumeration;

public class IlvMapStyleSheetRenderer
extends IlvStyleSheetRenderer {
    private static final long serialVersionUID = 308542018351438503L;
    public static final String SYMBOL_LAYER_NAME = IlvMapUtil.getString((Class)IlvMapStyleSheetRenderer.class, (String)"IlvMapStyleSheetRenderer.SymbolsLayerName");
    public static final String LINK_LAYER_NAME = IlvMapUtil.getString((Class)IlvMapStyleSheetRenderer.class, (String)"IlvMapStyleSheetRenderer.LinksLayerName");

    public IlvMapStyleSheetRenderer() {
        this.setAlias(IlvRendererUtil.getRendererAlias(IlvStyleSheetRenderer.class.getName()));
    }

    public static IlvMapLayer getLinkMapLayer(IlvManager ilvManager) {
        IlvMapLayerTreeModel ilvMapLayerTreeModel = IlvMapLayerTreeProperty.GetMapLayerTreeModel((IlvManager)ilvManager);
        IlvMapLayer ilvMapLayer = ilvMapLayerTreeModel.findChildLayer(null, LINK_LAYER_NAME);
        return ilvMapLayer;
    }

    public static IlvMapLayer getSymbolMapLayer(IlvManager ilvManager) {
        IlvMapLayerTreeModel ilvMapLayerTreeModel = IlvMapLayerTreeProperty.GetMapLayerTreeModel((IlvManager)ilvManager);
        IlvMapLayer ilvMapLayer = ilvMapLayerTreeModel.findChildLayer(null, SYMBOL_LAYER_NAME);
        return ilvMapLayer;
    }

    protected IlvMapLayer createSymbolMapLayer(IlvManager ilvManager) {
        IlvMapLayer ilvMapLayer = new IlvMapLayer();
        ilvMapLayer.setStyle(new IlvMapStyle());
        ilvMapLayer.getStyle().setThinClientBackground(false);
        ilvMapLayer.setName(SYMBOL_LAYER_NAME);
        IlvMapLayerTreeModel ilvMapLayerTreeModel = IlvMapLayerTreeProperty.GetMapLayerTreeModel((IlvManager)ilvManager);
        ilvMapLayerTreeModel.addChild(null, ilvMapLayer);
        ilvMapLayer.setManager(ilvManager);
        ilvMapLayer.insert(new IlvManagerLayer());
        ilvMapLayer.getManagerLayer().setQuadtreeEnabled(false);
        ilvMapLayerTreeModel.arrangeLayers();
        this.setNodesLayer(ilvMapLayer.getManagerLayer().getIndex());
        ilvManager.addManagerLayerListener((ManagerLayerListener)new LayerListener(ilvMapLayer));
        return ilvMapLayer;
    }

    protected IlvMapLayer createLinkMapLayer(IlvManager ilvManager) {
        IlvMapLayer ilvMapLayer = new IlvMapLayer();
        ilvMapLayer.setStyle(new IlvMapStyle());
        ilvMapLayer.getStyle().setThinClientBackground(false);
        ilvMapLayer.setName(LINK_LAYER_NAME);
        IlvMapLayerTreeModel ilvMapLayerTreeModel = IlvMapLayerTreeProperty.GetMapLayerTreeModel((IlvManager)ilvManager);
        ilvMapLayerTreeModel.addChild(null, ilvMapLayer);
        ilvMapLayer.setManager(ilvManager);
        ilvMapLayer.insert(new IlvManagerLayer());
        ilvMapLayer.getManagerLayer().setQuadtreeEnabled(false);
        ilvMapLayerTreeModel.arrangeLayers();
        this.setNodesLayer(ilvMapLayer.getManagerLayer().getIndex());
        ilvManager.addManagerLayerListener((ManagerLayerListener)new LayerListener(ilvMapLayer));
        return ilvMapLayer;
    }

    public void addNodeGraphic(IlvSDMEngine ilvSDMEngine, Object object, IlvGraphic ilvGraphic, boolean bl) {
        IlvNamedProperty ilvNamedProperty = ilvSDMEngine.getGrapher().getNamedProperty("__IlvMapLayerTreeProperty");
        if (ilvNamedProperty == null) {
            super.addNodeGraphic(ilvSDMEngine, object, ilvGraphic, bl);
            return;
        }
        IlvMapLayer ilvMapLayer = IlvMapStyleSheetRenderer.getSymbolMapLayer((IlvManager)ilvSDMEngine.getGrapher());
        if (ilvMapLayer == null) {
            ilvMapLayer = this.createSymbolMapLayer((IlvManager)ilvSDMEngine.getGrapher());
            this.setNodesLayer(ilvMapLayer.getManagerLayer().getIndex());
        } else if (ilvMapLayer.getManagerLayer() != null && this.getNodesLayer() != ilvMapLayer.getManagerLayer().getIndex()) {
            this.setNodesLayer(ilvMapLayer.getManagerLayer().getIndex());
        }
        ilvSDMEngine.getGrapher().addNode(ilvGraphic, this.getNodesLayer(), bl);
    }

    public void addLinkGraphic(IlvSDMEngine ilvSDMEngine, Object object, IlvGraphic ilvGraphic, boolean bl) {
        IlvNamedProperty ilvNamedProperty = ilvSDMEngine.getGrapher().getNamedProperty("__IlvMapLayerTreeProperty");
        if (ilvNamedProperty == null) {
            super.addLinkGraphic(ilvSDMEngine, object, ilvGraphic, bl);
            return;
        }
        IlvMapLayer ilvMapLayer = IlvMapStyleSheetRenderer.getLinkMapLayer((IlvManager)ilvSDMEngine.getGrapher());
        if (ilvMapLayer == null) {
            ilvMapLayer = this.createLinkMapLayer((IlvManager)ilvSDMEngine.getGrapher());
            this.setLinksLayer(ilvMapLayer.getManagerLayer().getIndex());
        } else if (ilvMapLayer.getManagerLayer() != null && this.getLinksLayer() != ilvMapLayer.getManagerLayer().getIndex()) {
            this.setLinksLayer(ilvMapLayer.getManagerLayer().getIndex());
        }
        ilvSDMEngine.getGrapher().addLink((IlvLinkImage)ilvGraphic, this.getLinksLayer(), bl);
    }

    private final class LayerListener
    implements ManagerLayerListener {
        private final IlvMapLayer a;

        private LayerListener(IlvMapLayer ilvMapLayer) {
            this.a = ilvMapLayer;
        }

        public void layerRemoved(ManagerLayerRemovedEvent managerLayerRemovedEvent) {
            if (managerLayerRemovedEvent.getLayer() == this.a.getManagerLayer()) {
                IlvSDMEngine ilvSDMEngine;
                managerLayerRemovedEvent.getManager().removeManagerLayerListener((ManagerLayerListener)this);
                if (managerLayerRemovedEvent.getManager() instanceof IlvGrapher && (ilvSDMEngine = IlvSDMEngine.getSDMEngine((IlvGrapher)managerLayerRemovedEvent.getManager())) != null) {
                    ilvSDMEngine.getModel().setAdjusting(true);
                    Enumeration enumeration = ilvSDMEngine.getAllObjects();
                    while (enumeration.hasMoreElements()) {
                        Object e = enumeration.nextElement();
                        ilvSDMEngine.getModel().removeObject(e);
                    }
                    ilvSDMEngine.getModel().setAdjusting(false);
                }
            }
        }

        public void layerMoved(ManagerLayerMovedEvent managerLayerMovedEvent) {
        }

        public void layerChanged(ManagerLayerEvent managerLayerEvent) {
        }

        public void layerInserted(ManagerLayerInsertedEvent managerLayerInsertedEvent) {
        }
    }
}

