/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class IpUtil {
    public static final String IPv4_All_Zeros_Str = "0.0.0.0";
    public static final String IPv4_All_Ones_Str = "255.255.255.255";
    public static final String IPv4_Class_A_Begin_Str = "1.0.0.0";
    public static final String IPv4_Class_B_Begin_Str = "128.0.0.0";
    public static final String IPv4_Class_C_Begin_str = "192.0.0.0";
    public static final String IPv4_Class_C_End_Str = "223.255.255.255";
    public static final String IPv4_Loopback_Begin_Str = "127.0.0.0";
    public static final String IPv4_Loopback_End_Str = "127.255.255.255";
    public static final String IPv4_Multicast_Begin_STR = "224.0.0.0";
    public static final String IPv4_Multicast_End_Str = "239.255.255.255";
    public static final String IPv4_Separator = ".";
    public static final int IPv4_Max_StrLen = 15;
    public static final int IPv4_Byte_Len = 4;
    public static final String IPv4_Wild = "*";
    public static final String IPv6_Zero_Compression_Token = "::";
    public static final String IPv6_Separator = ":";
    public static final int IPv6_Max_StrLen = 39;
    public static final int Ipv6_Byte_Len = 16;
    public static final Comparator<InetAddress> IPComparator = new Comparator<InetAddress>(){

        @Override
        public int compare(InetAddress addr1, InetAddress addr2) {
            int c = 0;
            if (addr1 != null && addr2 == null) {
                c = -1;
            } else if (addr1 == null && addr2 != null) {
                c = 1;
            } else if (addr1 != null && (c = (addr1 instanceof Inet4Address ? -1 : 1) - (addr2 instanceof Inet4Address ? -1 : 1)) == 0) {
                byte[] ab = addr1.getAddress();
                byte[] bb = addr2.getAddress();
                int max = Math.min(ab.length, bb.length);
                for (int i = 0; i < max && c == 0; ++i) {
                    c = (ab[i] & 0xFF) - (bb[i] & 0xFF);
                }
            }
            return c;
        }
    };

    private IpUtil() {
    }

    public static boolean isAllZeros(InetAddress ip) {
        if (ip == null) {
            return false;
        }
        return ip.getHostAddress().indexOf(IPv4_All_Zeros_Str) >= 0;
    }

    public static boolean isAllOnes(InetAddress ip) {
        if (ip == null) {
            return false;
        }
        return ip.getHostAddress().indexOf(IPv4_All_Ones_Str) >= 0;
    }

    public static String getMask(String ipAddr) {
        int pos = ipAddr.indexOf(46);
        if (pos != -1) {
            if (ipAddr.equals(IPv4_All_Zeros_Str)) {
                return IPv4_All_Zeros_Str;
            }
            try {
                int ip1 = Integer.parseInt(ipAddr.substring(0, pos));
                if (ip1 < 128) {
                    return "255.0.0.0";
                }
                if (ip1 < 192) {
                    return "255.255.0.0";
                }
                if (ip1 < 256) {
                    return "255.255.255.0";
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return "";
    }

    public static InetAddress getByName(int[] oid, int offset) throws UnknownHostException {
        StringBuffer ipAddr = new StringBuffer(Integer.toString(oid[offset]));
        for (int i = offset + 1; i < offset + 4; ++i) {
            ipAddr.append('.');
            ipAddr.append(oid[i]);
        }
        return InetAddress.getByName(ipAddr.toString());
    }

    public static InetAddress getSubnet(InetAddress ip, InetAddress mask) throws UnknownHostException {
        if (ip == null || mask == null) {
            throw new IllegalArgumentException("Invalid arguments:" + ip + "," + mask);
        }
        byte[] ipBytes = ip.getAddress();
        byte[] maskBytes = mask.getAddress();
        byte[] bytes = new byte[]{(byte)(ipBytes[0] & maskBytes[0]), (byte)(ipBytes[1] & maskBytes[1]), (byte)(ipBytes[2] & maskBytes[2]), (byte)(ipBytes[3] & maskBytes[3])};
        return InetAddress.getByAddress(bytes);
    }

    public static boolean isInSubnet(InetAddress ip, InetAddress subnet, InetAddress mask) {
        if (ip == null || subnet == null || mask == null) {
            return false;
        }
        byte[] ipBytes = ip.getAddress();
        byte[] maskBytes = mask.getAddress();
        byte[] bytes = new byte[]{(byte)(ipBytes[0] & maskBytes[0]), (byte)(ipBytes[1] & maskBytes[1]), (byte)(ipBytes[2] & maskBytes[2]), (byte)(ipBytes[3] & maskBytes[3])};
        byte[] subnetBytes = subnet.getAddress();
        for (int i = 0; i < 4; ++i) {
            if (bytes[i] == subnetBytes[i]) continue;
            return false;
        }
        return true;
    }

    public static InetAddress getSubnet(Inet6Address ip, int pfxLen) throws UnknownHostException {
        if (ip == null || pfxLen < 0) {
            throw new IllegalArgumentException("Invalid arguments:" + ip + "," + pfxLen);
        }
        int nBytes = pfxLen / 8;
        int nBits = pfxLen % 8;
        byte[] bytes = ip.getAddress();
        byte[] subnetBytes = new byte[16];
        System.arraycopy(bytes, 0, subnetBytes, 0, nBytes);
        if (nBits != 0) {
            byte mask = (byte)(255 << 8 - nBits);
            subnetBytes[nBytes] = (byte)(bytes[nBytes] & mask);
        }
        return InetAddress.getByAddress(subnetBytes);
    }

    public static InetAddress getAddressByInt(int ipInt) throws UnknownHostException {
        if (ipInt < 0) {
            throw new IllegalArgumentException("Invalid arguments:" + ipInt);
        }
        byte[] addr = new byte[]{(byte)(ipInt >>> 24 & 0xFF), (byte)(ipInt >>> 16 & 0xFF), (byte)(ipInt >>> 8 & 0xFF), (byte)(ipInt & 0xFF)};
        return InetAddress.getByAddress(addr);
    }

    public static int getIntByIP(InetAddress ip) {
        if (ip == null || ip instanceof Inet6Address) {
            throw new IllegalArgumentException("Invalid arguments:" + ip);
        }
        byte[] bytes = ip.getAddress();
        return ((0xFF & bytes[0]) << 24) + ((0xFF & bytes[1]) << 16) + ((0xFF & bytes[2]) << 8) + (0xFF & bytes[3]);
    }

    public static long getUnsignedIntValue(InetAddress ip) {
        if (ip == null || ip instanceof Inet6Address) {
            throw new IllegalArgumentException("Invalid arguments:" + ip);
        }
        byte[] addrs = ip.getAddress();
        int[] bytes = new int[ip.getAddress().length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = IpUtil.convertByte2Int(addrs[i]);
        }
        return ((long)bytes[0] << 24) + ((long)bytes[1] << 16) + ((long)bytes[2] << 8) + (long)bytes[3];
    }

    public static BigInteger getUnsignedBigIntValue(InetAddress ip) {
        byte[] bytes;
        if (ip == null || ip instanceof Inet4Address) {
            throw new IllegalArgumentException("Invalid arguments:" + ip);
        }
        byte[] b = bytes = ip.getAddress();
        if ((bytes[0] & 0x80) != 0) {
            b = new byte[bytes.length + 1];
            System.arraycopy(bytes, 0, b, 1, bytes.length);
        }
        return new BigInteger(b);
    }

    public static boolean isSubnetMask(InetAddress mask) {
        if (mask == null) {
            return false;
        }
        int intValue = IpUtil.getIntByIP(mask);
        boolean start = false;
        for (int idx = 0; idx < 32; ++idx) {
            int bit = intValue >> idx & 1;
            if (!start && bit == 1) {
                start = true;
                continue;
            }
            if (bit != 0 || !start) continue;
            return false;
        }
        return true;
    }

    public static boolean isClassA(InetAddress ip) {
        if (ip == null) {
            return false;
        }
        byte[] bytes = ip.getAddress();
        return (0xFF & bytes[0]) < 128;
    }

    public static boolean isClassB(InetAddress ip) {
        if (ip == null) {
            return false;
        }
        byte[] bytes = ip.getAddress();
        int firstOctet = 0xFF & bytes[0];
        return firstOctet >= 128 && firstOctet <= 191;
    }

    public static boolean isClassC(InetAddress ip) {
        if (ip == null) {
            return false;
        }
        byte[] bytes = ip.getAddress();
        int firstOctet = 0xFF & bytes[0];
        return firstOctet >= 192 && firstOctet <= 223;
    }

    public static boolean isClassAorBorC(InetAddress ip) {
        if (ip == null) {
            return false;
        }
        byte[] bytes = ip.getAddress();
        int firstOctet = 0xFF & bytes[0];
        return firstOctet < 224;
    }

    public static int compare(InetAddress ip1, InetAddress ip2) {
        if (ip1 == ip2) {
            return 0;
        }
        if (ip1 == null) {
            return -1;
        }
        if (ip2 == null) {
            return 1;
        }
        if (ip1 instanceof Inet4Address && ip2 instanceof Inet4Address) {
            Long c1 = IpUtil.getUnsignedIntValue((Inet4Address)ip1);
            Long c2 = IpUtil.getUnsignedIntValue((Inet4Address)ip2);
            return c1.compareTo(c2);
        }
        if (ip1 instanceof Inet6Address && ip2 instanceof Inet6Address) {
            BigInteger c1 = IpUtil.getUnsignedBigIntValue((Inet6Address)ip1);
            BigInteger c2 = IpUtil.getUnsignedBigIntValue((Inet6Address)ip2);
            return c1.compareTo(c2);
        }
        if (ip1 instanceof Inet4Address) {
            return -1;
        }
        return 1;
    }

    public static boolean isInRange(InetAddress checkIp, InetAddress startIp, InetAddress endIp) {
        if (checkIp == null || startIp == null || endIp == null) {
            return false;
        }
        if (IpUtil.compare(startIp, endIp) > 0) {
            return false;
        }
        if (IpUtil.compare(checkIp, startIp) < 0) {
            return false;
        }
        return IpUtil.compare(checkIp, endIp) <= 0;
    }

    public static InetAddress[] getIpRange(String rangeStr) throws UnknownHostException {
        if (rangeStr == null || rangeStr.length() == 0) {
            throw new IllegalArgumentException("Invalid arguments:" + rangeStr);
        }
        String[] dotStr = rangeStr.split("\\.");
        if (dotStr.length != 4) {
            throw new IllegalArgumentException("Invalid arguments:" + rangeStr + "," + dotStr);
        }
        InetAddress[] ipRange = new Inet4Address[2];
        byte[] bytes = new byte[4];
        for (int i = 0; i < 3; ++i) {
            int n = Integer.parseInt(dotStr[i]);
            if (n < 0 || n > 255) {
                throw new IllegalArgumentException("Invalid arguments:" + rangeStr);
            }
            bytes[i] = IpUtil.convertInt2Byte(n);
        }
        dotStr[3] = dotStr[3].trim();
        if (dotStr[3].equals(IPv4_Wild)) {
            bytes[3] = 1;
            ipRange[0] = Inet4Address.getByAddress(bytes);
            bytes[3] = IpUtil.convertInt2Byte(255);
            ipRange[1] = Inet4Address.getByAddress(bytes);
        } else {
            String[] rStr = dotStr[3].split("\\-");
            if (rStr.length != 2) {
                throw new IllegalArgumentException("Invalid arguments:" + rangeStr);
            }
            rStr[0] = rStr[0].trim();
            bytes[3] = IpUtil.convertInt2Byte(Integer.parseInt(rStr[0]));
            ipRange[0] = Inet4Address.getByAddress(bytes);
            rStr[1] = rStr[1].trim();
            bytes[3] = IpUtil.convertInt2Byte(Integer.parseInt(rStr[1]));
            ipRange[1] = Inet4Address.getByAddress(bytes);
        }
        return ipRange;
    }

    public static List<InetAddress> getIPsFromRange(String rangeStr) throws Exception {
        if (rangeStr == null || rangeStr.length() == 0) {
            System.err.println("IpUtil.getIPsFromRange: Invalid arguments:" + rangeStr);
            return Collections.EMPTY_LIST;
        }
        String[] dotStr = rangeStr.split("\\.");
        if (dotStr.length != 4) {
            String[] splitStr;
            boolean ok = false;
            if (dotStr.length == 7 && dotStr[3].indexOf(45) != -1 && dotStr[0].equals((splitStr = dotStr[3].split("-"))[1]) && dotStr[1].equals(dotStr[4]) && dotStr[2].equals(dotStr[5])) {
                dotStr[3] = splitStr[0] + '-' + dotStr[6];
                String[] newDotStr = new String[4];
                System.arraycopy(dotStr, 0, newDotStr, 0, 4);
                dotStr = newDotStr;
                ok = true;
            }
            if (!ok) {
                System.err.println("IpUtil.getIPsFromRange: Invalid arguments(range format not supported):" + rangeStr + "," + dotStr);
                throw new Exception("Invalid range:" + rangeStr);
            }
        }
        byte[] bytes = new byte[4];
        for (int i = 0; i < 3; ++i) {
            int n = Integer.parseInt(dotStr[i]);
            if (n < 0 || n > 255) {
                System.err.println("IpUtil.getIPsFromRange: Invalid arguments:" + rangeStr);
                throw new Exception("Invalid arguments:" + rangeStr);
            }
            bytes[i] = IpUtil.convertInt2Byte(n);
        }
        dotStr[3] = dotStr[3].trim();
        ArrayList<InetAddress> ipList = new ArrayList<InetAddress>();
        if (dotStr[3].equals(IPv4_Wild)) {
            for (int i = 1; i <= 255; ++i) {
                bytes[3] = IpUtil.convertInt2Byte(i);
                try {
                    ipList.add(InetAddress.getByAddress(bytes));
                    continue;
                }
                catch (Exception ex) {
                    System.err.println("IpUtil.getIPsFromRange, cannot resolve IP string to InetAddress:" + ex.getMessage());
                    throw new Exception("cannot resolve IP string to InetAddress:" + rangeStr);
                }
            }
        } else {
            String[] rStr = dotStr[3].split("\\-");
            if (rStr.length != 2) {
                System.err.println("IpUtil.getIPsFromRange: cannot parse IP string to InetAddress, Invalid arguments:" + rangeStr);
                throw new Exception("cannot parse IP string to InetAddress, Invalid arguments:" + rangeStr);
            }
            rStr[0] = rStr[0].trim();
            int low = Integer.parseInt(rStr[0]);
            int high = Integer.parseInt(rStr[1]);
            for (int b = low; b <= high; ++b) {
                bytes[3] = IpUtil.convertInt2Byte(b);
                try {
                    ipList.add(InetAddress.getByAddress(bytes));
                    continue;
                }
                catch (Exception ex) {
                    System.err.println("IpUtil.getIPsFromRange: cannot resolve IP string to InetAddress: " + ex.getMessage());
                    throw new Exception("cannot resolve IP string to InetAddress:" + rangeStr);
                }
            }
        }
        return ipList;
    }

    public static byte convertInt2Byte(int n) {
        byte ret = 0;
        int tmp = n;
        for (int i = 0; i < 8; ++i) {
            ret = (byte)(ret << 1);
            if ((tmp & 0x80) > 0) {
                ret = (byte)(ret | 1);
            }
            tmp <<= 1;
        }
        return ret;
    }

    public static int convertByte2Int(byte b) {
        return (char)b & 0xFF;
    }

    public static boolean isValidMgmtAddress(InetAddress nodeIp) {
        return nodeIp != null && !nodeIp.isLoopbackAddress() && !nodeIp.isMulticastAddress() && !nodeIp.isLinkLocalAddress() && !IpUtil.isAllZeros(nodeIp) && !IpUtil.isAllOnes(nodeIp);
    }

    public static String getIPListInString(List<InetAddress> ipList, String delimit) {
        if (ipList == null || ipList.size() == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        Collections.sort(ipList, IPComparator);
        int mark = -1;
        int i = 0;
        while (i < ipList.size()) {
            InetAddress stIP = ipList.get(i);
            if (stIP instanceof Inet6Address) {
                sb.append(ipList.get(i).getHostAddress()).append(delimit);
                ++i;
                continue;
            }
            mark = -1;
            byte[] stBytes = stIP.getAddress();
            byte[] endBytes = null;
            byte lastByte = stBytes[3];
            int k = i + 1;
            while (k < ipList.size() && stBytes[0] == (endBytes = ipList.get(k).getAddress())[0] && stBytes[1] == endBytes[1] && stBytes[2] == endBytes[2] && lastByte == endBytes[3] - 1) {
                lastByte = endBytes[3];
                mark = k++;
            }
            if (mark == -1) {
                sb.append(0xFF & stBytes[0]).append('.').append(0xFF & stBytes[1]).append('.').append(0xFF & stBytes[2]).append('.').append(0xFF & stBytes[3]).append(delimit);
                ++i;
                continue;
            }
            sb.append(0xFF & stBytes[0]).append('.').append(0xFF & stBytes[1]).append('.').append(0xFF & stBytes[2]).append('.').append(0xFF & stBytes[3]).append('-').append(0xFF & lastByte).append(delimit);
            i = mark + 1;
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    public static List<InetAddress> getIPListFromString(String ipStr, String delimit) throws Exception {
        String[] ipStrs = ipStr.split(delimit);
        HashSet<InetAddress> ipSet = new HashSet<InetAddress>();
        for (String str : ipStrs) {
            str = str.trim();
            if ((str = str.replaceAll("\\s+", "")).indexOf("-") < 0 || IpUtil.isHostnameFormat(str)) {
                try {
                    ipSet.add(InetAddress.getByName(str));
                    continue;
                }
                catch (UnknownHostException ex) {
                    System.err.println("IpUtil: cannot resolve IP string to InetAddress:" + str);
                    throw ex;
                }
                catch (Exception ex) {
                    System.err.println("IpUtil: cannot parse IP string to InetAddress:" + str);
                    throw ex;
                }
            }
            try {
                List<InetAddress> ipList = IpUtil.getIPsFromRange(str);
                if (ipList == null) continue;
                ipSet.addAll(ipList);
            }
            catch (Exception ex) {
                System.err.println("IpUtil: cannot parse IP range to InetAddress:" + str);
                throw ex;
            }
        }
        ArrayList<InetAddress> ipList = new ArrayList<InetAddress>(ipSet);
        Collections.sort(ipList, IPComparator);
        return ipList;
    }

    public static ArrayList<String> getIPStringListFromString(String ipStr, String delimit) throws Exception {
        List<InetAddress> list = IpUtil.getIPListFromString(ipStr, delimit);
        ArrayList<String> strList = new ArrayList<String>();
        for (InetAddress net : list) {
            strList.add(net.getHostAddress());
        }
        return strList;
    }

    private static boolean isHostnameFormat(String ipStr) {
        int hCount = 0;
        for (char c : ipStr.toCharArray()) {
            if (c == '-') {
                ++hCount;
                continue;
            }
            if (Character.isDigit(c) || c == '.') continue;
            return true;
        }
        return hCount > 1;
    }
}

