/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import com.cisco.dcbu.lib.jnm.ExternalTools;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpTrapSession;
import com.cisco.dcbu.lib.snmp.VshManager;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.util.ClientCache;
import com.cisco.dcbu.lib.util.GenUtil;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class LogWindow
extends JTextArea
implements ActionListener {
    protected JPopupMenu _menu;
    protected JCheckBoxMenuItem _snmpTrace;
    protected JCheckBoxMenuItem _trapTrace;

    public LogWindow() {
        this.addMouseListener(new MouseAdapter(){

            void checkPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    if (LogWindow.this._menu == null) {
                        LogWindow.this._menu = LogWindow.this.buildMenu();
                    }
                    LogWindow.this._snmpTrace.setSelected(SnmpSession.isTrace());
                    if (LogWindow.this._trapTrace != null) {
                        LogWindow.this._trapTrace.setSelected(SnmpTrapSession.isTrace());
                    }
                    LogWindow.this._menu.show(LogWindow.this, e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.checkPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.checkPopup(e);
            }
        });
    }

    protected JPopupMenu buildMenu() {
        JPopupMenu menu = new JPopupMenu();
        String[] labels = new String[]{"Clear", "Copy", "Export...", "Open Log File..."};
        for (int i = 0; i < labels.length; ++i) {
            menu.add(this.addItem(labels[i], false));
        }
        menu.addSeparator();
        menu.add(this.addItem("SNMP Statistics", false));
        menu.add(this.addItem("Thread Dump", false));
        menu.add(this.addItem("Thread Dump with Stack Trace", false));
        this._snmpTrace = (JCheckBoxMenuItem)this.addItem("Trace SNMP", true);
        menu.add(this._snmpTrace);
        this._trapTrace = (JCheckBoxMenuItem)this.addItem("Trace Traps", true);
        menu.add(this._trapTrace);
        menu.add(this.addItem("Vsh Dump", false));
        return menu;
    }

    protected JMenuItem addItem(String label, boolean checkbox) {
        JMenuItem mi = checkbox ? new JCheckBoxMenuItem(label) : new JMenuItem(label);
        mi.addActionListener(this);
        return mi;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = ((AbstractButton)e.getSource()).getText();
        switch (cmd.charAt(0)) {
            case 'C': {
                if (cmd.charAt(1) == 'l') {
                    this.setText(" ");
                    this.setText(null);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            System.gc();
                        }
                    });
                    break;
                }
                this.copy();
                break;
            }
            case 'E': {
                Window w = SwingUtilities.windowForComponent(this);
                JFrame f = (JFrame)(w instanceof JFrame ? w : w.getParent());
                String fName = Util.getFileName(f, "*.txt", 1);
                if (fName == null) break;
                try {
                    FileWriter out = new FileWriter(fName);
                    this.write(out);
                    out.close();
                }
                catch (IOException ex) {
                    Util.errorMessage((Component)this, "Can't write: " + ex.getMessage());
                }
                break;
            }
            case 'S': {
                DefaultLogger._DumpLogger.info((Object)SnmpSession.getStatsInfo());
                DefaultLogger._DumpLogger.info((Object)SnmpTrapSession.getStatsInfo());
                break;
            }
            case 'T': {
                if (cmd.charAt(6) == 'S') {
                    SnmpSession.setTrace(this._snmpTrace.isSelected());
                    break;
                }
                if (cmd.charAt(6) == 'T' && this._trapTrace != null) {
                    SnmpTrapSession.setTrace(this._trapTrace.isSelected());
                    break;
                }
                boolean showStackTrace = cmd.contains("Stack Trace");
                DefaultLogger._DumpLogger.info((Object)GenUtil.dumpAllThreads(showStackTrace));
                break;
            }
            case 'V': {
                DefaultLogger._DumpLogger.info((Object)VshManager.getInstance().info());
                break;
            }
            case 'O': {
                Window window = SwingUtilities.windowForComponent(this);
                JFrame frame = (JFrame)(window instanceof JFrame ? window : window.getParent());
                String fileName = Util.getFileName(frame, ClientCache.getLocation() + File.separator + "logs" + File.separator + "fm.log", "*.log", 0, true);
                if (fileName == null) break;
                try {
                    ExternalTools.openUnknownFile(fileName);
                    break;
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    protected boolean isSnmpTraceSelected() {
        return this._snmpTrace.isSelected();
    }

    public static void setLogLevel(Level level, String[] categoryNames) {
        if (level == null || categoryNames == null) {
            return;
        }
        Logger _Logger = null;
        for (int i = 0; i < categoryNames.length; ++i) {
            if (categoryNames[i] == null || categoryNames[i].length() <= 0) continue;
            _Logger = LogManager.getLogger((String)categoryNames[i]);
            _Logger.setLevel(level);
            if (!categoryNames[i].equals("snmp")) continue;
            Enumeration en = LogManager.getCurrentLoggers();
            while (en.hasMoreElements()) {
                Logger log = (Logger)en.nextElement();
                if (!log.getName().startsWith("snmp") || log.getName().equals("snmp.trap")) continue;
                log.setLevel(level);
            }
        }
    }
}

