/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpString;
import java.util.StringTokenizer;

public final class SnmpIscsiLun
extends SnmpString {
    public SnmpIscsiLun(byte[] fcId) {
        super(fcId);
    }

    public SnmpIscsiLun(String fcId) throws SnmpException {
        super(SnmpIscsiLun.parse(fcId));
    }

    @Override
    public String toString() {
        if (this._value == null) {
            this._value = SnmpIscsiLun.toString(this._byteValue);
        }
        return this._value;
    }

    public static String toString(byte[] value) {
        if (value == null || value.length == 0) {
            return null;
        }
        if (value.length > 2) {
            for (int i = 2; i < value.length; ++i) {
                if (value[i] == 0) continue;
                return SnmpIscsiLun.toHexString(value);
            }
        }
        return Integer.toHexString(((value[0] & 0xFF) << 8) + (value[1] & 0xFF));
    }

    public static byte[] parse(String lunNum) throws SnmpException {
        if (lunNum.indexOf(58) == -1) {
            try {
                if (lunNum.length() > 4) {
                    throw new NumberFormatException();
                }
                if (lunNum.length() != 4) {
                    String[] s = new String[]{"000", "00", "0"};
                    lunNum = s[lunNum.length() - 1] + lunNum;
                }
                String b1String = lunNum.substring(0, 2);
                String b2String = lunNum.substring(2);
                lunNum = b1String + ":" + b2String;
                byte[] b2 = SnmpString.fromHexString(lunNum);
                byte[] b = new byte[8];
                System.arraycopy(b2, 0, b, 0, b2.length);
                return b;
            }
            catch (Exception ex) {
                throw new SnmpException("bad Lun");
            }
        }
        lunNum = lunNum.startsWith("0x") ? lunNum.substring(2) : lunNum;
        try {
            StringTokenizer st = new StringTokenizer(lunNum, ":");
            byte[] b = new byte[st.countTokens()];
            if (b.length > 8) {
                throw new NumberFormatException();
            }
            StringBuffer sb = new StringBuffer();
            while (st.hasMoreTokens()) {
                sb.append(st.nextToken().trim());
            }
            String lunS = sb.toString();
            sb = new StringBuffer();
            for (int i = 0; i < lunS.length(); i += 2) {
                if (i != 0) {
                    sb.append(":");
                }
                sb.append(lunS.substring(i, i + 2));
            }
            b = new byte[8];
            byte[] lunB = SnmpString.fromHexString(sb.toString());
            System.arraycopy(lunB, 0, b, 0, lunB.length);
            return b;
        }
        catch (Exception ex) {
            throw new SnmpException("bad Lun");
        }
    }
}

