/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.jnm;

import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.DefaultCellEditor;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;

public class TrapLogDialog
extends JDialog
implements ActionListener,
KeyListener {
    static final String[] _Headers = new String[]{"Node", "Time", "Type", "Description"};
    static final boolean[] _Editable = new boolean[]{false, false, false, true};
    static final String[] _Buttons = new String[]{"Export...", "Clear", "Close"};
    static final String[] _ClearLabels = new String[]{"All", "Selected", "coldStart", "warmStart", "linkUp", "linkDown", "authFailure"};
    public static boolean _HideNodeColumn;
    KTableModel _model = new KTableModel();
    KTable _table;
    JMenu _clearMenu;
    AbstractButton[] _buttons;

    public TrapLogDialog(JFrame parent, Array trapData) {
        super((Frame)parent, "Notification (Trap) Log");
        this._model.setHeaders(_Headers);
        this._model.setData(trapData);
        this._model.setEditable(_Editable);
        this._model.setErrorComponent(this);
        this._table = new KTable(this._model);
        this._table.setAutoResizeMode(3);
        this._table.getTableHeader().addMouseListener(new HeaderListener());
        this._table.setSortable(true);
        this._table.setCellSelectionEnabled(true);
        JScrollPane tablePane = new JScrollPane(this._table);
        int[] colWidth = new int[]{90, 120, 130, 300};
        for (int i = 0; i < colWidth.length; ++i) {
            this._table.getColumnModel().getColumn(i).setPreferredWidth(colWidth[i]);
        }
        tablePane.setPreferredSize(new Dimension(560, 200));
        this.setResizable(true);
        if (_HideNodeColumn) {
            TableColumn col = this._table.getColumn(_Headers[0]);
            this._table.removeColumn(col);
        }
        TableColumn col = this._table.getColumn(_Headers[3]);
        col.setCellEditor(new DescriptionCellEditor(parent));
        DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)col.getHeaderRenderer();
        if (renderer != null) {
            renderer.setToolTipText("Double-click in cell to see full description");
        }
        this._buttons = DialogUtil.buildButtons(_Buttons, (ActionListener)this);
        this.addPulldown(this._buttons[1]);
        DialogUtil.buildDialog((JDialog)this, (Container)parent, (Container)tablePane, this._buttons);
        this.setResizable(true);
        DialogUtil.addKeyListener(this.getContentPane(), this);
    }

    void addPulldown(AbstractButton b) {
        this._clearMenu = new JMenu();
        for (int i = 0; i < _ClearLabels.length; ++i) {
            JMenuItem mi = new JMenuItem(_ClearLabels[i]);
            mi.addActionListener(this);
            this._clearMenu.add(mi);
        }
        b.setIcon(HeaderListener.getDownImage());
        b.setHorizontalTextPosition(2);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._buttons[0]) {
            FileDialog f = new FileDialog((Frame)((JFrame)this.getParent()), "Export", 1);
            f.setFile("traps.txt");
            f.setVisible(true);
            String fName = f.getFile();
            if (fName != null) {
                this._table.export(f.getDirectory() + File.separator + fName);
            }
        } else if (e.getSource() == this._buttons[1]) {
            this._clearMenu.getPopupMenu().show(this._buttons[1], 0, this._buttons[1].getHeight());
        } else if (e.getSource() == this._buttons[2]) {
            this.setVisible(false);
        } else if (e.getSource() instanceof JMenuItem) {
            String cmd = ((JMenuItem)e.getSource()).getText();
            switch (cmd.charAt(0)) {
                case 'A': {
                    this._model.getData().clear();
                    this._model.fireTableDataChanged();
                    break;
                }
                case 'S': {
                    int[] rows = this._table.getSelectedRows();
                    if (rows == null || rows.length == 0) break;
                    for (int i = 0; i < rows.length; ++i) {
                        this._model.getData().removeElementAt(rows[0]);
                    }
                    this._model.fireTableRowsDeleted(rows[0], rows[rows.length - 1]);
                    break;
                }
                default: {
                    this.removeTrap(cmd);
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 27) {
            this.setVisible(false);
        }
    }

    void removeTrap(String type) {
        for (int i = 0; i < this._model.getData().size(); ++i) {
            String t = (String)this._model.getValueAt(i, 2);
            if (!t.startsWith(type)) continue;
            this._model.getData().removeElementAt(i);
            --i;
        }
        this._model.fireTableDataChanged();
    }

    class DescriptionCellEditor
    extends DefaultCellEditor {
        JFrame _parent;
        JDialog _editor;
        JTextArea _textArea;

        public DescriptionCellEditor(JFrame parent) {
            super(new JTextField());
            this._parent = parent;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (this._editor == null) {
                this._editor = new JDialog((Frame)this._parent, "Trap Description");
                this._textArea = new JTextArea();
                JScrollPane sp = new JScrollPane(this._textArea);
                sp.setPreferredSize(new Dimension(400, 120));
                this._editor.getContentPane().add(sp);
                this._editor.pack();
            }
            int col = table.convertColumnIndexToModel(column);
            String text = TrapLogDialog.this._model.getValueAt(row, col).toString().replace('|', '\n');
            this._textArea.setText(text);
            Rectangle rect = table.getCellRect(row, column, false);
            this._editor.setLocation(DialogUtil.getPointOnScreen(new Point(rect.x + 10, rect.y), table, this._editor.getSize()));
            this._editor.setVisible(true);
            return null;
        }
    }
}

