/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.logging;

import com.cisco.dcbu.lib.logging.ConsoleFormatter;
import com.cisco.dcbu.lib.logging.DbgConsoleHandler;
import com.cisco.dcbu.lib.util.ClientCache;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class LocalLogManager {
    static String LINESEP = System.getProperty("line.separator");
    static boolean _StackTrace = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readConfiguration(String propertyFile) throws Exception {
        try (FileInputStream fis = null;){
            File file = new File(propertyFile);
            if (!file.exists()) {
                throw new Exception("cannot find logging configuration file " + propertyFile);
            }
            if (!file.canRead()) {
                throw new Exception("cannot read logging configuration file " + propertyFile);
            }
            fis = new FileInputStream(file);
            if (fis == null) {
                throw new IOException("cannot load logging configuration file " + propertyFile);
            }
            LogManager.getLogManager().readConfiguration(fis);
        }
    }

    public static Logger getLogger(String name) {
        LogManager lm = LogManager.getLogManager();
        Logger logger = lm.getLogger(name);
        if (logger != null) {
            return logger;
        }
        logger = Logger.getLogger(name);
        String value = lm.getProperty(name + ".level");
        if (value != null) {
            try {
                logger.setLevel(Level.parse(value));
            }
            catch (IllegalArgumentException ex) {
                System.err.println("invalid logging level \"" + value + "\" for Logger " + name);
            }
        }
        if ((value = lm.getProperty(name + ".useParentHandlers")) != null) {
            logger.setUseParentHandlers(Boolean.valueOf(value));
        }
        if ((value = lm.getProperty(name + ".handler")) != null) {
            String logFile;
            StreamHandler h = null;
            if (value.equals("System.out")) {
                h = new DbgConsoleHandler(System.out);
            } else if (value.equals("System.err")) {
                h = new DbgConsoleHandler(System.err);
            } else if (value.startsWith("file:") && (logFile = value.substring(5).trim()).length() > 0) {
                try {
                    h = new FileHandler(ClientCache.getInstallLocation() + logFile);
                }
                catch (Exception ex) {
                    System.err.println("Opening debug file " + logFile + " failed: " + ex);
                }
            }
            if (h != null) {
                logger.addHandler(h);
            }
        }
        if ((value = lm.getProperty(name + ".formatter")) != null && value.equals("ConsoleFormatter")) {
            logger.getHandlers()[0].setFormatter(new ConsoleFormatter());
        }
        return logger;
    }

    public static Level getLoggerLevel(String name) {
        Logger logger = LogManager.getLogManager().getLogger(name);
        if (logger != null) {
            return logger.getLevel();
        }
        return null;
    }

    public static void setLoggerLevel(String name, String level) {
        Logger logger = LogManager.getLogManager().getLogger(name);
        if (logger != null) {
            logger.setLevel(Level.parse(level.toUpperCase()));
        }
    }

    public static void setLoggerOutputStream(String name, OutputStream os) {
        LocalLogManager.setLoggerOutputStream(Logger.getLogger(name), os);
    }

    public static void setLoggerOutputStream(Logger logger, OutputStream os) {
        if (logger != null) {
            Formatter f = null;
            Level l = logger.getLevel();
            Handler[] handlers = logger.getHandlers();
            if (handlers != null && handlers.length != 0) {
                for (int i = 0; i < handlers.length; ++i) {
                    logger.removeHandler(handlers[i]);
                    f = handlers[i].getFormatter();
                    l = handlers[i].getLevel();
                }
            }
            if (f == null) {
                f = new Formatter(){

                    @Override
                    public String format(LogRecord record) {
                        return LINESEP + record.getMessage();
                    }
                };
            }
            StreamHandler h = new StreamHandler(os, f);
            h.setLevel(l == null ? Level.WARNING : l);
            logger.addHandler(h);
        }
    }

    public static void addLoggerOutputStream(String name, OutputStream os) {
        Logger logger = Logger.getLogger(name);
        if (logger != null) {
            StreamHandler h = new StreamHandler(os, new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return LINESEP + record.getMessage();
                }
            });
            logger.addHandler(h);
        }
    }

    public static void setStackTrace(boolean b) {
        _StackTrace = b;
    }
}

