/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.map.client;

import com.cisco.dcbu.lib.map.client.DragSelectorTool;
import com.cisco.dcbu.lib.map.client.PopupHandler;
import com.cisco.dcbu.lib.map.client.TopologyDragTool;
import com.cisco.dcbu.lib.map.common.TopologyGraph;
import com.cisco.dcbu.lib.map.common.TopologyNode;
import com.cisco.nm.esper.SelectionWorker;
import com.cisco.nm.esper.lib.graphics.RectPool;
import com.cisco.nm.esper.model.Edge;
import com.cisco.nm.esper.model.EdgeLabel;
import com.cisco.nm.esper.model.Graph;
import com.cisco.nm.esper.model.GraphMember;
import com.cisco.nm.esper.model.NodeLabel;
import com.cisco.nm.esper.tool.SelectorTool;
import com.cisco.nm.esper.tool.event.ExtraMouseListener;
import java.awt.AWTEvent;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;

public class TopologySelectorTool
extends SelectorTool {
    Graph _containerGraph = null;
    public static Logger _Logger = Logger.getLogger(TopologySelectorTool.class);

    public TopologySelectorTool() {
        this.setToolForGesture(null, 1);
        this.setToolForGesture(null, 4);
        this.setToolForGesture(TopologyDragTool.getInstance(), 2);
        this.setToolForGesture(new DragSelectorTool(), 0);
        this.setLabelOwnerSelected(true);
    }

    public Graph getContainerGraph() {
        return this._containerGraph;
    }

    @Override
    public void eventDispatched(AWTEvent event) {
        int id;
        if (this.isActivated() && 500 <= (id = event.getID()) && id <= 507) {
            MouseEvent mousev = (MouseEvent)event;
            this.setMousePosition(mousev.getX(), mousev.getY());
            this.updateActiveGraph(mousev);
            if (mousev.isPopupTrigger()) {
                ExtraMouseListener listener = this.getExtraMouseListener();
                if (listener == null) {
                    listener = this.getGraphComponent().getExtraMouseListener();
                }
                if (listener != null) {
                    switch (id) {
                        case 501: {
                            if (mousev.getClickCount() > 1) {
                                this.abort();
                                listener.onMultiClick(mousev);
                            }
                            if (mousev.isPopupTrigger()) {
                                this.abort();
                                listener.onPopup(mousev);
                            }
                            return;
                        }
                        case 502: {
                            if (mousev.isPopupTrigger()) {
                                this.abort();
                                listener.onPopup(mousev);
                            }
                            return;
                        }
                    }
                }
            }
        }
        super.eventDispatched(event);
    }

    @Override
    public int getOnGraphLocation(int x, int y) {
        int code = super.getOnGraphLocation(x, y);
        if (this.getRootGraph() == this._containerGraph) {
            return -1;
        }
        if (code == 7 || code == 5 || code == 6 || code == 4) {
            code = 12;
        }
        return code;
    }

    void updateContainerGraph(int x, int y) {
        Rectangle bounds = RectPool.INSTANCE.checkRectOut();
        TopologyGraph subGraph = null;
        this._containerGraph = this.getRootGraph();
        if (this.getRootGraph() == null || this.getRootGraph().graphs() == null) {
            return;
        }
        Iterator gIter = this.getRootGraph().graphs().iterator();
        while (gIter.hasNext()) {
            subGraph = (TopologyGraph)gIter.next();
            if (!subGraph.isExpanded()) continue;
            subGraph.getPainter().getBounds(subGraph, this.getTransform(), bounds);
            if (!bounds.contains(x, y)) continue;
            this._containerGraph = subGraph;
            break;
        }
        RectPool.INSTANCE.checkRectIn(bounds);
        if (this._containerGraph == null) {
            this._containerGraph = this.getRootGraph();
        }
    }

    @Override
    protected void select(GraphMember object, int modifiers) {
        SelectionWorker worker = this.getGraphComponent().getSelectionWorker();
        boolean repaint = false;
        if ((modifiers & 2) != 0) {
            if (object != null) {
                object.setSelected(!object.isSelected());
                repaint = true;
            }
        } else if ((modifiers & 1) != 0) {
            if (object != null && !object.isSelected()) {
                object.setSelected(true);
                repaint = true;
            }
        } else if (object == null) {
            repaint = worker.removeAllFromSelected(this.getRootGraph());
        } else {
            worker.removeAllFromSelected(this.getRootGraph());
            object.setSelected(true);
            repaint = true;
        }
        if (this.isLabelOwnerSelected()) {
            if (object instanceof NodeLabel) {
                ((NodeLabel)object).getOwner().setSelected(object.isSelected());
            } else if (object instanceof EdgeLabel) {
                ((EdgeLabel)object).getOwner().setSelected(object.isSelected());
            }
        }
        if (repaint) {
            this.getGraphComponent().asContainer().repaint();
        }
    }

    @Override
    public void onMousePressed(MouseEvent event) {
        try {
            ((TopologyDragTool)this.getToolForGesture(2)).onMouseReleased(event);
        }
        catch (Exception e1) {
            _Logger.trace((Object)"logEmptyCatch - getToolForGesture", (Throwable)e1);
        }
        int x = event.getX();
        int y = event.getY();
        PopupHandler.hidePreviousPopup();
        this.setMouseX(x);
        this.setMouseY(y);
        Graph graph = this.getTopGraphAt(x, y);
        this.updateContainerGraph(x, y);
        if (graph != null) {
            this.setHitObject(graph);
            this.select(graph, event.getModifiers());
            this.setMode(2);
        } else {
            TopologyNode node = (TopologyNode)this.getTopNodeAt(x, y);
            if (node != null) {
                int code;
                NodeLabel nodeLabel = node.getNodeLabel();
                this.select(nodeLabel, event.getModifiers());
                this.setHitObject(node);
                if (!nodeLabel.isSelected() && (event.getModifiers() & 2) != 0) {
                    this.getGraphComponent().asContainer().repaint();
                }
                if ((code = node.getHitCode(x, y, this.getTransform())) >= 4 && code <= 11) {
                    this.setMode(1);
                } else {
                    this.setMode(2);
                    this.getGraphComponent().asContainer().setCursor(this.getActionCursor());
                }
            } else {
                NodeLabel nodeLabel = this.getTopNodeLabelAt(x, y);
                if (nodeLabel != null) {
                    this.setHitObject(nodeLabel.getOwner());
                    this.select(nodeLabel, event.getModifiers());
                    if (!nodeLabel.isSelected() && (event.getModifiers() & 2) != 0) {
                        this.getGraphComponent().asContainer().repaint();
                    }
                    if (nodeLabel.getOwner().isSelected()) {
                        this.setMode(2);
                    } else {
                        this.setMode(6);
                    }
                } else {
                    EdgeLabel edgeLabel = this.getTopEdgeLabelAt(x, y);
                    if (edgeLabel != null) {
                        this.setHitObject(edgeLabel);
                        this.select(edgeLabel, event.getModifiers());
                        this.setMode(2);
                    } else {
                        Edge edge = this.getTopEdgeAt(x, y);
                        if (edge == null) {
                            try {
                                this.getGraphComponent().getSelectionWorker().removeAllFromSelected(this.getRootGraph());
                                ((TopologyDragTool)this.getToolForGesture(2)).onMouseReleased(event);
                                this.getGraphComponent().markCompletelyDirty();
                            }
                            catch (Exception ex) {
                                _Logger.trace((Object)"logEmptyCatch - markCompletelyDirty", (Throwable)ex);
                            }
                            this.setMode(5);
                            this.setHitObject(null);
                        } else {
                            this.setHitObject(edge);
                            this.select(edge, event.getModifiers());
                            this.setMode(4);
                        }
                    }
                }
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    TopologySelectorTool.this.getGraphComponent().asContainer().repaint();
                }
                catch (Exception ex) {
                    _Logger.trace((Object)"logEmptyCatch - repaint", (Throwable)ex);
                }
            }
        });
    }

    @Override
    public void onMouseReleased(MouseEvent event) {
        super.onMouseReleased(event);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    TopologySelectorTool.this.getGraphComponent().markCompletelyDirty();
                    TopologySelectorTool.this.getGraphComponent().asContainer().repaint();
                }
                catch (Exception ex) {
                    _Logger.trace((Object)"logEmptyCatch - TopologySelectorTool.onMouseReleased() repaint", (Throwable)ex);
                }
            }
        });
    }
}

