/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.map.common;

import com.cisco.dcbu.lib.map.common.TopologyLink;
import com.cisco.dcbu.lib.map.common.TopologyNode;
import com.cisco.nm.esper.ToolTipMaker;
import com.cisco.nm.esper.model.EdgeLabel;
import com.cisco.nm.esper.model.Graph;
import com.cisco.nm.esper.model.GraphObject;
import com.cisco.nm.esper.model.NodeLabel;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public class HtmlToolTipMaker
extends ToolTipMaker {
    public static Logger _Logger = Logger.getLogger(HtmlToolTipMaker.class);

    @Override
    protected String newToolTipText(Graph graph, Object object) {
        if (object == null) {
            return null;
        }
        String text = null;
        String formattedText = null;
        TopologyNode node = null;
        TopologyLink link = null;
        GraphObject obj = null;
        boolean isVisible = true;
        try {
            if (object instanceof NodeLabel) {
                node = (TopologyNode)((NodeLabel)object).getParent();
                obj = node;
                formattedText = node.getFormattedTooltip();
                isVisible = node.isVisible();
            } else if (object instanceof EdgeLabel) {
                link = (TopologyLink)((NodeLabel)object).getParent();
                obj = link;
                formattedText = link.getFormattedTooltip();
                isVisible = link.isVisible();
            } else if (object instanceof TopologyNode) {
                node = (TopologyNode)object;
                obj = node;
                formattedText = node.getFormattedTooltip();
                isVisible = node.isVisible();
            } else if (object instanceof TopologyLink) {
                link = (TopologyLink)object;
                obj = link;
                formattedText = link.getFormattedTooltip();
                isVisible = link.isVisible();
                if (link.isDummyLink()) {
                    formattedText = null;
                }
            }
        }
        catch (Exception ex) {
            _Logger.trace((Object)"logEmptyCatch", (Throwable)ex);
        }
        if (formattedText != null && !"".equals(formattedText)) {
            return formattedText;
        }
        if (obj != null) {
            if (isVisible) {
                text = obj.getTooltip();
            }
        } else {
            text = object.toString();
        }
        if (text == null) {
            return null;
        }
        if (text.indexOf(10) == -1) {
            return text;
        }
        StringBuffer buffer = new StringBuffer(text.length() + 21);
        StringTokenizer tokenizer = new StringTokenizer(text, "\n");
        buffer.append("<html>");
        buffer.append("<center>");
        String tt = null;
        int idx = -1;
        int lastIdx = -1;
        int secondIdx = -1;
        boolean first = true;
        boolean table = false;
        do {
            if ((idx = (tt = tokenizer.nextToken()).indexOf("<->")) != -1) {
                secondIdx = tt.indexOf("<->", idx + 3);
            }
            if ((lastIdx = tt.lastIndexOf("<->")) > secondIdx && secondIdx > idx) {
                idx = secondIdx;
            }
            if (idx != -1) {
                if (first) {
                    buffer.append("<table>");
                    table = true;
                    first = false;
                }
                buffer.append("<TR><TD ALIGN=\"right\">" + tt.substring(0, idx).replaceAll("<", "&lt;") + "</TD>");
                buffer.append("<TD>&lt;-></TD>");
                buffer.append("<TD\"left\">" + tt.substring(idx + 4).replaceAll("<", "&lt;") + "</TD></TR>");
                continue;
            }
            if (table) {
                buffer.append("<br>");
                buffer.append("</TABLE><CENTER>").append(tt).append("</CENTER><TABLE>");
                continue;
            }
            if (!first) {
                buffer.append("<br>");
            } else {
                first = false;
            }
            buffer.append(tt);
        } while (tokenizer.hasMoreTokens());
        if (table) {
            buffer.append("</table>");
        }
        buffer.append("</center>");
        buffer.append("</html>");
        if (node != null) {
            node.setFormattedTooltip(buffer.toString());
        } else if (link != null) {
            link.setFormattedTooltip(buffer.toString());
        }
        return buffer.toString();
    }
}

