/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds;

import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.mds.zm.AbstractMdsAction;
import com.cisco.dcbu.lib.mds.zm.ActionEnabler;
import com.cisco.dcbu.lib.mds.zm.PollerCallbackIf;
import com.cisco.dcbu.lib.mds.zm.PollerManager;
import com.cisco.dcbu.lib.mds.zm.StatusIf;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.util.ArrayList;

public class CfsActionCommitter
extends ActionEnabler {
    public static final int[] CFS_ACTION = MibNode.get("cfsFeatureOpAction").getOid();
    public static final int[] CFS_ACTION_RESULT = MibNode.get("cfsFeatureOpLastActionResult").getOid();
    public static final int[] CFS_ACTION_REASON = MibNode.get("cfsFeatureOpLastFailureReason").getOid();
    public static final int[] CFS_ACTION_SCOPE_VAL = MibNode.get("cfsFeatureOpScopeVal").getOid();
    public static final int[] CFS_ACTION_SCOPE_TYPE = MibNode.get("cfsFeatureOpScopeType").getOid();
    public static final MibEnum[] CFS_ENUM = MibNode.get("cfsFeatureOpAction").getEnums();
    public static final int SUCCESS = 2;
    public static final int IN_PROGRESS = 4;
    public static final int DEFAULT_FABRIC_SCOPE = 1;
    public static final int[] DPVM_INDEX = new int[]{4, 100, 112, 118, 109};
    public static final int[] PSM_INDEX = new int[]{4, 100, 112, 118, 109};
    public static final int[] IVR_INDEX = new int[]{3, 105, 118, 114};
    public static final int[] DEVICE_ALIAS_INDEX = new int[]{12, 100, 101, 118, 105, 99, 101, 45, 97, 108, 105, 97, 115};
    public static final int ENABLE_CFS = 2;
    public static final int COMMIT_CFS = 4;
    public static final int ABORT_CFS = 5;
    protected int[] _cfsIndex;
    protected String _featureName;
    protected int _action;
    protected String _actionName;
    protected int[] _scope;

    public CfsActionCommitter(ArrayList taskList, StatusIf statusIf, int[] cfsIndex, int[] scope, int action, String actionName) {
        super(taskList, statusIf);
        this._taskList = taskList;
        this._statusIf = statusIf;
        this._cfsIndex = cfsIndex;
        this._action = action;
        this._actionName = actionName;
        this._scope = scope;
        char[] feature = new char[this._cfsIndex.length - 1];
        for (int i = 0; i < feature.length; ++i) {
            feature[i] = (char)this._cfsIndex[i + 1];
        }
        this._featureName = String.valueOf(feature);
    }

    public CfsActionCommitter(ArrayList taskList, StatusIf statusIf, int[] cfsIndex, int action, String actionName) {
        this(taskList, statusIf, cfsIndex, new int[]{1, -1}, action, actionName);
    }

    @Override
    protected AbstractMdsAction createAction(Object sw, PollerManager manager) throws SnmpException {
        CfsAction act = new CfsAction((SnmpPeer)sw, this);
        manager.addTask(act);
        return act;
    }

    public String getActionName() {
        return this._actionName;
    }

    public class CfsAction
    extends AbstractMdsAction {
        private SnmpPeer _sw;

        private CfsAction(SnmpPeer sw, PollerCallbackIf pollerCallBack) {
            super(pollerCallBack);
            this._sw = sw;
        }

        @Override
        public VarBindList getPollVarBind() {
            VarBindList vb = new VarBindList();
            vb.add(CFS_ACTION_RESULT, CfsActionCommitter.this._cfsIndex);
            vb.add(CFS_ACTION_REASON, CfsActionCommitter.this._cfsIndex);
            return vb;
        }

        @Override
        public VarBindList getActionVarBind() throws SnmpException {
            VarBindList vb = new VarBindList();
            vb.add(CFS_ACTION, CfsActionCommitter.this._cfsIndex, (SnmpVar)new SnmpInt(CfsActionCommitter.this._action));
            if (CfsActionCommitter.this._scope != null && CfsActionCommitter.this._scope.length == 2 && CfsActionCommitter.this._scope[0] != 1) {
                vb.add(CFS_ACTION_SCOPE_TYPE, CfsActionCommitter.this._cfsIndex, (SnmpVar)new SnmpInt(CfsActionCommitter.this._scope[0]));
                vb.add(CFS_ACTION_SCOPE_VAL, CfsActionCommitter.this._cfsIndex, (SnmpVar)new SnmpString(SnmpIntList.valueOf(new int[]{CfsActionCommitter.this._scope[1]})));
            }
            return vb;
        }

        @Override
        public int pollStatus(PollerManager manager, VarBindList response, StringBuffer status) {
            int commitResult = response.intValue(0);
            if (commitResult == 4) {
                if (CfsActionCommitter.this._statusIf != null) {
                    CfsActionCommitter.this._statusIf.setStatus(this._sw + ":checking CFS status for " + CfsActionCommitter.this._actionName);
                }
                return 0;
            }
            if (commitResult == 2) {
                this._pollerCallBack.pollStatus(manager, response, status);
                return 1;
            }
            status.setLength(0);
            status.append("CFS " + CfsActionCommitter.this._actionName + " failed.");
            status.append("\n" + response.stringValue(1));
            return 2;
        }

        @Override
        public void success(PollerManager manager, StringBuffer status) {
            status.setLength(0);
            super.success(manager, status.append("CFS " + CfsActionCommitter.this._actionName + " success."));
        }

        @Override
        public String toString() {
            return "CFS action " + CfsActionCommitter.this._actionName;
        }
    }
}

