/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds;

import com.cisco.dcbu.lib.jnm.Bits;
import com.cisco.dcbu.lib.jnm.DefaultSnmpNumberRenderer;
import com.cisco.dcbu.lib.jnm.Fc4Decoder;
import com.cisco.dcbu.lib.jnm.IfIndexIf;
import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.InterfaceIndex;
import com.cisco.dcbu.lib.jnm.JnmMibEnum;
import com.cisco.dcbu.lib.jnm.SnmpBitmap;
import com.cisco.dcbu.lib.jnm.SnmpDateAndTime;
import com.cisco.dcbu.lib.jnm.SnmpIntList;
import com.cisco.dcbu.lib.jnm.SnmpIscsiLun;
import com.cisco.dcbu.lib.jnm.SnmpLongList;
import com.cisco.dcbu.lib.jnm.WwnDictionary;
import com.cisco.dcbu.lib.mds.ficon.FiconPortAddrList;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCounter64;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpGauge;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpTimeticks;
import com.cisco.dcbu.lib.snmp.SnmpUnsignedInt;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.util.Array;
import java.math.BigInteger;
import java.text.DecimalFormat;

public class MibVariableFormat {
    static final int CARD_OFFSET = 21;
    public static final int LINK_FAILURE_ID = 1;
    public static final int TRUST_SEC_ID = 2;
    public static final int BIT_ERROR_RATE_ID = 3;
    public static final int SIGNAL_LOSS_ID = 4;
    public static final int SYNC_LOSS_ID = 5;
    public static final int LINK_RESET_ID = 6;
    public static final int CREDIT_LOSS_ID = 7;
    public static final int FCIFOPERSTATUSREASON_ZONEMERGE = 24;
    public static IfIndexIf _IfIndexIf;
    static MibEnum[] _IfOpStatusCause;
    public static MibEnum[] _cfsFeatureOpLastAction;
    public static MibEnum[] _FcIfOperStatusReason;
    static MibEnum[] _cfsFeatureOpLastActionResult;
    public static final int ASM_PROV_EMCSR_OFFSET = 1;
    public static final int ASM_PROV_NSP_OFFSET = 2;
    public static final String[] ASM_PROV_Features;
    public static final String[] MSM_PROV_Features;
    static final long[] _HbaPortSpeedValue;
    static final String[] _HbaPortSpeedDisplay;
    public static final String[] _LunDevTypes;
    static final int[][] _InterfaceVars;
    public static final int[][] _UsmUserProtocolOid;
    static final String[] _UsmUserProtocol;
    public static final MibEnum[] _UsmUserProtocolEnums;
    static final long[] _INetPortNumberValue;
    static final String[] _INetPortNumberDisplay;
    static final long[] _TosValue;
    static final String[] _TosDisplay;
    static final long[] _ICMPTypeValue;
    static final String[] _ICMPTypeDisplay;

    private MibVariableFormat() {
    }

    public static Object dmFcIdCacheAge(SnmpVar value) {
        return SnmpTimeticks.formatTimeElapsed(((SnmpTimeticks)value).getValue());
    }

    public static Object ifSpeed(SnmpVar value) {
        if (value instanceof SnmpUnsignedInt) {
            return MibVariableFormat.speedBasic(((SnmpUnsignedInt)value).getValue());
        }
        if (value instanceof SnmpInt) {
            return MibVariableFormat.speedBasic(((SnmpInt)value).getValue());
        }
        return value.toString();
    }

    public static Object connUnitPortSpeed(SnmpVar value) {
        int speed = ((SnmpInt)value).getValue();
        if (speed == 0) {
            return "n/a";
        }
        return speed / 100000 + " Gb";
    }

    public static String speedBasic(long speed) {
        if (speed == 0L) {
            return "n/a";
        }
        if (speed >= 1000000000L) {
            return speed / 1000000000L + " Gb";
        }
        if (speed >= 1000000L) {
            return speed / 1000000L + " Mb";
        }
        if (speed >= 1000L) {
            return speed / 1000L + " kb";
        }
        return speed + " b";
    }

    public static Object ifHighSpeed(SnmpVar value) {
        return MibVariableFormat.highSpeed(((SnmpUnsignedInt)value).getValue());
    }

    public static String highSpeed(long speed) {
        if (speed == 0L) {
            return "n/a";
        }
        if (speed >= 1000L) {
            if (speed / 1000L * 10L == speed / 100L) {
                return speed / 1000L + " Gb";
            }
            return Math.round((double)speed / 1000.0) + " Gb";
        }
        return speed + " Mb";
    }

    public static String convertMemoryUnit(long memoryBytes, DecimalFormat formatter) {
        if (memoryBytes < 0L || memoryBytes > Long.MAX_VALUE) {
            return "n/a";
        }
        double d = 0.0;
        String suffix = null;
        if (memoryBytes >= 0x40000000L) {
            d = (double)memoryBytes / 1.073741824E9;
            suffix = "G";
        } else if (memoryBytes >= 0x100000L) {
            d = (double)memoryBytes / 1048576.0;
            suffix = "M";
        } else if (memoryBytes >= 1024L) {
            d = (double)memoryBytes / 1024.0;
            suffix = "K";
        }
        if (suffix != null) {
            return formatter.format(d) + suffix;
        }
        return Long.toString(memoryBytes) + "Byte";
    }

    public static Object dmAssignedAreaIdList(SnmpVar value) {
        byte[] b = ((SnmpString)value).getValue();
        if (b.length == 0) {
            return "";
        }
        if (b.length == 1) {
            return "0x" + Integer.toHexString(b[0] & 0xFF);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("0x");
        MibVariableFormat.appendHex(b[0], sb);
        boolean inRange = b[1] - b[0] == 1;
        for (int i = 1; i < b.length; ++i) {
            if ((b[i] & 0xFF) - (b[i - 1] & 0xFF) == 1) {
                inRange = true;
                continue;
            }
            if (inRange) {
                sb.append('-');
                MibVariableFormat.appendHex(b[i - 1], sb);
            }
            sb.append(',');
            MibVariableFormat.appendHex(b[i], sb);
            inRange = false;
        }
        if (inRange) {
            sb.append('-');
            MibVariableFormat.appendHex(b[b.length - 1], sb);
        }
        return sb.toString();
    }

    private static void appendHex(byte b, StringBuffer sb) {
        sb.append(SnmpString.HEX_DIGIT[b >> 4 & 0xF]);
        sb.append(SnmpString.HEX_DIGIT[b & 0xF]);
    }

    public static Object fcIfSFPSerialIDData(SnmpVar value) {
        byte[] b = ((SnmpString)value).getValue();
        if (b.length > 96) {
            return MibVariableFormat.getCwdmCode(b[96] & 0xFF);
        }
        return value;
    }

    public static String getCwdmCode(int id) {
        String[] ciscoId = new String[]{"1470", "1490", "1510", "1530", "1550", "1570", "1590", "1610", "60.61", "59.79", "58.98", "58.17", "56.55", "55.75", "54.94", "54.13", "52.52", "51.72", "50.92", "50.12", "48.51", "47.72", "46.92", "46.12", "44.53", "43.73", "42.94", "42.14", "40.56", "39.77", "38.98", "38.19", "36.61", "35.82", "35.04", "34.25", "32.68", "31.90", "31.12", "30.33"};
        if (id >= 1 && id <= 8) {
            return "CWDM-" + ciscoId[id - 1];
        }
        if (id >= 9 && id <= 40) {
            return "DWDM-GBIC-" + ciscoId[id - 1];
        }
        if (id == 41) {
            return "XWDM Rx-Only";
        }
        return Integer.toString(id);
    }

    public static Object cefcTotalDrawnCurrentWithAmps(SnmpVar value, SnmpVar ampsType) {
        return MibVariableFormat.cefcFRUCurrentWithAmps(value, ampsType);
    }

    public static Object cefcTotalDrawnCurrent(SnmpVar value) {
        return MibVariableFormat.cefcFRUCurrent(value);
    }

    public static Object dmFcIdPurge(SnmpVar value) {
        return ((SnmpInt)value).getValue() == 2 ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object iscsi2FcNodeFcAddrAssignment(SnmpVar value) {
        return ((SnmpInt)value).getValue() == 1 ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object portChannelExtPersistent(SnmpVar value) {
        return ((SnmpInt)value).getValue() == 1 ? Boolean.FALSE : Boolean.TRUE;
    }

    public static Object portChannelAddType(SnmpVar value) {
        return ((SnmpInt)value).getValue() == 1 ? Boolean.FALSE : Boolean.TRUE;
    }

    public static Object commonRoleScopeRestriction(SnmpVar value) {
        return MibVariableFormat.dmFcIdPurge(value);
    }

    public static Object cefcModuleAdminStatus(SnmpVar value) {
        return Boolean.FALSE;
    }

    public static Object cPrefPathRouteMapRouteActive(SnmpVar value) {
        return Boolean.FALSE;
    }

    public static Object cefcMaxDefaultHighInLinePowerWithUnit(SnmpVar value, SnmpVar units) {
        SnmpGauge current = (SnmpGauge)value;
        double wattsV = (double)current.getValue() / 1000.0;
        double unitsV = (double)((SnmpInt)units).getValue() / 100.0;
        if (wattsV == 0.0) {
            return "n/a";
        }
        double ampsV = wattsV / unitsV;
        return wattsV + "W / " + ampsV + 'A';
    }

    public static Object cefcMaxDefaultInLinePowerWithUnit(SnmpVar value, SnmpVar units) {
        SnmpInt current = (SnmpInt)value;
        double amp = (double)current.getValue() / 100.0;
        if (amp == 0.0) {
            return "n/a";
        }
        double unit = ((SnmpInt)units).getValue();
        int watt = (int)(amp * unit);
        return (double)watt / 100.0 + "W / " + amp + 'A';
    }

    public static Object cefcMaxDefaultInLinePowerWithAmps(SnmpVar value, SnmpVar ampsType) {
        return MibVariableFormat.cefcFRUCurrentWithAmps(value, ampsType);
    }

    public static Object cefcMaxDefaultInLinePower(SnmpVar value) {
        return MibVariableFormat.cefcFRUCurrent(value);
    }

    public static Object cefcTotalAvailableCurrentWithAmps(SnmpVar value, SnmpVar ampsType) {
        return MibVariableFormat.cefcFRUCurrentWithAmps(value, ampsType);
    }

    public static Object cefcTotalAvailableCurrent(SnmpVar value) {
        return MibVariableFormat.cefcFRUCurrent(value);
    }

    public static Object cefcFRUCurrentWithAmps(SnmpVar value, SnmpVar ampsType) {
        return MibVariableFormat.cefcFRUCurrent(value, ampsType, true);
    }

    public static Object cefcFRUCurrent(SnmpVar value) {
        return MibVariableFormat.cefcFRUCurrent(value, new SnmpInt(1), false);
    }

    public static Object cefcFRUCurrent(SnmpVar value, SnmpVar ampsType) {
        return MibVariableFormat.cefcFRUCurrent(value, ampsType, false);
    }

    public static Object cefcFRUCurrent(SnmpVar value, SnmpVar ampsType, boolean ampsFirst) {
        SnmpInt current = (SnmpInt)value;
        double amp = (double)current.getValue() / 100.0;
        if (amp == 0.0) {
            return "n/a";
        }
        int type = ((SnmpInt)ampsType).getValue();
        double amps = 0.0;
        switch (type) {
            case 1: {
                amps = 4200.0;
                break;
            }
            case 2: {
                amps = 1200.0;
                break;
            }
            case 3: {
                amps = 5600.0;
                break;
            }
            default: {
                amps = 1200.0;
            }
        }
        int watt = (int)(amp * amps);
        if (ampsFirst) {
            return amp + "A / " + (double)watt / 100.0 + "W";
        }
        return (double)watt / 100.0 + "W / " + amp + 'A';
    }

    public static Object portChannelMemberOperStatus(SnmpVar pcMemberList, SnmpVar memberOperStatus, IfIndexIf ifIndexIf) {
        int[] memberList = SnmpIntList.valueOf(((SnmpString)pcMemberList).getValue());
        int[] operStatus = SnmpIntList.valueOf(((SnmpString)memberOperStatus).getValue());
        Array<Integer> mlist = new Array<Integer>();
        for (int i = 0; i < operStatus.length; ++i) {
            if (operStatus[i] != 1 || i >= memberList.length) continue;
            mlist.addElement(new Integer(memberList[i]));
        }
        int[] list = new int[mlist.size()];
        for (int i = 0; i < mlist.size(); ++i) {
            list[i] = (Integer)mlist.elementAt(i);
        }
        return SnmpIntList.toString(list, ifIndexIf, false);
    }

    public static Object cRFStatusUnitId(SnmpVar value) {
        SnmpInt slotNo = (SnmpInt)value;
        slotNo.setValue(slotNo.getValue() - 21);
        return slotNo;
    }

    public static Object cRFStatusPeerUnitId(SnmpVar value) {
        if (((SnmpInt)value).getValue() == 0) {
            return "n/a";
        }
        return MibVariableFormat.cRFStatusUnitId(value);
    }

    public static Object fcIfOperStatusCause(SnmpVar value) {
        if (((SnmpInt)value).getValue() == 0) {
            return "";
        }
        return MibEnum.getLabel(_FcIfOperStatusReason, ((SnmpInt)value).getValue());
    }

    public static Object fcIfOperRxPerfBuffer(SnmpVar value) {
        if (((SnmpInt)value).getValue() == 0) {
            return "n/a";
        }
        return value;
    }

    public static Object dmAreaAssignedPortIdList(SnmpVar value) {
        return MibVariableFormat.dmAssignedAreaIdList(value);
    }

    public static Object cficonPortIfIndex(SnmpVar value) {
        if (!(value instanceof SnmpInt)) {
            return null;
        }
        try {
            return new InterfaceIndex((SnmpInt)value, _IfIndexIf);
        }
        catch (SnmpException snmpException) {
            return value;
        }
    }

    public static Object cficonCfgFileDescr(SnmpVar value) {
        return new SnmpString(value.toString().trim());
    }

    public static Object cficonVsanCupName(SnmpVar value) {
        return MibVariableFormat.cficonCfgFileDescr(value);
    }

    public static Object cficonCfgFileCupName(SnmpVar value) {
        return MibVariableFormat.cficonCfgFileDescr(value);
    }

    public static Object cficonPortName(SnmpVar value) {
        return MibVariableFormat.cficonCfgFileDescr(value);
    }

    public static Object cficonPortRunCfgName(SnmpVar value) {
        return MibVariableFormat.cficonCfgFileDescr(value);
    }

    public static Object cficonDirHistPortNumbers(SnmpVar value) {
        return SnmpBitmap.toString(((SnmpString)value).getValue());
    }

    public static Object dmAllowedDomainIDList(SnmpVar value) {
        return MibVariableFormat.commonRoleScope1(value);
    }

    public static Object cspanVsanFilterVsans2k(SnmpVar value) {
        return MibVariableFormat.commonRoleScope1(value);
    }

    public static Object cspanSourcesVsans2k(SnmpVar value) {
        return MibVariableFormat.commonRoleScope1(value);
    }

    public static Object cFcSdvVdRealDevMapList(SnmpVar value) {
        return SnmpBitmap.toString(((SnmpString)value).getValue(), true);
    }

    public static Object commonRoleScope1(SnmpVar value) {
        byte[] b = ((SnmpString)value).getValue();
        if (b.length == 0) {
            return "";
        }
        return MibVariableFormat.fcIfActiveVsanList2k(value);
    }

    public static Object vlanTrunkPortVlansActiveFirst2k(SnmpVar value) {
        return MibVariableFormat.fcIfAllowedVsanList2k(value);
    }

    public static Object vlanTrunkPortVlansEnabled(SnmpVar value) {
        return MibVariableFormat.fcIfAllowedVsanList2k(value);
    }

    public static Object vmVlans(SnmpVar value) {
        return MibVariableFormat.fcIfAllowedVsanList2k(value);
    }

    public static Object vmVlansNonIPS(SnmpVar value) {
        byte[] b = ((SnmpString)value).getValue();
        if (b.length == 0) {
            return "1-4094";
        }
        return SnmpBitmap.toString(((SnmpString)value).getValue(), true);
    }

    public static Object fcIfAllowedVsanList2k(SnmpVar value) {
        byte[] b = ((SnmpString)value).getValue();
        if (b.length == 0) {
            return "0-4095";
        }
        return MibVariableFormat.fcIfActiveVsanList2k(value);
    }

    public static Object fcAddress(SnmpVar value) {
        return MibVariableFormat.iscsi2FcNodeFCAddr(value);
    }

    public static Object iscsi2FcNodeFCAddr(SnmpVar value) {
        if (((SnmpString)value).isNull()) {
            return "n/a";
        }
        return SnmpString.toHexString(((SnmpString)value).getValue());
    }

    public static Object iscsi2FcNodeVsanList2k(SnmpVar value) {
        return SnmpBitmap.toString(((SnmpString)value).getValue());
    }

    public static Object fcIfActiveVsanUpList2k(SnmpVar value) {
        if (!(value instanceof SnmpString)) {
            return "n/a";
        }
        return MibVariableFormat.fcIfActiveVsanList2k(value);
    }

    public static Object fcIfActiveVsanList2k(SnmpVar value) {
        return SnmpBitmap.toString(((SnmpString)value).getValue());
    }

    public static Object fcIfNxCosSuppAgreed(SnmpVar value) {
        return MibVariableFormat.fcNameServerClassOfSvc(value);
    }

    public static Object fcIfElpCosSuppAgreed(SnmpVar value) {
        return MibVariableFormat.fcNameServerClassOfSvc(value);
    }

    public static Object connUnitSnsClassOfSvc(SnmpVar value) {
        return MibVariableFormat.fcNameServerClassOfSvc(value);
    }

    public static Object fcFxPortCosSupported(SnmpVar value) {
        return MibVariableFormat.fcNameServerClassOfSvc(value);
    }

    public static Object fcFxPortCapCos(SnmpVar value) {
        return MibVariableFormat.fcNameServerClassOfSvc(value);
    }

    public static Object fcIfCapCos(SnmpVar value) {
        return MibVariableFormat.fcNameServerClassOfSvc(value);
    }

    public static Object fcNameServerClassOfSvc(SnmpVar value) {
        StringBuffer sb = null;
        byte b = ((SnmpString)value).getValue()[0];
        for (int i = 0; i < 8; ++i) {
            if ((b >> i & 1) == 0) continue;
            if (sb == null) {
                sb = new StringBuffer();
            } else {
                sb.append(',');
            }
            sb.append(i == 0 ? "F" : Integer.toString(i));
        }
        return sb == null ? "" : sb.toString();
    }

    public static Object connUnitDomainId(SnmpVar value) {
        byte[] b = ((SnmpString)value).getValue();
        StringBuffer sb = new StringBuffer();
        sb.append("0x");
        sb.append(SnmpString.toHexString(b, b.length - 1, b.length));
        sb.append('(');
        sb.append(Integer.toString(b[b.length - 1] & 0xFF));
        sb.append(')');
        return sb.toString();
    }

    public static Object dmDomainId(SnmpVar value) {
        return MibVariableFormat.fspfIfNbrDomainId(value);
    }

    public static Object cfmMulticastRootDomainId(SnmpVar value) {
        return MibVariableFormat.fspfIfNbrDomainId(value);
    }

    public static Object fcsIeDomainId(SnmpVar value) {
        return MibVariableFormat.fspfIfNbrDomainId(value);
    }

    public static Object fspfLinkNbrDomainId(SnmpVar value) {
        return MibVariableFormat.fspfIfNbrDomainId(value);
    }

    public static Object fspfLsrAdvDomainId(SnmpVar value) {
        return MibVariableFormat.fspfIfNbrDomainId(value);
    }

    public static Object fspfDomainId(SnmpVar value) {
        return MibVariableFormat.fspfIfNbrDomainId(value);
    }

    public static Object cpsmFabricBindDomIdRev1(SnmpVar value) {
        return MibVariableFormat.cpsmFabricBindDomId(value);
    }

    public static Object cpsmFabricBindDomId(SnmpVar value) {
        return MibVariableFormat.fspfIfNbrDomainId(value);
    }

    public static Object cpsmFabricBindEnfDomId(SnmpVar value) {
        int v = ((SnmpInt)value).getValue();
        if (v == 0) {
            return "any";
        }
        return MibVariableFormat.fspfIfNbrDomainId(value);
    }

    public static Object cpsmFabricBindDiffDomId(SnmpVar value) {
        return MibVariableFormat.fspfIfNbrDomainId(value);
    }

    public static Object fspfIfNbrDomainId(SnmpVar value) {
        int v = value.getType() == 2 ? ((SnmpInt)value).getValue() : (int)((SnmpUnsignedInt)value).getValue();
        StringBuffer sb = new StringBuffer("0x");
        sb.append(Integer.toHexString(v));
        sb.append('(');
        sb.append(v);
        sb.append(')');
        return sb.toString();
    }

    public static Object fspfIfNbrPortIndex(SnmpVar value) {
        return MibVariableFormat.fspfLinkPortIndex(value);
    }

    public static Object fspfLinkNbrPortIndex(SnmpVar value) {
        return MibVariableFormat.fspfLinkPortIndex(value);
    }

    public static Object fspfLinkPortIndex(SnmpVar value) {
        int v = (int)((SnmpUnsignedInt)value).getValue();
        return "0x" + Integer.toHexString(v);
    }

    public static Object fspfIfNbrPortIndexWithIfIndex(SnmpVar value, SnmpVar isMdsV) {
        boolean isMds = ((SnmpInt)isMdsV).getValue() == 1;
        int v = (int)((SnmpUnsignedInt)value).getValue();
        StringBuffer sb = new StringBuffer();
        if (isMds) {
            sb.append(" (");
            sb.append(IfIndexUtil.ifIndexToName(IfIndexUtil.fspfPortIndexToIfIndex(v)));
            sb.append(")");
        }
        return "0x" + Integer.toHexString(v) + sb.toString();
    }

    public static Object fspfLsrIncarnationNumber(SnmpVar value) {
        return MibVariableFormat.fspfLinkPortIndex(value);
    }

    public static Object fspfLsrCheckSum(SnmpVar value) {
        return MibVariableFormat.fspfLinkPortIndex(value);
    }

    public static Object cfcspDhChapGroupList(SnmpVar value) {
        String[] groupList = new String[]{"null", "1024", "1280", "1536", "2048"};
        String list = value.toString();
        StringBuffer names = new StringBuffer();
        try {
            for (int i = 0; i < list.length(); i += 2) {
                if (i > 0) {
                    names.append(':');
                }
                int id = list.charAt(i) - 48;
                names.append(groupList[id]);
            }
        }
        catch (Exception ex) {
            return list;
        }
        return names.toString();
    }

    public static Object cfdmiHbaPortCurrentSpeed(SnmpVar value) {
        long speed = ((SnmpGauge)value).getValue();
        for (int i = 0; i < _HbaPortSpeedValue.length; ++i) {
            if (speed != _HbaPortSpeedValue[i]) continue;
            return _HbaPortSpeedDisplay[i];
        }
        return "Unknown " + speed;
    }

    public static Object cfdmiHbaPortSupportedSpeed(SnmpVar value) {
        long speed = ((SnmpGauge)value).getValue();
        byte[] b = new byte[8];
        for (int i = 0; i < b.length; ++i) {
            b[i] = (byte)(speed >> i * 8 & 0xFFL);
        }
        StringBuffer sb = new StringBuffer();
        for (int pos = 0; pos < b.length; ++pos) {
            int shift = pos % 8;
            if (shift == 8) {
                shift = 0;
            }
            if ((b[pos / 8] >> shift & 1) == 0) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            if (pos < _HbaPortSpeedDisplay.length) {
                sb.append(_HbaPortSpeedDisplay[pos]);
                continue;
            }
            sb.append("Unknown");
        }
        return sb.toString();
    }

    public static Object connUnitSnsFC4Type(SnmpVar value) {
        return Fc4Decoder.fcNameServerFC4Type(value);
    }

    public static Object cfdmiHbaPortSupportedFC4Type(SnmpVar value) {
        return Fc4Decoder.fcNameServerFC4Type(value);
    }

    public static Object fcNameServerFC4Type(SnmpVar value) {
        return Fc4Decoder.fcNameServerFC4Type(value);
    }

    public static Object fcNameServerFC4TypeFC4Feature(SnmpVar fc4Type, SnmpVar fc4Feature) {
        return Fc4Decoder.fcNameServerFC4Features((SnmpString)fc4Type, (SnmpString)fc4Feature);
    }

    public static Object fcNameServerFC4Features(SnmpVar value) {
        SnmpString s = (SnmpString)value;
        byte[] b = s.getValue();
        if (b.length >= 8) {
            if (b[7] == 1) {
                return "target";
            }
            if (b[7] == 2) {
                return "init";
            }
        }
        return b.length == 0 ? "" : SnmpString.toHexString(b);
    }

    public static Object fcNameServerPortIpAddress(SnmpVar value) {
        return MibVariableFormat.fcNameServerNodeIpAddress(value);
    }

    public static Object civrTopologyConfigSwitchVsan2k(SnmpVar value) {
        return MibVariableFormat.fcIfActiveVsanUpList2k(value);
    }

    public static Object civrAddIvrVirtualDomainsVsans2k(SnmpVar value) {
        return MibVariableFormat.fcIfActiveVsanUpList2k(value);
    }

    public static Object civrTopologyActiveSwitchVsan2k(SnmpVar value) {
        return MibVariableFormat.fcIfActiveVsanUpList2k(value);
    }

    public static Object civrTopologyIvrSrvGrpVsan2k(SnmpVar value) {
        return MibVariableFormat.fcIfActiveVsanUpList2k(value);
    }

    public static Object civrTopologyAfidConfSwitchVsan2k(SnmpVar value) {
        return MibVariableFormat.fcIfActiveVsanUpList2k(value);
    }

    public static Object cfmFcipLinkExtFiconTAVsanL2k(SnmpVar value) {
        return MibVariableFormat.fcIfActiveVsanUpList2k(value);
    }

    public static Object cfmFcipLinkExtFiconTAVsanLOper2k(SnmpVar value) {
        return MibVariableFormat.fcIfActiveVsanUpList2k(value);
    }

    public static Object fcNameServerNodeIpAddress(SnmpVar value) {
        SnmpString s = (SnmpString)value;
        if (s.isNull()) {
            return "";
        }
        byte[] v = s.getValue();
        if (v.length == 16 && v[10] == -1 && v[11] == -1) {
            return SnmpIpAddress.toString(v, 12, v.length);
        }
        return SnmpIpAddress.toString(v, 0, v.length);
    }

    public static Object fcNameServerProxyPortName(SnmpVar value) {
        return MibVariableFormat.dmFabricName(value);
    }

    public static Object dmFabricName(SnmpVar value) {
        byte[] b = ((SnmpString)value).getValue();
        ((SnmpString)value)._value = SnmpString.toHexString(b, 0, b.length);
        return value;
    }

    public static Object fcIfVendorData(SnmpVar value) {
        SnmpString s = (SnmpString)value;
        s._value = SnmpString.toHexString(s.getValue());
        return s;
    }

    public static Object connUnitSnsPortName(SnmpVar value) {
        return MibVariableFormat.dmPrincipalSwitchWwn(value);
    }

    public static Object connUnitSnsNodeName(SnmpVar value) {
        return MibVariableFormat.dmPrincipalSwitchWwn(value);
    }

    public static Object fcNameServerPortName(SnmpVar value) {
        return MibVariableFormat.dmPrincipalSwitchWwn(value);
    }

    public static Object fcNameServerNodeName(SnmpVar value) {
        return MibVariableFormat.dmPrincipalSwitchWwn(value);
    }

    public static Object fcIfElpNbrNodeName(SnmpVar value) {
        return MibVariableFormat.dmPrincipalSwitchWwn(value);
    }

    public static Object fcIfElpNbrPortName(SnmpVar value) {
        return MibVariableFormat.dmPrincipalSwitchWwn(value);
    }

    public static Object fcNameServerFabricPortName(SnmpVar value) {
        return MibVariableFormat.dmPrincipalSwitchWwn(value);
    }

    public static Object fcsIeInfoList(SnmpVar value) {
        int i;
        if (((SnmpString)value).isNull()) {
            return "";
        }
        byte[] b = ((SnmpString)value).getValue();
        StringBuffer sb = new StringBuffer(44);
        int pos = i = 4;
        for (int j = 0; j < 3; ++j) {
            while (i < b.length && b[i] != 0) {
                ++i;
            }
            sb.append(new String(b, pos, i - pos));
            sb.append(", ");
            pos = ++i;
        }
        byte[] bb = new byte[8];
        for (int j = 0; j < 8; ++j) {
            bb[j] = b[pos + j];
        }
        sb.append(WwnDictionary.get(bb));
        return sb;
    }

    public static Object fcsPlatformName(SnmpVar value) {
        byte[] b = ((SnmpString)value).getValue();
        int len = b.length;
        for (int i = len - 1; b[i] == 0 && i > 0; --i) {
            --len;
        }
        return new String(b, 0, len);
    }

    public static Object scsiLuExtRemotePortFcAddress(SnmpVar value) {
        return MibVariableFormat.dmPrincipalSwitchWwn(value);
    }

    public static Object csiSessionPeerPwwn(SnmpVar value) {
        return MibVariableFormat.dmPrincipalSwitchWwn(value);
    }

    public static Object csiSessionPeerNwwn(SnmpVar value) {
        return MibVariableFormat.dmPrincipalSwitchWwn(value);
    }

    public static Object ciscoScsiDscTgtName(SnmpVar value) {
        return MibVariableFormat.dmPrincipalSwitchWwn(value);
    }

    public static Object ceExtHCProcessorRam(SnmpVar value) {
        return MibVariableFormat.ciscoFlashPartitionSize(value);
    }

    public static Object ceExtProcessorRam(SnmpVar value) {
        return MibVariableFormat.ciscoFlashPartitionSize(value);
    }

    public static Object ceExtNVRAMSize(SnmpVar value) {
        return MibVariableFormat.ciscoFlashPartitionSize(value);
    }

    public static Object ceExtNVRAMUsed(SnmpVar value) {
        return MibVariableFormat.ciscoFlashPartitionSize(value);
    }

    public static Object ciscoFlashPartitionFreeSpaceExtended(SnmpVar value) {
        return MibVariableFormat.ciscoFlashPartitionSize(value);
    }

    public static Object ciscoFlashPartitionFreeSpace(SnmpVar value) {
        return MibVariableFormat.ciscoFlashPartitionSize(value);
    }

    public static Object ciscoFlashPartitionSizeExtended(SnmpVar value) {
        return MibVariableFormat.ciscoFlashPartitionSize(value);
    }

    public static Object ciscoFlashPartitionSize(SnmpVar value) {
        long v = value.getType() == 2 ? (long)((SnmpInt)value).getValue() : (value.getType() == 70 ? ((SnmpCounter64)value).getLongValue() : ((SnmpUnsignedInt)value).getValue());
        return DefaultSnmpNumberRenderer.formatLong(v);
    }

    public static Object scsiLuExtLocalLun(SnmpVar value) {
        return MibVariableFormat.scsiLuExtRemoteLun(value);
    }

    public static Object scsiLuExtRemoteLun(SnmpVar value) {
        return new SnmpIscsiLun(((SnmpString)value).getValue());
    }

    public static Object ciscoExtScsiIntrDiscLunNumber(SnmpVar value) {
        String lun = SnmpIscsiLun.toString(((SnmpString)value).getValue());
        if (lun.indexOf(58) == -1) {
            return "0x" + lun;
        }
        return lun;
    }

    public static Object ciscoExtScsiIntrDiscLunSerialNum(SnmpVar value) {
        int i;
        SnmpString s = (SnmpString)value;
        byte[] b = s.getValue();
        for (i = b.length - 1; i >= 0 && b[i] == 0; --i) {
        }
        if (i == 0) {
            return "";
        }
        return new String(b, 0, i + 1);
    }

    public static Object ciscoExtScsiIntrDiscTgtDevType(SnmpVar value) {
        return MibVariableFormat.extScsiIntrDiscTgtDevTypeInt((int)((SnmpUnsignedInt)value).getValue());
    }

    public static String extScsiIntrDiscTgtDevTypeInt(int value) {
        if (value == 31) {
            return "unknown(1F)";
        }
        if (value >= _LunDevTypes.length) {
            return null;
        }
        return _LunDevTypes[value];
    }

    public static Object ciscoExtScsiIntrDiscTgtOtherInfo(SnmpVar value) {
        return MibVariableFormat.extScsiIntrDiscTgtOtherInfo(((SnmpString)value).getValue());
    }

    public static String extScsiIntrDiscTgtOtherInfo(byte[] b) {
        StringBuffer sb = new StringBuffer(32);
        sb.append("Version=");
        sb.append(b[2]);
        sb.append(',');
        if (b[1] >> 7 == 1) {
            sb.append("RMB,");
        }
        if (b[5] >> 7 == 1) {
            sb.append("SCCS,");
        }
        if ((b[6] >> 6 & 1) == 1) {
            sb.append("EncSvc,");
        }
        if ((b[6] >> 4 & 1) == 1) {
            sb.append("MultiP,");
        }
        if ((b[6] >> 3 & 1) == 1) {
            sb.append("MChngr,");
        }
        sb.setLength(sb.length() - 1);
        return sb.toString();
    }

    public static Object fcsIeFabricName(SnmpVar value) {
        return MibVariableFormat.dmPrincipalSwitchWwn(value);
    }

    public static Object dmPrincipalSwitchWwn(SnmpVar value) {
        byte[] b = ((SnmpString)value).getValue();
        if (b.length == 8) {
            return WwnDictionary.get(b);
        }
        return null;
    }

    public static Object cIsnsRegIscsiNodeWwnToken(SnmpVar value) {
        byte[] b = ((SnmpString)value).getValue();
        if (b.length == 8) {
            return WwnDictionary.get(b);
        }
        return value;
    }

    public static Object entSensorThresholdValue(SnmpVar value) {
        if (((SnmpInt)value).getValue() == -127) {
            return "n/a";
        }
        return null;
    }

    public static Object entPhysicalFirmwareRev(SnmpVar value) {
        String s = value.toString();
        if (s.equals("0.0")) {
            return "n/a";
        }
        return s;
    }

    public static Object entPhysicalSoftwareRev(SnmpVar value) {
        return MibVariableFormat.entPhysicalFirmwareRev(value);
    }

    public static Object cHcAlarmVariable(SnmpVar value) {
        return MibVariableFormat.alarmVariable(value);
    }

    public static Object alarmVariable(SnmpVar value) {
        int[] oid = ((SnmpOID)value).getValue();
        for (int i = 0; i < _InterfaceVars.length; ++i) {
            if (MibNode.equals(_InterfaceVars[i], oid) != 0) continue;
            String var = MibNode.oidToName(oid);
            String ifName = _IfIndexIf.ifIndexToName(oid[oid.length - 1]);
            int dot = var.lastIndexOf(46);
            return var.substring(0, dot + 1) + ifName;
        }
        return MibNode.oidToName(oid);
    }

    public static Object ccmCommonUserSNMPPrivProtocol(SnmpVar value) {
        return MibVariableFormat.ccmCommonUserSNMPAuthProtocol(value);
    }

    public static Object ccmCommonUserSNMPAuthProtocol(SnmpVar value) {
        int[] oid = ((SnmpOID)value).getValue();
        for (int i = 0; i < _UsmUserProtocolOid.length; ++i) {
            if (!SnmpOID.equals(_UsmUserProtocolOid[i], oid)) continue;
            return new JnmMibEnum(_UsmUserProtocolEnums[i].getLabel(), i, _UsmUserProtocolEnums);
        }
        return new JnmMibEnum("Unknown: " + value, -1, _UsmUserProtocolEnums);
    }

    public static Object usmUserAuthProtocol(SnmpVar value) {
        return MibVariableFormat.usmUserPrivProtocol(value);
    }

    public static Object usmUserPrivProtocol(SnmpVar value) {
        int[] oid = ((SnmpOID)value).getValue();
        for (int i = 0; i < _UsmUserProtocolOid.length; ++i) {
            if (!SnmpOID.equals(_UsmUserProtocolOid[i], oid)) continue;
            return _UsmUserProtocol[i];
        }
        return "unknown " + SnmpOID.toString(oid);
    }

    public static Object logDescription(SnmpVar value) {
        String s = value.toString();
        int semiColon = s.indexOf(58);
        if (semiColon == -1) {
            return null;
        }
        int equals = s.indexOf(61);
        String var = MibNode.oidToName("1" + s.substring(semiColon + 4, equals));
        StringBuffer sb = new StringBuffer(32);
        sb.append(var);
        sb.append(s.substring(equals));
        sb.append(' ');
        sb.append(s.substring(0, semiColon));
        return sb.toString();
    }

    public static Object cfmFcipLinkRemFcipEntityAddress(SnmpVar value) {
        return MibVariableFormat.cfmFcipEntityAddress(value);
    }

    public static Object cfmFcipEntityAddress(SnmpVar value) {
        byte[] b;
        if (value instanceof SnmpString && ((b = ((SnmpString)value).getValue()).length == 4 || b.length == 16)) {
            ((SnmpString)value)._value = SnmpIpAddress.toString(b);
        }
        return value;
    }

    public static Object snmpTargetAddrTAddress(SnmpVar value) {
        byte[] b = ((SnmpString)value).getValue();
        if (b.length >= 4) {
            StringBuffer sb = new StringBuffer();
            sb.append(SnmpIpAddress.toString(b, 0, b.length - 2));
            sb.append('/');
            int port = ((b[b.length - 2] & 0xFF) << 8) + (b[b.length - 1] & 0xFF);
            sb.append(port);
            return sb.toString();
        }
        return null;
    }

    public static String fcIfPortChannelIfIndex(SnmpVar value) {
        int ifIndex = ((SnmpInt)value).getValue();
        return ifIndex == 0 ? "none" : _IfIndexIf.ifIndexToName(ifIndex);
    }

    public static Object sysUpTime(SnmpVar value) {
        long t = ((SnmpTimeticks)value).getValue();
        return SnmpTimeticks.formatTimeElapsed(t) + " (" + SnmpTimeticks.formatTimeAsDate(t) + ')';
    }

    public static Object cseSysUpTime(SnmpVar value) {
        long t = ((SnmpGauge)value).getValue() * 100L;
        return SnmpTimeticks.formatTimeElapsed(t) + " (Start Time: " + SnmpTimeticks.formatTimeAsDate(t) + ')';
    }

    public static Object clmLicenseExpiryDate(SnmpVar value) {
        return MibVariableFormat.csyClockDateAndTime(value);
    }

    public static Object cdpCacheVersion(SnmpVar value) {
        String version = value.toString();
        int pos = version.indexOf("Copy");
        if (pos != -1) {
            return version.substring(0, pos - 1);
        }
        return version;
    }

    public static Object connUnitPortWwn(SnmpVar value) {
        return SnmpString.toHexString(((SnmpString)value).getValue(), 0, 8);
    }

    public static Object connUnitPortFCId(SnmpVar value) {
        return MibVariableFormat.fcFxPortID(value);
    }

    public static Object fcFxPortID(SnmpVar value) {
        byte[] b = ((SnmpString)value).getValue();
        return "0x" + SnmpString.toHexString(b, 0, b.length, false);
    }

    public static Object csiNportFcid(SnmpVar value) {
        String hex = Integer.toHexString(((SnmpInt)value).getValue());
        if (hex.length() == 5) {
            return "0x0" + hex;
        }
        return "0x" + hex;
    }

    public static Object csiSessionPeerFcid(SnmpVar value) {
        return MibVariableFormat.csiNportFcid(value);
    }

    public static Object scsiLuExtRemotePortSecFcAddress(SnmpVar value) {
        return MibVariableFormat.scsiLuExtRemotePortFcAddress(value);
    }

    public static Object cntpPeersRootDispersion(SnmpVar value) {
        return MibVariableFormat.cntpSysRootDelay(value);
    }

    public static Object cntpPeersDispersion(SnmpVar value) {
        return MibVariableFormat.cntpSysRootDelay(value);
    }

    public static Object cntpSysRootDispersion(SnmpVar value) {
        return MibVariableFormat.cntpSysRootDelay(value);
    }

    public static Object cntpPeersDelay(SnmpVar value) {
        return MibVariableFormat.cntpSysRootDelay(value);
    }

    public static Object cntpPeersOffset(SnmpVar value) {
        return MibVariableFormat.cntpSysRootDelay(value);
    }

    public static Object cntpPeersRootDelay(SnmpVar value) {
        return MibVariableFormat.cntpSysRootDelay(value);
    }

    public static Object cntpSysRootDelay(SnmpVar value) {
        byte[] b = ((SnmpString)value).getValue();
        int sec1 = ((b[0] & 0xFF) << 8) + (b[1] & 0xFF);
        int sec2 = ((b[2] & 0xFF) << 8) + (b[3] & 0xFF);
        return sec1 + "." + sec2;
    }

    public static Object cntpPeersTransmitTime(SnmpVar value) {
        return MibVariableFormat.cntpSysRefTime(value);
    }

    public static Object cntpPeersReceiveTime(SnmpVar value) {
        return MibVariableFormat.cntpSysRefTime(value);
    }

    public static Object cntpPeersOrgTime(SnmpVar value) {
        return MibVariableFormat.cntpSysRefTime(value);
    }

    public static Object cntpPeersRefTime(SnmpVar value) {
        return MibVariableFormat.cntpSysRefTime(value);
    }

    public static Object cntpSysClock(SnmpVar value) {
        return MibVariableFormat.cntpSysRefTime(value);
    }

    public static Object cntpSysRefTime(SnmpVar value) {
        StringBuffer sb = new StringBuffer(20);
        byte[] b = ((SnmpString)value).getValue();
        int sec1 = ((b[0] & 0xFF) << 24) + ((b[1] & 0xFF) << 16) + ((b[2] & 0xFF) << 8) + (b[3] & 0xFF);
        sb.append(sec1);
        sb.append('.');
        int sec2 = ((b[4] & 0xFF) << 24) + ((b[5] & 0xFF) << 16) + ((b[6] & 0xFF) << 8) + (b[7] & 0xFF);
        sb.append(sec2);
        return sb.toString();
    }

    public static Object fcIfRNIDInfoPortId(SnmpVar value) {
        int portId = ((SnmpInt)value).getValue();
        if (portId == 0) {
            return "0x0000";
        }
        if (portId < 16) {
            return "0x000" + Integer.toHexString(portId).toUpperCase();
        }
        if (portId < 256) {
            return "0x00" + Integer.toHexString(portId).toUpperCase();
        }
        if (portId < 4096) {
            return "0x0" + Integer.toHexString(portId).toUpperCase();
        }
        return "0x" + Integer.toHexString(portId).toUpperCase();
    }

    public static Object clmLicenseFlag(SnmpVar value) {
        byte[] b = ((SnmpString)value).getValue();
        int max = b.length * 8;
        for (int i = 0; i < max; ++i) {
            if (!SnmpString.getBitBase0(b, i)) continue;
            return null;
        }
        return "uncounted";
    }

    public static Object clmLicenseFlag(SnmpVar value, boolean isGracePeriod) {
        byte[] flag = ((SnmpString)value).getValue();
        byte[] b = new byte[flag.length];
        System.arraycopy(flag, 0, b, 0, flag.length);
        int max = b.length * 8;
        for (int i = 0; i < max; ++i) {
            if (!SnmpString.getBitBase0(b, i)) continue;
            MibEnum[] enums = MibNode.get("clmLicenseFlag").getEnums();
            if (!isGracePeriod) {
                SnmpString.clearBitBase0(b, 4);
            }
            return new Bits(enums, b);
        }
        return "uncounted";
    }

    public static Object clmLicenseFlag(SnmpVar value, int gracePeriod) {
        byte[] bits = ((SnmpString)value).getValue();
        if (SnmpString.getBitBase0(bits, 4)) {
            if (gracePeriod == 0) {
                return new SnmpString("Grace Expired");
            }
            int mins = gracePeriod / 60;
            int hours = mins / 60;
            int days = hours / 24;
            if (days >= 120) {
                return MibVariableFormat.clmLicenseFlag(value, false);
            }
        }
        return MibVariableFormat.clmLicenseFlag(value, true);
    }

    public static Object clmLicenseGracePeriodLeft(int gracePeriod, SnmpVar flag) {
        byte[] bits = ((SnmpString)flag).getValue();
        if (SnmpString.getBitBase0(bits, 1) || !SnmpString.getBitBase0(bits, 4)) {
            return "";
        }
        int secs = gracePeriod % 60;
        int mins = gracePeriod / 60;
        int hours = mins / 60;
        int days = hours / 24;
        hours %= 24;
        mins %= 60;
        if (gracePeriod == 0) {
            return "";
        }
        if (days >= 120) {
            return (days > 0 ? days + " days " : "") + (hours > 0 ? hours + " hours " : "");
        }
        if (hours > 0 || days > 0) {
            return (days > 0 ? days + " days " : "") + (hours > 0 ? hours + " hours " : "");
        }
        return (mins > 0 ? mins + " mins " : "") + (secs > 0 ? secs + " seconds " : "");
    }

    public static Object cippfIpFilterPrecedence(SnmpVar value) {
        int precedence = ((SnmpInt)value).getValue();
        if (precedence == -1) {
            ((SnmpInt)value).setValue(99);
        }
        return null;
    }

    public static Object cippfIpFilterSrcPortLow(SnmpVar value) {
        return MibVariableFormat.cippfIpFilterSrcPortHigh(value);
    }

    public static Object cippfIpFilterSrcPortHigh(SnmpVar value) {
        long port = ((SnmpGauge)value).getValue();
        for (int i = 0; i < _INetPortNumberValue.length; ++i) {
            if (port != _INetPortNumberValue[i]) continue;
            return _INetPortNumberDisplay[i];
        }
        return null;
    }

    public static Object cippfIpFilterDestPortLow(SnmpVar value) {
        return MibVariableFormat.cippfIpFilterSrcPortHigh(value);
    }

    public static Object cippfIpFilterDestPortHigh(SnmpVar value) {
        return MibVariableFormat.cippfIpFilterSrcPortHigh(value);
    }

    public static Object cippfIpFilterTos(SnmpVar value) {
        int tos = ((SnmpInt)value).getValue();
        for (int i = 0; i < _TosValue.length; ++i) {
            if ((long)tos != _TosValue[i]) continue;
            return _TosDisplay[i];
        }
        return null;
    }

    public static Object cippfIpFilterICMPType(SnmpVar value) {
        int type = ((SnmpInt)value).getValue();
        for (int i = 0; i < _ICMPTypeValue.length; ++i) {
            if ((long)type != _ICMPTypeValue[i]) continue;
            return _ICMPTypeDisplay[i];
        }
        return null;
    }

    public static String toCauseString(int cause) {
        return MibEnum.getLabel(_IfOpStatusCause, cause);
    }

    public static Object cIpNetworkGigEIfIndexToDiscover(SnmpVar value) {
        int ifIndex = ((SnmpInt)value).getValue();
        if (ifIndex == 0) {
            return new SnmpString("");
        }
        return new SnmpString(IfIndexUtil.ifIndexToName(ifIndex));
    }

    public static Object cdsmFCMultiFieldMatchIntf(SnmpVar value) {
        int ifIndex = ((SnmpInt)value).getValue();
        if (ifIndex == 0) {
            return "";
        }
        return IfIndexUtil.ifIndexToName(ifIndex);
    }

    public static Object cpsmFabricBindSwitchWwn(SnmpVar value) {
        return MibVariableFormat.dmPrincipalSwitchWwn(value);
    }

    public static Object cpsmFabricBindEnfSwitchWwn(SnmpVar value) {
        return MibVariableFormat.dmPrincipalSwitchWwn(value);
    }

    public static Object cpsmFabricBindDiffSwitchWwn(SnmpVar value) {
        return MibVariableFormat.dmPrincipalSwitchWwn(value);
    }

    public static Object cpsmFabricBindSwwnR1(SnmpVar value) {
        return MibVariableFormat.dmPrincipalSwitchWwn(value);
    }

    public static Object ccmCommonUserExpiryDate(SnmpVar value) {
        return new SnmpDateAndTime(((SnmpString)value).getValue(), false);
    }

    public static Object cIsnsRegEntityTimestamp(SnmpVar value) {
        return MibVariableFormat.csyClockDateAndTime(value);
    }

    public static Object csyClockDateAndTime(SnmpVar value) {
        return new SnmpDateAndTime(((SnmpString)value).getValue());
    }

    public static Object clmNoOfLicenseMaxUsages(SnmpVar value) {
        if (((SnmpInt)value).getValue() == 0) {
            return "";
        }
        return ((SnmpInt)value).toString();
    }

    public static Object clmNoOfLicenseCurrentUsages(SnmpVar value) {
        if (((SnmpInt)value).getValue() > 0) {
            return "In Use";
        }
        return "Unused";
    }

    public static Object cAAAServerTimeOut(SnmpVar value) {
        return MibVariableFormat.cAAAServerRetransmits(value);
    }

    public static Object cAAAServerRetransmits(SnmpVar value) {
        if (((SnmpGauge)value).getValue() == 0L) {
            return "default";
        }
        return value;
    }

    public static Object cfsPendingConfOwnerIDType(SnmpVar value) {
        return SnmpString.bitsToStringBase0(((SnmpString)value).getValue(), MibNode.get("cfsPendingConfOwnerIDType").getEnums());
    }

    public static Object cfsFeatureOpScopeVal(SnmpVar value) {
        long[] vsans = SnmpLongList.valueOf(((SnmpString)value).getValue());
        if (vsans.length > 1) {
            System.err.println("wrong cfsFeatureOpScopeVal : " + value.toString());
            byte[] b = ((SnmpString)value).getValue();
            byte[] vsanB = new byte[4];
            System.arraycopy(b, 0, vsanB, 0, vsanB.length);
            return new SnmpLongList(vsanB);
        }
        return new SnmpLongList(((SnmpString)value).getValue());
    }

    public static Object cfsFeatureOpLastAction(SnmpVar value) {
        if (((SnmpInt)value).getValue() == 1) {
            return "";
        }
        return MibEnum.getLabel(_cfsFeatureOpLastAction, ((SnmpInt)value).getValue());
    }

    public static Object cfsFeatureOpLastActionResultAdv(SnmpVar cfsFeatureOpLastAction, SnmpVar value, String failureReason) {
        if (((SnmpInt)cfsFeatureOpLastAction).getValue() == 1) {
            return "";
        }
        String strLastActionResult = MibEnum.getLabel(_cfsFeatureOpLastActionResult, ((SnmpInt)value).getValue());
        if (strLastActionResult.equals("failed")) {
            strLastActionResult = strLastActionResult + " - " + failureReason;
        }
        return strLastActionResult;
    }

    public static Object sysLocation(SnmpVar value) {
        if (value instanceof SnmpString && ((SnmpString)value).toString().equals("<sysLocation undefined>")) {
            return new SnmpString("");
        }
        return value;
    }

    public static Object sysContact(SnmpVar value) {
        if (value instanceof SnmpString && ((SnmpString)value).toString().equals("<sysContact undefined>")) {
            return new SnmpString("");
        }
        return value;
    }

    public static Object cfdaConfigDeviceId(SnmpVar value) {
        return MibVariableFormat.cIsnsRegIscsiNodeWwnToken(value);
    }

    public static Object cpkiRevokeCheckMethods(SnmpVar value) {
        byte[] b = ((SnmpString)value).getValue();
        String[] revokeChkMethodString = new String[]{"none", "crl", "ocsp"};
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < b.length; ++i) {
            byte byteValue = b[i];
            if (byteValue < 1) continue;
            if (i != 0) {
                buf.append(", ");
            }
            buf.append(revokeChkMethodString[byteValue - 1]);
        }
        return buf.toString();
    }

    public static Object cficonSlotReservedPN(SnmpVar value) {
        return new FiconPortAddrList(((SnmpString)value).getValue());
    }

    public static Object cficonLogicReservedPN(SnmpVar value) {
        return new FiconPortAddrList(((SnmpString)value).getValue());
    }

    public static Object cigIscsiInitTgtSecondaryVsan(SnmpVar value) {
        if (value instanceof SnmpInt && ((SnmpInt)value).getValue() == 0) {
            return "";
        }
        return Integer.toString(((SnmpInt)value).getValue());
    }

    public static Object ipCidrRouteType(SnmpVar value) {
        return MibVariableFormat.cInetCidrRouteType(value);
    }

    public static Object cInetCidrRouteType(SnmpVar value) {
        return value instanceof SnmpInt && ((SnmpInt)value).getValue() != 1 ? "true" : "false";
    }

    public static Object cHcAlarmAbsValue(SnmpVar sign, SnmpVar value) {
        if (((SnmpInt)sign).getValue() == 1) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (((SnmpInt)sign).getValue() == 3) {
            sb.append("-");
        }
        sb.append((SnmpCounter64)value);
        return sb.toString();
    }

    public static Object cHcAlarmFallingThreshAbsValueLo(SnmpVar sign, SnmpVar hiVar, SnmpVar loVar) {
        return MibVariableFormat.cHcAlarmRisingThreshAbsValueLo(sign, hiVar, loVar);
    }

    public static Object cHcAlarmRisingThreshAbsValueLo(SnmpVar sign, SnmpVar hiVar, SnmpVar loVar) {
        long hi = ((SnmpGauge)hiVar).getValue();
        long lo = ((SnmpGauge)loVar).getValue();
        if (((SnmpInt)sign).getValue() == 1) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (((SnmpInt)sign).getValue() == 3) {
            sb.append("-");
        }
        if (hi != 0L) {
            long[] ids = new long[]{hi, lo};
            byte[] b = new byte[8];
            int bCount = 0;
            for (int i = 0; i < 2; ++i) {
                b[bCount++] = (byte)(ids[i] >> 24 & 0xFFL);
                b[bCount++] = (byte)(ids[i] >> 16 & 0xFFL);
                b[bCount++] = (byte)(ids[i] >> 8 & 0xFFL);
                b[bCount++] = (byte)(ids[i] & 0xFFL);
            }
            BigInteger bValue = new BigInteger(b);
            SnmpCounter64 counterV = new SnmpCounter64(bValue);
            sb.append(counterV);
        } else {
            sb.append(lo);
        }
        return sb.toString();
    }

    public static Object cficonRunCfgProhibitPrtNums(SnmpVar value) {
        return MibVariableFormat.cficonProhibitPortNumbers(value);
    }

    public static Object cficonProhibitPortNumbers(SnmpVar value) {
        int i;
        byte[] b = ((SnmpString)value).getValue();
        StringBuffer sb = new StringBuffer();
        int max = b.length * 8 - 1;
        for (i = 0; i <= max && !SnmpString.getBitBase0(b, i); ++i) {
        }
        while (i <= max) {
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(Integer.toHexString(i));
            while (i <= max) {
                int j;
                for (j = i + 1; j <= max && SnmpString.getBitBase0(b, j); ++j) {
                }
                if (j <= max && j > i + 1) {
                    sb.append('-');
                    sb.append(Integer.toHexString(j - 1));
                }
                for (i = j; i <= max && !SnmpString.getBitBase0(b, i); ++i) {
                }
                if (i > max) continue;
                sb.append(',');
                sb.append(Integer.toHexString(i));
            }
        }
        return sb.toString();
    }

    public static String clmLicensedAppName(SnmpVar value, IfIndexIf ifIndexIf) {
        if (value instanceof SnmpString) {
            try {
                int ifIndex = Integer.parseInt(((SnmpString)value).toString());
                return ifIndexIf.ifIndexToName(ifIndex);
            }
            catch (Exception ex) {
                return value.toString();
            }
        }
        return value.toString();
    }

    public static String clmLicensedAppName(SnmpVar value) {
        if (value instanceof SnmpString) {
            try {
                int ifIndex = Integer.parseInt(((SnmpString)value).toString());
                return IfIndexUtil.ifIndexToName(ifIndex);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return null;
    }

    public static Object cNotifCtrlOID(SnmpVar value) {
        if (value instanceof SnmpOID) {
            return MibNode.oidToName(((SnmpOID)value).getValue());
        }
        return value;
    }

    static {
        _IfOpStatusCause = MibNode.get("fcIfOperStatusCause").getEnums();
        _cfsFeatureOpLastAction = MibNode.get("cfsFeatureOpLastAction").getEnums();
        _FcIfOperStatusReason = MibNode.get("fcIfOperStatusCause").getEnums();
        _cfsFeatureOpLastActionResult = MibNode.get("cfsFeatureOpLastActionResult").getEnums();
        ASM_PROV_Features = new String[]{"scsi-flow", "emcsr", "nsp", "santap", "dmm"};
        MSM_PROV_Features = new String[]{"santap", "dmm"};
        _HbaPortSpeedValue = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 32768L};
        _HbaPortSpeedDisplay = new String[]{"1 Gbps", "2 Gbps", "10 Gbps", "4 Gbp", "8 Gbps", "16 Gbps", "32 Gbps", "20 Gbps", "40 Gbps", "Unknown"};
        _LunDevTypes = new String[]{"Disk", "Tape", "Printer", "Processor", "OpticalDisk", "CD-ROM", "Scanner", "OpticalDisk", "JukeBox", "Comm", "GAPP", "GAPP", "RAID", "SES", "RBC Disk", "OCR", null, "OSD"};
        _InterfaceVars = new int[][]{{1, 3, 6, 1, 2, 1, 31, 1, 1, 1}, {1, 3, 6, 1, 2, 1, 2, 2, 1}, {1, 3, 6, 1, 4, 1, 9, 9, 287, 2, 2, 1}, {1, 3, 6, 1, 4, 1, 9, 9, 289, 1, 2}};
        _UsmUserProtocolOid = new int[][]{{1, 3, 6, 1, 6, 3, 10, 1, 1, 2}, {1, 3, 6, 1, 6, 3, 10, 1, 1, 3}, {1, 3, 6, 1, 6, 3, 10, 1, 1, 1}, {1, 3, 6, 1, 6, 3, 10, 1, 2, 2}, {1, 3, 6, 1, 6, 3, 10, 1, 2, 4}, {1, 3, 6, 1, 6, 3, 10, 1, 2, 1}};
        _UsmUserProtocol = new String[]{"MD5", "SHA", "NoAuth", "DES", "AES", "NoPriv"};
        _UsmUserProtocolEnums = new MibEnum[]{new MibEnum("MD5", 0), new MibEnum("SHA", 1), new MibEnum("NoAuth", 2), new MibEnum("DES", 3), new MibEnum("AES", 4), new MibEnum("NoPriv", 5)};
        _INetPortNumberValue = new long[]{20L, 21L, 22L, 23L, 25L, 65L, 53L, 69L, 80L, 115L, 123L, 143L, 161L, 162L, 514L, 1812L, 5988L, 5989L};
        _INetPortNumberDisplay = new String[]{"ftp-data", "ftp", "ssh", "telnet", "smtp", "tasacs-ds", "dns", "tftp", "www", "sftp", "ntp", "http", "snmp", "snmp-trap", "syslog", "radius", "wbem-http", "wbem-https"};
        _TosValue = new long[]{0L, 1L, 2L, 4L, 8L};
        _TosDisplay = new String[]{"normal-service", "monetary-cost", "reliability", "throughput", "delay"};
        _ICMPTypeValue = new long[]{0L, 3L, 5L, 8L, 11L, 30L};
        _ICMPTypeDisplay = new String[]{"echo-reply", "unreachable", "redirect", "echo", "time-exceeded", "traceroute"};
    }
}

