/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds;

import com.cisco.dcbu.lib.jnm.SnmpBitmap;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.util.Array;

public class PortInterfaceUtil {
    static PortInterfaceUtil _instance;
    public static final int FC_TYPE = 1;
    public static final int ISCSI_TYPE = 2;
    public static final int VLAN_TYPE = 3;
    public static final int COMMONROLE_TYPE = 4;
    public static final int SPAN_SOURCE_TYPE = 5;
    public static final int SPAN_FILTER_TYPE = 6;
    public static final int IVR_TYPE = 7;
    public static final int IVR_VIR_DOMAIN_TYPE = 8;
    public static final int IVR_SERVICE_GROUP_TYPE = 9;
    public static final int IVR_FABRIC_ID_TYPE = 10;
    public static final int FCIP_VSAN_CFG_TYPE = 11;
    public static final int FCIP_VSAN_OPER_TYPE = 12;
    public static final int VLAN_VTP_TYPE = 13;
    public static final int VLAN_VTP_ACTIVE_TYPE = 14;
    public static final int SPAN_ADD = 1;
    public static final int SPAN_REMOVE = 2;
    static final int[] _allowedVsan2kOid;
    static final int[] _allowedVsan4kOid;
    static final int[] _allowedVsanFcip2kOid;
    static final int[] _allowedVsanFcip4kOid;
    static final int[] _commonRoleScope1Oid;
    static final int[] _commonRoleScope2Oid;
    static final int[] _srcVsanCfg2kOid;
    static final int[] _srcVsanCfg4kOid;
    static final int[] _filtVsanOp2kOid;
    static final int[] _filtVsanOp4kOid;
    static final int[] _srcCommandOid;
    static final int[] _filtCommandOid;
    static final int[] _ivrTopologyVsan2kOid;
    static final int[] _ivrTopologyVsan4kOid;
    static final int[] _ivrVirDomainVsan2kOid;
    static final int[] _ivrVirDomainVsan4kOid;
    static final int[] _ivrServiceGrpVsan2kOid;
    static final int[] _ivrServiceGrpVsan4kOid;
    static final int[] _ivrFabricIDVsan2kOid;
    static final int[] _ivrFabricIDVsan4kOid;
    static final int[] _cfmFcipLinkExtFiconTAVsanL2kOid;
    static final int[] _cfmFcipLinkExtFiconTAVsanL4kOid;
    static final int[] _cfmFcipLinkExtFiconTAVsanLOper2kOid;
    static final int[] _cfmFcipLinkExtFiconTAVsanLOper4kOid;
    static final int[] _vlanTrunkPortVlansEnabledOid;
    static final int[] _vlanTrunkPortVlansEnabled2kOid;
    static final int[] _vlanTrunkPortVlansEnabled3kOid;
    static final int[] _vlanTrunkPortVlansEnabled4kOid;
    static final int[] _vlanTrunkPortVlansActiveFirst2kOid;
    static final int[] _vlanTrunkPortVlansActiveSecond2kOid;
    public static final int[] _vlanOid;
    static final int[] _vmVlans2kOid;
    static final int[] _vmVlans3kOid;
    static final int[] _vmVlans4kOid;
    static int[] _firstOid;
    static int[] _1kOid;
    static int[] _2kOid;
    static int[] _3kOid;
    static int[] _4kOid;
    static int[] _commandOid;
    static int _byteSize;
    static int _type;

    public static PortInterfaceUtil getInstance(int type) {
        if (_instance == null) {
            _instance = new PortInterfaceUtil();
        }
        _firstOid = null;
        _4kOid = null;
        _3kOid = null;
        _2kOid = null;
        _1kOid = null;
        switch (type) {
            case 1: {
                _firstOid = _allowedVsan2kOid;
                _2kOid = _allowedVsan2kOid;
                _4kOid = _allowedVsan4kOid;
                break;
            }
            case 2: {
                _firstOid = _allowedVsanFcip2kOid;
                _2kOid = _allowedVsanFcip2kOid;
                _4kOid = _allowedVsanFcip4kOid;
                break;
            }
            case 4: {
                _firstOid = _commonRoleScope1Oid;
                _2kOid = _commonRoleScope1Oid;
                _4kOid = _commonRoleScope2Oid;
                break;
            }
            case 5: {
                _firstOid = _srcVsanCfg2kOid;
                _2kOid = _srcVsanCfg2kOid;
                _4kOid = _srcVsanCfg4kOid;
                _commandOid = _srcCommandOid;
                break;
            }
            case 6: {
                _firstOid = _filtVsanOp2kOid;
                _2kOid = _filtVsanOp2kOid;
                _4kOid = _filtVsanOp4kOid;
                _commandOid = _filtCommandOid;
                break;
            }
            case 7: {
                _firstOid = _ivrTopologyVsan2kOid;
                _2kOid = _ivrTopologyVsan2kOid;
                _4kOid = _ivrTopologyVsan4kOid;
                break;
            }
            case 8: {
                _firstOid = _ivrVirDomainVsan2kOid;
                _2kOid = _ivrVirDomainVsan2kOid;
                _4kOid = _ivrVirDomainVsan4kOid;
                break;
            }
            case 9: {
                _firstOid = _ivrServiceGrpVsan2kOid;
                _2kOid = _ivrServiceGrpVsan2kOid;
                _4kOid = _ivrServiceGrpVsan4kOid;
                break;
            }
            case 10: {
                _firstOid = _ivrFabricIDVsan2kOid;
                _2kOid = _ivrFabricIDVsan2kOid;
                _4kOid = _ivrFabricIDVsan4kOid;
                break;
            }
            case 11: {
                _firstOid = _cfmFcipLinkExtFiconTAVsanL2kOid;
                _2kOid = _cfmFcipLinkExtFiconTAVsanL2kOid;
                _4kOid = _cfmFcipLinkExtFiconTAVsanL4kOid;
                break;
            }
            case 12: {
                _firstOid = _cfmFcipLinkExtFiconTAVsanLOper2kOid;
                _2kOid = _cfmFcipLinkExtFiconTAVsanLOper2kOid;
                _4kOid = _cfmFcipLinkExtFiconTAVsanLOper4kOid;
                break;
            }
            case 3: {
                _firstOid = _vlanOid;
                _1kOid = _vlanOid;
                _2kOid = _vmVlans2kOid;
                _3kOid = _vmVlans3kOid;
                _4kOid = _vmVlans4kOid;
                break;
            }
            case 13: {
                _firstOid = _vlanTrunkPortVlansEnabledOid;
                _1kOid = _vlanTrunkPortVlansEnabledOid;
                _2kOid = _vlanTrunkPortVlansEnabled2kOid;
                _3kOid = _vlanTrunkPortVlansEnabled3kOid;
                _4kOid = _vlanTrunkPortVlansEnabled4kOid;
                break;
            }
            case 14: {
                _firstOid = _vlanTrunkPortVlansActiveFirst2kOid;
                _1kOid = _vlanTrunkPortVlansActiveFirst2kOid;
                _2kOid = _vlanTrunkPortVlansActiveSecond2kOid;
                break;
            }
            default: {
                _commandOid = null;
                _4kOid = null;
                _2kOid = null;
            }
        }
        _type = type;
        _byteSize = type == 3 || type == 13 ? 128 : 256;
        return _instance;
    }

    public int[] getFirstOid() {
        return _firstOid;
    }

    public SnmpString getVsan(SnmpString vsan2k, SnmpString vsan4k, boolean isAllowedVsan) {
        if (vsan2k.getValue().length > 0 || vsan4k.getValue().length > 0) {
            vsan2k = this.doBitStringPadding(vsan2k, isAllowedVsan);
            vsan4k = this.doBitStringPadding(vsan4k, isAllowedVsan);
            byte[] b1 = new byte[512];
            System.arraycopy(vsan2k.getValue(), 0, b1, 0, _byteSize);
            System.arraycopy(vsan4k.getValue(), 0, b1, _byteSize, _byteSize);
            vsan2k.setValue(b1);
        }
        return vsan2k;
    }

    public SnmpString getVlans(SnmpString vlans, SnmpString vlan2k, SnmpString vlan3k, SnmpString vlan4k) {
        if (vlans.getValue().length > 0 || vlan2k.getValue().length > 0 || vlan3k.getValue().length > 0 || vlan4k.getValue().length > 0) {
            vlans = this.doVlanBitStringPadding(vlans);
            vlan2k = this.doVlanBitStringPadding(vlan2k);
            vlan3k = this.doVlanBitStringPadding(vlan3k);
            vlan4k = this.doVlanBitStringPadding(vlan4k);
            byte[] b1 = new byte[512];
            System.arraycopy(vlans.getValue(), 0, b1, 0, _byteSize);
            System.arraycopy(vlan2k.getValue(), 0, b1, _byteSize, _byteSize);
            System.arraycopy(vlan3k.getValue(), 0, b1, _byteSize * 2, _byteSize);
            System.arraycopy(vlan4k.getValue(), 0, b1, _byteSize * 3, _byteSize);
            vlans.setValue(b1);
        }
        return vlans;
    }

    public SnmpString getVlans4Two(SnmpString vlansFirst, SnmpString vlanSecond) {
        if (vlansFirst.getValue().length > 0 || vlanSecond.getValue().length > 0) {
            vlansFirst = this.doVlanBitStringPadding(vlansFirst);
            vlanSecond = this.doVlanBitStringPadding(vlanSecond);
            byte[] b1 = new byte[512];
            System.arraycopy(vlansFirst.getValue(), 0, b1, 0, _byteSize);
            System.arraycopy(vlanSecond.getValue(), 0, b1, _byteSize, _byteSize);
            vlansFirst.setValue(b1);
        }
        return vlansFirst;
    }

    public SnmpString doBitStringPadding(SnmpString vsan, boolean isAllowedVsan) {
        byte[] b1 = new byte[_byteSize];
        if (vsan.getValue().length == 0) {
            for (int i = 0; i < _byteSize; ++i) {
                b1[i] = _type == 2 || _type == 4 || _type == 5 || _type == 6 || _type == 7 || _type == 9 || _type == 10 || _type == 8 || !isAllowedVsan ? 0 : -1;
            }
        } else {
            byte[] b = vsan.getValue();
            System.arraycopy(b, 0, b1, 0, b.length);
            if (b.length < _byteSize) {
                for (int i = b.length; i < _byteSize; ++i) {
                    b1[i] = _type == 2 || _type == 4 || _type == 5 || _type == 7 || _type == 9 || _type == 10 || _type == 8 || _type == 6 ? 0 : -1;
                }
            }
        }
        vsan.setValue(b1);
        return vsan;
    }

    public SnmpString doVlanBitStringPadding(SnmpString vlan) {
        byte[] b1 = new byte[_byteSize];
        if (vlan.getValue().length == 0) {
            for (int i = 0; i < _byteSize; ++i) {
                b1[i] = 0;
            }
        } else {
            byte[] b = vlan.getValue();
            System.arraycopy(b, 0, b1, 0, b.length);
            if (b.length < _byteSize) {
                for (int i = b.length; i < _byteSize; ++i) {
                    b1[i] = 0;
                }
            }
        }
        vlan.setValue(b1);
        return vlan;
    }

    public void addVsan4k2Pdu(SnmpPDU pdu, SnmpOID oid, SnmpVar vsan2k, int index) {
        int[] idx = new int[]{index};
        this.addVsan4k2Pdu(pdu, oid, vsan2k, idx);
    }

    public void addVsan4k2Pdu(SnmpPDU pdu, SnmpOID oid, SnmpVar vsan2k, int[] index) {
        this.addVsan4k2Pdu(pdu.getVariables(), oid, vsan2k, index);
    }

    public boolean is2k3k4kOid(SnmpOID oid) {
        return oid.startsWith(_2kOid) || oid.startsWith(_3kOid) || oid.startsWith(_4kOid);
    }

    public void addVsan4k2Pdu(VarBindList vbl, SnmpOID oid, SnmpVar vsan2k, int[] index) {
        if (oid.startsWith(_2kOid)) {
            if (!(vsan2k instanceof SnmpString)) {
                return;
            }
            byte[] b = ((SnmpString)vsan2k).getValue();
            byte[] b2k = new byte[_byteSize];
            byte[] b4k = new byte[_byteSize];
            System.arraycopy(b, 0, b2k, 0, _byteSize);
            System.arraycopy(b, _byteSize, b4k, 0, _byteSize);
            ((SnmpString)vsan2k).setValue(b2k);
            SnmpOID oid4K = index == null ? new SnmpOID(_4kOid) : new SnmpOID(_4kOid, index);
            SnmpVarBind vb4k = new SnmpVarBind(oid4K, new SnmpBitmap(b4k));
            vbl.add(vb4k);
        }
    }

    public static byte[] getVsan4k2(SnmpOID oid, SnmpVar vsan2k) {
        if (oid.startsWith(_2kOid)) {
            byte[] b = ((SnmpString)vsan2k).getValue();
            byte[] b2k = new byte[_byteSize];
            byte[] b4k = new byte[_byteSize];
            System.arraycopy(b, 0, b2k, 0, _byteSize);
            System.arraycopy(b, _byteSize, b4k, 0, _byteSize);
            ((SnmpString)vsan2k).setValue(b2k);
            return b4k;
        }
        return null;
    }

    public void addVlanAllowed4k3k2Pdu(SnmpPDU pdu, SnmpOID oid, SnmpVar vlans, int index) {
        if (oid.startsWith(_vlanTrunkPortVlansEnabledOid)) {
            byte[] b = ((SnmpString)vlans).getValue();
            byte[] bvlans = new byte[_byteSize];
            byte[] b2k = new byte[_byteSize];
            byte[] b3k = new byte[_byteSize];
            byte[] b4k = new byte[_byteSize];
            System.arraycopy(b, 0, bvlans, 0, _byteSize);
            System.arraycopy(b, _byteSize, b2k, 0, _byteSize);
            System.arraycopy(b, _byteSize * 2, b3k, 0, _byteSize);
            System.arraycopy(b, _byteSize * 3, b4k, 0, _byteSize);
            ((SnmpString)vlans).setValue(bvlans);
            pdu.addVar(new SnmpOID(_vlanTrunkPortVlansEnabledOid, index), new SnmpBitmap(bvlans));
            pdu.addVar(new SnmpOID(_vlanTrunkPortVlansEnabled2kOid, index), new SnmpBitmap(b2k));
            pdu.addVar(new SnmpOID(_vlanTrunkPortVlansEnabled3kOid, index), new SnmpBitmap(b3k));
            pdu.addVar(new SnmpOID(_vlanTrunkPortVlansEnabled4kOid, index), new SnmpBitmap(b4k));
        }
    }

    public void addVlan4k2Pdu(SnmpPDU pdu, SnmpOID oid, SnmpVar vlans, int index) {
        int[] idx = new int[]{index};
        this.addVlan4k2Pdu(pdu, oid, vlans, idx);
    }

    public void addVlan4k2Pdu(SnmpPDU pdu, SnmpOID oid, SnmpVar vlans, int[] index) {
        if (oid.startsWith(_1kOid)) {
            byte[] b = ((SnmpString)vlans).getValue();
            byte[] bvlans = new byte[_byteSize];
            byte[] b2k = new byte[_byteSize];
            byte[] b3k = new byte[_byteSize];
            byte[] b4k = new byte[_byteSize];
            System.arraycopy(b, 0, bvlans, 0, _byteSize);
            System.arraycopy(b, _byteSize, b2k, 0, _byteSize);
            System.arraycopy(b, _byteSize * 2, b3k, 0, _byteSize);
            System.arraycopy(b, _byteSize * 3, b4k, 0, _byteSize);
            ((SnmpString)vlans).setValue(bvlans);
            SnmpVarBind vb2k = new SnmpVarBind(new SnmpOID(_2kOid, index), new SnmpBitmap(b2k));
            pdu.getVariables().add(vb2k);
            SnmpVarBind vb3k = new SnmpVarBind(new SnmpOID(_3kOid, index), new SnmpBitmap(b3k));
            pdu.getVariables().add(vb3k);
            SnmpVarBind vb4k = new SnmpVarBind(new SnmpOID(_4kOid, index), new SnmpBitmap(b4k));
            pdu.getVariables().add(vb4k);
        }
    }

    public void addSpanVsanCfg2Pdu(Array pduList, SnmpBitmap oldVsan, SnmpBitmap newVsan, int[] index) {
        int j;
        int i;
        byte[] oldB = oldVsan.getValue();
        byte[] newB = newVsan.getValue();
        int oldMax = oldB.length * 8;
        int newMax = newB.length * 8;
        SnmpString addVsans = new SnmpString(new byte[newB.length]);
        SnmpString removeVsans = new SnmpString(new byte[oldB.length]);
        boolean isAddVsans = false;
        boolean isRemoveVsans = false;
        for (i = 0; i < oldMax && i < newMax; ++i) {
            if (SnmpString.getBit(oldB, i)) {
                if (SnmpString.getBit(newB, i)) continue;
                SnmpString.setBit(removeVsans.getValue(), i);
                isRemoveVsans = true;
                continue;
            }
            if (!SnmpString.getBit(newB, i)) continue;
            SnmpString.setBit(addVsans.getValue(), i);
            isAddVsans = true;
        }
        if (oldMax > newMax) {
            for (j = i; j < oldMax; ++j) {
                if (!SnmpString.getBit(oldB, i)) continue;
                SnmpString.setBit(removeVsans.getValue(), i);
                isRemoveVsans = true;
            }
        }
        if (newMax > oldMax) {
            for (j = i; j < newMax; ++j) {
                if (!SnmpString.getBit(newB, i)) continue;
                SnmpString.setBit(addVsans.getValue(), i);
                isAddVsans = true;
            }
        }
        if (isAddVsans) {
            pduList.addElement(this.add2Pdu(addVsans, index, 1));
        }
        if (isRemoveVsans) {
            pduList.addElement(this.add2Pdu(removeVsans, index, 2));
        }
    }

    SnmpPDU add2Pdu(SnmpString vsanList, int[] index, int command) {
        SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
        byte[] b = vsanList.getValue();
        byte[] b2k = new byte[256];
        byte[] b4k = new byte[256];
        System.arraycopy(b, 0, b2k, 0, 256);
        System.arraycopy(b, 256, b4k, 0, 256);
        pdu.getVariables().add(new SnmpVarBind(new SnmpOID(_commandOid, index), new SnmpInt(command)));
        pdu.getVariables().add(new SnmpVarBind(new SnmpOID(_2kOid, index), new SnmpBitmap(b2k)));
        pdu.getVariables().add(new SnmpVarBind(new SnmpOID(_4kOid, index), new SnmpBitmap(b4k)));
        return pdu;
    }

    public SnmpString get2KString(byte[] b) {
        if (b.length != 512) {
            return null;
        }
        byte[] b2K = new byte[_byteSize];
        System.arraycopy(b, 0, b2K, 0, _byteSize);
        return new SnmpString(b2K);
    }

    public SnmpString get4KString(byte[] b) {
        if (b.length != 512) {
            return null;
        }
        byte[] b4K = new byte[_byteSize];
        System.arraycopy(b, _byteSize, b4K, 0, _byteSize);
        return new SnmpString(b4K);
    }

    static {
        _allowedVsan2kOid = MibNode.get("fcIfAllowedVsanList2k").getOid();
        _allowedVsan4kOid = MibNode.get("fcIfAllowedVsanList4k").getOid();
        _allowedVsanFcip2kOid = MibNode.get("iscsi2FcNodeVsanList2k").getOid();
        _allowedVsanFcip4kOid = MibNode.get("iscsi2FcNodeVsanList4k").getOid();
        _commonRoleScope1Oid = MibNode.get("commonRoleScope1").getOid();
        _commonRoleScope2Oid = MibNode.get("commonRoleScope2").getOid();
        _srcVsanCfg2kOid = MibNode.get("cspanSourcesVsanCfgVsans2k").getOid();
        _srcVsanCfg4kOid = MibNode.get("cspanSourcesVsanCfgVsans4k").getOid();
        _filtVsanOp2kOid = MibNode.get("cspanVsanFilterOpVsans2k").getOid();
        _filtVsanOp4kOid = MibNode.get("cspanVsanFilterOpVsans4k").getOid();
        _srcCommandOid = MibNode.get("cspanSourcesVsanCfgCommand").getOid();
        _filtCommandOid = MibNode.get("cspanVsanFilterOpCommand").getOid();
        _ivrTopologyVsan2kOid = MibNode.get("civrTopologyConfigSwitchVsan2k").getOid();
        _ivrTopologyVsan4kOid = MibNode.get("civrTopologyConfigSwitchVsan4k").getOid();
        _ivrVirDomainVsan2kOid = MibNode.get("civrAddIvrVirtualDomainsVsans2k").getOid();
        _ivrVirDomainVsan4kOid = MibNode.get("civrAddIvrVirtualDomainsVsans4k").getOid();
        _ivrServiceGrpVsan2kOid = MibNode.get("civrTopologyIvrSrvGrpVsan2k").getOid();
        _ivrServiceGrpVsan4kOid = MibNode.get("civrTopologyIvrSrvGrpVsan4k").getOid();
        _ivrFabricIDVsan2kOid = MibNode.get("civrTopologyAfidConfSwitchVsan2k").getOid();
        _ivrFabricIDVsan4kOid = MibNode.get("civrTopologyAfidConfSwitchVsan4k").getOid();
        _cfmFcipLinkExtFiconTAVsanL2kOid = MibNode.get("cfmFcipLinkExtFiconTAVsanL2k").getOid();
        _cfmFcipLinkExtFiconTAVsanL4kOid = MibNode.get("cfmFcipLinkExtFiconTAVsanL4k").getOid();
        _cfmFcipLinkExtFiconTAVsanLOper2kOid = MibNode.get("cfmFcipLinkExtFiconTAVsanLOper2k").getOid();
        _cfmFcipLinkExtFiconTAVsanLOper4kOid = MibNode.get("cfmFcipLinkExtFiconTAVsanLOper4k").getOid();
        _vlanTrunkPortVlansEnabledOid = MibNode.get("vlanTrunkPortVlansEnabled").getOid();
        _vlanTrunkPortVlansEnabled2kOid = MibNode.get("vlanTrunkPortVlansEnabled2k").getOid();
        _vlanTrunkPortVlansEnabled3kOid = MibNode.get("vlanTrunkPortVlansEnabled3k").getOid();
        _vlanTrunkPortVlansEnabled4kOid = MibNode.get("vlanTrunkPortVlansEnabled4k").getOid();
        _vlanTrunkPortVlansActiveFirst2kOid = MibNode.get("vlanTrunkPortVlansActiveFirst2k").getOid();
        _vlanTrunkPortVlansActiveSecond2kOid = MibNode.get("vlanTrunkPortVlansActiveSecond2k").getOid();
        _vlanOid = MibNode.get("vmVlans").getOid();
        _vmVlans2kOid = MibNode.get("vmVlans2k").getOid();
        _vmVlans3kOid = MibNode.get("vmVlans3k").getOid();
        _vmVlans4kOid = MibNode.get("vmVlans4k").getOid();
    }
}

