/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.flash;

import com.cisco.dcbu.lib.jnm.IfVshStatus;
import com.cisco.dcbu.lib.jnm.Vsh;
import com.cisco.dcbu.lib.mds.flash.FlashFileRow;
import com.cisco.dcbu.lib.mds.flash.FlashUtil;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.tree.TreeTableModel;
import com.jidesoft.grid.CellStyle;
import com.jidesoft.grid.Row;
import com.jidesoft.grid.StyleModel;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public class FileSystemModel
extends com.jidesoft.grid.TreeTableModel
implements StyleModel {
    protected static final String[] cNames = new String[]{"Name", "Size", "Modified"};
    protected static final Class[] cTypes = new Class[]{TreeTableModel.class, String.class, String.class};
    public static final Integer ZERO = new Integer(0);
    public long _used = 0L;
    public long _free = 0L;
    public long _total = 0L;
    FlashFileRow _rootNode;
    JFrame _frame;
    String _hostName;
    SnmpPeer _peer;
    boolean _useSSH;
    Logger _log;

    public FileSystemModel(JFrame frame, String hostName, boolean useSSH, String volumeName, String rootDirName, Logger log) {
        this._rootNode = new FlashFileRow(volumeName, rootDirName, frame, hostName, useSSH, log);
        super.addRow((Row)this._rootNode);
        this._rootNode.setModel(this);
        this._frame = frame;
        this._hostName = hostName;
        this._useSSH = useSSH;
        this._log = log;
    }

    public FileSystemModel(JFrame frame, SnmpPeer peer, boolean useSSH, String volumeName, String rootDirName, Logger log) {
        this._rootNode = new FlashFileRow(volumeName, rootDirName, frame, peer, useSSH, log);
        super.addRow((Row)this._rootNode);
        this._rootNode.setModel(this);
        this._frame = frame;
        this._peer = peer;
        this._useSSH = useSSH;
        this._hostName = peer.getAddress().getHostAddress();
        this._log = log;
    }

    protected FlashFileRow.MDSFile getFile(Object node) {
        FlashFileRow fileNode = (FlashFileRow)((Object)node);
        return fileNode.getFile();
    }

    public long getUsed() {
        if (this._rootNode != null) {
            return this._used;
        }
        return 0L;
    }

    public long getFree() {
        if (this._rootNode != null) {
            return this._free;
        }
        return 0L;
    }

    public FlashFileRow.Result mkdir(String newDirName, String parentPath) throws IOException {
        FlashFileRow.VshStatusImpl vshImpl = new FlashFileRow.VshStatusImpl(this._rootNode);
        FlashFileRow.Result result = new FlashFileRow.Result(this._rootNode);
        String command = "";
        String copyResults = "";
        String actualRes = "";
        Vsh vsh = Vsh.get(this._frame, this._hostName, this._useSSH, (IfVshStatus)vshImpl);
        if (vsh == null) {
            throw new IOException("CLI connection cancelled");
        }
        if (parentPath.indexOf("bootflash://sup-local") != -1) {
            command = "cd " + parentPath + " \n";
            vsh.send(command);
            vsh.readPrompt();
            copyResults = vsh.getReply();
            actualRes = FileSystemModel.stripFooter(copyResults);
            if (this.findProblem(vsh)) {
                result.hasWarning = true;
                if (SnmpSession.isTrace()) {
                    System.err.println(copyResults);
                }
                result.resultString = actualRes;
                return result;
            }
        } else {
            newDirName = parentPath + newDirName;
        }
        command = "mkdir " + newDirName + " \n";
        vsh.send(command);
        vsh.readPrompt();
        copyResults = vsh.getReply();
        actualRes = FileSystemModel.stripFooter(copyResults);
        result.resultString = copyResults;
        result.hasWarning = this.findProblem(vsh);
        Vsh.put(vsh);
        return result;
    }

    public FlashFileRow.Result copy(String sourceFullPath, String destFullPath) throws IOException {
        FlashFileRow.VshStatusImpl vshImpl = new FlashFileRow.VshStatusImpl(this._rootNode);
        Vsh vsh = Vsh.get(this._frame, this._hostName, this._useSSH, (IfVshStatus)vshImpl);
        if (vsh == null) {
            throw new IOException("CLI connection cancelled");
        }
        FlashUtil.disableTerminalColor(vsh);
        String command = "copy " + sourceFullPath + " " + destFullPath + " \n";
        vsh.send(command);
        String[] s = new String[]{new String("[n]")};
        int iResult = vsh.expect(s);
        if (iResult == 0) {
            vsh.send("y\n");
            vsh.readPrompt();
        }
        String copyResults = vsh.getReply();
        String actualRes = FileSystemModel.stripFooter(copyResults);
        FlashFileRow.Result result = new FlashFileRow.Result(this._rootNode);
        result.hasWarning = this.findProblem(vsh);
        result.resultString = FileSystemModel.stripHeader(actualRes);
        Vsh.put(vsh);
        return result;
    }

    public FlashFileRow.Result delete(String deleteFullPath, boolean isDir) throws IOException {
        return this.delete(deleteFullPath, isDir, false, false);
    }

    public FlashFileRow.Result delete(String deleteFullPath, boolean isDir, boolean isFileDelConfirm, boolean isDirDelDoubleConfirm) throws IOException {
        String output;
        StringBuffer bufOut;
        FlashFileRow.VshStatusImpl vshImpl = new FlashFileRow.VshStatusImpl(this._rootNode);
        Vsh vsh = Vsh.get(this._frame, this._hostName, this._useSSH, (IfVshStatus)vshImpl);
        if (vsh == null) {
            throw new IOException("CLI connection cancelled");
        }
        String command = "";
        if (SnmpSession.isTrace()) {
            System.out.println("Deleting " + deleteFullPath + " \n isDir? = " + isDir);
        }
        FlashUtil.disableTerminalColor(vsh);
        command = "delete " + deleteFullPath;
        if (!isDir) {
            if (isFileDelConfirm) {
                bufOut = new StringBuffer();
                vsh.send(command + "\n");
                vsh.expect(new String[]{"[y]", "#"}, bufOut);
                output = bufOut.toString();
                if (output.contains("#")) {
                    output = output.replace(command, "");
                    String errorMsg = output.replace(vsh.getPrompt(), "").trim();
                    throw new IOException(errorMsg);
                }
                vsh.send("y\n");
            } else {
                vsh.send(command + "\n");
            }
        } else {
            bufOut = new StringBuffer();
            vsh.send(command + "\n");
            vsh.expect(new String[]{"?  [y]", "#"}, bufOut);
            output = bufOut.toString();
            if (output.contains("#")) {
                output = output.replace(command, "");
                String errorMsg = output.replace(vsh.getPrompt(), "").trim();
                throw new IOException(errorMsg);
            }
            vsh.send("y\n");
            if (isDirDelDoubleConfirm) {
                vsh.expect(new String[]{"[y]", "#"}, bufOut);
                output = bufOut.toString();
                if (output.contains("#")) {
                    output = output.replace(command, "");
                    String errorMsg = output.replace(vsh.getPrompt(), "").trim();
                    throw new IOException(errorMsg);
                }
                vsh.send("y\n");
            }
        }
        vsh.readPrompt();
        String promptStr = vsh.getPrompt();
        String copyResults = vsh.getReply();
        if (copyResults != null) {
            copyResults = copyResults.replaceAll(promptStr, "");
        }
        FlashFileRow.Result result = new FlashFileRow.Result(this._rootNode);
        result.resultString = copyResults;
        result.hasWarning = this.findProblem(vsh);
        if (SnmpSession.isTrace()) {
            System.out.println(copyResults);
        }
        Vsh.put(vsh);
        return result;
    }

    private boolean findProblem(Vsh vsh) throws IOException {
        vsh.send("show eol status \n");
        vsh.readPrompt();
        String swResult = vsh.getReply();
        String actualResult = FileSystemModel.stripFooter(swResult);
        actualResult = FileSystemModel.stripHeader(actualResult);
        return Integer.parseInt(actualResult.trim()) != 0;
    }

    public long getTotal() {
        if (this._rootNode != null) {
            return this._total;
        }
        return 0L;
    }

    public static String stripFooter(String input) {
        if (input == null) {
            return input;
        }
        StringTokenizer st = new StringTokenizer(input, "\n");
        String newOutput = "";
        int totalLines = st.countTokens();
        int i = 0;
        while (st.hasMoreTokens()) {
            String currToken = st.nextToken();
            if (i != totalLines - 1 && !currToken.trim().equals("")) {
                newOutput = newOutput + currToken + "\n";
            }
            ++i;
        }
        return newOutput;
    }

    public static String stripHeader(String input) {
        if (input == null) {
            return input;
        }
        StringTokenizer st = new StringTokenizer(input, "\n");
        String newOutput = "";
        int i = 0;
        while (st.hasMoreTokens()) {
            String currToken = st.nextToken();
            if (i != 0 && !currToken.trim().equals("")) {
                newOutput = newOutput + currToken + "\n";
            }
            ++i;
        }
        return newOutput;
    }

    protected List getChildren(Object node) {
        FlashFileRow fileNode = (FlashFileRow)((Object)node);
        return fileNode.getChildren();
    }

    public int getChildCount(Object node) {
        List children = this.getChildren(node);
        return children.size();
    }

    public Object getChild(Object node, int i) {
        return this.getChildren(node).get(i);
    }

    public boolean isLeaf(Object node) {
        return this.getFile(node).isFile();
    }

    public String getColumnName(int column) {
        return cNames[column];
    }

    public Class getColumnClass(int column) {
        return cTypes[column];
    }

    public Object getValueAt(Object node, int column) {
        FlashFileRow.MDSFile file = ((FlashFileRow)((Object)node)).getFile();
        try {
            switch (column) {
                case 0: {
                    return file.getDisplayName();
                }
                case 1: {
                    if (file.getPath() == null) {
                        return 0;
                    }
                    return file.length();
                }
                case 2: {
                    return file.lastModified();
                }
            }
        }
        catch (SecurityException se) {
            // empty catch block
        }
        return null;
    }

    public int getColumnCount() {
        return cNames.length;
    }

    public CellStyle getCellStyleAt(int rowIndex, int columnIndex) {
        return null;
    }

    public boolean isCellStyleOn() {
        return false;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }
}

