/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.renderers;

import com.cisco.dcbu.lib.jnm.IndexCellRenderer;
import com.cisco.dcbu.lib.jnm.SnmpFiconPort;
import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.mds.VsanUtil;
import com.cisco.dcbu.lib.mds.ficon.FiconPortByIfIndexCache;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.util.Array;

public class FiconPortIfIndexRenderer
extends IndexCellRenderer {
    SnmpPeer _peer;
    SnmpString _members;

    public FiconPortIfIndexRenderer(SnmpPeer peer, SnmpString members) {
        this._peer = peer;
        this._members = members;
    }

    @Override
    public String getLabel(int[] index) {
        int portAddr = index[index.length - 1];
        String portLabel = SnmpFiconPort.toString(portAddr);
        Array list = FiconPortByIfIndexCache.getInstance(this._peer).getFiconIfIndexByPortAddr(portAddr);
        if (list == null) {
            return portLabel;
        }
        StringBuffer ifIndexSb = new StringBuffer();
        boolean first = true;
        for (int i = 0; i < list.size(); ++i) {
            int ifIndex = (Integer)list.elementAt(i);
            if (ifIndex == -1) continue;
            if (this._members != null) {
                int card = MibVariableFormat._IfIndexIf.ifIndex2Card(ifIndex);
                int port = MibVariableFormat._IfIndexIf.ifIndex2Port(ifIndex);
                if (!VsanUtil.getBit(this._members.getValue(), (card << 6) + port)) continue;
            }
            if (!first) {
                ifIndexSb.append(", ");
            } else {
                first = false;
            }
            ifIndexSb.append(MibVariableFormat._IfIndexIf.ifIndexToName(ifIndex));
        }
        if (ifIndexSb.toString().length() > 0) {
            return portLabel + '(' + ifIndexSb.toString() + ')';
        }
        return portLabel;
    }
}

