/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.zm;

import com.cisco.dcbu.lib.mds.zm.VersionPeer;
import com.cisco.dcbu.lib.mds.zm.ZoneCapability;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpAggregrate;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.client.model.Switch;
import com.cisco.dcbu.sm.client.zm.common.SmIvrZoneSwitch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class IvrZoneSwitch
implements Comparator,
Comparable {
    static final int IVR_ENABLED = 2;
    static final int CFS_ENABLED = 2;
    private VersionPeer _switch;
    private ZoneCapability _ivrCap;
    private boolean _isIvrEnabled;
    private boolean _isIvrCfsEnabled;
    private boolean _isNatEnabled;
    private boolean _isAutoTopologyEnabled;
    private String _activeIvrZnsetName;
    private boolean _isIvrMergeFailed;
    protected int _ivrRegionId;

    protected IvrZoneSwitch() {
    }

    protected IvrZoneSwitch(VersionPeer sw) throws SnmpException {
        if (!sw.isMds()) {
            throw new SnmpException("This is not a IVR capable MDS switch");
        }
        this.buildSwitchInfo(sw);
    }

    private void buildSwitchInfo(VersionPeer sw) throws SnmpException {
        if (!sw.isMds()) {
            throw new SnmpException("This is not a IVR capable MDS switch");
        }
        this._switch = sw;
        this._ivrCap = sw.getIvrCapability();
    }

    public static HashMap getCfsRegionsInfo(ArrayList ivrZnSwList, StringBuffer msg) {
        HashMap ivrRegionMap = new HashMap();
        if (ivrZnSwList != null && ivrZnSwList.size() > 0) {
            StringBuffer pendingSwitches = new StringBuffer(132);
            ArrayList peers = new ArrayList();
            for (int i = 0; i < ivrZnSwList.size(); ++i) {
                SmIvrZoneSwitch zs = (SmIvrZoneSwitch)ivrZnSwList.get(i);
                int regionID = zs.getIvrRegionId() <= 0 ? -1 : zs.getIvrRegionId();
                ArrayList<Switch> swLst = (ArrayList<Switch>)ivrRegionMap.get(regionID);
                if (swLst == null) {
                    swLst = new ArrayList<Switch>();
                }
                if (!swLst.contains(zs.getSwitch())) {
                    swLst.add(zs.getSwitch());
                }
                ivrRegionMap.put(regionID, swLst);
            }
        }
        if (ivrRegionMap.size() > 1) {
            for (Map.Entry obEntry : ivrRegionMap.entrySet()) {
                String regionId = (Integer)obEntry.getKey() <= 0 ? "default(potential)" : obEntry.getKey().toString();
                msg.append("Region " + regionId + " : ");
                ArrayList swList = (ArrayList)obEntry.getValue();
                for (int j = 0; j < swList.size(); ++j) {
                    if (j > 0) {
                        msg.append(" ,");
                    }
                    msg.append(swList.get(j));
                    if (j < 2 || j >= swList.size() - 1) continue;
                    msg.append("...");
                    break;
                }
                msg.append("\n");
            }
        }
        return ivrRegionMap;
    }

    public static ArrayList discoverSwitchProperties(ArrayList peersLst, IvrZoneSwitch ivrSw) throws SnmpException {
        ArrayList<IvrZoneSwitch> list = new ArrayList<IvrZoneSwitch>();
        if (peersLst.size() > 0) {
            ArrayList peersList = VersionPeer.getSnmpPeersFromVerPeers(peersLst);
            SnmpPeer[] peers = peersList.toArray(new SnmpPeer[peersList.size()]);
            VarBindList vbl = new VarBindList();
            vbl.add(MibNode.get("cfcFeatureCtrlOpStatus").getOid(), 1);
            vbl.add(MibNode.get("cfsFeatureOpStatus").getOid(), new int[]{3, 105, 118, 114});
            vbl.add(MibNode.get("civrFcidNatMode").getOid(), 0);
            vbl.add(MibNode.get("civrVsanTopologyAutoDisc").getOid(), 0);
            vbl.add(MibNode.get("civrZoneEnforcedZoneSetName").getOid(), 0);
            vbl.add(MibNode.get("cfsMergeStatusValue").getOid(), new int[]{7, 115, 121, 115, 108, 111, 103, 100, 1});
            vbl.add(MibNode.get("cfsFeatureRegionId").getOid(), new int[]{3, 105, 118, 114, 1});
            SnmpPDU[] pdus = new SnmpAggregrate().get(peers, vbl);
            for (int i = 0; i < pdus.length; ++i) {
                if (pdus[i].getError() != 0) {
                    throw new SnmpException(pdus[i].getAddress().getHostName() + ": " + SnmpException.toError(pdus[i].getError()));
                }
                VersionPeer sw = VersionPeer.findVersionPeer(peersLst, pdus[i].getAddress());
                if (sw == null) continue;
                IvrZoneSwitch zSw = ivrSw.buildIvrSwitchOb(sw);
                VarBindList vbData = pdus[i].getVariables();
                boolean bl = zSw.isIvrCapable() ? vbData.intValue(0) == 2 : (zSw._isIvrEnabled = false);
                boolean bl2 = zSw.isCfsCapable() ? vbData.intValue(1) == 2 : (zSw._isIvrCfsEnabled = false);
                boolean bl3 = zSw.isNatTopoCapable() ? vbData.intValue(2) == 1 : (zSw._isNatEnabled = false);
                zSw._isAutoTopologyEnabled = zSw.isNatTopoCapable() ? vbData.intValue(3) == 1 : false;
                zSw._activeIvrZnsetName = vbData.getVb(4).getVar().getType() == 4 ? vbData.stringValue(4) : null;
                zSw._isIvrMergeFailed = false;
                zSw._ivrRegionId = zSw._isIvrEnabled ? vbData.intValue(6) : -1;
                list.add(zSw);
            }
        }
        return list;
    }

    public static Integer[] getIvrRegions(ArrayList switchInfo) {
        ArrayList<Integer> regions = new ArrayList<Integer>();
        if (switchInfo != null) {
            for (int i = 0; i < switchInfo.size(); ++i) {
                IvrZoneSwitch zSw = (IvrZoneSwitch)switchInfo.get(i);
                if (zSw._ivrRegionId < 0 || regions.contains(zSw._ivrRegionId)) continue;
                regions.add(zSw._ivrRegionId);
            }
        }
        return regions.toArray(new Integer[regions.size()]);
    }

    protected IvrZoneSwitch buildIvrSwitchOb(VersionPeer sw) throws SnmpException {
        return new IvrZoneSwitch(sw);
    }

    public ZoneCapability getCapability() {
        return this._ivrCap;
    }

    public SnmpPeer getPeer() {
        return this._switch.getSwitchPeer();
    }

    public boolean isIvrEnabled() {
        return this._isIvrEnabled;
    }

    public boolean isIvrCapable() {
        return this._ivrCap.isIvrCapable();
    }

    public boolean isIvrCfsEnabled() {
        return this._isIvrCfsEnabled;
    }

    public boolean isCfsCapable() {
        return this._ivrCap.isCFSSupported();
    }

    public boolean isNatTopoCapable() {
        return this._ivrCap.isNatAutoTopoAfidSupported();
    }

    public boolean isNatEnabled() {
        return this._isNatEnabled;
    }

    public boolean isAutoTopologyEnabled() {
        return this._isAutoTopologyEnabled;
    }

    public boolean hasActiveZnst() {
        return this._activeIvrZnsetName != null && this._activeIvrZnsetName.length() > 0;
    }

    public boolean isIvrMergeFailed() {
        return this._isIvrMergeFailed;
    }

    public String getActiveIvrZnstName() {
        return this._activeIvrZnsetName;
    }

    public String toString() {
        return this._switch.getSwitchPeer().toString();
    }

    public static ArrayList getMergeFailedSwitches(ArrayList swLst) {
        ArrayList<IvrZoneSwitch> failed = new ArrayList<IvrZoneSwitch>();
        for (int i = 0; i < swLst.size(); ++i) {
            IvrZoneSwitch sw = (IvrZoneSwitch)swLst.get(i);
            if (!sw.isIvrMergeFailed() || failed.contains(sw)) continue;
            failed.add(sw);
        }
        return failed;
    }

    public static boolean areAllSwitches21OrAbove(ArrayList swLst) {
        for (int i = 0; i < swLst.size(); ++i) {
            IvrZoneSwitch sw = (IvrZoneSwitch)swLst.get(i);
            if (!sw.getCapability().isVersionLessThan("2.1(0)")) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllSwitchesLowerThan21(ArrayList swLst) {
        for (int i = 0; i < swLst.size(); ++i) {
            IvrZoneSwitch sw = (IvrZoneSwitch)swLst.get(i);
            if (!sw.getCapability().isVersionGreaterThanEqual("2.1(0)")) continue;
            return false;
        }
        return true;
    }

    public static boolean areAllIvrEnabledSwitches21OrAbove(ArrayList swLst) {
        for (int i = 0; i < swLst.size(); ++i) {
            IvrZoneSwitch sw = (IvrZoneSwitch)swLst.get(i);
            if (!sw.isIvrEnabled() || !sw.getCapability().isVersionLessThan("2.1(0)")) continue;
            return false;
        }
        return true;
    }

    public static ArrayList getNatEnabledSwitches(ArrayList swLst) {
        ArrayList<IvrZoneSwitch> list = new ArrayList<IvrZoneSwitch>();
        for (int i = 0; i < swLst.size(); ++i) {
            IvrZoneSwitch sw = (IvrZoneSwitch)swLst.get(i);
            if (!sw.isNatEnabled() || list.contains(sw)) continue;
            list.add(sw);
        }
        return list;
    }

    public static ArrayList getNatDisabledActiveIvrZnstSwitches(ArrayList swLst) {
        ArrayList<IvrZoneSwitch> list = new ArrayList<IvrZoneSwitch>();
        for (int i = 0; i < swLst.size(); ++i) {
            IvrZoneSwitch sw = (IvrZoneSwitch)swLst.get(i);
            if (sw.isNatEnabled() || !sw.hasActiveZnst() || list.contains(sw)) continue;
            list.add(sw);
        }
        return list;
    }

    public static ArrayList getIvr2CapableZnstSwitches(ArrayList swLst) {
        ArrayList<IvrZoneSwitch> list = new ArrayList<IvrZoneSwitch>();
        for (int i = 0; i < swLst.size(); ++i) {
            IvrZoneSwitch sw = (IvrZoneSwitch)swLst.get(i);
            if (!sw.getCapability().isVersionGreaterThanEqual("2.1(0)") || list.contains(sw)) continue;
            list.add(sw);
        }
        return list;
    }

    public static ArrayList getAutoTopoEnabledSwitches(ArrayList swLst) {
        ArrayList<IvrZoneSwitch> list = new ArrayList<IvrZoneSwitch>();
        for (int i = 0; i < swLst.size(); ++i) {
            IvrZoneSwitch sw = (IvrZoneSwitch)swLst.get(i);
            if (!sw.isAutoTopologyEnabled() || list.contains(sw)) continue;
            list.add(sw);
        }
        return list;
    }

    public static ArrayList getIvrSwitches(ArrayList swLst, boolean ivrEnabled) {
        ArrayList<VersionPeer> list = new ArrayList<VersionPeer>();
        for (int i = 0; i < swLst.size(); ++i) {
            IvrZoneSwitch sw = (IvrZoneSwitch)swLst.get(i);
            if (!sw.getVersionPeer().isMds() || list.contains(sw) || (!ivrEnabled || !sw.isIvrEnabled()) && (ivrEnabled || !sw.isIvrCapable())) continue;
            list.add(sw._switch);
        }
        Collections.sort(list);
        return list;
    }

    public static ArrayList getIvrPeers(ArrayList swLst, boolean ivrEnabled) {
        ArrayList sws = IvrZoneSwitch.getIvrSwitches(swLst, ivrEnabled);
        ArrayList<VersionPeer> peers = new ArrayList<VersionPeer>();
        for (int i = 0; i < sws.size(); ++i) {
            VersionPeer sw = (VersionPeer)sws.get(i);
            if (peers.contains(sw)) continue;
            peers.add(sw);
        }
        Collections.sort(peers);
        return peers;
    }

    public static void setSwitchIvrState(ArrayList sws, boolean state, ArrayList swInfoLst) {
        for (int i = 0; i < sws.size(); ++i) {
            IvrZoneSwitch.setSwitchIvrState((SnmpPeer)sws.get(i), state, swInfoLst);
        }
    }

    public static void setSwitchIvrState(SnmpPeer sws, boolean state, ArrayList swInfoLst) {
        IvrZoneSwitch zsw = IvrZoneSwitch.findSwitchInfo(swInfoLst, sws);
        if (zsw != null) {
            zsw._isIvrEnabled = state;
        }
    }

    public static IvrZoneSwitch findSwitchInfo(ArrayList swInfoLst, SnmpPeer sw) {
        for (int i = 0; i < swInfoLst.size(); ++i) {
            IvrZoneSwitch zsw = (IvrZoneSwitch)swInfoLst.get(i);
            if (zsw._switch.getSwitchPeer().compareTo(sw) != 0) continue;
            return zsw;
        }
        return null;
    }

    public VersionPeer getVersionPeer() {
        return this._switch;
    }

    public int compare(Object o1, Object o2) {
        IvrZoneSwitch sw1 = (IvrZoneSwitch)o1;
        IvrZoneSwitch sw2 = (IvrZoneSwitch)o2;
        return sw1.getVersionPeer().getSwitchPeer().compare(sw1.getVersionPeer().getSwitchPeer(), sw2.getVersionPeer().getSwitchPeer());
    }

    public int compareTo(Object o) {
        return this.compare(this, o);
    }

    public int getIvrRegionId() {
        return this._ivrRegionId;
    }

    public void setIvrRegionId(int ivrRegionId) {
        this._ivrRegionId = ivrRegionId;
    }
}

