/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.mds.zm;

import com.cisco.dcbu.lib.mds.zm.AbstractZone;
import com.cisco.dcbu.lib.mds.zm.CommandHandler;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.VarBindList;
import java.util.ArrayList;

public class ZoneAlias
extends AbstractZone {
    public static final String[] _ZoneAliasVars = new String[]{"zoneAliasName", "zoneAliasLastChange"};
    public static final String[] ZONE_ALIAS_NUM = new String[]{"zoneEnforcedZoneAliasNumber", "zoneAliasNumber"};
    public static final int[] ZONE_ALIAS_ROW_STATUS_OID = MibNode.get("zoneAliasRowStatus").getOid();

    public ZoneAlias(int vsan, int index, String name, long lastChange) {
        this.zoneVsanId = vsan;
        this.zoneIndex = index;
        this.zoneName = name;
        this.type = 2;
        this.zoneLastModtime = lastChange;
    }

    @Override
    public void buildTimeStampVarBind(VarBindList tmstmpVBL) {
        tmstmpVBL.add(MibNode.get(_ZoneAliasVars[1]).getOid(), this.getSnmpIndex());
    }

    @Override
    public int[] getSnmpIndex() {
        return new int[]{this.zoneVsanId, this.zoneIndex};
    }

    @Override
    public boolean equals(Object ob) {
        if (ob == this) {
            return true;
        }
        if (!(ob instanceof ZoneAlias)) {
            return false;
        }
        ZoneAlias za = (ZoneAlias)ob;
        return super.equals(za) && this.zoneName.equals(za.zoneName);
    }

    public String toString() {
        return this.zoneName;
    }

    public static ArrayList discover(CommandHandler handler, ArrayList members) throws SnmpException {
        return handler.discoverAliases(false, members);
    }

    @Override
    public int[] getRowStatusOid(boolean isIvr) {
        return ZONE_ALIAS_ROW_STATUS_OID;
    }

    public static ZoneAlias createNewZoneAlias(CommandHandler handler, int vsan, int index, ArrayList members, String name, long sysUpTime) throws SnmpException {
        return handler.createNewZoneAlias(vsan, index, members, name, sysUpTime);
    }

    @Override
    public void addMembers(CommandHandler handler, AbstractZone[] az) throws SnmpException {
        handler.addMembers(this, az);
    }

    @Override
    public int[] getNameOID() {
        return MibNode.get(_ZoneAliasVars[0]).getOid();
    }
}

