/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp;

import com.cisco.dcbu.lib.snmp.SnmpASN1;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInputStream;
import com.cisco.dcbu.lib.snmp.SnmpOutputStream;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.ui.FieldPanel;

public class SnmpInt
extends SnmpVar {
    protected int _value;

    public SnmpInt(int value) {
        this._type = (byte)2;
        this._value = value;
    }

    public SnmpInt(String value) throws NumberFormatException {
        this(FieldPanel.getNumber(value));
    }

    protected SnmpInt(SnmpInputStream is, int len) throws SnmpException {
        this(SnmpASN1.parseInteger(is, len));
    }

    public final int getValue() {
        return this._value;
    }

    public void setValue(int value) {
        this._value = value;
    }

    public String toString() {
        return Integer.toString(this._value);
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        SnmpInt i1 = (SnmpInt)o1;
        SnmpInt i2 = (SnmpInt)o2;
        return i1._value - i2._value;
    }

    @Override
    protected void encode(SnmpOutputStream os) throws SnmpException {
        SnmpASN1.buildInteger(os, this._value);
    }
}

