/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp;

import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.SnmpASN1;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInputStream;
import com.cisco.dcbu.lib.snmp.SnmpOutputStream;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import java.util.Arrays;
import java.util.StringTokenizer;

public class SnmpString
extends SnmpVar {
    protected byte[] _byteValue;
    public String _value;
    public static final char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public SnmpString(byte[] b) {
        this._type = (byte)4;
        this._byteValue = b;
    }

    public SnmpString(String hex) throws NumberFormatException {
        this._type = (byte)4;
        if (hex == null) {
            throw new NumberFormatException("empty");
        }
        this._byteValue = hex.length() > 2 && hex.charAt(2) == ':' ? SnmpString.fromHexString(hex) : hex.getBytes();
        this._value = hex;
    }

    public SnmpString(String hex, boolean force) throws NumberFormatException {
        this._type = (byte)4;
        if (hex == null) {
            throw new NumberFormatException("empty");
        }
        this._byteValue = !force && hex.length() > 2 && hex.charAt(2) == ':' ? SnmpString.fromHexString(hex) : hex.getBytes();
        this._value = hex;
    }

    protected SnmpString(SnmpInputStream is, int len) throws SnmpException {
        this._type = (byte)4;
        this._byteValue = new byte[len];
        System.arraycopy(is._buf, is._pos, this._byteValue, 0, len);
        is._pos += len;
    }

    public final byte[] getValue() {
        return this._byteValue;
    }

    public final void setValue(byte[] value) {
        this._byteValue = value;
    }

    public String toString() {
        if (this._value == null && this._byteValue != null) {
            this._value = this._type == 4 && SnmpString.isPrintable(this._byteValue) ? new String(this._byteValue) : SnmpString.toHexString(this._byteValue);
        }
        return this._value;
    }

    public final void cacheString(boolean isPrintable) {
        if (isPrintable) {
            int len;
            for (len = this._byteValue.length - 1; len >= 0 && this._byteValue[len] == 0; --len) {
            }
            this._value = new String(this._byteValue, 0, len + 1);
        } else {
            this._value = SnmpString.toHexString(this._byteValue);
        }
    }

    public final boolean isNull() {
        for (int i = 0; i < this._byteValue.length; ++i) {
            if (this._byteValue[i] == 0) continue;
            return false;
        }
        return true;
    }

    public final boolean equals(SnmpString s) {
        return s != null && SnmpString.equals(this._byteValue, s._byteValue);
    }

    @Override
    public int compare(Object o1, Object o2) {
        if (o1 == o2) {
            return 0;
        }
        byte[] b1 = ((SnmpString)o1)._byteValue;
        byte[] b2 = ((SnmpString)o2)._byteValue;
        for (int i = 0; i < b1.length && i < b2.length; ++i) {
            if (b1[i] < b2[i]) {
                return 1;
            }
            if (b1[i] <= b2[i]) continue;
            return -1;
        }
        return b1.length - b2.length;
    }

    public static final boolean equals(byte[] b1, byte[] b2) {
        return Arrays.equals(b1, b2);
    }

    @Override
    protected void encode(SnmpOutputStream os) throws SnmpException {
        SnmpASN1.buildOctet(os, this._type, this._byteValue);
    }

    protected void encode(SnmpOutputStream os, int len) throws SnmpException {
        SnmpASN1.buildHeader(os, this._type, len);
        System.arraycopy(this._byteValue, 0, os._buf, os._pos, len);
        os._pos += len;
    }

    public static boolean isPrintable(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            int c = b[i] & 0xFF;
            if (c >= 32 && c <= 126 || c == 10 || c == 13 || c == 9) continue;
            return false;
        }
        return true;
    }

    public static boolean isPrintable(int c) {
        return c >= 32 && c <= 126 || c == 10 || c == 13 || c == 9;
    }

    public static String toHexString(byte[] b) {
        if (b == null || b.length == 0) {
            return null;
        }
        StringBuffer sb = new StringBuffer(b.length * 3);
        for (int i = 0; i < b.length; ++i) {
            int n = b[i] & 0xFF;
            sb.append(HEX_DIGIT[n >> 4 & 0xF]);
            sb.append(HEX_DIGIT[n & 0xF]);
            if (i + 1 >= b.length) continue;
            sb.append(':');
        }
        return sb.toString();
    }

    public static String toHexString(byte[] index, int offset, int length) {
        return SnmpString.toHexString(index, offset, length, true);
    }

    public static String toHexString(byte[] index, int offset, int length, boolean useSemicolon) {
        if (index == null || index.length == 0) {
            return null;
        }
        if (offset < 0 || offset >= index.length || length < 0) {
            return index.toString();
        }
        if (length > index.length) {
            length = index.length;
        }
        StringBuffer sb = new StringBuffer(length * 3);
        for (int i = offset; i < length; ++i) {
            int n = index[i] & 0xFF;
            sb.append(HEX_DIGIT[n >> 4 & 0xF]);
            sb.append(HEX_DIGIT[n & 0xF]);
            if (i + 1 >= length || !useSemicolon) continue;
            sb.append(':');
        }
        return sb.toString();
    }

    public static String toHexString(int[] index, int offset, int length, boolean useSemicolon) {
        StringBuffer sb = new StringBuffer(length * 3);
        for (int i = offset; i < length; ++i) {
            sb.append(HEX_DIGIT[index[i] >> 4 & 0xF]);
            sb.append(HEX_DIGIT[index[i] & 0xF]);
            if (!useSemicolon || i + 1 >= length) continue;
            sb.append(':');
        }
        return sb.toString();
    }

    public static byte[] fromHexString(String hexStr) throws NumberFormatException {
        return SnmpString.fromHexString(hexStr, true);
    }

    public static byte[] fromHexString(String hexStr, boolean hasColon) throws NumberFormatException {
        hexStr = hexStr.toLowerCase();
        int len = hexStr.length();
        byte[] bytes = new byte[hasColon ? len / 3 + 1 : len / 2];
        int sPos = 0;
        int bPos = 0;
        try {
            while (sPos < len) {
                char a = hexStr.charAt(sPos);
                char b = hexStr.charAt(sPos + 1);
                if (hasColon && (a == ':' || b == ':')) {
                    throw new NumberFormatException("bad Hex format");
                }
                int v1 = Character.digit(a, 16);
                int v2 = Character.digit(b, 16);
                if (v1 < 0 || v2 < 0) {
                    throw new NumberFormatException("bad Hex format");
                }
                int v3 = v1 * 16 + v2;
                bytes[bPos] = (byte)v3;
                sPos += hasColon ? 3 : 2;
                ++bPos;
            }
        }
        catch (Exception ex) {
            throw new NumberFormatException("bad Hex format");
        }
        if (bPos < bytes.length) {
            throw new NumberFormatException("bad Hex format");
        }
        return bytes;
    }

    public static String bitsToString(byte[] b, MibEnum[] enums) {
        int len = b.length;
        if (len < 1) {
            return SnmpString.toHexString(b);
        }
        return SnmpString.bitsToString(b, enums, false);
    }

    public static String bitsToStringBase0(byte[] b, MibEnum[] enums) {
        return SnmpString.bitsToString(b, enums, true);
    }

    public static String bitsToString(byte[] b, MibEnum[] enums, boolean bBase0) {
        StringBuffer sb = new StringBuffer();
        int max = b.length * 8;
        for (int i = 0; i < max; ++i) {
            boolean bitSet;
            boolean bl = bitSet = bBase0 ? SnmpString.getBitBase0(b, i) : SnmpString.getBit(b, i);
            if (!bitSet) continue;
            for (int j = 0; j < enums.length; ++j) {
                if (i != enums[j].getValue()) continue;
                sb.append(enums[j].getLabel());
                sb.append(' ');
            }
        }
        return sb.toString();
    }

    public static final String toString(int[] index, int offset, int len) {
        char[] c = new char[len - offset];
        for (int i = 0; i < c.length; ++i) {
            c[i] = (char)index[i + offset];
        }
        return new String(c);
    }

    public static int[] valueOf(byte[] b, boolean isLength) {
        int length = isLength ? b.length + 1 : b.length;
        int[] index = new int[length];
        int indexSize = 0;
        if (isLength) {
            index[indexSize++] = b.length;
        }
        for (int i = 0; i < b.length; ++i) {
            index[indexSize++] = b[i] & 0xFF;
        }
        return index;
    }

    public static boolean getBit(byte[] b, int pos) {
        int shift = 8 - pos % 8;
        if (shift == 8) {
            shift = 0;
        }
        return (b[(pos - 1) / 8] >> shift & 1) != 0;
    }

    public static void setBit(byte[] b, int pos) {
        int shift = 8 - pos % 8;
        if (shift == 8) {
            shift = 0;
        }
        int n = (pos - 1) / 8;
        b[n] = (byte)(b[n] | 1 << shift);
    }

    public static void clearBit(byte[] b, int pos) {
        int shift = 8 - pos % 8;
        if (shift == 8) {
            shift = 0;
        }
        int n = (pos - 1) / 8;
        b[n] = (byte)(b[n] & ~(1 << shift));
    }

    public static boolean getBitBase0(byte[] b, int pos) {
        int shift = 7 - pos % 8;
        return (b[pos / 8] >> shift & 1) != 0;
    }

    public static void setBitBase0(byte[] b, int pos) {
        int shift = 7 - pos % 8;
        int n = pos / 8;
        b[n] = (byte)(b[n] | 1 << shift);
    }

    public static void clearBitBase0(byte[] b, int pos) {
        int shift = 7 - pos % 8;
        int n = pos / 8;
        b[n] = (byte)(b[n] & ~(1 << shift));
    }

    public static SnmpString[] parseStringList(String idList) throws NumberFormatException {
        StringTokenizer st = new StringTokenizer(idList, ",", false);
        int tokens = st.countTokens();
        if (tokens > 0) {
            SnmpString[] out = new SnmpString[tokens];
            int start = 0;
            while (st.hasMoreTokens()) {
                out[start++] = new SnmpString(SnmpString.fromHexString(st.nextToken().trim()));
            }
            return out;
        }
        return null;
    }
}

