/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp.proxy;

import com.cisco.dcbu.lib.snmp.transport.SnmpTransportPacket;
import com.cisco.dcbu.lib.util.NameValuePair;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Observer;
import java.util.concurrent.Semaphore;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

final class TcpClientSession {
    private Observer _observer;
    private Socket _socket;
    private DataOutputStream _out;
    private DataInputStream _in;
    private Semaphore _writingLock = new Semaphore(1);
    private InetSocketAddress _snmpSocketAddr;
    private boolean _close = false;
    Logger _logger;
    private Map<String, NameValuePair<String, String>> _snmpSrcAddrRequests = Collections.synchronizedMap(new HashMap(3));
    private String _snmpSrcAddr = null;

    TcpClientSession(Socket socket, Observer observer, Logger logger) throws IOException {
        this._socket = socket;
        this._observer = observer;
        this._logger = logger;
        try {
            this._socket.setTcpNoDelay(true);
            this._socket.setSoLinger(false, 0);
            this._socket.setKeepAlive(true);
            this._socket.setSoTimeout(0);
        }
        catch (SocketException se) {
            this._logger.warn((Object)se.toString());
        }
        this._in = new DataInputStream(new BufferedInputStream(this._socket.getInputStream()));
        this._out = new DataOutputStream(new BufferedOutputStream(this._socket.getOutputStream()));
    }

    public InetAddress getLocalAddress() {
        return this._socket.getLocalAddress();
    }

    public int getLocalPort() {
        return this._socket.getLocalPort();
    }

    public InetAddress getRemoteAddress() {
        return this._socket.getInetAddress();
    }

    public int getRemotePort() {
        return this._socket.getPort();
    }

    public InetAddress getSnmpSourceAddress() {
        return this._snmpSocketAddr != null ? this._snmpSocketAddr.getAddress() : null;
    }

    public int getSnmpSourcePort() {
        return this._snmpSocketAddr != null ? this._snmpSocketAddr.getPort() : -1;
    }

    public String getRemoteEndpoint() {
        return this._socket.getInetAddress().getHostAddress() + ':' + this._socket.getPort();
    }

    public String toString() {
        return "TCP client session " + this._socket.getLocalAddress().getHostAddress() + ':' + this._socket.getLocalPort() + " -> " + this._socket.getInetAddress().getHostAddress() + ':' + this._socket.getPort();
    }

    public void close() {
        this._close = true;
        if (this._socket != null) {
            try {
                this._socket.close();
                this._in.close();
                this._out.close();
            }
            catch (IOException ioe) {
                this._logger.warn((Object)("close client connection error: " + ioe));
            }
            this._socket = null;
        }
        this._observer = null;
        this._writingLock = null;
        this._logger = null;
    }

    void sendRequest(byte reqType) throws IOException {
        this.sendRequest(reqType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendRequest(byte reqType, String message) throws IOException {
        try {
            this._writingLock.acquire();
            this._out.writeByte(reqType);
            if (message != null) {
                this._out.writeInt(message.length());
                this._out.writeUTF(message);
            }
            this._out.flush();
        }
        catch (InterruptedException ie) {
            if (!this._close) {
                this._logger.warn((Object)("sendRequest error: " + ie));
            }
        }
        finally {
            this._writingLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendSnmpRequest(SnmpTransportPacket packet) throws IOException {
        byte[] addr;
        int addrType;
        InetAddress remoteAddr = packet.getAddress();
        if (remoteAddr == null) {
            String hostname = packet.getAddress().getHostName();
            addrType = 3;
            addr = hostname.getBytes();
        } else {
            addr = remoteAddr.getAddress();
            addrType = addr.length == 4 ? 1 : 2;
        }
        int remotePort = packet.getPort();
        try {
            this._writingLock.acquire();
            this._out.writeByte(3);
            this._out.writeInt(packet.getTransactionId());
            this._out.writeByte(addrType);
            this._out.writeInt(addr.length);
            this._out.write(addr);
            this._out.writeInt(remotePort);
            this._out.writeInt(packet.getLength());
            this._out.write(packet.getData(), 0, packet.getLength());
            this._out.flush();
        }
        catch (InterruptedException ie) {
            if (!this._close) {
                this._logger.warn((Object)("sendRequest error: " + ie));
            }
        }
        finally {
            this._writingLock.release();
        }
    }

    int receive(SnmpTransportPacket packet) throws IOException {
        block9: while (!this._close) {
            byte rspType = this._in.readByte();
            byte rtnCode = this._in.readByte();
            String msg = this._in.readInt() != 0 ? this._in.readUTF() : null;
            switch (rspType) {
                case 65: {
                    packet.setLength(1);
                    if (rtnCode == 1 && msg != null) {
                        int del = msg.indexOf(47);
                        try {
                            this._snmpSocketAddr = new InetSocketAddress(InetAddress.getByName(msg.substring(0, del)), Integer.parseInt(msg.substring(del + 1)));
                        }
                        catch (Exception ex) {
                            this._logger.log((Priority)Level.ERROR, (Object)"ProxyTransportProvider::receive()", (Throwable)ex);
                        }
                        this._logger.info((Object)("remote SNMP Socket opened: " + msg));
                        continue block9;
                    }
                    this._logger.warn((Object)("opening remote SNMP Socket error: " + msg));
                    continue block9;
                }
                case 66: {
                    packet.setLength(1);
                    if (rtnCode == 1) {
                        this._logger.info((Object)"remote DatagramSocket closed");
                        continue block9;
                    }
                    this._logger.warn((Object)("closing remote DatagramSocket error: " + msg));
                    continue block9;
                }
                case 67: {
                    packet.setLength(1);
                    if (rtnCode == 1) {
                        this._logger.info((Object)"SNMP status OK");
                        continue block9;
                    }
                    this._logger.warn((Object)("remote SNMP exception: " + msg));
                    continue block9;
                }
                case 68: {
                    return this.receivePDUResponse(packet);
                }
                case 69: {
                    packet.setLength(1);
                    this.snmpSrcAddressReceived(rtnCode, msg);
                    continue block9;
                }
            }
            this._logger.error((Object)("unknown repsonse from server, type=" + rspType));
        }
        if (this._observer != null) {
            this._observer.update(null, this);
        }
        return -1;
    }

    private int receivePDUResponse(SnmpTransportPacket packet) {
        try {
            int addrlen = this._in.readInt();
            byte[] addr = new byte[addrlen];
            this._in.read(addr, 0, addrlen);
            packet.setAddress(InetAddress.getByAddress(addr));
            int srcport = this._in.readInt();
            packet.setPort(srcport);
            int pdulen = this._in.readInt();
            packet.setLength(pdulen);
            this._in.read(packet.getData(), 0, pdulen);
            this._logger.debug((Object)("Received PDU from " + packet.getAddress() + ", len=" + pdulen + " via " + this.getRemoteEndpoint()));
            return pdulen;
        }
        catch (Exception ex) {
            this._logger.log((Priority)Level.ERROR, (Object)"Receiving PDU error", (Throwable)ex);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSnmpSourceAddressRequest(InetAddress host) {
        if (host == null) {
            return this._snmpSocketAddr != null ? this._snmpSocketAddr.getAddress().getHostAddress() : null;
        }
        NameValuePair<String, String> nv = null;
        String hostAddr = host.getHostAddress();
        Map<String, NameValuePair<String, String>> map = this._snmpSrcAddrRequests;
        synchronized (map) {
            nv = this._snmpSrcAddrRequests.get(hostAddr);
            if (nv == null) {
                nv = new NameValuePair(hostAddr);
                this._snmpSrcAddrRequests.put(hostAddr, nv);
            }
        }
        try {
            map = nv;
            synchronized (map) {
                this.sendRequest((byte)4, hostAddr);
                try {
                    nv.wait(3000L);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
            }
            map = this._snmpSrcAddrRequests;
            synchronized (map) {
                this._snmpSrcAddrRequests.remove(hostAddr);
            }
            String value = nv.getValue();
            if (value != null) {
                return value;
            }
            InetAddress addr = this.getSnmpSourceAddress();
            return addr != null ? addr.getHostAddress() : null;
        }
        catch (Exception ex) {
            if (this._snmpSrcAddr != null) {
                return this._snmpSrcAddr;
            }
            InetAddress addr = this.getSnmpSourceAddress();
            return addr != null ? addr.getHostAddress() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void snmpSrcAddressReceived(byte returnCode, String msg) {
        int index;
        if (msg == null || msg.trim().length() == 0) {
            return;
        }
        if (this._snmpSrcAddr == null) {
            this._snmpSrcAddr = msg;
        }
        String host = msg;
        String snmpAddr = null;
        if (returnCode == 1 && (index = msg.indexOf("=")) != -1) {
            host = msg.substring(0, index);
            if (index < msg.length() - 1) {
                snmpAddr = msg.substring(index + 1);
            }
        }
        Map<String, NameValuePair<String, String>> map = this._snmpSrcAddrRequests;
        synchronized (map) {
            NameValuePair<String, String> nv = this._snmpSrcAddrRequests.get(host);
            if (nv != null) {
                nv.setValue(snmpAddr);
                NameValuePair<String, String> nameValuePair = nv;
                synchronized (nameValuePair) {
                    nv.notifyAll();
                }
            }
        }
    }
}

