/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp.security;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.snmp.security.CommunityUser;
import com.cisco.dcbu.lib.snmp.security.CommunityUserEntry;
import com.cisco.dcbu.lib.snmp.security.SnmpUser;
import com.cisco.dcbu.lib.snmp.security.Target;
import com.cisco.dcbu.lib.snmp.security.UsmUser;
import com.cisco.dcbu.lib.snmp.security.UsmUserEntry;
import com.cisco.dcbu.lib.snmp.security.V3Target;
import java.net.InetAddress;

public abstract class UserEntry {
    public static final String ROLE_OPER = "network-operator";
    public static final String ROLE_ADMIN = "network-admin";
    static final int[] _VacmGroupNameOid = new int[]{1, 3, 6, 1, 6, 3, 16, 1, 2, 1, 3};
    static final int[] _CVacmSecurityGrpStatusOid = new int[]{1, 3, 6, 1, 4, 1, 9, 9, 409, 1, 1, 1, 3};
    static final int[][] _CommonRoleOid = new int[][]{{1, 3, 6, 1, 4, 1, 9, 9, 361, 1, 2, 2, 1, 3}, {1, 3, 6, 1, 4, 1, 9, 9, 361, 1, 2, 2, 1, 4}, {1, 3, 6, 1, 4, 1, 9, 9, 361, 1, 2, 2, 1, 5}};
    SnmpSession _session;

    public abstract SnmpUser getUser();

    public abstract Target getTarget();

    public abstract int getSecurityModel();

    public abstract SnmpPDU createPDU(int var1);

    public abstract void querySecurityName(SnmpSession var1) throws SnmpException;

    public SnmpSession getSession() {
        return this._session;
    }

    public void queryRoleName(SnmpSession session) throws SnmpException {
        String securityName = this.getUser().getSecurityName();
        int[] oid = new int[_VacmGroupNameOid.length + securityName.length() + 2];
        System.arraycopy(_VacmGroupNameOid, 0, oid, 0, _VacmGroupNameOid.length);
        oid[UserEntry._VacmGroupNameOid.length] = this.getSecurityModel();
        oid[UserEntry._VacmGroupNameOid.length + 1] = securityName.length();
        int max = securityName.length();
        for (int i = 0; i < max; ++i) {
            oid[UserEntry._VacmGroupNameOid.length + i + 2] = securityName.charAt(i) & 0xFF;
        }
        SnmpPDU pdu = this.createPDU(1);
        pdu.addNull(new SnmpOID(oid));
        pdu = session.send(pdu);
        if (pdu.getVar(0).getType() == 4) {
            this.getUser().setRoleName(pdu.getVariables().stringValue(0));
        }
        if (this.getUser().getRoleName() != null && !this.getUser().getRoleName().equals(ROLE_ADMIN)) {
            try {
                this.querySecondaryRoleName(session);
            }
            catch (SnmpException se) {
                // empty catch block
            }
        }
        if (this.getUser().getRoleName() == null) {
            this.getUser().setRoleName(ROLE_OPER);
        }
    }

    public void querySecondaryRoleName(SnmpSession session) throws SnmpException {
        String securityName = this.getUser().getSecurityName();
        int[] oid = new int[_CVacmSecurityGrpStatusOid.length + securityName.length() + 2];
        System.arraycopy(_CVacmSecurityGrpStatusOid, 0, oid, 0, _CVacmSecurityGrpStatusOid.length);
        oid[UserEntry._CVacmSecurityGrpStatusOid.length] = this.getSecurityModel();
        oid[UserEntry._CVacmSecurityGrpStatusOid.length + 1] = securityName.length();
        int max = securityName.length();
        for (int i = 0; i < max; ++i) {
            oid[UserEntry._CVacmSecurityGrpStatusOid.length + i + 2] = securityName.charAt(i) & 0xFF;
        }
        SnmpPDU pdu = this.createPDU(2);
        pdu.addNull(new SnmpOID(oid));
        pdu.setCommand((byte)-91);
        pdu.setMaxRptr(5);
        pdu = session.send(pdu);
        VarBindList vbl = pdu.getVariables();
        for (int i = 0; i < 5; ++i) {
            String name;
            int[] toid = vbl.getVb(i).getOid().getValue();
            if (!SnmpOID.startsWith(toid, oid) || vbl.intValue(i) != 1 || !(name = SnmpString.toString(toid, oid.length + 1, toid.length)).equals(ROLE_ADMIN)) continue;
            this.getUser().setRoleName(name);
        }
    }

    public short[] queryRoleScope(SnmpSession session) throws SnmpException {
        int i;
        SnmpPDU pdu = this.createPDU(3);
        String role = this.getUser().getRoleName();
        int[] index = new int[role.length() + 1];
        index[0] = role.length();
        for (i = 0; i < role.length(); ++i) {
            index[i + 1] = role.charAt(i) & 0xFF;
        }
        for (i = 0; i < 3; ++i) {
            pdu.addNull(new SnmpOID(_CommonRoleOid[i], index));
        }
        try {
            pdu = session.send(pdu);
            VarBindList vbl = pdu.getVariables();
            if (vbl.intValue(0) == 2) {
                byte[] scope1 = vbl.byteValue(1);
                byte[] scope2 = vbl.byteValue(2);
                byte[] scope = new byte[scope1.length + scope2.length];
                System.arraycopy(scope1, 0, scope, 0, scope1.length);
                System.arraycopy(scope2, 0, scope, scope1.length, scope2.length);
                if (scope.length != 0) {
                    short[] tvids = new short[4096];
                    int vsanCnt = 0;
                    int fstHalf = scope1.length;
                    int secondValue = 2048 - fstHalf * 8;
                    for (int i2 = 0; i2 < scope.length; ++i2) {
                        int vid = i2 * 8;
                        for (int j = 0; j < 8; ++j) {
                            if ((scope[i2] & (byte)(128 >> j % 8)) > 0) {
                                tvids[vsanCnt++] = i2 < fstHalf ? (short)vid : (short)(vid + secondValue);
                            }
                            ++vid;
                        }
                    }
                    if (vsanCnt > 0) {
                        short[] vids = new short[vsanCnt];
                        System.arraycopy(tvids, 0, vids, 0, vsanCnt);
                        return vids;
                    }
                }
            }
        }
        catch (SnmpException e) {
            // empty catch block
        }
        return null;
    }

    public void queryV2cRoleName(SnmpSession session) {
        SnmpPDU pdu = this.createPDU(1);
        pdu.addNull(new SnmpOID(new int[]{1, 3, 6, 1, 2, 1, 1, 4, 0}));
        pdu.setCommand((byte)-96);
        try {
            pdu = session.send(pdu);
            if (pdu.getVar(0).getType() != 4) {
                return;
            }
            this.getUser().setRoleName(ROLE_OPER);
            pdu.setCommand((byte)-93);
            pdu = session.send(pdu);
            if (pdu.getError() == 0) {
                this.getUser().setRoleName(ROLE_ADMIN);
            }
        }
        catch (SnmpException snmpException) {
            // empty catch block
        }
    }

    public static UserEntry authenticate(SnmpUser user, InetAddress targetAdd) throws SnmpException {
        return UserEntry.authenticate(user, targetAdd, null);
    }

    public static UserEntry authenticate(SnmpUser user, InetAddress targetAdd, String transport) throws SnmpException {
        UserEntry entry;
        SnmpPeer peer = SnmpPeer.findPeer(targetAdd);
        SnmpPeer tmpPeer = null;
        if (user.getSecurityModel() == 3 && peer != null && !peer.hasCerdentialAs(user) && peer.isV3()) {
            tmpPeer = SnmpPeer.createSnmpPeer(targetAdd, SnmpSession.getInstance(transport), user);
        }
        SnmpSession session = null;
        if (transport == null || transport.length() == 0) {
            session = peer == null ? SnmpSession.getInstance() : peer.getSession();
        } else {
            SnmpSession snmpSession = session = peer == null ? SnmpSession.getInstance(transport) : peer.getSession();
        }
        if (user.getSecurityModel() == 3) {
            UsmUserEntry uentry = new UsmUserEntry((UsmUser)user, new V3Target(targetAdd));
            uentry.discoverEngine(session);
            entry = uentry;
        } else {
            entry = new CommunityUserEntry((CommunityUser)user, new Target(targetAdd));
        }
        entry.querySecurityName(session);
        if (entry.getSession() != null) {
            session = entry.getSession();
        }
        if (user.getSecurityName() == null && user.getSecurityModel() != 3) {
            entry.queryV2cRoleName(session);
        } else {
            entry.queryRoleName(session);
        }
        if (user.getRoleName() == null) {
            throw new SnmpException("Invalid SNMP credentials");
        }
        return entry;
    }

    public static UserEntry authenticateBrcd(SnmpUser user, InetAddress targetAdd) throws SnmpException {
        UserEntry entry;
        SnmpSession session;
        SnmpPeer peer = SnmpPeer.findPeer(targetAdd);
        SnmpSession snmpSession = session = peer == null ? SnmpSession.getInstance() : peer.getSession();
        if (user.getSecurityModel() == 3) {
            UsmUserEntry uentry = new UsmUserEntry((UsmUser)user, new V3Target(targetAdd));
            uentry.discoverEngine(session);
            entry = uentry;
        } else {
            entry = new CommunityUserEntry((CommunityUser)user, new Target(targetAdd));
        }
        entry.querySecurityName(session);
        if (entry.getSession() != null) {
            session = entry.getSession();
        }
        entry.queryV2cRoleName(session);
        if (user.getRoleName() == null) {
            throw new SnmpException("Invalid SNMP credentials");
        }
        return entry;
    }
}

