/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.snmp.transport;

import com.cisco.dcbu.lib.snmp.CallbackHandler;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpInputStream;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpOutputStream;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpReportException;
import com.cisco.dcbu.lib.snmp.SnmpTcpConnectionException;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.snmp.transport.SessionCallbackIf;
import com.cisco.dcbu.lib.snmp.transport.SnmpTransportPacket;
import com.cisco.dcbu.lib.snmp.transport.TcpTransportOptions;
import com.cisco.dcbu.lib.util.GenUtil;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.lib.util.SyncedInt;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

final class TcpSession
extends Thread {
    static final int ASN_LONG_LEN = -128;
    static final int PRE_READ_LEN = 6;
    static final byte STATE_READ_HEADER = 1;
    static final byte STATE_READ_PAYLOAD = 2;
    static final byte STATE_PDU_READY = 3;
    static final byte STATE_CLOSE = 4;
    private String _sessionId;
    private SyncedInt _sessionState = new SyncedInt(1);
    private Socket _socket;
    private SessionCallbackIf _callback;
    private byte[] _buf = new byte[6000];
    private int _bufPos = 0;
    private int _pduLen = 0;
    private Semaphore _writingLock = new Semaphore(1);
    private Logger _log = LogManager.getLogger((String)"snmp.tcp");
    private static final int BUF_SIZE = 6192;
    public static final int RESP_BUF_SIZE = 6000;
    public static final int _MaxQueueSize = Integer.getInteger("snmp.qsize", 128);
    private boolean _close = false;
    public int _receiver_pri_inc;
    public int _sender_pri_inc;
    private int _nRequests;
    private int _nResponses;
    private long _requestLen;
    private long _responseLen;
    private int _nTimeouts;
    private int _nResends;
    private int _nMaxResponseLen;
    private long _nMaxQueueTime;
    private int _nMaxOutstanding;
    private int _nMaxHandoff;
    private Map<Integer, SnmpPDU> _outstandingList;
    private ArrayBlockingQueue<SnmpPDU> _handoffQueue;
    private SnmpOutputStream _requestBuf = new SnmpOutputStream(6192);
    private static CallbackHandler _CallbackHandler;
    Thread senderThread = new SenderThread();

    public TcpSession(ThreadGroup group, String threadName, Socket socket, String userName, SessionCallbackIf callback) {
        super(group, threadName);
        this._socket = socket;
        this._callback = callback;
        this._sessionId = this._socket.getInetAddress().getHostAddress() + "/" + this._socket.getPort() + (userName == null ? "" : "/" + userName);
        this._receiver_pri_inc = Integer.getInteger("snmp.rcvThreadPriInc", 1);
        this._sender_pri_inc = Integer.getInteger("snmp.sndThreadPriInc", 1);
        this.setPriority(this.getPriority() + this._receiver_pri_inc);
        this._handoffQueue = new ArrayBlockingQueue(_MaxQueueSize);
        this._outstandingList = Collections.synchronizedMap(new HashMap(_MaxQueueSize, 0.75f));
        if (_CallbackHandler == null) {
            _CallbackHandler = CallbackHandler.getInstance();
        }
        this.senderThread.start();
    }

    public String getSessionId() {
        return this._sessionId;
    }

    public InetAddress getInetAddress() {
        if (this._socket == null) {
            return null;
        }
        return this._socket.getInetAddress();
    }

    public InetAddress getLocalInetAddress() {
        if (this._socket == null) {
            return null;
        }
        return this._socket.getLocalAddress();
    }

    public int getPort() {
        return this._socket.getPort();
    }

    public TcpTransportOptions getTransportOptions() {
        return new TcpTransportOptions(this._socket.getInetAddress(), this._socket.getPort(), this._socket.getLocalAddress().getHostName(), this._socket.getLocalPort());
    }

    public boolean isConnected() {
        if (this._socket == null) {
            return false;
        }
        return this._socket.isConnected();
    }

    public boolean isPduReady() {
        return this._sessionState.get() == 3;
    }

    public int readPdu(SnmpTransportPacket tpacket) {
        int len = 0;
        if (this._sessionState.get() == 3 && this._pduLen != 0) {
            byte[] buf = tpacket.getData();
            tpacket.setData(this._buf);
            tpacket.setLength(this._pduLen);
            tpacket.setAddress(this._socket.getInetAddress());
            tpacket.setPort(this._socket.getPort());
            len = this._pduLen;
            this._bufPos = 0;
            this._pduLen = 0;
            this._buf = buf;
            this.setSessionState((byte)1);
        }
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePdu(byte[] data, int len) throws IOException {
        try {
            this._writingLock.acquire();
            OutputStream os = this._socket.getOutputStream();
            os.write(data, 0, len);
            os.flush();
            if (this._log.isTraceEnabled()) {
                this._log.trace((Object)(this._sessionId + ": " + len + " bytes sent"));
            }
        }
        catch (IOException ioe) {
            try {
                this.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            throw ioe;
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this._writingLock.release();
        }
    }

    public void writePdu(SnmpPDU pdu) throws SnmpException {
        try {
            if (!this._handoffQueue.offer(pdu, 1L, TimeUnit.SECONDS)) {
                pdu.getLogger().warn((Object)"request sending timed out, queue full");
                System.setProperty("rqst_queue_full", "true");
                throw new SnmpException("timeout, request queue full");
            }
            if (this._handoffQueue.size() > this._nMaxHandoff) {
                this._nMaxHandoff = this._handoffQueue.size();
            }
        }
        catch (InterruptedException iex) {
            pdu.getLogger().warn((Object)"request sending interrupted");
            throw new SnmpException("timeout, request interrupted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSend(SnmpPDU pdu) {
        pdu.setSendException(null);
        pdu.setTimeSent(System.currentTimeMillis());
        long timeExpires = pdu.getTimeSent() + (pdu.getRemainingRetries() == pdu.getRetries() ? (long)pdu.getTimeout() : (long)pdu.getTimeout() * 2L);
        pdu.setTimeExpires(timeExpires);
        pdu.setNotInTimeWindowResend(false);
        this._outstandingList.put(pdu.getReqid(), pdu);
        int size = this._outstandingList.size();
        if (size > this._nMaxOutstanding) {
            this._nMaxOutstanding = size;
        }
        try {
            this.writePDU(pdu);
        }
        catch (Throwable ex) {
            this._outstandingList.remove(pdu.getReqid());
            if (ex instanceof SnmpException) {
                pdu.setSendException((SnmpException)ex);
            } else {
                pdu.setSendException(new SnmpException(ex.getMessage(), ex));
            }
            pdu.setError(-1);
            if (pdu.getTarget() == null) {
                SnmpPDU snmpPDU = pdu;
                synchronized (snmpPDU) {
                    pdu.notifyAll();
                }
            } else {
                _CallbackHandler.add(pdu);
            }
            pdu.getLogger().log((Priority)Level.ERROR, (Object)("request sending error: <" + pdu + ">"), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePDU(SnmpPDU pdu) throws SnmpException {
        if (pdu.getLogger().isDebugEnabled()) {
            pdu.getLogger().debug((Object)pdu);
        }
        SnmpOutputStream snmpOutputStream = this._requestBuf;
        synchronized (snmpOutputStream) {
            this._requestBuf.reset();
            pdu.encode(this._requestBuf);
            SnmpTransportPacket tpacket = new SnmpTransportPacket(pdu.getAddress(), pdu.getPort(), pdu.getUserName(), this._requestBuf._buf, this._requestBuf._pos, pdu.getReqid());
            try {
                this.writePdu(tpacket.getData(), tpacket.getLength());
                ++this._nRequests;
                this._requestLen += (long)this._requestBuf._pos;
            }
            catch (IOException ioe) {
                if (ioe.getMessage().indexOf("Timeout") != -1) {
                    throw new SnmpException(ioe.getMessage());
                }
                InetAddress localAddr = this.getLocalAddress();
                InetAddress targetAddr = pdu.getAddress();
                if (targetAddr == null) {
                    throw new SnmpException("PDU target address is null.");
                }
                if (pdu.getLogger().isTraceEnabled()) {
                    pdu.getLogger().log((Priority)Level.TRACE, (Object)("Send PDU Transport provider: UDP Session Address " + NetUtil.getHostAddress(localAddr) + " Type : " + (localAddr == null || localAddr instanceof Inet4Address ? "V4" : "V6") + "Target Address " + NetUtil.getHostAddress(targetAddr) + " Type : " + (targetAddr instanceof Inet4Address ? "V4" : "V6")), (Throwable)ioe);
                }
                if (!(targetAddr instanceof Inet4Address && (localAddr == null || localAddr instanceof Inet4Address) || targetAddr instanceof Inet6Address && (localAddr == null || localAddr instanceof Inet6Address))) {
                    if (localAddr == null || localAddr instanceof Inet6Address) {
                        throw new SnmpException("Host bound to IPv6 Address, Cannot connect to IPv4 Target");
                    }
                    throw new SnmpException("Host bound to IPv4 Address, Cannot connect to IPv6 Target");
                }
                if (ioe instanceof SocketException) {
                    throw new SnmpException(ioe.getMessage(), ioe);
                }
                if (ioe instanceof SnmpTcpConnectionException) {
                    SnmpTcpConnectionException tcpEx = (SnmpTcpConnectionException)ioe;
                    throw new SnmpException("send PDU: " + ioe.getMessage(), tcpEx);
                }
                throw new SnmpException("send PDU: " + ioe.getMessage(), ioe);
            }
        }
    }

    public void close() throws IOException {
        this.close(true);
    }

    public void close(boolean withCallback) throws IOException {
        if (this._socket != null && SnmpPeer.findPeer(this._socket.getInetAddress()) != null) {
            SnmpPeer.findPeer(this._socket.getInetAddress()).checkSnmpConnection();
        }
        this.setSessionState((byte)4);
        if (!this._socket.isClosed()) {
            this._socket.close();
        }
        if (withCallback) {
            this._callback.update(this, (byte)4);
        }
        this._close = true;
        this.senderThread.interrupt();
    }

    public void destroy() {
        this._socket = null;
        this._buf = null;
        this._bufPos = 0;
        this._pduLen = 0;
        this._sessionId = null;
        this._sessionState = null;
        this._callback = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block12: while (this._socket != null && !this._socket.isClosed() && !this._close) {
            try {
                InputStream is = this._socket.getInputStream();
                switch (this._sessionState.get()) {
                    case 1: {
                        int readlen = is.read(this._buf, this._bufPos, 6 - this._bufPos);
                        if (readlen < 0) {
                            this._log.error((Object)("SNMP/TCP session " + this._sessionId + " read header <0,  reset: readlen is -1"));
                            break block12;
                        }
                        this._bufPos += readlen;
                        if (this._bufPos != 6) continue block12;
                        this._pduLen = TcpSession.decodeLength(this._buf);
                        if (this._pduLen > 6000) {
                            this._log.error((Object)("SNMP/TCP session " + this._sessionId + " reset due to large PDU size: " + this._pduLen));
                            break block12;
                        }
                        if (this._pduLen < 6) {
                            this._log.error((Object)("SNMP/TCP session " + this._sessionId + " decoding PDU length error: " + this._pduLen + "\n" + new Date() + " " + this._bufPos + " bytes read:" + GenUtil.dump(this._buf, 0, this._bufPos)));
                            break block12;
                        }
                        this.setSessionState((byte)2);
                        break;
                    }
                    case 2: {
                        int readlength = is.read(this._buf, this._bufPos, this._pduLen - this._bufPos);
                        if (readlength < 0) {
                            this._log.error((Object)("SNMP/TCP session " + this._sessionId + " read payload <0, reset: readlen is -1"));
                            break block12;
                        }
                        this._bufPos += readlength;
                        if (this._bufPos != this._pduLen) continue block12;
                        this.setSessionState((byte)3);
                        this.receiver();
                        break;
                    }
                    case 3: {
                        Object object = this._sessionState.getLock();
                        synchronized (object) {
                            this._sessionState.getLock().wait(100L);
                            break;
                        }
                    }
                    default: {
                        break block12;
                    }
                }
            }
            catch (Exception ex) {
                if (this._sessionState == null) break;
                if (this._sessionState.get() == 4) {
                    this._log.debug((Object)("SNMP/TCP session " + this._sessionId + " closed " + new Date()));
                    break;
                }
                if (!this._socket.isConnected()) {
                    this._log.debug((Object)("SNMP/TCP session " + this._sessionId + " lost connection " + new Date()));
                    break;
                }
                this._log.error((Object)("SNMP/TCP session " + this._sessionId + ": " + ex.getMessage() + " " + new Date()));
                break;
            }
        }
        if (this._sessionState != null && this._sessionState.get() != 4) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSessionState(byte newState) {
        Object object = this._sessionState.getLock();
        synchronized (object) {
            if (this._sessionState.get() != 4) {
                this._sessionState.set(newState);
                this._sessionState.getLock().notifyAll();
            } else {
                this._log.debug((Object)("Cannot set state for  " + this._sessionId + "session is closed already"));
            }
        }
    }

    public static int decodeLength(byte[] buf) throws ArrayIndexOutOfBoundsException {
        int len;
        int pos = 1;
        if ((len = buf[pos++]) < 0) {
            int j = len & 0x7F;
            len = 0;
            while (j-- > 0) {
                len = len << 8 | buf[pos++] & 0xFF;
            }
        }
        return len + pos;
    }

    @Override
    public String toString() {
        return this._sessionId;
    }

    private void receiver() {
        byte[] _responseBuf = new byte[6000];
        SnmpTransportPacket tpacket = new SnmpTransportPacket(_responseBuf);
        tpacket.setLength(_responseBuf.length);
        try {
            if (this.readPdu(tpacket) != 0) {
                this.processPacket(tpacket);
            } else {
                this._log.info((Object)"UDP provider is closed");
            }
        }
        catch (Exception ex) {
            this._log.log((Priority)Level.ERROR, (Object)(this + " receiver error"), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPacket(SnmpTransportPacket packet) {
        int reqId;
        if (packet.getLength() == 1) {
            return;
        }
        SnmpPDU pdu = new SnmpPDU(new VarBindList());
        pdu.setTimeReceived(System.currentTimeMillis());
        pdu.setAddress(packet.getAddress());
        pdu.setPort(packet.getPort());
        SnmpInputStream is = new SnmpInputStream(packet.getData(), packet.getLength());
        try {
            reqId = SnmpPDU.decodeReqId(is);
        }
        catch (Exception ex) {
            this._log.log((Priority)Level.ERROR, (Object)("decodeReqId: bad packet from " + pdu.getAddress() + ", " + pdu.getPort()), (Throwable)ex);
            return;
        }
        SnmpPDU qPdu = null;
        if (reqId == 0) {
            this._log.log((Priority)Level.ERROR, (Object)("decodeReqId: bad packet from " + pdu.getAddress() + ", " + pdu.getPort()));
            return;
        }
        qPdu = this._outstandingList.remove(reqId);
        SnmpPeer peer = null;
        if (qPdu != null) {
            if (qPdu.getLogger().isDebugEnabled() && !pdu.getAddress().equals(qPdu.getAddress())) {
                qPdu.getLogger().debug((Object)("restore req " + reqId + " IP " + pdu.getAddress() + " --> " + qPdu.getAddress()));
            }
            peer = qPdu.getPeer();
            pdu.setPeer(qPdu.getPeer());
            pdu.setSession(qPdu.getSession());
            pdu.setAddress(qPdu.getAddress());
            pdu.setTarget(qPdu.getTarget());
            pdu.setAuthProtocol(qPdu.getAuthProtocol());
            pdu.setPrivacyProtocol(qPdu.getPrivacyProtocol());
            pdu.setPrivacyKey(qPdu.getPrivacyKey());
            pdu.setLogger(qPdu.getLogger());
            pdu.setVarBindMask(qPdu.getVarBindMask());
            pdu.setRountTripTime(pdu.getTimeReceived() - qPdu.getTimeSent());
        }
        if (peer == null) {
            peer = SnmpPeer.findPeer(pdu.getAddress());
        }
        if (peer != null) {
            pdu.setPrivacyProtocol(pdu.getPrivacyProtocol() != -1 ? pdu.getPrivacyProtocol() : peer.getPrivProtocol());
            pdu.setPrivacyKey(pdu.getPrivacyKey() != null ? pdu.getPrivacyKey() : peer.getPrivKey());
        }
        try {
            pdu.decode(is);
            if (peer != null && pdu.getVersion() == 3) {
                peer.setEngineTime(pdu.getEngineTime());
                peer.setEngineBoots(pdu.getEngineBoots());
            }
            if (pdu.getLogger().isDebugEnabled()) {
                pdu.getLogger().debug((Object)pdu);
            }
        }
        catch (Exception ex) {
            pdu.getLogger().log((Priority)Level.ERROR, (Object)("pdu.decode: bad packet from " + pdu.getAddress() + ", " + pdu.getPort()), (Throwable)ex);
            if (peer != null) {
                peer.setNDelays(peer.getNDelays() + 1);
            }
            return;
        }
        if (qPdu == null) {
            pdu.getLogger().warn((Object)("Response after timeout (in process packet): " + pdu));
            if (peer != null) {
                peer.setNDelays(peer.getNDelays() + 1);
            }
        } else {
            if (peer != null) {
                peer.setRoundTripDelay(peer.getRoundTripDelay() + (pdu.getTimeReceived() - qPdu.getTimeSent()));
                peer.setNResponses(peer.getNResponses() + 1);
                peer.setResponseLen(peer.getResponseLen() + packet.getLength());
            }
            ++this._nResponses;
            this._responseLen += (long)packet.getLength();
            if (packet.getLength() > this._nMaxResponseLen) {
                this._nMaxResponseLen = packet.getLength();
            }
            if (pdu.getCommand() == -88) {
                pdu.setError(SnmpReportException.getError(pdu.getOid(0).getValue()));
                if (pdu.getError() == 27 || pdu.getError() == 25) {
                    if (peer != null) {
                        peer.setEngineId(pdu.getEngineId());
                        peer.setEngineBoots(pdu.getEngineBoots());
                        peer.setEngineTime(pdu.getEngineTime());
                    }
                    if (qPdu.getVariables().size() != 0 && !qPdu.isNotInTimeWindowResend()) {
                        qPdu.setEngineId(pdu.getEngineId());
                        qPdu.setEngineTime(pdu.getEngineTime());
                        qPdu.setEngineBoots(pdu.getEngineBoots());
                        qPdu.setNotInTimeWindowResend(true);
                        this.resend(qPdu);
                        return;
                    }
                    if (qPdu.getEngineTime() > 0) {
                        qPdu.getLogger().warn((Object)("Time Sync Failure on " + qPdu + "\n\t SENT time,boots: " + qPdu.getEngineTime() + "," + qPdu.getEngineBoots() + ". RECV " + pdu.getEngineTime() + "," + pdu.getEngineBoots()));
                    }
                } else if ((pdu.getError() == 26 || pdu.getError() == 28 || pdu.getError() == 24) && !qPdu.isAaaAuthenticated() && peer != null && peer.canTryAaaAuth()) {
                    try {
                        pdu.getLogger().info((Object)"Attempting to reauthenticate user due to SNMP command failure.");
                        peer.aaaAuthenticate();
                        this.resend(qPdu);
                        return;
                    }
                    catch (Exception ex) {
                        pdu.getLogger().log((Priority)Level.ERROR, (Object)(pdu.getHostAddress() + ": AAA validation failed!"), (Throwable)ex);
                    }
                    catch (Throwable e) {
                        pdu.getLogger().log((Priority)Level.ERROR, (Object)(pdu.getHostAddress() + ": AAA validation failed!"), e);
                    }
                    finally {
                        qPdu.setAaaAuthenticated(true);
                        pdu.setAaaAuthenticated(true);
                    }
                }
            }
            if (pdu.getError() == 0) {
                if (peer != null && qPdu.getCommand() == -93 && !qPdu.isIgnoreSetCount()) {
                    peer.incrementSets();
                } else if (qPdu.getCommand() == -95 && pdu.getVariables().getVb(0).getError() != 21 && SnmpOID.equals(qPdu.getOid(0).getValue(), pdu.getOid(0).getValue())) {
                    pdu.setError(3);
                }
            } else if (pdu.getError() == 13 && qPdu.getRemainingRuaRetries() > 0) {
                qPdu.setRemainingRuaRetries((short)(qPdu.getRemainingRuaRetries() - 1));
                this.resend(qPdu);
                return;
            }
            qPdu.setResponse(pdu);
            if (qPdu.getTarget() == null) {
                SnmpPDU snmpPDU = qPdu;
                synchronized (snmpPDU) {
                    qPdu.notifyAll();
                }
            } else {
                _CallbackHandler.add(qPdu);
            }
        }
    }

    private void resend(SnmpPDU pdu) {
        pdu.setTimeQueued(System.currentTimeMillis());
        try {
            if (!this._handoffQueue.contains(pdu)) {
                this._handoffQueue.offer(pdu, 1L, TimeUnit.SECONDS);
            }
        }
        catch (Exception ex) {
            pdu.getLogger().log((Priority)Level.ERROR, (Object)"resend", (Throwable)ex);
        }
        if (this._handoffQueue.size() > this._nMaxHandoff) {
            this._nMaxHandoff = this._handoffQueue.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void monitorRequests() {
        long now = System.currentTimeMillis();
        ArrayList<SnmpPDU> timeouts = new ArrayList<SnmpPDU>();
        ArrayList<SnmpPDU> resends = new ArrayList<SnmpPDU>();
        Map<Integer, SnmpPDU> map = this._outstandingList;
        synchronized (map) {
            Iterator<SnmpPDU> it = this._outstandingList.values().iterator();
            while (it.hasNext()) {
                SnmpPDU pdu = it.next();
                if (pdu.getTimeExpires() >= now) continue;
                it.remove();
                if (pdu.getRemainingRetries() > 0) {
                    resends.add(pdu);
                    continue;
                }
                timeouts.add(pdu);
            }
        }
        this._nTimeouts += timeouts.size();
        for (SnmpPDU pdu : timeouts) {
            pdu.setError(-1);
            pdu.setResponse(null);
            pdu.getLogger().warn((Object)("TIMEOUT " + SnmpPDU._TimeFormat.format(new Date()) + " elapsed=" + (System.currentTimeMillis() - pdu.getTimeSent()) + " Udp Transport " + pdu.toString()));
            if (pdu.getTarget() == null) {
                SnmpPDU snmpPDU = pdu;
                synchronized (snmpPDU) {
                    pdu.notifyAll();
                    continue;
                }
            }
            _CallbackHandler.add(pdu);
        }
        this._nResends += resends.size();
        for (SnmpPDU pdu : resends) {
            pdu.setRemainingRetries((short)(pdu.getRemainingRetries() - 1));
            if (pdu.getPeer() != null) {
                pdu.setEngineTime(pdu.getPeer().getEngineTime());
                pdu.setEngineBoots(pdu.getPeer().getEngineBoots());
            }
            this.resend(pdu);
            pdu.getLogger().info((Object)("RESEND PDU:  elapsed=" + (System.currentTimeMillis() - pdu.getTimeSent()) + " Udp Transport" + pdu.toString()));
        }
    }

    public InetAddress getLocalAddress() {
        return this._socket != null ? this._socket.getLocalAddress() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatsInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nTCP Session " + this.getName());
        if (this._nRequests > 0) {
            sb.append("\n\tTx Total: ").append(this._nRequests).append(" packets, ").append(this._requestLen).append(" bytes (").append(this._requestLen / (long)this._nRequests).append(" avg)");
        }
        if (this._nResponses > 0) {
            sb.append("\n\tRx Total: ").append(this._nResponses).append(" packets, ").append(this._responseLen).append(" bytes (").append(this._responseLen / (long)this._nResponses).append(" avg, ").append(this._nMaxResponseLen).append(" max)");
        }
        sb.append("\n\tTotal Timeout: ").append(this._nTimeouts).append("\n\tTotal Resend: ").append(this._nResends).append("\n\tMax Outstanding: ").append(this._nMaxOutstanding).append("\n\tMax Queued: ").append(this._nMaxHandoff).append("\n\tMax Queued Time (ms): ").append(this._nMaxQueueTime).append("\n\tCurrent outstanding requests: ").append(this._outstandingList.size());
        Map<Integer, SnmpPDU> map = this._outstandingList;
        synchronized (map) {
            for (Map.Entry<Integer, SnmpPDU> entry : this._outstandingList.entrySet()) {
                sb.append("\n\t\t").append(entry.getKey()).append(" > ").append(entry.getValue());
            }
        }
        sb.append("\n\tCurrent queued requests: ").append(this._handoffQueue.size());
        Iterator<SnmpPDU> it = this._handoffQueue.iterator();
        while (it.hasNext()) {
            sb.append("\n\t\t").append(it.next());
        }
        return sb.toString();
    }

    class SenderThread
    extends Thread {
        SenderThread() {
            super(TcpSession.this.getThreadGroup(), TcpSession.this.getName() + ".SenderThread");
            this.setPriority(this.getPriority() + TcpSession.this._sender_pri_inc);
        }

        @Override
        public void run() {
            SnmpPDU pdu = null;
            while (!TcpSession.this._close) {
                try {
                    pdu = (SnmpPDU)TcpSession.this._handoffQueue.take();
                    long queueTime = System.currentTimeMillis() - pdu.getTimeQueued();
                    if (queueTime > TcpSession.this._nMaxQueueTime) {
                        TcpSession.this._nMaxQueueTime = queueTime;
                    }
                    TcpSession.this.handleSend(pdu);
                }
                catch (InterruptedException ie) {
                    if (!TcpSession.this._close) continue;
                    break;
                }
                catch (Exception ex) {
                    if (TcpSession.this._close) break;
                    if (pdu == null) continue;
                    pdu.getLogger().log((Priority)Level.ERROR, (Object)"RequestQueue error", (Throwable)ex);
                }
            }
        }
    }
}

