/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui;

import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.UIManager;

public final class DialogSeparator
extends JComponent {
    static Font _Font;
    static Font _Font1;
    private static final Color COLOR;
    static final int MARGIN = 4;
    static final int LABEL_MARGIN = 10;
    String _label;
    boolean _useMargins = true;

    public DialogSeparator() {
    }

    public DialogSeparator(boolean useMargins) {
        this._useMargins = useMargins;
    }

    public DialogSeparator(String label) {
        this._label = label;
    }

    public void setLabel(String label) {
        this._label = label;
    }

    @Override
    public void paint(Graphics g) {
        int margin = 4;
        if (!this._useMargins) {
            margin = 0;
        }
        Dimension d = this.getPreferredSize();
        int y = d.height / 2;
        int x = d.width - margin * 2;
        g.setColor(Color.gray);
        g.drawLine(margin, y, x, y);
        g.setColor(Color.white);
        g.drawLine(margin, y + 1, x, y + 1);
        if (this._label == null) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(_Font);
        int w = fontMetrics.stringWidth(this._label);
        g.setColor(this.getBackground());
        g.fillRect(10, 0, w + margin, d.height);
        g.setColor(COLOR);
        g.setFont(_Font);
        g.drawString(this._label, 12, d.height - 2);
    }

    public void setWidth(int width) {
        this.setSize(this.getHeight(), this._label == null ? width + 8 : width + 10 + 4);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (this._label == null) {
            return new Dimension(this.getSize().width, 4);
        }
        return new Dimension(this.getSize().width, _Font.getSize() + 4);
    }

    public static Font getItalicBoldFont() {
        return _Font1;
    }

    static {
        COLOR = UIManager.getColor("Table.foreground");
        Font f = ChangedCellRenderer.getNormalFont();
        _Font1 = new Font(f.getName(), 3, f.getSize());
        _Font = new Font(f.getName(), 1, f.getSize());
    }
}

