/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui;

import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public class MenuButton
extends JButton
implements ActionListener {
    protected static final int MAX_ITEMS = 25;
    protected JMenu _menu;
    protected boolean _isSetText = true;

    public MenuButton(JMenu menu) {
        super(HeaderListener.getDownImage());
        this.setMargin(new Insets(4, 0, 4, 0));
        this.addActionListener(this);
        this._menu = menu;
    }

    public MenuButton(JMenu menu, String name) {
        super(name, HeaderListener.getDownImage());
        this.setHorizontalTextPosition(2);
        this.setMargin(new Insets(2, 12, 2, 12));
        this.addActionListener(this);
        this._menu = menu;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JMenuItem) {
            if (this.getParent() instanceof FieldPanel) {
                ((FieldPanel)this.getParent()).setText(this._isSetText ? ((JMenuItem)e.getSource()).getText() : "");
            }
        } else if (this._menu != null) {
            if (this._menu.getItemCount() > 0) {
                this._menu.getPopupMenu().show(this, 0, this.getHeight());
            } else {
                JOptionPane.showMessageDialog(this, "No match", "Warning", 2);
            }
        }
    }

    public JMenu buildMenu(Object[] items) {
        this._menu = new JMenu();
        if (items == null) {
            return null;
        }
        JMenu menu = this._menu;
        int i = 0;
        while (i < items.length) {
            int max = i + 25;
            while (i < items.length && i < max) {
                if (items[i].toString().startsWith("-")) {
                    menu.addSeparator();
                } else {
                    menu.add(this.buildMenuItem(items[i]));
                }
                ++i;
            }
            if (i >= items.length) continue;
            JMenu more = new JMenu("More");
            menu.add(more);
            menu = more;
        }
        return this._menu;
    }

    protected JMenuItem buildMenuItem(Object item) {
        JMenuItem mi = new JMenuItem(item.toString());
        mi.addActionListener(this);
        return mi;
    }

    public void setShowText(boolean isSetText) {
        this._isSetText = isSetText;
    }

    public JMenu getMenu() {
        return this._menu;
    }
}

