/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui.fcoe;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.mds.renderers.CheckBoxHeaderRenderer;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.ui.fcoe.FCoEConfigurationTableModel;
import com.cisco.dcbu.lib.ui.fcoe.VsanVlanCellEditor;
import com.cisco.dcbu.lib.ui.table.ChangedBooleanCellRenderer;
import com.cisco.dcbu.lib.ui.table.ChangedCellRenderer;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.fcoe.StatusMsg;
import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.View;

public class FCoEConfigurationTable
extends SnmpKTable {
    private static final long serialVersionUID = -1369051802064171004L;
    private FCoEConfigurationTableModel tableModel;
    private CheckBoxHeaderRenderer headerR;
    protected ChangedCellRenderer changedCellRenderer = new ChangedCellRenderer();
    protected StatusColumnRenderer statusCellRenderer = new StatusColumnRenderer();

    public FCoEConfigurationTable(KTableModel dataModel) {
        super(dataModel);
        this.tableModel = (FCoEConfigurationTableModel)dataModel;
        this.tableModel.addTableModelListener(this);
        CheckBoxRenderer booleanRenderer = new CheckBoxRenderer();
        this.setDefaultRenderer(Boolean.class, booleanRenderer);
        booleanRenderer.setHorizontalAlignment(0);
        this.tableModel.setEditable(this.tableModel.VFC_COLUMN, true);
        this.headerR = new CheckBoxHeaderRenderer(this);
        this.headerR.autoRenderBooleanColumns();
        this.setAutoResizeMode(3);
        this.getTableHeader().addMouseListener(new HeaderListener());
        this.setCellSelectionEnabled(true);
        TableColumn column = this.getColumnModel().getColumn(this.tableModel.VLAN_COLUMN);
        column.setCellRenderer(this.changedCellRenderer);
        column = this.getColumnModel().getColumn(this.tableModel.VFC_ID_COLUMN);
        column.setCellRenderer(this.changedCellRenderer);
        column = this.getColumnModel().getColumn(this.tableModel.STATUS_COLUMN);
        column.setCellRenderer(this.statusCellRenderer);
        VfcModeRenderer modeRenderer = new VfcModeRenderer(FCoEConfigurationTableModel.VFC_PORT_MODE_ENUMS);
        column = this.getColumnModel().getColumn(this.tableModel.VFC_PORT_MODE);
        column.setCellRenderer(modeRenderer);
        JComboBox<MibEnum> combo = new JComboBox<MibEnum>(new DefaultComboBoxModel<MibEnum>(FCoEConfigurationTableModel.VFC_PORT_MODE_ENUMS));
        combo.setEditable(false);
        this.getColumnModel().getColumn(this.tableModel.VFC_PORT_MODE).setCellEditor((SnmpKTable)this.new SnmpKTable.BoldEditor(combo));
        this.setEnumWidth(this.tableModel.VFC_PORT_MODE, FCoEConfigurationTableModel.VFC_PORT_MODE_ENUMS, this.getFontMetrics(ChangedCellRenderer.getChangeFont()));
        this.setColumnsWidth();
        this.setVlanColumnEditor();
        this.hideColumn(this.tableModel.VFC_ID_COLUMN);
    }

    public FCoEConfigurationTable(KTableModel dataModel, boolean veModeFCoE) {
        super(dataModel);
        this.tableModel = (FCoEConfigurationTableModel)dataModel;
    }

    private void setColumnsWidth() {
        TableColumn column = this.getColumnModel().getColumn(this.tableModel.VFC_COLUMN);
        column.setMaxWidth(75);
        column = this.getColumnModel().getColumn(this.tableModel.INTERFACE_COLUMN);
        column.setPreferredWidth(100);
        column.setMaxWidth(125);
        column = this.getColumnModel().getColumn(this.tableModel.VFC_ID_COLUMN);
        column.setMaxWidth(75);
        column = this.getColumnModel().getColumn(this.tableModel.VFC_PORT_MODE);
        column.setMaxWidth(100);
        column = this.getColumnModel().getColumn(this.tableModel.VLAN_COLUMN);
        column.setPreferredWidth(125);
        column.setMaxWidth(125);
    }

    public void setVlanColumnEditor() {
        TableColumn column = this.getColumnModel().getColumn(this.tableModel.VLAN_COLUMN);
        column.setCellEditor(this.getVlanCellEditor());
    }

    public void resetHeaderValues() {
        this.headerR.resetHeaderValues();
    }

    protected DefaultCellEditor getVlanCellEditor() {
        Object[] activeVlanVsans = this.tableModel.getActiveVlanVsans().getVlanVsanObjArray();
        VsanVlanCellEditor ed = new VsanVlanCellEditor(activeVlanVsans, this.tableModel.isVfcTrunkingSupported());
        return ed;
    }

    public void hideColumn(int modelIndex) {
        int viewColIndex = this.convertColumnIndexToView(modelIndex);
        TableColumn column = this.getColumnModel().getColumn(viewColIndex);
        column.setMinWidth(0);
        column.setMaxWidth(0);
    }

    public void showColumn(int modelIndex) {
        int viewColIndex = this.convertColumnIndexToView(modelIndex);
        TableColumn column = this.getColumnModel().getColumn(viewColIndex);
        column.setMaxWidth(275);
        column.setMinWidth(75);
        column.setResizable(true);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        Boolean obj;
        boolean colValue;
        Object value;
        column = this.convertColumnIndexToModel(column);
        if (!this.tableModel.getValueAt(row, this.tableModel.STATUS_COLUMN).equals("")) {
            return false;
        }
        return column == this.tableModel.VLAN_COLUMN || column == this.tableModel.VFC_ID_COLUMN || column == this.tableModel.VFC_PORT_MODE ? (value = this.tableModel.getValueAt(row, this.tableModel.VFC_COLUMN)) instanceof Boolean && (colValue = (obj = (Boolean)value).booleanValue()) : column == this.tableModel.VFC_COLUMN;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int row;
        Object value;
        if (this.tableModel != null && e != null && e.getColumn() == this.tableModel.VFC_COLUMN && (value = this.tableModel.getValueAt(row = e.getFirstRow(), e.getColumn())) instanceof Boolean) {
            Boolean obj = (Boolean)value;
            boolean colValue = obj;
            if (colValue) {
                if (this.tableModel.getSelectedVlanVsans() != null) {
                    this.tableModel.setValueAt(this.tableModel.getSelectedVlanVsans(), row, this.tableModel.VLAN_COLUMN);
                } else if (this.tableModel.isVfcTrunkingSupported()) {
                    this.tableModel.setValueAt(this.tableModel.getActiveVlanVsans(), row, this.tableModel.VLAN_COLUMN);
                } else {
                    this.tableModel.setValueAt(this.tableModel.getFirstActiveVlanVsan(), row, this.tableModel.VLAN_COLUMN);
                }
            } else {
                String statusValue = this.tableModel.getValueAt(row, this.tableModel.STATUS_COLUMN).toString();
                if (statusValue == null || statusValue.equals("")) {
                    this.tableModel.setValueAt("", row, this.tableModel.VLAN_COLUMN);
                    this.tableModel.setValueAt("", row, this.tableModel.VFC_ID_COLUMN);
                }
            }
        }
        super.tableChanged(e);
    }

    class VfcModeRenderer
    extends ChangedCellRenderer {
        private static final long serialVersionUID = 1L;
        MibEnum[] enums;

        public VfcModeRenderer(MibEnum[] enums) {
            this.enums = enums;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            for (MibEnum nextEnum : this.enums) {
                if (!value.equals(nextEnum.getValue())) continue;
                ((JLabel)comp).setText(nextEnum.getLabel());
                break;
            }
            return comp;
        }
    }

    class CheckBoxRenderer
    extends ChangedBooleanCellRenderer {
        private static final long serialVersionUID = 1L;

        CheckBoxRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (table.isCellEditable(row, column)) {
                comp.setEnabled(true);
            } else {
                comp.setEnabled(false);
            }
            return comp;
        }
    }

    class StatusColumnRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 4558242204414206333L;

        StatusColumnRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof StatusMsg && ((StatusMsg)value).getIcon() != null) {
                Icon icon = ((StatusMsg)value).getIcon();
                this.setIcon(icon);
                int iconWidth = icon.getIconWidth();
                int iconHeight = icon.getIconHeight();
                this.setToolTipText(value.toString());
                int rowHeight = table.getRowHeight(row);
                int gap = this.getIconTextGap();
                int columnMargin = table.getColumnModel().getColumnMargin();
                int columnWidth = table.getColumnModel().getColumn(column).getWidth() - (iconWidth + gap + columnMargin);
                View view = (View)this.getClientProperty("html");
                if (view != null) {
                    view.setSize(columnWidth, rowHeight);
                    int preferredHeight = (int)view.getPreferredSpan(1);
                    if (rowHeight != preferredHeight) {
                        table.setRowHeight(row, preferredHeight + 5);
                    }
                } else {
                    table.setRowHeight(row, iconHeight + 5);
                }
                super.setVerticalAlignment(1);
            } else {
                this.setIcon(null);
                this.setToolTipText(value.toString());
            }
            return comp;
        }
    }
}

