/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui.script;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.util.TFTP;

public class TFTPServer {
    public static int PORT = 69;
    private static TFTP tftp = null;
    private static boolean tftpServerStarted = false;

    public static synchronized TFTP start(String[] all, String userdir) throws Exception {
        block5: {
            try {
                String yes = "true";
                if (tftpServerStarted) break block5;
                tftp = TFTP.getInstance();
                if (tftp.canStartServer()) {
                    tftp.setMaxConns(5);
                    tftp.setRoot(userdir);
                    tftp.setMaxTimeouts(10);
                    if (all != null) {
                        for (int i = 0; i < all.length; ++i) {
                            tftp.addIpAccess(all[i].trim(), yes, yes, yes);
                        }
                    }
                    tftp.startServer(true);
                    DefaultLogger._DefLogger.info((Object)("TFTP Addr= " + tftp.getServerAddress()));
                    DefaultLogger._DefLogger.info((Object)("TFTP Port= " + tftp.getServerPort()));
                    DefaultLogger._DefLogger.info((Object)("TFTP Root= " + tftp.getRoot()));
                    PORT = tftp.getServerPort();
                    tftpServerStarted = true;
                    System.out.println("TFTP Started @ Root=(" + tftp.getRoot() + ") : " + tftpServerStarted);
                    break block5;
                }
                tftpServerStarted = false;
                throw new Exception("Cannot start TFTP Server.Please try again.");
            }
            catch (Exception ex) {
                tftpServerStarted = false;
                tftp = null;
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                throw new Exception(ex.getMessage());
            }
        }
        return tftp;
    }

    public static synchronized void addAccess(String hostName) {
        if (tftp != null) {
            tftp.addIpAccess(hostName, "true", "true", "true");
        }
    }

    public static synchronized void stop() {
        if (tftp != null) {
            tftp.stopServer();
            tftpServerStarted = false;
            tftp = null;
        }
    }
}

