/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.ui.table;

import com.cisco.dcbu.lib.ui.table.ColumnGroup;
import com.cisco.dcbu.lib.ui.table.GroupableTableHeader;
import com.cisco.dcbu.lib.util.Array;
import java.awt.Point;
import java.awt.Robot;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import sun.awt.SunToolkit;

public class KTableColumnModel
extends DefaultTableColumnModel {
    static Robot _robot = null;
    private GroupableTableHeader _gtHeader = null;
    int _y = 0;
    int _drag = 0;
    private boolean _movingColumnsAllowed = true;

    private int getIndex(TableColumn tc) {
        int i;
        for (i = 0; i < this.getColumnCount(); ++i) {
            TableColumn col = this.getColumn(i);
            if (tc != col) continue;
            return i;
        }
        return i;
    }

    private void flushEvents() {
        try {
            SunToolkit.flushPendingEvents();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void moveColumn(int columnIndex, int newIndex) {
        if (!this.isMovingColumnsAllowed()) {
            return;
        }
        if (columnIndex == newIndex || this._gtHeader == null) {
            super.moveColumn(columnIndex, newIndex);
            if (this._gtHeader != null) {
                this._gtHeader.repaint();
                this._gtHeader.getTable().repaint();
            }
            return;
        }
        if (this._drag == -999) {
            this._drag = 4;
            this._gtHeader.setDraggedDistance(4);
            this.flushEvents();
            return;
        }
        Point p = this._gtHeader.getLocationOnScreen();
        boolean flush = false;
        try {
            TableColumn tc = this.getColumn(newIndex);
            Array groups = this._gtHeader.getColumnGroups(tc);
            ColumnGroup cg = (ColumnGroup)groups.elementAt(0);
            tc = (TableColumn)cg.get(0);
            int index = this.getIndex(tc);
            if (index >= columnIndex && (index = this.getIndex(tc = (TableColumn)cg.get(cg.size() - 1))) >= this.getColumnCount()) {
                index = this.getColumnCount() - 1;
            }
            if (newIndex != index) {
                flush = true;
                newIndex = index;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        int w = 0;
        for (int i = 0; i < newIndex; ++i) {
            TableColumn col = this.getColumn(i);
            w += col.getWidth();
        }
        this._drag = -999;
        this._gtHeader.setDraggedDistance(4);
        super.moveColumn(columnIndex, newIndex);
        this._gtHeader.getTable().repaint();
        this._gtHeader.repaint();
        this._drag = -999;
        this._gtHeader.setDraggedDistance(4);
        try {
            if (_robot == null) {
                _robot = new Robot();
            }
            _robot.mouseMove((int)p.getX() + w + 7, this._y);
        }
        catch (Exception e) {
            // empty catch block
        }
        this._gtHeader.setDraggedDistance(4);
        if (flush) {
            this.flushEvents();
        }
        this._gtHeader.getTable().repaint();
    }

    public void setGroupableTableHeader(GroupableTableHeader gth) {
        this._gtHeader = gth;
        if (this._gtHeader == null) {
            return;
        }
        this._gtHeader.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Point p = new Point(e.getX(), e.getY());
                SwingUtilities.convertPointToScreen(p, KTableColumnModel.this._gtHeader);
                KTableColumnModel.this._y = (int)p.getY();
                int drag = KTableColumnModel.this._gtHeader.getDraggedDistance();
                if (KTableColumnModel.this._drag == 4 && drag == 4) {
                    KTableColumnModel.this._drag = -999;
                }
                if (KTableColumnModel.this._drag == -999 && drag == 4) {
                    KTableColumnModel.this._gtHeader.setDraggedDistance(4);
                } else {
                    KTableColumnModel.this._drag = drag;
                }
            }
        });
    }

    public void setMovingColumnsAllowed(boolean allow) {
        this._movingColumnsAllowed = allow;
    }

    public boolean isMovingColumnsAllowed() {
        return this._movingColumnsAllowed;
    }
}

