/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.util;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.LinkedList;
import java.util.List;

public class ByteBufferPool {
    private final List<ByteBuffer> _heapBuffers;
    private final List<ByteBuffer> _directBuffers;
    private final int _bufferCapacity;
    private final long _maxPoolCapacity;
    private final boolean _preferDirect;
    private final ByteOrder _byteOrder;
    private long _currentPoolCapacity;
    protected long _nAllocations;
    protected long _nAllocated;
    protected long _nTakes;
    protected long _nTakesReused;
    protected long _nTakenBytes;
    protected long _nReusedBytes;
    protected long _nReplacingPuts;

    public ByteBufferPool(long maxPoolCapacity, int bufferCapacity, boolean preferDirect, ByteOrder byteOrder) {
        if (bufferCapacity <= 0) {
            throw new IllegalArgumentException("bufferCapacity must be > 0");
        }
        if (maxPoolCapacity < 0L) {
            throw new IllegalArgumentException("maxPoolCapacity must be >= 0");
        }
        this._maxPoolCapacity = maxPoolCapacity;
        this._bufferCapacity = bufferCapacity;
        this._preferDirect = preferDirect;
        this._byteOrder = byteOrder == null ? ByteOrder.BIG_ENDIAN : byteOrder;
        this._heapBuffers = new LinkedList<ByteBuffer>();
        this._directBuffers = new LinkedList<ByteBuffer>();
        this.clear();
    }

    public int getBufferCapacity() {
        return this._bufferCapacity;
    }

    public ByteOrder getByteOrder() {
        return this._byteOrder;
    }

    public long getMaxPoolCapacity() {
        return this._maxPoolCapacity;
    }

    public boolean preferDirect() {
        return this._preferDirect;
    }

    public synchronized void put(ByteBuffer buffer) {
        if (buffer == null || buffer.capacity() < this._bufferCapacity) {
            return;
        }
        if (this._currentPoolCapacity + (long)buffer.capacity() > this._maxPoolCapacity) {
            List<ByteBuffer> dropBuffers;
            if (buffer.isDirect() != this._preferDirect) {
                return;
            }
            List<ByteBuffer> list = dropBuffers = buffer.isDirect() ? this._heapBuffers : this._directBuffers;
            if (dropBuffers.size() == 0) {
                return;
            }
            int cap = dropBuffers.get(dropBuffers.size() - 1).capacity();
            if (this._currentPoolCapacity - (long)cap + (long)buffer.capacity() > this._maxPoolCapacity) {
                return;
            }
            dropBuffers.remove(dropBuffers.size() - 1);
            this._currentPoolCapacity -= (long)cap;
            ++this._nReplacingPuts;
        }
        List<ByteBuffer> buffers = buffer.isDirect() ? this._directBuffers : this._heapBuffers;
        buffers.add(0, buffer);
        this._currentPoolCapacity += (long)buffer.capacity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteBuffer take() {
        ByteBuffer buffer = null;
        ByteBufferPool byteBufferPool = this;
        synchronized (byteBufferPool) {
            List<ByteBuffer> buffers;
            ++this._nTakes;
            List<ByteBuffer> list = buffers = this._preferDirect ? this._directBuffers : this._heapBuffers;
            if (buffers.size() > 0) {
                buffer = buffers.get(0);
            } else {
                List<ByteBuffer> list2 = buffers = this._preferDirect ? this._heapBuffers : this._directBuffers;
                if (buffers.size() > 0) {
                    buffer = buffers.get(0);
                }
            }
            if (buffer != null) {
                buffers.remove(0);
                this._currentPoolCapacity -= (long)buffer.capacity();
                this._nReusedBytes += (long)buffer.capacity();
                this._nTakenBytes += (long)buffer.capacity();
                ++this._nTakesReused;
            }
        }
        if (buffer == null) {
            boolean allocateDirect;
            ByteBufferPool byteBufferPool2 = this;
            synchronized (byteBufferPool2) {
                allocateDirect = this._preferDirect && this._nAllocated + (long)this._bufferCapacity > this._maxPoolCapacity ? false : this._preferDirect;
                this._nAllocated += (long)this._bufferCapacity;
                this._nTakenBytes += (long)this._bufferCapacity;
                ++this._nAllocations;
            }
            buffer = this.createBuffer(this._bufferCapacity, allocateDirect);
        }
        buffer.clear();
        if (buffer.order() != this._byteOrder) {
            buffer.order(this._byteOrder);
        }
        return buffer;
    }

    protected ByteBuffer createBuffer(int capacity, boolean direct) {
        if (direct) {
            try {
                return ByteBuffer.allocateDirect(capacity);
            }
            catch (OutOfMemoryError e) {
                System.err.println("OutOfMemoryError: No more direct buffers available; trying heap buffer instead");
            }
        }
        return ByteBuffer.allocate(capacity);
    }

    public synchronized void clear() {
        this._heapBuffers.clear();
        this._directBuffers.clear();
        this._currentPoolCapacity = 0L;
        this._nAllocations = 0L;
        this._nAllocated = 0L;
        this._nTakes = 0L;
        this._nTakesReused = 0L;
        this._nTakenBytes = 0L;
        this._nReusedBytes = 0L;
        this._nReplacingPuts = 0L;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ByteBufferPool:\n\tnAllocated = ").append(ByteBufferPool.mb(this._nAllocated)).append(" MB\n\tnAllocations = ").append(this._nAllocations).append("\n\tnTakes = ").append(this._nTakes).append("\n\tnTakesReused = ").append(this._nTakesReused).append("\n\tnReplacingPuts = ").append(this._nReplacingPuts).append("\n\tnTakenBytes = ").append(ByteBufferPool.mb(this._nTakenBytes)).append(" MB\n\tnReusedBytes = ").append(ByteBufferPool.mb(this._nReusedBytes)).append(" MB\n\tmaxPoolCapacity = ").append(ByteBufferPool.mb(this._maxPoolCapacity)).append(" MB\n\tcurrentPoolCapacity = ").append(ByteBufferPool.mb(this._currentPoolCapacity)).append(" MB\n\tefficiency = ").append(100.0f * (float)this._nReusedBytes / (float)this._nTakenBytes).append(" %");
        return sb.toString();
    }

    private static float mb(long bytes) {
        return (float)bytes / 1048576.0f;
    }
}

