/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.util;

import com.cisco.dcbu.lib.util.StreamRelay;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;

public final class DumbTerminal
implements Runnable {
    private Socket _socket;
    private DataInputStream _lin;
    private DataInputStream _rin;
    private DataOutputStream _lout;
    private DataOutputStream _rout;
    private Thread _t1;
    private Thread _t2;

    public DumbTerminal(String remoteHost, int remotePort) throws IOException {
        this._socket = new Socket(remoteHost, remotePort);
        this._lin = new DataInputStream(System.in);
        this._lout = new DataOutputStream(this._socket.getOutputStream());
        StreamRelay sr1 = new StreamRelay(this._lin, this._lout);
        this._t1 = new Thread((Runnable)sr1, "StreamRelay-out");
        this._rin = new DataInputStream(this._socket.getInputStream());
        this._rout = new DataOutputStream(System.out);
        StreamRelay sr2 = new StreamRelay(this._rin, this._rout);
        this._t2 = new Thread((Runnable)sr2, "StreamRelay-in");
        this._t1.start();
        this._t2.start();
    }

    @Override
    public void run() {
        while (this._socket.isConnected()) {
            try {
                this._t1.join();
                this._t2.join();
                break;
            }
            catch (InterruptedException ex) {
                System.err.println(ex);
            }
        }
        this.dispose();
    }

    public void dispose() {
        try {
            this._socket.close();
        }
        catch (IOException ex) {
            System.err.println(ex);
        }
        this._socket = null;
    }

    public static void main(String[] args) {
        String host = "localhost";
        int port = 9197;
        if (args.length > 0) {
            if (args[0].equals("?")) {
                System.out.println("[host] [port]");
            } else {
                host = args[0];
                if (args.length > 1) {
                    port = Integer.parseInt(args[1]);
                }
            }
        }
        try {
            DumbTerminal console = new DumbTerminal(host, port);
            console.run();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }
}

