/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;

public class NetUtil {
    public static final boolean _SupportIPv4;
    public static final boolean _SupportIPv6;
    public static final int _HttpConnectTimeout;
    public static final int _HttpReadTimeout;
    public static final String IP_JNLP_FILE = "cgi-bin/ip.jnlp";
    public static InetAddress _NatAddr;
    public static final Comparator _InetAddrComparator;

    public static InetAddress getLocalAddressByName(String name) throws IOException {
        NetworkInterface ni = null;
        InetAddress inetAddr = null;
        if (name == null) {
            return InetAddress.getLocalHost();
        }
        try {
            ni = NetworkInterface.getByName(name);
        }
        catch (SocketException se) {
            // empty catch block
        }
        if (ni != null) {
            InetAddress v4 = null;
            InetAddress v6 = null;
            Enumeration<InetAddress> en = ni.getInetAddresses();
            while (en.hasMoreElements()) {
                inetAddr = en.nextElement();
                if (inetAddr.isLoopbackAddress() || inetAddr.isMulticastAddress() || inetAddr.isLinkLocalAddress()) continue;
                if (inetAddr instanceof Inet4Address) {
                    v4 = inetAddr;
                    break;
                }
                v6 = inetAddr;
            }
            if (v4 == null && v6 == null) {
                throw new IOException("NIC " + ni.getDisplayName() + " is not connected");
            }
            inetAddr = v4 != null ? v4 : v6;
        } else {
            try {
                inetAddr = InetAddress.getByName(name);
            }
            catch (UnknownHostException uhEx) {
                throw new IOException(name + " is not a valid NIC or host address");
            }
        }
        return inetAddr;
    }

    public static String[] getLocalNICBindingAddresses() {
        Enumeration<NetworkInterface> en;
        try {
            en = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            return null;
        }
        if (en == null) {
            return null;
        }
        ArrayList<String> ifs = new ArrayList<String>();
        while (en.hasMoreElements()) {
            NetworkInterface ni = en.nextElement();
            Enumeration<InetAddress> addrs = ni.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress addr = addrs.nextElement();
                if (addr.isLoopbackAddress() || addr.isMulticastAddress() || addr.isLinkLocalAddress()) continue;
                if (ni.getDisplayName().length() > 30) {
                    ifs.add(ni.getName() + " (" + ni.getDisplayName().substring(0, 29) + "... " + NetUtil.getHostAddress(addr) + ")");
                    continue;
                }
                ifs.add(ni.getName() + " (" + ni.getDisplayName() + " " + NetUtil.getHostAddress(addr) + ")");
            }
        }
        if (ifs.size() == 0) {
            return null;
        }
        return ifs.toArray(new String[ifs.size()]);
    }

    public static String[] getLocalIpv4Addresses() {
        Enumeration<NetworkInterface> en;
        try {
            en = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            return null;
        }
        if (en == null) {
            return null;
        }
        ArrayList<String> ifs = new ArrayList<String>();
        while (en.hasMoreElements()) {
            NetworkInterface ni = en.nextElement();
            Enumeration<InetAddress> addrs = ni.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress addr = addrs.nextElement();
                if (addr.isLoopbackAddress() || addr.isMulticastAddress() || addr.isLinkLocalAddress() || addr instanceof Inet6Address) continue;
                if (ni.getDisplayName().length() > 30) {
                    ifs.add(ni.getName() + " (" + ni.getDisplayName().substring(0, 29) + "... " + NetUtil.getHostAddress(addr) + ")");
                    continue;
                }
                ifs.add(ni.getName() + " (" + ni.getDisplayName() + " " + NetUtil.getHostAddress(addr) + ")");
            }
        }
        if (ifs.size() == 0) {
            return null;
        }
        return ifs.toArray(new String[ifs.size()]);
    }

    public static String[] getLoopIpv4Addresses() {
        Enumeration<NetworkInterface> en;
        try {
            en = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            return null;
        }
        if (en == null) {
            return null;
        }
        ArrayList<String> ifs = new ArrayList<String>();
        while (en.hasMoreElements()) {
            NetworkInterface ni = en.nextElement();
            Enumeration<InetAddress> addrs = ni.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress addr = addrs.nextElement();
                if (!addr.isLoopbackAddress() || addr instanceof Inet6Address) continue;
                if (ni.getDisplayName().length() > 30) {
                    ifs.add(ni.getName() + " (" + ni.getDisplayName().substring(0, 29) + "... " + NetUtil.getHostAddress(addr) + ")");
                    continue;
                }
                ifs.add(ni.getName() + " (" + ni.getDisplayName() + " " + NetUtil.getHostAddress(addr) + ")");
            }
        }
        if (ifs.size() == 0) {
            return null;
        }
        return ifs.toArray(new String[ifs.size()]);
    }

    public static String[] getLocalIPAddresses() {
        Enumeration<NetworkInterface> en;
        try {
            en = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            return null;
        }
        if (en == null) {
            return null;
        }
        ArrayList<String> ifs = new ArrayList<String>();
        while (en.hasMoreElements()) {
            NetworkInterface ni = en.nextElement();
            Enumeration<InetAddress> addrs = ni.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress addr = addrs.nextElement();
                if (addr.isLoopbackAddress() || addr.isMulticastAddress() || addr.isLinkLocalAddress()) continue;
                ifs.add(NetUtil.getHostAddress(addr));
            }
        }
        if (ifs.size() == 0) {
            return null;
        }
        return ifs.toArray(new String[ifs.size()]);
    }

    public static InetAddress[] getLocalAddresses() {
        Enumeration<NetworkInterface> en;
        try {
            en = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException ex) {
            return null;
        }
        if (en == null) {
            return null;
        }
        ArrayList<InetAddress> ifs = new ArrayList<InetAddress>();
        while (en.hasMoreElements()) {
            NetworkInterface ni = en.nextElement();
            Enumeration<InetAddress> addrs = ni.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress addr = addrs.nextElement();
                if (addr.isLoopbackAddress() || addr.isMulticastAddress() || addr.isLinkLocalAddress()) continue;
                ifs.add(addr);
            }
        }
        if (ifs.size() == 0) {
            return null;
        }
        return ifs.toArray(new InetAddress[ifs.size()]);
    }

    public static InetAddress getLocalAddr(InetAddress exclusiveAddr) throws SocketException, UnknownHostException {
        String cmdArg;
        InetAddress addr = null;
        InetAddress firstAddr = null;
        if (!(exclusiveAddr != null && exclusiveAddr.hashCode() != 0 || (cmdArg = System.getProperty("mds.nmsAddress")) == null || exclusiveAddr != null && cmdArg.equals(exclusiveAddr.getHostAddress()))) {
            try {
                addr = NetUtil.getLocalAddressByName(cmdArg);
                return addr;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex1) {
            // empty catch block
        }
        if (!(addr == null || addr.isLinkLocalAddress() || addr.isLoopbackAddress() || exclusiveAddr != null && addr.equals(exclusiveAddr))) {
            return addr;
        }
        Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
        if (nis != null) {
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                Enumeration<InetAddress> addrs = ni.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    addr = addrs.nextElement();
                    if (!(addr.isLoopbackAddress() || exclusiveAddr != null && addr.equals(exclusiveAddr))) {
                        return addr;
                    }
                    if (addr.isLoopbackAddress()) continue;
                    firstAddr = addr;
                }
            }
        }
        if (firstAddr != null) {
            return firstAddr;
        }
        throw new UnknownHostException("no local host address detected");
    }

    public static InetAddress getLocalAddress() throws SocketException, UnknownHostException {
        InetAddress addr = null;
        InetAddress firstAddr = null;
        InetAddress firstV6Addr = null;
        try {
            addr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException ex1) {
            // empty catch block
        }
        if (!(addr == null || addr.isLinkLocalAddress() || addr.isLoopbackAddress() || addr.isMulticastAddress() || addr.isAnyLocalAddress())) {
            return addr;
        }
        Enumeration<NetworkInterface> nis = NetworkInterface.getNetworkInterfaces();
        if (nis != null) {
            while (nis.hasMoreElements()) {
                NetworkInterface ni = nis.nextElement();
                Enumeration<InetAddress> addrs = ni.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    addr = addrs.nextElement();
                    if (!(addr.isLoopbackAddress() || addr.isMulticastAddress() || addr.isLinkLocalAddress() || addr.isAnyLocalAddress() || !(addr instanceof Inet4Address))) {
                        return addr;
                    }
                    if (!(firstV6Addr != null || addr.isLoopbackAddress() || addr.isMulticastAddress() || addr.isLinkLocalAddress() || addr.isAnyLocalAddress())) {
                        firstV6Addr = addr;
                        continue;
                    }
                    if (firstAddr != null || addr.isLoopbackAddress()) continue;
                    firstAddr = addr;
                }
            }
        }
        if (firstV6Addr != null) {
            return firstV6Addr;
        }
        if (firstAddr != null) {
            return firstAddr;
        }
        throw new UnknownHostException("no local host address detected");
    }

    public static String getLocalIpConfig() {
        Enumeration<NetworkInterface> nis = null;
        try {
            nis = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException se) {
            return se.getMessage();
        }
        if (nis != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("TCP/IP support:");
            if (_SupportIPv4) {
                sb.append(" v4");
            }
            if (_SupportIPv6) {
                sb.append(" v6");
            }
            while (nis.hasMoreElements()) {
                NetworkInterface ni;
                if (sb.length() != 0) {
                    sb.append(System.getProperty("line.separator"));
                }
                sb.append((ni = nis.nextElement()).getName() == null ? "null" : ni.getName());
                if (ni.getDisplayName() != null) {
                    sb.append(" (").append(ni.getDisplayName()).append(") addresses: ");
                }
                Enumeration<InetAddress> e = ni.getInetAddresses();
                while (e.hasMoreElements()) {
                    InetAddress addr = e.nextElement();
                    sb.append(NetUtil.getHostAddress(addr)).append("\t");
                }
            }
            return sb.toString();
        }
        return "Cannot detect a network interface card";
    }

    public static String getLocalNIC(InetAddress localAddr) {
        try {
            Enumeration<NetworkInterface> en = NetworkInterface.getNetworkInterfaces();
            while (en != null && en.hasMoreElements()) {
                NetworkInterface ni = en.nextElement();
                Enumeration<InetAddress> addrs = ni.getInetAddresses();
                while (addrs.hasMoreElements()) {
                    if (!addrs.nextElement().equals(localAddr)) continue;
                    return ni.getName();
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }

    public static String getHostAddress(InetAddress v) {
        if (v instanceof Inet4Address) {
            return v.getHostAddress();
        }
        byte[] val = v.getAddress();
        StringBuffer a = new StringBuffer();
        int zc = 0;
        for (int i = 0; i < 16; ++i) {
            int n = (val[i] << 8 & 0xFF00) + (val[i + 1] & 0xFF);
            if (n == 0) {
                if (zc > 0) {
                    ++zc;
                    if (i >= 14) {
                        a.append(":0");
                    }
                } else {
                    if (i == 0) {
                        a.append(":");
                    }
                    ++zc;
                }
            } else {
                if (zc > 0) {
                    if (zc == 1) {
                        a.append("0:");
                    } else {
                        a.append(":");
                    }
                    zc = 0;
                }
                a.append(Integer.toHexString(n & 0xFFFF));
                if (i < 14) {
                    a.append(":");
                }
            }
            ++i;
        }
        return a.toString();
    }

    public static boolean isAnyLocalAddress(String address) {
        return "0.0.0.0".equals(address) || "::".equals(address) || "::0".equals(address);
    }

    public static boolean isLocalHost(InetAddress address) {
        try {
            Enumeration<NetworkInterface> nifs = NetworkInterface.getNetworkInterfaces();
            if (nifs != null) {
                while (nifs.hasMoreElements()) {
                    NetworkInterface nif = nifs.nextElement();
                    Enumeration<InetAddress> addrs = nif.getInetAddresses();
                    while (addrs.hasMoreElements()) {
                        if (!address.equals(addrs.nextElement())) continue;
                        return true;
                    }
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isLocalHost(String host) {
        try {
            return NetUtil.isLocalHost(InetAddress.getByName(host));
        }
        catch (UnknownHostException uhEx) {
            return false;
        }
    }

    public static boolean isAPIPAddress(String address) {
        return address.startsWith("169.254.");
    }

    public static boolean memberofSubnet(byte[] address, byte[] subnet, byte[] subnetMask) {
        int i;
        byte[] addressSubnet = new byte[4];
        for (i = 0; i < address.length; ++i) {
            addressSubnet[i] = (byte)(address[i] & subnetMask[i] & 0xFF);
        }
        for (i = 0; i < address.length; ++i) {
            if (addressSubnet[i] == subnet[i]) continue;
            return false;
        }
        return true;
    }

    public static InetAddress parseIpAddress(String ipAddress) {
        InetAddress inetAddress = null;
        try {
            int end;
            int start = ipAddress.indexOf("//");
            if (start == -1) {
                start = -2;
            }
            if ((inetAddress = (end = ipAddress.indexOf(47, start + 2)) != -1 ? InetAddress.getByName(ipAddress.substring(start + 2, end)) : InetAddress.getByName(ipAddress.substring(start + 2))) != null && inetAddress.hashCode() == 0) {
                inetAddress = null;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return inetAddress;
    }

    public static String getHtml(String host, String file) throws IOException {
        try {
            URL url = new URL("http://" + host + "/" + file);
            URLConnection con = url.openConnection();
            con.setConnectTimeout(_HttpConnectTimeout);
            con.setReadTimeout(_HttpReadTimeout);
            BufferedReader r = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer sb = new StringBuffer();
            String line = null;
            while ((line = r.readLine()) != null) {
                sb.append(line);
            }
            return sb.toString();
        }
        catch (IOException ex) {
            String svrIp = System.getProperty("server.translatedAddr");
            if (svrIp != null && (svrIp = svrIp.trim()).length() > 0) {
                return svrIp;
            }
            throw ex;
        }
    }

    public static void putHtml(String host, int port, String file, String message) throws IOException {
        URL url = new URL("http://" + host + ":" + port + "/" + file);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("PUT");
        con.setDoOutput(true);
        con.setUseCaches(false);
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(con.getOutputStream()));
        w.write(message);
        w.flush();
        w.close();
        con.disconnect();
    }

    public static String getLocalHostFromSwitch(InetAddress addr) {
        boolean isV6 = addr.getAddress().length == 16;
        String host = addr.getHostAddress();
        if (isV6) {
            host = "[" + host + "]";
        }
        try {
            return NetUtil.getHtml(host, IP_JNLP_FILE);
        }
        catch (IOException ex) {
            System.out.println("NetUtil.getLocalHostFromSwitch(" + host + ") error: " + ex);
            return null;
        }
    }

    public static String getLocalServerHostAddress() {
        String svrIp = System.getProperty("server.translatedAddr");
        if (svrIp != null && (svrIp = svrIp.trim()).length() > 0) {
            return svrIp;
        }
        svrIp = System.getProperty("server.bindaddrs");
        if (svrIp != null && (svrIp = svrIp.trim()).length() > 0) {
            return svrIp;
        }
        try {
            InetAddress svrAddr = NetUtil.getLocalAddress();
            return svrAddr.getHostAddress();
        }
        catch (Exception ex) {
            System.out.println("NetUtil.getLocalServerHostAddress() failed to get local server address:" + ex);
            return null;
        }
    }

    public static String detectVPN(InetAddress addr) {
        String localHost = NetUtil.getLocalHostFromSwitch(addr);
        if (localHost != null && NetUtil.isLocalHost(localHost)) {
            return localHost;
        }
        return "";
    }

    public static String detectVPN(String host) {
        String addr = null;
        try {
            addr = NetUtil.getHtml(host, IP_JNLP_FILE);
            if (!NetUtil.isLocalHost(addr)) {
                addr = "";
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return addr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String detectVisibleAddress(InetAddress host, InetAddress localhost) {
        if (host == null) {
            return null;
        }
        String contentType = "Content-Type";
        Socket socket = null;
        String ip = null;
        try {
            socket = localhost == null ? new Socket(host, 80) : new Socket(host, 80, localhost, 0);
            PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            out.println("GET /cgi-bin/ip.jnlp HTTP/1.1");
            out.println("Host: " + host.getHostAddress() + ":80");
            out.println("Connection: Close");
            out.println();
            boolean loop = true;
            boolean parseIp = false;
            int retries = 0;
            while (loop) {
                if (in.ready()) {
                    String str;
                    while ((str = in.readLine()) != null) {
                        if (parseIp && str.length() > 1) {
                            try {
                                InetAddress.getByName(str);
                                ip = str;
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                        if (!str.startsWith(contentType)) continue;
                        parseIp = true;
                    }
                    loop = false;
                }
                Thread.currentThread();
                Thread.sleep(50L);
                if (++retries != 50) continue;
                loop = false;
            }
        }
        catch (Exception ex) {
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception e) {}
            }
        }
        return ip;
    }

    public static boolean isThroughNAT(String host) {
        if (host == null) {
            return _NatAddr != null && !_NatAddr.isAnyLocalAddress();
        }
        try {
            InetAddress remAddr = InetAddress.getByName(host);
            if (remAddr instanceof Inet4Address) {
                return !NetUtil.isLocalHost(NetUtil.getHtml(remAddr.getHostAddress(), IP_JNLP_FILE));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static InetAddress detectSourceAddress(InetAddress remAddr) throws IOException {
        if (remAddr == null) {
            return _NatAddr != null && !_NatAddr.isAnyLocalAddress() ? _NatAddr : InetAddress.getLocalHost();
        }
        InetAddress srcAddr = null;
        if (_NatAddr == null && remAddr instanceof Inet4Address) {
            try {
                String addr = NetUtil.getHtml(remAddr.getHostAddress(), IP_JNLP_FILE);
                srcAddr = InetAddress.getByName(addr);
                _NatAddr = NetUtil.isLocalHost(addr) ? InetAddress.getByName("0.0.0.0") : srcAddr;
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        if (srcAddr == null) {
            int[] ports = new int[]{23, 22, 80};
            Socket s = null;
            for (int i = 0; i < ports.length; ++i) {
                try {
                    s = new Socket();
                    s.connect(new InetSocketAddress(remAddr, ports[i]), 500);
                    srcAddr = s.getLocalAddress();
                    break;
                }
                catch (NoRouteToHostException nrthex) {
                    throw new IOException(remAddr + " cannot be reached because of an intervening firewall, or if an intermediate router is down.");
                }
                catch (Exception ex) {
                    continue;
                }
                finally {
                    if (s != null && !s.isClosed()) {
                        try {
                            s.close();
                        }
                        catch (Exception ex) {}
                    }
                    s = null;
                }
            }
        }
        if (srcAddr == null) {
            if (_NatAddr != null) {
                return _NatAddr;
            }
            throw new IOException(remAddr + " is unknown or unreachable");
        }
        return srcAddr;
    }

    public static InetAddress detectSourceAddress(String host) throws IOException {
        return NetUtil.detectSourceAddress(host != null ? InetAddress.getByName(host) : (InetAddress)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReachable(InetAddress addr, int port, int timeout) {
        Socket s = null;
        try {
            if (addr == null) {
                addr = InetAddress.getLocalHost();
            }
            s = new Socket();
            s.connect(new InetSocketAddress(addr, port), timeout);
            boolean bl = true;
            return bl;
        }
        catch (Exception ex) {
        }
        finally {
            if (s != null && !s.isClosed()) {
                try {
                    s.close();
                }
                catch (Exception ex) {}
            }
            s = null;
        }
        return false;
    }

    public static boolean isReachable(String host, int port, int timeout) {
        try {
            InetAddress addr = host != null ? InetAddress.getByName(host) : InetAddress.getLocalHost();
            return NetUtil.isReachable(addr, port, timeout);
        }
        catch (UnknownHostException uhe) {
            return false;
        }
    }

    public static int compareInetAddress(InetAddress addr1, InetAddress addr2) {
        return _InetAddrComparator.compare(addr1, addr2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        _HttpConnectTimeout = Integer.getInteger("http.connectTimeout", 2000);
        _HttpReadTimeout = Integer.getInteger("http.readTimeout", 2000);
        _NatAddr = null;
        _InetAddrComparator = new Comparator(){

            public int compare(Object addr1, Object addr2) {
                int c = 0;
                if (addr1 != null && addr2 == null) {
                    c = -1;
                } else if (addr1 == null && addr2 != null) {
                    c = 1;
                } else if (addr1 != null && (c = (addr1 instanceof Inet4Address ? -1 : 1) - (addr2 instanceof Inet4Address ? -1 : 1)) == 0) {
                    byte[] ab = ((InetAddress)addr1).getAddress();
                    byte[] bb = ((InetAddress)addr2).getAddress();
                    int max = Math.min(ab.length, bb.length);
                    for (int i = 0; i < max && c == 0; ++i) {
                        c = (ab[i] & 0xFF) - (bb[i] & 0xFF);
                    }
                }
                return c;
            }
        };
        DatagramSocket s = null;
        try {
            s = new DatagramSocket(0, InetAddress.getByName("0.0.0.0"));
        }
        catch (Exception ex) {
        }
        finally {
            if (s != null && s.isBound()) {
                _SupportIPv4 = true;
                s.close();
            } else {
                _SupportIPv4 = false;
            }
            s = null;
        }
        try {
            s = new DatagramSocket(0, InetAddress.getByName("::"));
        }
        catch (Exception exception) {
        }
        finally {
            if (s != null && s.isBound()) {
                _SupportIPv6 = true;
                s.close();
            } else {
                _SupportIPv6 = false;
            }
            s = null;
        }
    }
}

