/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.lib.util;

import com.cisco.dcbu.lib.util.Schedule;
import com.cisco.dcbu.lib.util.ScheduledTask;
import com.cisco.dcbu.lib.util.TaskQueue;
import com.cisco.dcbu.lib.util.TimerThread;
import java.io.PrintStream;

public final class SchedulerSingleton {
    private static SchedulerSingleton _Instance = null;
    private static TaskQueue _taskQueue = null;
    private TimerThread _timerThread = null;
    private Object _threadReaper = new Object(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void finalize() throws Throwable {
            TaskQueue taskQueue = _taskQueue;
            synchronized (taskQueue) {
                ((SchedulerSingleton)SchedulerSingleton.this)._timerThread._newTasksMayBeScheduled = false;
                _taskQueue.notify();
            }
            _Instance = null;
        }
    };

    public void show(PrintStream ps) {
        ps.println("number of scheduled task:" + _taskQueue.getTasks().length);
        for (int i = 0; i < _taskQueue.getTasks().length; ++i) {
            ps.println(" " + i + " task: " + _taskQueue.getTasks()[i]);
        }
    }

    private SchedulerSingleton() {
        _taskQueue = new TaskQueue();
        this._timerThread = new TimerThread(_taskQueue);
        this._timerThread.start();
    }

    public static SchedulerSingleton getInstance() {
        if (_Instance == null) {
            _Instance = new SchedulerSingleton();
        }
        return _Instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTask(ScheduledTask task) {
        task.setState(1);
        TaskQueue taskQueue = _taskQueue;
        synchronized (taskQueue) {
            _taskQueue.add(task);
        }
    }

    public void addTask(ScheduledTask task, Schedule schedule) {
        task._schedule = schedule;
        this.addTask(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTask(ScheduledTask task) {
        task.setState(4);
        TaskQueue taskQueue = _taskQueue;
        synchronized (taskQueue) {
            _taskQueue.remove(task);
        }
    }

    public boolean isTaskScheduled(ScheduledTask task) {
        return _taskQueue.getTaskPosition(task) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskSchedule(ScheduledTask task, Schedule schedule) {
        if (task.getState() == 3) {
            throw new IllegalArgumentException("Task already executed.");
        }
        if (task.getState() == 4) {
            throw new IllegalArgumentException("Task already cancelled.");
        }
        Object object = task._lock;
        synchronized (object) {
            task._schedule = schedule;
        }
        _taskQueue.rescheduleTask(task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScheduledTask[] getTasks() {
        TaskQueue taskQueue = _taskQueue;
        synchronized (taskQueue) {
            return _taskQueue.getTasks();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        TaskQueue taskQueue = _taskQueue;
        synchronized (taskQueue) {
            this._timerThread._newTasksMayBeScheduled = false;
            _taskQueue.clear();
            _taskQueue.notify();
        }
    }
}

