/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.aaa;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.aaa.AAAManager;
import com.cisco.dcbu.sm.client.aaa.AAASearchMap;
import com.cisco.dcbu.sm.client.aaa.AAAServer;
import com.cisco.dcbu.sm.client.aaa.AAAServerGroup;
import com.cisco.dcbu.sm.client.aaa.AAAWizard;
import com.cisco.dcbu.sm.client.model.Switch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class AAAStatusPanel
extends WizardPanel {
    DefaultListModel _listModel = new DefaultListModel();
    ArrayList<SnmpPeer> _peers = new ArrayList();
    boolean _cancel = false;
    boolean _abort = false;
    boolean _complete = false;
    Map<SnmpPeer, SnmpException> serverErrors = new HashMap<SnmpPeer, SnmpException>();
    Map<SnmpPeer, SnmpException> groupErrors = new HashMap<SnmpPeer, SnmpException>();
    Map<SnmpPeer, SnmpException> mapErrors = new HashMap<SnmpPeer, SnmpException>();
    Map<SnmpPeer, SnmpException> appErrors = new HashMap<SnmpPeer, SnmpException>();
    private AAAManager aaaManager = null;

    public AAAStatusPanel() {
        super("3 of 3: Status", "Status of Configuration. Please wait until all configuration is complete. Closing the wizard prior to that may leave the switch in an unknown state.", AAAWizard.AAA_ICON);
        JScrollPane scrollPane = new JScrollPane(new JList(this._listModel));
        this.add(scrollPane);
        this.aaaManager = AAAManager.getInstance();
    }

    @Override
    public boolean refresh() {
        this.getWizard().setBusy(true);
        this._cancel = false;
        for (Switch s : this.aaaManager.getSwitches()) {
            this._peers.add(s.getSnmpPeer());
        }
        int totalCount = this._peers.size();
        this.postStatus("---------------Creating primary server---------------");
        this.checkProceed();
        try {
            AAAServer priServer = this.aaaManager.getPrimaryServer();
            this.serverErrors = this.aaaManager.createAAAserver(this._peers, priServer);
        }
        catch (SnmpException e) {
            this.postStatus("Could not create AAA primary server: " + e.getMessage());
        }
        for (SnmpPeer peer : this.serverErrors.keySet()) {
            this.postStatus("Could not create AAA primary server: " + this.serverErrors.get(peer).getMessage());
            this._peers.remove(peer);
        }
        this.postStatus("Created " + this.aaaManager.getProtocol().toString() + " primary server on " + this._peers.size() + " of " + totalCount + " switches");
        if (this.aaaManager.getSecondaryServer() != null) {
            this.postStatus("---------------Creating secondary server---------------");
            this.checkProceed();
            try {
                AAAServer secServer = this.aaaManager.getSecondaryServer();
                this.serverErrors = this.aaaManager.createAAAserver(this._peers, secServer);
            }
            catch (SnmpException e) {
                this.postStatus("Could not create secondary server: " + e.getMessage());
            }
            for (SnmpPeer peer : this.serverErrors.keySet()) {
                this.postStatus("Could not create secondary server: " + this.serverErrors.get(peer).getMessage());
            }
            this.postStatus("Created " + this.aaaManager.getProtocol().toString() + " secondary server on " + this._peers.size() + " of " + totalCount + " switches");
        }
        if (AAAManager.getInstance().isLDAP()) {
            this.postStatus("---------------Creating Search Map---------------");
            this.checkProceed();
            try {
                AAASearchMap searchMap = this.aaaManager.getSearchMap();
                this.mapErrors = this.aaaManager.createAAASearchMap(this._peers, searchMap);
            }
            catch (SnmpException e) {
                this.postStatus("Could not create search map: " + e.getMessage());
            }
            for (SnmpPeer peer : this.groupErrors.keySet()) {
                this.postStatus("Could not create search map: " + this.mapErrors.get(peer).getMessage());
                this._peers.remove(peer);
            }
            this.postStatus("Created " + this.aaaManager.getProtocol().toString() + " search map on " + this._peers.size() + " of " + totalCount + " switches");
        }
        this.postStatus("---------------Creating Server group---------------");
        this.checkProceed();
        try {
            AAAServerGroup serverGroup = this.aaaManager.createDefaultServerGroup();
            this.groupErrors = this.aaaManager.createAAAserverGroup(this._peers, serverGroup);
        }
        catch (SnmpException e) {
            this.postStatus("Could not create server group: " + e.getMessage());
        }
        for (SnmpPeer peer : this.groupErrors.keySet()) {
            this.postStatus("Could not create server group: " + this.groupErrors.get(peer).getMessage());
            this._peers.remove(peer);
        }
        this.postStatus("Created " + this.aaaManager.getProtocol().toString() + " server group on " + this._peers.size() + " of " + totalCount + " switches");
        this.postStatus("---------------Updating applications---------------");
        this.checkProceed();
        Map<Object, Object> appErrors = new HashMap();
        try {
            appErrors = this.aaaManager.modifyApplications(this._peers);
        }
        catch (SnmpException e) {
            this.postStatus("Could not update apps: " + e.getMessage());
        }
        for (SnmpException snmpException : appErrors.values()) {
            this.postStatus("Could not update apps: " + snmpException.getMessage());
        }
        this.postStatus("Updated applications on " + this._peers.size() + " of " + totalCount + " switches");
        if (appErrors.size() > 0 || this.groupErrors.size() > 0) {
            this.postStatus("---------------Rolling back incomplete operations---------------");
        }
        for (SnmpPeer snmpPeer : appErrors.keySet()) {
            this.postStatus("Deleting server group on: " + snmpPeer);
            String grpErr = this.aaaManager.deleteServerGroup(snmpPeer, this.aaaManager.getProtocol());
            if (grpErr.length() > 0) {
                this.postStatus("Failed to delete server group: " + grpErr);
            }
            this.postStatus("Deleting server on: " + snmpPeer);
            String serErr = this.aaaManager.deleteServer(snmpPeer, this.aaaManager.getProtocol(), true);
            if (serErr.length() <= 0) continue;
            this.postStatus("Failed to delete server: " + serErr);
        }
        for (SnmpPeer snmpPeer : this.groupErrors.keySet()) {
            this.postStatus("Deleting server on: " + snmpPeer);
            String serErr = this.aaaManager.deleteServer(snmpPeer, this.aaaManager.getProtocol(), true);
            if (serErr.length() <= 0) continue;
            this.postStatus("Failed to delete server: " + serErr);
        }
        this.postStatus("---------------AAA configuration complete---------------");
        this._complete = true;
        this.getWizard().setBusy(false);
        return this._complete;
    }

    public void setStatus(String status) {
        this.postStatus(status);
    }

    private void checkProceed() {
        if (this._peers.size() == 0) {
            this.postStatus("No switches to configure.");
            return;
        }
        if (this._cancel) {
            this.postStatus("Configuration Cancelled.");
            return;
        }
    }

    private void postStatus(String message) {
        this._listModel.addElement(message);
    }
}

