/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.aaa;

import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.aaa.AAAManager;
import com.cisco.dcbu.sm.client.aaa.AAAModel;
import com.cisco.dcbu.sm.client.model.Switch;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.ListSelectionModel;

public class AAATableModel
extends KTableModel {
    public final String[] ColumnNames = new String[]{"", "Switch", "CFS enabled protocols", "Configured protocols"};
    private Array<Object[]> allData = new Array();
    AAAManager.PROTOCOL protocol;

    public AAATableModel(AAAManager.PROTOCOL p) {
        this.protocol = p;
        this.initializeData();
        this.setData(this.allData);
        this.setHeaders(this.ColumnNames);
        this.setEditable(new boolean[]{false, false, false, false});
    }

    public void refresh() {
        this.allData = new Array();
        this.initializeData();
        this.setData(this.allData);
    }

    @Override
    public Class getColumnClass(int r, int c) {
        if (c == Column.SWITCH.ordinal()) {
            return Switch.class;
        }
        if (c == Column.CFS.ordinal()) {
            return AAAManager.CFSState.class;
        }
        if (c == Column.CONFIG.ordinal()) {
            return AAAManager.ConfigState.class;
        }
        return super.getColumnClass(r, c);
    }

    public Switch getSwitchAt(int row) {
        return (Switch)this.getValueAt(row, Column.SWITCH.ordinal());
    }

    public void initializeData() {
        AAAManager AAAMgr = AAAManager.getInstance();
        Collection<AAAModel> list = AAAMgr.getAAAModel();
        for (AAAModel aaa : list) {
            boolean selected;
            if (aaa == null || aaa.cfs == null) continue;
            Object[] row = new Object[5];
            boolean bl = selected = !aaa.config.ldap;
            if (this.protocol.equals((Object)AAAManager.PROTOCOL.TACACS)) {
                selected = aaa.cfs.tacacs != 2 && !aaa.config.tacacs;
            } else if (this.protocol.equals((Object)AAAManager.PROTOCOL.RADIUS)) {
                selected = aaa.cfs.radius != 2 && !aaa.config.radius;
            } else if (this.protocol.equals((Object)AAAManager.PROTOCOL.LDAP)) {
                selected = aaa.getSwitch().isVersionGreaterThanEqual("5.2(0)");
            }
            row[Column.SELECT.ordinal()] = selected;
            row[Column.SWITCH.ordinal()] = aaa.getSwitch();
            row[Column.CFS.ordinal()] = aaa.cfs;
            row[Column.CONFIG.ordinal()] = aaa.config;
            this.allData.addElement(row);
        }
        this.fireTableDataChanged();
    }

    @Override
    public void sort(int sortColumn, boolean ascending, ListSelectionModel selection) {
        if (sortColumn == Column.SELECT.ordinal()) {
            return;
        }
        super.sort(sortColumn, ascending, selection);
    }

    public List<Switch> getSelectedSwitches() {
        ArrayList<Switch> swList = new ArrayList<Switch>();
        Array tdata = this.getData();
        for (int i = 0; i < tdata.size(); ++i) {
            Object[] objs = (Object[])tdata.elementAt(i);
            if (!((Boolean)objs[Column.SELECT.ordinal()]).booleanValue()) continue;
            Switch sw = (Switch)objs[Column.SWITCH.ordinal()];
            swList.add(sw);
        }
        return swList;
    }

    public boolean isSelected(int row) throws Exception {
        if (row >= 0 && row < this.getData().size()) {
            Object[] objs = (Object[])this.getData().elementAt(row);
            return (Boolean)objs[Column.SELECT.ordinal()];
        }
        throw new Exception("Invalid row: " + row);
    }

    void setProtocol(AAAManager.PROTOCOL p) {
        this.protocol = p;
        this.refresh();
    }

    AAAManager.PROTOCOL getProtocol() {
        return this.protocol;
    }

    public static enum Column {
        SELECT,
        SWITCH,
        CFS,
        CONFIG;

    }
}

