/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.cat;

import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.cat.PingSweep;
import com.cisco.dcbu.sm.client.cat.Search;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.EnforcedZone;
import com.cisco.dcbu.sm.client.model.EnforcedZoneMember;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.Isl;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JDialog;

class RedundancySweep
extends PingSweep {
    HashMap _nbrMap;

    RedundancySweep(Fabric fabric, Vsan vsan, boolean verbose) {
        this._fabric = fabric;
        this._vsan = vsan;
        this._verbose = verbose;
        ArrayList<Isl> islsArr = this._vsan != null ? this._vsan.getIsls(null) : this._fabric.getIsls(null);
        Isl[] isls = new Isl[islsArr.size()];
        this._nbrMap = Search.buildNbrMap(islsArr.toArray(isls));
    }

    @Override
    void reset() {
        this._data.clear();
        this._numRequests = 0;
        this._numResults = 0;
        this._summary = "";
    }

    @Override
    void startPings() {
    }

    @Override
    boolean startSweep(JDialog dlg) throws Exception {
        return super.startSweep(dlg);
    }

    @Override
    void startSweep(EnforcedZone zone) {
        int i;
        Array zmems = zone.getMembers();
        int size = zmems.size();
        for (i = 0; i < size; ++i) {
            EnforcedZoneMember mem = (EnforcedZoneMember)zmems.elementAt(i);
            EndPort np = mem.getEndPort(this._fabric);
            if (np != null) continue;
            this.addError(zone, mem, mem.getInfo());
        }
        for (i = 0; i < size - 1; ++i) {
            EnforcedZoneMember src = (EnforcedZoneMember)zmems.elementAt(i);
            EndPort np1 = src.getEndPort(this._fabric);
            if (np1 == null) continue;
            for (int j = i + 1; j < size; ++j) {
                EnforcedZoneMember dest = (EnforcedZoneMember)zmems.elementAt(j);
                EndPort np2 = dest.getEndPort(this._fabric);
                if (np2 == null) continue;
                if (np1.getSwitch() == np2.getSwitch()) {
                    this.addError(zone, src, dest, "Both devices on the same switch.");
                    continue;
                }
                ArrayList uniqPaths = Search.searchUniquePaths(np1.getSwitch(), np2.getSwitch(), this._nbrMap);
                if (uniqPaths.size() == 0) {
                    this.addError(zone, src, dest, "No paths exist.");
                    continue;
                }
                if (uniqPaths.size() == 1) {
                    this.addError(zone, src, dest, "Only one unique path exists.");
                    continue;
                }
                ++this._numRequests;
            }
        }
    }
}

