/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.cfs.callhome;

import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpAggregrate;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.cfs.CfsMasterSwitchPanel;
import com.cisco.dcbu.sm.client.cfs.CfsSwitchPeer;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.Component;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import javax.swing.DefaultListModel;

public class CallHomeMasterSwitchPanel
extends CfsMasterSwitchPanel {
    private static final int[] CALLHOME_INDEX = new int[]{8, 99, 97, 108, 108, 104, 111, 109, 101};
    private static final int[] CALLHOME_CFS_INDEX = new int[]{8, 99, 97, 108, 108, 104, 111, 109, 101, 1};
    private static final String DEFAULT_DESC = "Please select a Master Switch.  All CallHome configurations will be applied to this switch and propagated to rest of the switches using CFS.  In addition, CallHome CFS will be enabled on all capable fabric switches.";
    private static final String MERGE_FAIL_DESC = "NOTE: Due to Merge Failure the Master Switch configuration will be propagated to all switches.";
    private ArrayList _featureList;

    public CallHomeMasterSwitchPanel(JWizard wizard) throws SnmpException {
        super(wizard, DEFAULT_DESC, 3);
    }

    @Override
    protected SnmpPeer[] build20SwitchList() {
        ArrayList<SnmpPeer> peersLst = new ArrayList<SnmpPeer>();
        Switch[] swLst = ClientController.getInstance().getFabric().getSwitches();
        if (swLst != null) {
            for (int i = 0; i < swLst.length; ++i) {
                if (swLst[i] == null || !swLst[i].isMDS() || swLst[i].isUCS() || !swLst[i].isManageable() || swLst[i].getPeer() == null || !swLst[i].isVersionGreaterThan("2.0(0)")) continue;
                peersLst.add(swLst[i].getPeer());
            }
        }
        return peersLst.toArray(new SnmpPeer[peersLst.size()]);
    }

    @Override
    protected Object getSelectedListObject() {
        return (CfsSwitchPeer)this._switchLst.getSelectedValue();
    }

    @Override
    public void doNext() {
        Object ob = this.getSelectedListObject();
        if (ob == null) {
            Util.errorMessage((Component)this.getWizard(), "Please select a Master Switch");
            return;
        }
        this.setModelValue("CFS_SWITCH_LIST", this._peers);
        try {
            Object obSw = this.getModelValue("CFS_MASTER_SWITCH");
            if (obSw != ob) {
                this.setModelValue("CFS_MASTER_SWITCH", ob);
                this.setDataValid(false);
            }
            if (this.userAction()) {
                super.doNext();
            }
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)this.getWizard(), ex.getMessage());
            return;
        }
    }

    @Override
    protected boolean userAction() throws SnmpException {
        boolean locked;
        StringBuffer globalCfsPr = new StringBuffer();
        DefaultListModel defModel = (DefaultListModel)this._switchLst.getModel();
        for (int i = 0; i < defModel.getSize(); ++i) {
            CfsSwitchPeer pr = (CfsSwitchPeer)defModel.getElementAt(i);
            if (pr._globalCfsState) continue;
            if (globalCfsPr.length() > 0) {
                globalCfsPr.append(", ");
            }
            globalCfsPr.append(pr._peer);
        }
        if (globalCfsPr.length() > 0) {
            throw new SnmpException("Please enable global CFS for following switches and then rerun the wizard\n" + globalCfsPr.toString());
        }
        CfsSwitchPeer pr = (CfsSwitchPeer)this._switchLst.getSelectedValue();
        boolean bl = locked = pr.isLocked() && pr.isLockedByMe();
        if (!locked) {
            Switch sww = null;
            CfsSwitchPeer prLoc = this.getLockedPeerInList();
            if (prLoc != null) {
                try {
                    ClientController.getInstance();
                    sww = ClientController.findFabricSwitchByIpAddress(InetAddress.getByAddress(prLoc._lockedOn));
                }
                catch (UnknownHostException exU) {
                    // empty catch block
                }
                throw new SnmpException("The Fabric is currently locked by user " + prLoc._lockedBy + " with pending changes" + (sww != null ? " at switch " + sww : "") + ".");
            }
        }
        this.getWizard().getNavigator().getNextBtn().setEnabled(true);
        return true;
    }

    private CfsSwitchPeer getLockedPeerInList() {
        DefaultListModel model = (DefaultListModel)this._switchLst.getModel();
        for (int i = 0; i < model.getSize(); ++i) {
            CfsSwitchPeer pr = (CfsSwitchPeer)model.get(i);
            if (!pr.isLocked()) continue;
            return pr;
        }
        return null;
    }

    @Override
    public void setVisible(boolean b) {
        if (b && this._switchLst.getModel() instanceof DefaultListModel) {
            DefaultListModel model = (DefaultListModel)this._switchLst.getModel();
            boolean mergeFailed = false;
            for (int i = 0; i < model.getSize(); ++i) {
                CfsSwitchPeer pr = (CfsSwitchPeer)model.get(i);
                if (!pr._isMergeFailed) continue;
                mergeFailed = true;
                break;
            }
            this.setDescription(DEFAULT_DESC + (mergeFailed ? "\nNOTE: Due to Merge Failure the Master Switch configuration will be propagated to all switches." : ""));
        }
        super.setVisible(b);
    }

    @Override
    protected void populateSwitchList() {
        try {
            this._featureList = this.buildFeatureList();
        }
        catch (SnmpException ex) {
            Util.errorMessage((Component)this.getWizard(), ex.getMessage());
            return;
        }
        DefaultListModel<CfsSwitchPeer> listMdl = new DefaultListModel<CfsSwitchPeer>();
        listMdl.clear();
        Switch principalVsan1 = ClientController.getInstance().getFabric().getVsans()[0].getPrincipalSwitch();
        SnmpPeer principalVsan1Peer = principalVsan1 != null && principalVsan1.getPeer() != null ? principalVsan1.getPeer() : null;
        int principalIndex = -1;
        for (int i = 0; i < this._peers.length; ++i) {
            CfsSwitchPeer swPr = new CfsSwitchPeer();
            swPr._peer = this._peers[i];
            if (swPr._peer == principalVsan1Peer) {
                principalIndex = i;
            }
            swPr._sw = ClientController.findFabricSwitchByIpAddress(this._peers[i].getAddress());
            swPr._featureName = "callhome";
            swPr._featureState = true;
            swPr._cfs = true;
            if (this._featureList != null && this._featureList.size() > 0) {
                for (int k = 0; k < this._featureList.size(); ++k) {
                    Object[] obb = (Object[])this._featureList.get(k);
                    if (obb[0] != this._peers[i]) continue;
                    if (obb[1] != null) {
                        int[] feature = (int[])obb[1];
                        swPr._featureState = feature[0] != 1;
                        swPr._cfs = false;
                    }
                    swPr._lockedBy = obb[2].toString();
                    swPr._lockedOn = (byte[])obb[4];
                    swPr._isMergeFailed = (Boolean)obb[5];
                    swPr._globalCfsState = (Boolean)obb[6];
                }
            }
            listMdl.addElement(swPr);
        }
        this._switchLst.setModel(listMdl);
        if (listMdl.getSize() > 0) {
            this._switchLst.setSelectedIndex(principalIndex != -1 ? principalIndex : 0);
        }
        this.setModelValue("SWITCH_LIST", this._switchLst);
        this.setModelValue("FEATURE_LIST", this._featureList);
    }

    private ArrayList buildFeatureList() throws SnmpException {
        ArrayList<Object[]> featureList = new ArrayList<Object[]>();
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get("cfsFeatureOpStatus").getOid(), CALLHOME_INDEX);
        vbl.add(MibNode.get("cfsPendingConfOwnerID").getOid(), CALLHOME_CFS_INDEX);
        vbl.add(MibNode.get("cfsPendingConfOwnerIDType").getOid(), CALLHOME_CFS_INDEX);
        vbl.add(MibNode.get("cfsPendingConfOwnerAddr").getOid(), CALLHOME_CFS_INDEX);
        vbl.add(MibNode.get("cfsMergeStatusValue").getOid(), CALLHOME_CFS_INDEX);
        vbl.add(MibNode.get("cfsDistCtrl").getOid(), 0);
        SnmpPDU[] pdus = new SnmpAggregrate().get(this._peers, vbl);
        for (int i = 0; i < pdus.length; ++i) {
            if (pdus[i].getError() != 0) {
                throw new SnmpException(pdus[i].getAddress().getHostName() + ": " + SnmpException.toError(pdus[i].getError()));
            }
            VarBindList response = pdus[i].getVariables();
            if (response == null) continue;
            Object[] obb = new Object[7];
            obb[0] = ClientController.findFabricSwitchByIpAddress(pdus[i].getAddress()).getPeer();
            if (response.intValue(0) != 2) {
                obb[1] = new int[]{3};
            }
            obb[2] = response.stringValue(1);
            obb[3] = new int[]{response.intValue(2)};
            obb[4] = response.byteValue(3);
            obb[5] = response.intValue(4) == 3;
            obb[6] = response.intValue(5) == 1;
            featureList.add(obb);
        }
        return featureList;
    }

    public SnmpPeer[] getPeers() {
        return this._peers;
    }
}

