/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.cfs.dpvm;

import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.ui.wizard.WizardPanel;
import com.cisco.dcbu.sm.client.cfs.CfsClientActionCommiter;
import com.cisco.dcbu.sm.client.cfs.CfsConfigWizard;
import com.cisco.dcbu.sm.client.cfs.dpvm.DPVMConfigWizard;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JCheckBox;

public class AutoLearnPanel
extends WizardPanel
implements ActionListener {
    private static final int ACTIVATE = 1;
    private static final int ACTIVATE_COMMIT = 2;
    private static final int AUTOLEARN_COMMIT = 4;
    private static final int AUTOLEARN_OFF_COMMIT = 6;
    private static final int COPY_ACTIVE_COMMIT = 8;
    private JCheckBox _autoLearn;
    private CfsClientActionCommiter _cfsCommitter;
    private SnmpPeer _masterPeer;
    private ArrayList _swList = new ArrayList();
    private static int _state;

    public AutoLearnPanel(JWizard wizard) {
        super("2 of 3: Autolearn Current End Devices", "Select the checkbox to configure attached End Devices login VSANs.\nNOTE: Selecting this option will overwrite any existing configuration!", wizard, CfsConfigWizard._Image);
        this._autoLearn = new JCheckBox("Create Configuration From Currently Logged In End Devices");
        this.add((Component)this._autoLearn, "Center");
    }

    @Override
    public boolean refresh() {
        this._autoLearn.setSelected(false);
        _state = 0;
        this._swList.clear();
        this._masterPeer = (SnmpPeer)this.getModelValue("CFS_MASTER_SWITCH");
        this._swList.add(this._masterPeer);
        this.getWizard().setStatus(" ");
        return super.refresh();
    }

    @Override
    public void doNext() {
        try {
            if (this._autoLearn.isSelected() && _state != 8) {
                this.getWizard().getNavigator().getNextBtn().setEnabled(false);
                this.getWizard().getNavigator().getBackBtn().setEnabled(false);
                this.setDataValid(false);
                this.activate();
            } else {
                super.doNext();
            }
        }
        catch (SnmpException ex) {
            ((DPVMConfigWizard)this.getWizard()).setCursor(false);
            this.getWizard().getNavigator().getNextBtn().setEnabled(true);
            this.getWizard().getNavigator().getBackBtn().setEnabled(true);
            Util.errorMessage((Component)this.getWizard(), ex);
        }
    }

    private void activate() throws SnmpException {
        boolean activateNeeded;
        VarBindList vbl = new VarBindList();
        DPVMConfigWizard.appendReadFromVbl(vbl, true);
        SnmpFetch.set(this._masterPeer, vbl);
        vbl.clear();
        vbl.add(MibNode.get("cdpvmActivationState").getOid(), 0);
        boolean bl = activateNeeded = SnmpFetch.get(this._masterPeer, vbl).getVariables().intValue(0) != 1;
        if (activateNeeded) {
            vbl.clear();
            vbl.add(MibNode.get("cdpvmActivate").getOid(), 0, (SnmpVar)new SnmpInt(1));
            this.getWizard().setStatus(this._masterPeer + ":Activate local database.");
            DPVMConfigWizard.appendReadFromVbl(vbl, false);
            _state = 1;
            SnmpFetch.set(this._masterPeer, new SnmpPDU(-93, vbl));
            vbl.clear();
            vbl.add(MibNode.get("cdpvmActivateResult").getOid(), 0);
            int resultVal = this._masterPeer.send(new SnmpPDU(-96, vbl)).getVariables().intValue(0);
            if (resultVal > 1) {
                throw new SnmpException("Activation failed on " + this._masterPeer + "\n" + MibEnum.getLabel(DPVMConfigWizard.DPVM_ACTIVATE_RESULT_ENUM, resultVal));
            }
            ((DPVMConfigWizard)this.getWizard()).setCursor(true);
            this.startCommit(2, "Activate database");
        } else {
            _state = 2;
            ((DPVMConfigWizard)this.getWizard()).setCursor(true);
            this.actionFinished(false);
        }
    }

    private void autoLearn(boolean enable) throws SnmpException {
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get("cdpvmAutoLearn").getOid(), 0, (SnmpVar)new SnmpInt(enable ? 1 : 2));
        if (!enable || this._masterPeer.send(new SnmpPDU(-96, vbl)).getVariables().intValue(0) == 2) {
            DPVMConfigWizard.appendReadFromVbl(vbl, false);
            ++_state;
            this.getWizard().setStatus(this._masterPeer + ":Autolearn already logged in devices.");
            SnmpFetch.set(this._masterPeer, new SnmpPDU(-93, vbl));
            this.startCommit(++_state, "Autolearn attached devices");
        } else {
            _state = 4;
            this.actionFinished(false);
        }
    }

    private void copyActiveToLocal() throws SnmpException {
        VarBindList vbl = new VarBindList();
        vbl.add(MibNode.get("cdpvmCopyEnfToConfig").getOid(), 0, (SnmpVar)new SnmpInt(1));
        DPVMConfigWizard.appendReadFromVbl(vbl, false);
        ++_state;
        this.getWizard().setStatus(this._masterPeer + ":Copy Active Database to Local.");
        SnmpFetch.set(this._masterPeer, new SnmpPDU(-93, vbl));
        this.startCommit(++_state, "Copy Active to Local Database");
    }

    private void startCommit(int state, String name) throws SnmpException {
        this._cfsCommitter = new CfsClientActionCommiter(this._swList, (DPVMConfigWizard)this.getWizard(), CfsClientActionCommiter.DPVM_INDEX, 4, name);
        _state = state;
        this._cfsCommitter.startAction();
    }

    @Override
    public void actionFinished(boolean success) {
        try {
            switch (_state) {
                case 2: {
                    this.setReadFrom(true);
                    this.autoLearn(true);
                    break;
                }
                case 4: {
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception exx) {
                        // empty catch block
                    }
                    this.setReadFrom(true);
                    this.autoLearn(false);
                    break;
                }
                case 6: {
                    this.setReadFrom(true);
                    this.copyActiveToLocal();
                    break;
                }
                case 8: {
                    this.setReadFrom(true);
                    this.getWizard().getNavigator().getNextBtn().setEnabled(true);
                    this.getWizard().getNavigator().getBackBtn().setEnabled(true);
                    this._autoLearn.setSelected(false);
                    ((DPVMConfigWizard)this.getWizard()).setCursor(false);
                    this.getWizard().setModelValue("AUTO_LEARNT", Boolean.TRUE);
                    super.doNext();
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (SnmpException ex) {
            ((DPVMConfigWizard)this.getWizard()).setCursor(false);
            this.getWizard().getNavigator().getNextBtn().setEnabled(true);
            this.getWizard().getNavigator().getBackBtn().setEnabled(true);
            Util.errorMessage((Component)this.getWizard(), ex);
        }
    }

    private void setReadFrom(boolean running) throws SnmpException {
        VarBindList vbl = new VarBindList();
        DPVMConfigWizard.appendReadFromVbl(vbl, running);
        SnmpFetch.set(this._masterPeer, vbl);
    }

    @Override
    public void dispose() {
        if (this._cfsCommitter != null) {
            this._cfsCommitter.stopPolling();
        }
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this._autoLearn.isSelected()) {
            _state = 0;
        }
    }
}

