/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.cfs.dpvm;

import com.cisco.dcbu.lib.jnm.IfIndexUtil;
import com.cisco.dcbu.lib.jnm.SnmpWWN;
import com.cisco.dcbu.lib.jnm.Wwn;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.FieldPanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.table.KTableModel;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.cfs.SearchTable;
import com.cisco.dcbu.sm.client.model.DeviceAlias;
import com.cisco.dcbu.sm.client.model.EndPort;
import com.cisco.dcbu.sm.client.model.Vsan;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SmInsertDpvm
extends JDialog
implements ListSelectionListener,
ActionListener {
    static final int VSAN_COL = 1;
    static final int SW_INTERFACE_COL = 2;
    static final int DEVICE_NAME = 3;
    static final int WWN_COL = 0;
    static final String[] HEADERS = new String[]{"WWN", "Login VSAN", "Switch Interface", "Name"};
    static final int DPVM_COLUMN_INDEX = HEADERS.length + 1;
    private SearchTable _portsTable;
    private KTableModel _portsTableModel;
    private FieldPanel _wwn;
    private FieldPanel _vsan;
    private Wwn _selectedWwn;
    private int _selectedVsan;

    public SmInsertDpvm(JDialog parent) {
        super(parent);
        this.setTitle(parent.getTitle() + " (Preconfigure Login VSAN)");
        this.buildDialog();
    }

    protected void buildDialog() {
        this._portsTableModel = new KTableModel();
        this._portsTableModel.setHeaders(HEADERS);
        this._portsTableModel.setData(this.updateData());
        this._portsTable = new SearchTable(this._portsTableModel, this);
        this._portsTable.setAutoResizeMode(0);
        this._portsTable.setSelectionMode(0);
        this._portsTable.getSelectionModel().addListSelectionListener(this);
        this._portsTable.getTableHeader().addMouseListener(new HeaderListener());
        this._portsTable.setSortable(true);
        JPanel mainPnl = new JPanel(new BorderLayout());
        mainPnl.add((Component)new JScrollPane(this._portsTable), "Center");
        this._wwn = new FieldPanel(25);
        this._vsan = new FieldPanel(10, 1, 1, 4093);
        mainPnl.add((Component)DialogUtil.buildPanel(DialogUtil.buildLabels(new String[]{"WWN:", "VSAN Id:"}), new JComponent[]{this._wwn, this._vsan}), "South");
        this._portsTable.calcPreferredSize();
        DialogUtil.buildDialog(this, Util.getFrameAncestor(this), mainPnl);
        this.setSize(this._portsTable.getPreferredSize().width + 30, this._portsTable.getRowHeight() * 22);
        this.setModal(true);
        this.setResizable(true);
    }

    private Array updateData() {
        Array<Object[]> data = new Array<Object[]>();
        EndPort[] ep = ClientController.getInstance().getFabric().getEndPorts();
        if (ep != null) {
            for (int i = 0; i < ep.length; ++i) {
                Vsan[] vsans;
                if (IfIndexUtil.getType(ep[i].getSwitchIntKey()._index) != 1 || ep[i].isLoop() || ep[i].isFiconCup() || ep[i].isFiconCU() || (vsans = ep[i].getVsans()) == null) continue;
                for (int v = 0; v < vsans.length; ++v) {
                    Object[] ob = new Object[HEADERS.length];
                    ob[1] = vsans[v];
                    ob[0] = ep[i].getPortWwn();
                    ob[2] = ep[i].getSwitch() + " " + ep[i].getIfIndexName();
                    DeviceAlias da = ClientController.getInstance().getFabric().findDeviceAliasByWwn(ep[i].getPortWwn());
                    ob[3] = da != null ? da.toString() : null;
                    data.addElement(ob);
                }
            }
        }
        return data;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        char ch = e.getActionCommand().charAt(0);
        if (ch != 'O') {
            this._selectedWwn = null;
            this._selectedVsan = -1;
        } else if (!this.validateData()) {
            return;
        }
        this.dispose();
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int row = this._portsTable.getSelectedRow();
        if (row != -1) {
            Vsan v = (Vsan)this._portsTable.getModel().getValueAt(row, 1);
            this._vsan.setText(v == null ? "0" : Integer.toString(v.getId()));
            Wwn wwn = (Wwn)this._portsTable.getModel().getValueAt(row, 0);
            this._wwn.setText(SnmpString.toHexString(wwn.getValue()));
        }
    }

    private boolean validateData() {
        String wwn = this._wwn.getText().trim();
        try {
            this._selectedWwn = new Wwn(SnmpWWN.parse(wwn, false));
        }
        catch (NumberFormatException ex) {
            Util.errorMessage((Component)this, "Invalid Port WWN.");
            return false;
        }
        try {
            this._selectedVsan = this._vsan.getInt();
        }
        catch (NumberFormatException ex) {
            Util.errorMessage((Component)this, "Invalid Vsan Id.");
            return false;
        }
        return true;
    }

    Wwn getWWN() {
        return this._selectedWwn;
    }

    int getVsan() {
        return this._selectedVsan;
    }
}

