/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.datamig;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.DialogUtil;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.datamig.DMMStatusJobLog;
import com.cisco.dcbu.sm.client.datamig.DMMStatusRescheduleJob;
import com.cisco.dcbu.sm.client.datamig.DMMStatusTableModel;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.DataViewModelIf;
import com.cisco.dcbu.sm.client.gui.UIControls;
import com.cisco.dcbu.sm.client.se.SEStatusTable;
import com.cisco.dcbu.sm.common.model.ddm.DDMJob;
import com.cisco.dcbu.sm.common.rif.DDMServerRif;
import com.jidesoft.grid.HierarchicalTable;
import com.jidesoft.grid.HierarchicalTableComponentFactory;
import com.jidesoft.grid.HierarchicalTableModel;
import com.jidesoft.grid.ListSelectionModelGroup;
import com.jidesoft.grid.SortableTable;
import com.jidesoft.grid.TreeLikeHierarchicalPanel;
import com.jidesoft.swing.JideSwingUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseWheelListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;

public class DMMStatusTable
extends HierarchicalTable
implements DataViewModelIf,
ActionListener,
ListSelectionListener {
    protected static final Color BG1 = new Color(232, 237, 230);
    protected static final Color BG2 = new Color(243, 234, 217);
    protected static final Color BG3 = new Color(214, 231, 247);
    private ListSelectionModelGroup _group = new ListSelectionModelGroup();
    private List<DDMJob> _jobList = new ArrayList<DDMJob>();
    JComponent _parent;
    private DMMStatusTableModel _jobTableModel;
    private JButton[] _operButtons;
    private static final String[][] OperButtons = new String[][]{{"Verify", "V"}, {"Delete", "l"}, {"Stop", "S"}, {"Start", "T"}, {"Modify...", "E"}, {"Finish", "O"}, {"Log...", "L"}};
    private static final String[][] _ButtonAttrStardard = new String[][]{{"icons/server_copy16.png", "Config Server Based Mode", "DMWizServer"}, {"icons/storage_copy16.png", "Config Storage Based Mode", "DMWizStorage"}, {"icons/Refresh16.gif", "Refresh Values", "R"}};
    static final String[] _Intervals = new String[]{"None", "30s", "1m", "5m"};
    static final int[] _MSecsIntervals = new int[]{0, 30000, 60000, 300000};
    JComboBox _pollInterval;
    Timer _statusTimer;

    public DMMStatusTable() {
        this.createTable();
        DataView dataView = BrowserFrame.getDataView();
        JPanel actButtonStardardPanel = new JPanel(new FlowLayout(2, 2, 2));
        JButton[] actButtonStandard = new JButton[_ButtonAttrStardard.length];
        for (int i = 0; i < _ButtonAttrStardard.length; ++i) {
            actButtonStandard[i] = Util.createButton(_ButtonAttrStardard[i][0], _ButtonAttrStardard[i][1], _ButtonAttrStardard[i][2], this);
            actButtonStardardPanel.add(actButtonStandard[i]);
        }
        JPanel seBtnPanel = new JPanel(new FlowLayout(0, 2, 2));
        this._operButtons = DialogUtil.buildButtons(OperButtons, (ActionListener)this);
        for (int i = 0; i < this._operButtons.length; ++i) {
            this._operButtons[i].setEnabled(false);
            seBtnPanel.add(this._operButtons[i]);
        }
        JPanel statsPanel = new JPanel(new FlowLayout(0, 2, 2));
        statsPanel.add(new JLabel("Poll Interval:"));
        this._pollInterval = new JComboBox<String>(_Intervals);
        this._pollInterval.setSelectedIndex(0);
        this._pollInterval.addActionListener(this);
        this._pollInterval.setActionCommand("PI");
        this._pollInterval.setToolTipText("Status Update Frequency");
        statsPanel.add(this._pollInterval);
        this._statusTimer = new Timer(10000, this);
        JPanel newToolbar = new JPanel(new FlowLayout(2, 2, 5));
        newToolbar.add(actButtonStardardPanel);
        newToolbar.add(statsPanel);
        newToolbar.add(seBtnPanel);
        dataView.replaceButtonPanel(newToolbar);
    }

    public void setParent(JComponent parent) {
        this._parent = parent;
    }

    private void createTable() {
        block3: {
            try {
                DDMServerRif ddmServerRif = ClientController.getInstance().getDDMServerRif();
                DDMJob[] jobs = ddmServerRif.findAllJobs();
                this._jobList = Arrays.asList(jobs);
            }
            catch (RemoteException ex) {
                Util.errorMessage((Component)BrowserFrame.getDataView(), ex);
                if (SnmpSession.isTrace()) {
                    DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
                if (this._statusTimer == null || !this._statusTimer.isRunning()) break block3;
                this._statusTimer.stop();
                this._pollInterval.setSelectedIndex(0);
            }
        }
        this._jobTableModel = new DMMStatusTableModel(this._jobList);
        this.setAutoRefreshOnRowUpdate(false);
        this.setModel(this._jobTableModel);
        this.setBackground(BG1);
        this.setForeground(Color.black);
        this.setName("Jobs");
        this.getColumnModel().getColumn(0).setPreferredWidth(100);
        this.setSelectionMode(0);
        this.getSelectionModel().addListSelectionListener(this);
        this.setComponentFactory(new HierarchicalTableComponentFactory(){

            public Component createChildComponent(HierarchicalTable table, Object value, int row) {
                if (value == null) {
                    return new JPanel();
                }
                TableModel model = (TableModel)value;
                if (model instanceof HierarchicalTableModel) {
                    HierarchicalTable childTable = new HierarchicalTable(model){

                        public void scrollRectToVisible(Rectangle aRect) {
                            DMMStatusTable.scrollRectToVisible((Component)((Object)this), aRect);
                        }
                    };
                    childTable.setBackground(BG2);
                    childTable.setForeground(Color.black);
                    childTable.setOpaque(true);
                    childTable.setName("Sessions");
                    childTable.setComponentFactory(new HierarchicalTableComponentFactory(){

                        public Component createChildComponent(HierarchicalTable table, Object value, int row) {
                            TableModel model;
                            if (value instanceof TableModel && (model = (TableModel)value) != null) {
                                SortableTable sortableTable = new SortableTable(model){

                                    public void scrollRectToVisible(Rectangle aRect) {
                                        SEStatusTable.scrollRectToVisible((Component)((Object)this), aRect);
                                    }
                                };
                                FitScrollPane pane = new FitScrollPane((Component)sortableTable);
                                sortableTable.setBackground(BG3);
                                sortableTable.setForeground(Color.black);
                                DMMStatusTable.this._group.add((Object)sortableTable.getSelectionModel());
                                TreeLikeHierarchicalPanel treeLikeHierarchicalPanel = new TreeLikeHierarchicalPanel((Component)pane);
                                treeLikeHierarchicalPanel.setBackground(sortableTable.getMarginBackground());
                                return treeLikeHierarchicalPanel;
                            }
                            return null;
                        }

                        public void destroyChildComponent(HierarchicalTable table, Component component, int row) {
                            Component t = JideSwingUtilities.getFirstChildOf(JTable.class, (Component)component);
                            if (t instanceof JTable) {
                                DMMStatusTable.this._group.remove((Object)((JTable)t).getSelectionModel());
                            }
                        }
                    });
                    TreeLikeHierarchicalPanel treeLikeHierarchicalPanel = new TreeLikeHierarchicalPanel((Component)new FitScrollPane((Component)childTable));
                    treeLikeHierarchicalPanel.setBackground(childTable.getMarginBackground());
                    return treeLikeHierarchicalPanel;
                }
                SortableTable sortableTable = new SortableTable(model){

                    public void scrollRectToVisible(Rectangle aRect) {
                        DMMStatusTable.scrollRectToVisible((Component)((Object)this), aRect);
                    }
                };
                sortableTable.setBackground(BG2);
                sortableTable.setForeground(Color.black);
                sortableTable.setCellSelectionEnabled(false);
                DMMStatusTable.this._group.add((Object)sortableTable.getSelectionModel());
                TreeLikeHierarchicalPanel treeLikeHierarchicalPanel = new TreeLikeHierarchicalPanel((Component)new FitScrollPane((Component)sortableTable));
                treeLikeHierarchicalPanel.setBackground(sortableTable.getMarginBackground());
                return treeLikeHierarchicalPanel;
            }

            public void destroyChildComponent(HierarchicalTable table, Component component, int row) {
                Component t = JideSwingUtilities.getFirstChildOf(JTable.class, (Component)component);
                if (t instanceof JTable) {
                    DMMStatusTable.this._group.remove((Object)((JTable)t).getSelectionModel());
                }
            }
        });
        this._group.add((Object)this.getSelectionModel());
    }

    public static void scrollRectToVisible(Component component, Rectangle aRect) {
        Container parent;
        int dx = component.getX();
        int dy = component.getY();
        for (parent = component.getParent(); !(parent == null || parent instanceof JViewport && ((JViewport)parent).getClientProperty("HierarchicalTable.mainViewport") != null); parent = parent.getParent()) {
            Rectangle bounds = parent.getBounds();
            dx += bounds.x;
            dy += bounds.y;
        }
        if (parent != null) {
            aRect.x += dx;
            aRect.y += dy;
            ((JComponent)parent).scrollRectToVisible(aRect);
            aRect.x -= dx;
            aRect.y -= dy;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._statusTimer) {
            this.refresh();
            int mSecs = _MSecsIntervals[this._pollInterval.getSelectedIndex()];
            if (mSecs <= 0) {
                this._statusTimer.stop();
            }
        } else if (e.getSource() instanceof JComboBox) {
            int mSecs = _MSecsIntervals[this._pollInterval.getSelectedIndex()];
            if (mSecs > 0) {
                this._statusTimer.setDelay(mSecs);
                if (this._statusTimer.isRunning()) {
                    this._statusTimer.restart();
                } else {
                    this._statusTimer.start();
                }
            } else {
                this._statusTimer.stop();
            }
        } else {
            int[] selectedRows = this.getSelectedRows();
            ArrayList<DDMJob> jobs = new ArrayList<DDMJob>();
            for (int i = 0; i < selectedRows.length; ++i) {
                jobs.add((DDMJob)this._jobTableModel.getValueAt(selectedRows[i], 0));
            }
            char ch = ((AbstractButton)e.getSource()).getActionCommand().charAt(0);
            switch (ch) {
                case 'R': {
                    this.refresh();
                    break;
                }
                case 'V': {
                    new ActionThread(jobs, OPERATION.VERIFY).start();
                    break;
                }
                case 'l': {
                    new ActionThread(jobs, OPERATION.DELETE).start();
                    break;
                }
                case 'S': {
                    new ActionThread(jobs, OPERATION.STOP).start();
                    break;
                }
                case 'T': {
                    new ActionThread(jobs, OPERATION.RESTART).start();
                    break;
                }
                case 'E': {
                    this.reschedule((DDMJob)jobs.get(0));
                    break;
                }
                case 'O': {
                    new ActionThread(jobs, OPERATION.CUTOVER).start();
                    break;
                }
                case 'L': {
                    this.log((DDMJob)jobs.get(0));
                    break;
                }
                default: {
                    UIControls.getInstance().actionPerformed(e);
                }
            }
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        block10: {
            int[] selectedRows = this.getSelectedRows();
            if (selectedRows.length == 0) {
                return;
            }
            ArrayList selectedJobs = new ArrayList();
            boolean isMultiJobNodes = selectedRows.length > 1;
            try {
                DDMServerRif ddmServerRif = ClientController.getInstance().getDDMServerRif();
                DDMJob job = (DDMJob)this._jobTableModel.getValueAt(selectedRows[0], 0);
                int jobStatus = job.getStatus();
                for (int i = 0; i < this._operButtons.length; ++i) {
                    if (i == OPERATION.VERIFY.ordinal()) {
                        this._operButtons[i].setEnabled(!isMultiJobNodes && (jobStatus == 3 || jobStatus == 10 || jobStatus == 12));
                        continue;
                    }
                    if (i == OPERATION.DELETE.ordinal()) {
                        this._operButtons[i].setEnabled(jobStatus != 4 && jobStatus != 7 && jobStatus != 9);
                        continue;
                    }
                    if (i == OPERATION.STOP.ordinal()) {
                        this._operButtons[i].setEnabled(!isMultiJobNodes && (jobStatus == 4 || jobStatus == 7 || jobStatus == 9));
                        continue;
                    }
                    if (i == OPERATION.RESTART.ordinal()) {
                        this._operButtons[i].setEnabled(!isMultiJobNodes && (jobStatus == 1 || jobStatus == 5 || jobStatus == 6 || jobStatus == 8));
                        continue;
                    }
                    if (i == OPERATION.MODIFY.ordinal()) {
                        this._operButtons[i].setEnabled(!isMultiJobNodes && jobStatus != 11 && jobStatus != 3 && jobStatus != 11 && jobStatus != 12);
                        continue;
                    }
                    if (i == OPERATION.LOG.ordinal()) {
                        this._operButtons[i].setEnabled(!isMultiJobNodes);
                        continue;
                    }
                    if (i != OPERATION.CUTOVER.ordinal()) continue;
                    boolean enable = job.getMethod() == -18 ? false : job.getJobMode() != -35 && jobStatus == 7;
                    this._operButtons[i].setEnabled(!isMultiJobNodes && enable);
                }
            }
            catch (Exception ex) {
                Util.errorMessage((Component)((Object)this), ex.getMessage());
                if (!SnmpSession.isTrace()) break block10;
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public void reschedule(DDMJob job) {
        try {
            DMMStatusRescheduleJob reschDlg = new DMMStatusRescheduleJob(job, this);
            reschDlg.setVisible(true);
        }
        catch (Exception ex) {
            Util.errorMessage((Component)((Object)this), ex.getMessage());
        }
    }

    private void log(DDMJob job) {
        try {
            DMMStatusJobLog logDlg = new DMMStatusJobLog(job);
            logDlg.setVisible(true);
        }
        catch (Exception ex) {
            if (SnmpSession.isTrace()) {
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
            Util.errorMessage((Component)((Object)this), ex.getMessage());
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public void cleanup() {
        if (this._statusTimer != null) {
            this._statusTimer.stop();
        }
    }

    public void refresh() {
        new RefreshThread().start();
    }

    class ActionThread
    extends Thread {
        OPERATION _code;
        List<DDMJob> _jobs;

        public ActionThread(List<DDMJob> jobs, OPERATION code) {
            this._code = code;
            this._jobs = jobs;
        }

        void checkDualFabJob(DDMJob job) throws Exception {
            if (job.getPeerIps() != null && job.getPeerIps().length != 0 && job.getSsm2() == null && job.getMethod() != -35) {
                throw new Exception("Cannot perform the operation, this dual fabric job is missing SSM2 information!");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                DDMServerRif ddmServerRif = ClientController.getInstance().getDDMServerRif();
                boolean needRefresh = true;
                switch (this._code) {
                    case VERIFY: {
                        if (JOptionPane.showConfirmDialog(BrowserFrame.getInstance(), "VERIFY is an offline operation. Once started all I/O from the Host to the storage will be rejected. Do you want to continue?", "DCNM-SAN", 1, 2) == 0) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    BrowserFrame.getInstance().setStatus("DMM: Verifying Job...");
                                }
                            });
                            Util.setBusy(true, BrowserFrame.getDataView().getRootPane());
                            ddmServerRif.verifyJob(this._jobs.get(0));
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    BrowserFrame.getInstance().setStatus("DMM: Verifying Job Done.");
                                }
                            });
                            break;
                        }
                        needRefresh = false;
                        break;
                    }
                    case DELETE: {
                        if (JOptionPane.showConfirmDialog(BrowserFrame.getInstance(), "Caution:  Prior to proceeding with this operation,\nall I/O and data access to the existing storage luns should be halted.\nFailure to do so may result in the new storage being out of sync with the existing storage,\nany I/O to the existing storage LUNs will NOT be synchronized with the new storage LUNs. \nPlease consult the cutover section of the DMM documentation for details.\n\nDo you want to continue?", "DCNM-SAN", 1, 2) == 0) {
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    BrowserFrame.getInstance().setStatus("DMM: Deleting Job(s)...");
                                }
                            });
                            Util.setBusy(true, BrowserFrame.getDataView().getRootPane());
                            for (DDMJob job : this._jobs) {
                                ddmServerRif.cutOffJob(job);
                            }
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    BrowserFrame.getInstance().setStatus("DMM: Deleting Job(s) Done.");
                                }
                            });
                            break;
                        }
                        needRefresh = false;
                        break;
                    }
                    case RESTART: {
                        this.checkDualFabJob(this._jobs.get(0));
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                BrowserFrame.getInstance().setStatus("DMM: Starting Job...");
                            }
                        });
                        Util.setBusy(true, BrowserFrame.getDataView().getRootPane());
                        ddmServerRif.restartJob(this._jobs.get(0));
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                BrowserFrame.getInstance().setStatus("DMM: Starting Job Done.");
                            }
                        });
                        break;
                    }
                    case STOP: {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                BrowserFrame.getInstance().setStatus("DMM: Stopping Job...");
                            }
                        });
                        Util.setBusy(true, BrowserFrame.getDataView().getRootPane());
                        ddmServerRif.stopJob(this._jobs.get(0));
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                BrowserFrame.getInstance().setStatus("DMM: Stopping Job Done.");
                            }
                        });
                        break;
                    }
                    case CUTOVER: {
                        this.checkDualFabJob(this._jobs.get(0));
                        if (JOptionPane.showConfirmDialog(BrowserFrame.getInstance(), "Caution:  Prior to proceeding with this operation,\nall I/O and data access to the existing storage luns should be halted.\nFailure to do so may result in I/Os errors from the existing storage luns.\nThe existing storage luns will be put in offline mode.\n\nDo you want to continue?", "DCNM-SAN", 1, 2) != 0) break;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                BrowserFrame.getInstance().setStatus("DMM: Finishing Job...");
                            }
                        });
                        Util.setBusy(true, BrowserFrame.getDataView().getRootPane());
                        ddmServerRif.cutOverJob(this._jobs.get(0));
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                BrowserFrame.getInstance().setStatus("DMM: Finishing Job Done.");
                            }
                        });
                    }
                }
                if (needRefresh) {
                    DMMStatusTable.this.refresh();
                }
            }
            catch (Exception ex) {
                Util.errorMessage((Component)((Object)DMMStatusTable.this), ex.getMessage());
            }
            finally {
                Util.setBusy(false, BrowserFrame.getDataView().getRootPane());
            }
        }
    }

    class RefreshThread
    extends Thread {
        RefreshThread() {
        }

        @Override
        public void run() {
            DMMStatusTable.this.removeAll();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BrowserFrame.getInstance().setStatus("SE: Quering Jobs...");
                    Util.setBusy(true, BrowserFrame.getDataView().getRootPane());
                    DMMStatusTable.this.createTable();
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    int nJobs = DMMStatusTable.this._jobList.size();
                    BrowserFrame.getInstance().setStatus(nJobs + " row" + (nJobs == 0 || nJobs == 1 ? "" : "s"));
                    for (int i = 0; i < DMMStatusTable.this._operButtons.length; ++i) {
                        DMMStatusTable.this._operButtons[i].setEnabled(false);
                    }
                    Util.setBusy(false, BrowserFrame.getDataView().getRootPane());
                }
            });
        }
    }

    static class FitScrollPane
    extends JScrollPane
    implements ComponentListener {
        public FitScrollPane() {
            this.initScrollPane();
        }

        public FitScrollPane(Component view) {
            super(view);
            this.initScrollPane();
        }

        public FitScrollPane(Component view, int vsbPolicy, int hsbPolicy) {
            super(view, vsbPolicy, hsbPolicy);
            this.initScrollPane();
        }

        public FitScrollPane(int vsbPolicy, int hsbPolicy) {
            super(vsbPolicy, hsbPolicy);
            this.initScrollPane();
        }

        private void initScrollPane() {
            this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            this.setHorizontalScrollBarPolicy(31);
            this.setVerticalScrollBarPolicy(21);
            this.getViewport().getView().addComponentListener(this);
            this.removeMouseWheelListeners();
        }

        private void removeMouseWheelListeners() {
            MouseWheelListener[] listeners;
            for (MouseWheelListener listener : listeners = this.getMouseWheelListeners()) {
                this.removeMouseWheelListener(listener);
            }
        }

        @Override
        public void updateUI() {
            super.updateUI();
            this.removeMouseWheelListeners();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.setSize(this.getSize().width, this.getPreferredSize().height);
        }

        @Override
        public void componentMoved(ComponentEvent e) {
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void componentHidden(ComponentEvent e) {
        }

        @Override
        public Dimension getPreferredSize() {
            this.getViewport().setPreferredSize(this.getViewport().getView().getPreferredSize());
            return super.getPreferredSize();
        }
    }

    public static enum OPERATION {
        VERIFY,
        DELETE,
        STOP,
        RESTART,
        MODIFY,
        CUTOVER,
        LOG;

    }
}

