/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.datamig;

import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.ui.AddRemovePanel;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.VerticalFlowLayout;
import com.cisco.dcbu.lib.ui.table.HeaderListener;
import com.cisco.dcbu.lib.ui.wizard.JWizard;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.datamig.DataMigConfigPanel;
import com.cisco.dcbu.sm.client.datamig.DataMigConfigThread;
import com.cisco.dcbu.sm.client.datamig.DataMigWizard;
import com.cisco.dcbu.sm.client.datamig.LunCapacityRenderer;
import com.cisco.dcbu.sm.client.datamig.LunInfoCellRenderer;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.common.model.ddm.DDMLun;
import com.cisco.dcbu.sm.common.model.ddm.DDMLunITL;
import com.cisco.dcbu.sm.common.rif.DDMCreationRif;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class DataMigNonAslLunMap
extends DataMigConfigPanel
implements ActionListener {
    int _notAslMode;
    JComboBox[] _storageCmbxList;
    SnmpKTable _storageTable;
    SmTableModel _storageTableModel;
    AddRemovePanel _addRemovepanel;
    public static final int SRC_NON_ASL = 0;
    public static final int DEST_NON_ASL = 1;

    public DataMigNonAslLunMap(JWizard wizard, int migType, int mode) {
        super("Step " + ((DataMigWizard)wizard).getNextStep() + ": Create LUN Map Correlation " + (mode == 0 ? "(Existing Storage)" : "(New Storage)"), (mode == 0 ? "Create LUN Map Correlation for Existing Storage" : "Create LUN Map Correlation for New Storage") + ". Select LUN from different Host-Storage path and Add/Remove manual LUN map Correlation.", wizard, null);
        this._notAslMode = mode;
    }

    @Override
    public boolean refresh() {
        block5: {
            try {
                JComboBox cmbx;
                this.removeAll();
                DDMCreationRif dmCreateRif = (DDMCreationRif)this.getModelValue("CreateRif");
                DDMLunITL[] luns = dmCreateRif.getLunMap(this._notAslMode == 0);
                JPanel storageLunListPanel = new JPanel();
                storageLunListPanel.setLayout(new VerticalFlowLayout(0));
                this._storageCmbxList = new JComboBox[luns.length];
                for (int i = 0; i < luns.length; ++i) {
                    DefaultComboBoxModel<DDMLun> model = new DefaultComboBoxModel<DDMLun>(luns[i].getLuns());
                    cmbx = new JComboBox();
                    cmbx.setModel(model);
                    cmbx.setRenderer(new LunInfoCellRenderer(luns[i]));
                    storageLunListPanel.add(cmbx);
                    this._storageCmbxList[i] = cmbx;
                }
                JScrollPane storageLunListScrollPanel = new JScrollPane(storageLunListPanel);
                Dimension dCmbx = null;
                if (this._storageCmbxList != null && this._storageCmbxList[0] != null) {
                    cmbx = this._storageCmbxList[0];
                    dCmbx = cmbx.getPreferredSize();
                    storageLunListScrollPanel.getVerticalScrollBar().setUnitIncrement(dCmbx.height);
                }
                storageLunListScrollPanel.setPreferredSize(new Dimension(dCmbx.width, dCmbx.height * 8));
                JPanel tablePanel = new JPanel(new BorderLayout());
                tablePanel.setLayout(new BorderLayout());
                this._storageTableModel = new SmTableModel();
                this._storageTableModel.setData(new Array());
                this._storageTable = new SnmpKTable(this._storageTableModel);
                this._storageTable.setAutoResizeMode(3);
                this._storageTable.getTableHeader().addMouseListener(new HeaderListener());
                this._storageTable.setSortable(true);
                ((JLabel)((Object)this._storageTable.getTableHeader().getDefaultRenderer())).setHorizontalAlignment(2);
                String[] oldStorageColLabel = new String[luns.length + 1];
                oldStorageColLabel[0] = "Size";
                for (int i = 0; i < luns.length; ++i) {
                    oldStorageColLabel[i + 1] = "<html>" + luns[i].getInitator() + "<br>" + luns[i].getTaget() + "<br>(" + luns[i].getSwitch() + ")" + "<br>LUN ID";
                }
                this._storageTableModel.setHeaders(oldStorageColLabel);
                this._storageTableModel.fireTableStructureChanged();
                this._storageTable.getTableHeader().resizeAndRepaint();
                this._storageTable.colWidthToWidest();
                this._storageTable.getColumnModel().getColumn(0).setCellRenderer(new LunCapacityRenderer());
                JScrollPane scrollTablePane = new JScrollPane(this._storageTable);
                Dimension dm = this._storageTable.calcPreferredSize();
                scrollTablePane.setPreferredSize(new Dimension(dm.width, this._storageTable.getRowHeight() * 10));
                this._addRemovepanel = new AddRemovePanel("(Size, Host, Storage, Fabric, Switch, Module, LUN Id)");
                this._addRemovepanel.buildPanel(2, storageLunListScrollPanel, scrollTablePane, this);
                this._addRemovepanel.enableUpBtn(false);
                this.add(this._addRemovepanel);
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this, ex);
                if (!SnmpSession.isTrace()) break block5;
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        block6: {
            char cmd = ((AbstractButton)e.getSource()).getActionCommand().charAt(0);
            try {
                switch (cmd) {
                    case 'A': {
                        this.addLUNMap();
                        break;
                    }
                    case 'R': {
                        this.removeLunMap();
                    }
                }
            }
            catch (Exception ex) {
                Util.errorMessage((Component)this, ex);
                if (!SnmpSession.isTrace()) break block6;
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
    }

    void addLUNMap() throws Exception {
        DDMLun selLunl0 = (DDMLun)this._storageCmbxList[0].getSelectedItem();
        long capacity0 = selLunl0.getCapacity();
        for (int i = 1; i < this._storageCmbxList.length; ++i) {
            JComboBox cmbx = this._storageCmbxList[i];
            DDMLun selLun = (DDMLun)cmbx.getSelectedItem();
            int selIndex = cmbx.getSelectedIndex();
            if (selLun.getCapacity() == capacity0) continue;
            throw new Exception("mismatch LUN capacity at row " + (i + 1) + ". Expected: " + capacity0 + "MB");
        }
        Object[] row = new Object[this._storageCmbxList.length + 1 + 1 + 1 + 1];
        ArrayList<DDMLun> luns = new ArrayList<DDMLun>();
        for (int i = 0; i < this._storageCmbxList.length; ++i) {
            JComboBox cmbx = this._storageCmbxList[i];
            DDMLun selLun = (DDMLun)cmbx.getSelectedItem();
            int selIndex = cmbx.getSelectedIndex();
            row[i + 1] = new Long(selLun.getLunNumber());
            luns.add(selLun);
            DefaultComboBoxModel model = (DefaultComboBoxModel)cmbx.getModel();
            model.removeElement(selLun);
            cmbx.setModel(model);
            if (i == 0) {
                this._addRemovepanel.enableUpBtn(true);
            }
            if (model.getSize() > 0) {
                cmbx.setSelectedIndex(0);
                continue;
            }
            cmbx.setEnabled(false);
            if (i != this._storageCmbxList.length - 1) continue;
            this._addRemovepanel.enableDownBtn(false);
        }
        row[0] = new Long(selLunl0.getCapacity());
        row[row.length - 3] = luns;
        row[row.length - 2] = selLunl0;
        row[row.length - 1] = selLunl0.getPhysicalLunToken();
        this._storageTableModel.getData().addElement(row);
        this._storageTableModel.fireTableDataChanged();
        this._storageTable.colWidthToWidest();
        this._storageTable.repaint();
    }

    void removeLunMap() {
        int[] selected = this._storageTable.getSelectedRows();
        boolean firstPass = true;
        for (int i = selected.length - 1; i >= 0; --i) {
            Object[] row = (Object[])this._storageTableModel.getData().elementAt(selected[i]);
            this._storageTableModel.getData().removeElementAt(selected[i]);
            ArrayList luns = (ArrayList)row[row.length - 3];
            for (int j = 0; j < this._storageCmbxList.length; ++j) {
                JComboBox cmbx = this._storageCmbxList[j];
                DefaultComboBoxModel model = (DefaultComboBoxModel)cmbx.getModel();
                model.addElement(luns.get(j));
                cmbx.setModel(model);
                if (!firstPass) continue;
                cmbx.setEnabled(true);
            }
            if (!firstPass) continue;
            this._addRemovepanel.enableDownBtn(true);
            firstPass = false;
        }
        if (selected.length >= 1) {
            this._storageTableModel.fireTableRowsDeleted(selected[0], selected[selected.length - 1]);
        }
        this._addRemovepanel.enableUpBtn(this._storageTable.getModel().getRowCount() > 0);
    }

    @Override
    public void doNext() {
        this._cfgThread = new ConfigCreateLunMapThread(this.getWizard());
        this._cfgThread.start();
    }

    class ConfigCreateLunMapThread
    extends DataMigConfigThread {
        public ConfigCreateLunMapThread(JWizard wizard) {
            super(wizard);
        }

        @Override
        public void run() {
            try {
                DDMCreationRif dmCreateRif = (DDMCreationRif)DataMigNonAslLunMap.this.getModelValue("CreateRif");
                DDMLunITL[] lunsItl = dmCreateRif.getLunMap(DataMigNonAslLunMap.this._notAslMode == 0);
                if (!this.keepRunning(DataMigNonAslLunMap.this._cfgThread)) {
                    return;
                }
                Array data = DataMigNonAslLunMap.this._storageTableModel.getData();
                if (data.size() == 0) {
                    throw new Exception("Please construct LUN Map Correlation using the information provided!");
                }
                ArrayList<DDMLunITL> lunmaps = new ArrayList<DDMLunITL>();
                for (int col = 0; col < lunsItl.length; ++col) {
                    DDMLunITL lunItl = new DDMLunITL();
                    lunItl.setInitator(lunsItl[col].getInitator());
                    lunItl.setTarget(lunsItl[col].getTarget());
                    lunItl.setSwitch(lunsItl[col].getSwitch());
                    int nOfLuns = data.size();
                    DDMLun[] luns = new DDMLun[nOfLuns];
                    for (int row = 0; row < nOfLuns; ++row) {
                        Object[] rowData = (Object[])data.elementAt(row);
                        luns[row] = new DDMLun();
                        luns[row].setCapacity((Long)rowData[0]);
                        luns[row].setLunNumber((Long)rowData[col + 1]);
                        luns[row].setPhysicalLunToken((String)rowData[rowData.length - 1]);
                        luns[row].setMaxLba(((DDMLun)rowData[rowData.length - 2]).getMaxLba());
                    }
                    lunItl.setLuns(luns);
                    lunmaps.add(lunItl);
                }
                boolean srcAsl = (Boolean)DataMigNonAslLunMap.this.getModelValue("sourceAsl");
                boolean destAsl = (Boolean)DataMigNonAslLunMap.this.getModelValue("destAsl");
                DDMLunITL[] luns = lunmaps.toArray(new DDMLunITL[lunmaps.size()]);
                if (DataMigNonAslLunMap.this._notAslMode == 0) {
                    DataMigNonAslLunMap.this.setModelValue("sourceLun", luns);
                } else {
                    DataMigNonAslLunMap.this.setModelValue("destLun", luns);
                }
                if (!srcAsl && !destAsl && DataMigNonAslLunMap.this._notAslMode == 1) {
                    ((DataMigWizard)DataMigNonAslLunMap.this.getWizard()).setupSrcDestPath();
                } else {
                    ((DataMigWizard)DataMigNonAslLunMap.this.getWizard()).setupSrcDestPath();
                }
                this.setupConfigStatus(true, false, null);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DataMigNonAslLunMap.this.getWizard().setStatus("Creating LUN Map Correlation...");
                    }
                });
                dmCreateRif.createLunMap(luns);
                if (!this.keepRunning(DataMigNonAslLunMap.this._cfgThread)) {
                    return;
                }
                this.setupConfigStatus(false, false, null);
                DataMigNonAslLunMap.this.goNext();
            }
            catch (Exception ex) {
                if (!this.keepRunning(DataMigNonAslLunMap.this._cfgThread)) {
                    return;
                }
                this.setupConfigStatus(false, false, ex);
            }
        }
    }
}

