/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.datamig;

import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.datamig.DataMigMisMatchNumLunPanel;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.common.model.ddm.DDMLunITL;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class LunNumTableModel
extends SmTableModel
implements MouseListener {
    public static final int SELECT_COL = 0;
    public static final int N_OF_LUNS_COL = 1;
    public static final int DETAIL_COL = 2;
    public static final int UNDO = 3;
    public static final int LUNS_INFO_COL = 4;
    boolean _isSrc;
    LunNumTableModel _checkModel;
    KTable _table;
    DataMigMisMatchNumLunPanel _owner;
    int _selectedRow;

    public LunNumTableModel(boolean isSrc, DataMigMisMatchNumLunPanel owner) {
        this._isSrc = isSrc;
        this._owner = owner;
    }

    public void setCheckModel(LunNumTableModel checkModel, KTable table) {
        this._checkModel = checkModel;
        this._table = table;
        table.addMouseListener(this);
    }

    @Override
    public void setValueAt(Object aValue, int row, int col) {
        if (col == 0) {
            boolean isSelected;
            boolean bl = isSelected = (Boolean)aValue == Boolean.TRUE;
            if (isSelected) {
                Array data = this.getData();
                int total = data.size();
                for (int i = 0; i < total; ++i) {
                    Object[] rowData = (Object[])data.elementAt(i);
                    if ((Boolean)rowData[0] != Boolean.TRUE) continue;
                    rowData[0] = Boolean.FALSE;
                    this.fireTableDataChanged();
                    break;
                }
                this._selectedRow = row;
                this._owner.setDataValid(false);
            }
        }
        super.setValueAt(aValue, row, col);
    }

    synchronized Object processSelectCol(Object aValue, int row, int col) {
        return aValue;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getSource() instanceof KTable && e.getClickCount() == 1) {
            Point p = e.getPoint();
            KTable t = (KTable)e.getSource();
            int r = t.rowAtPoint(p);
            int c = t.columnAtPoint(p);
            int model = this._table.convertColumnIndexToModel(c);
            if (model == 0) {
                Array data = this.getData();
                if (this._isSrc) {
                    Object[] srcRow = (Object[])data.elementAt(r);
                    DDMLunITL srcLun = (DDMLunITL)srcRow[4];
                    Array destData = this._checkModel.getData();
                    boolean findMatch = false;
                    for (int i = 0; i < destData.size(); ++i) {
                        Object[] destRow = (Object[])destData.elementAt(i);
                        DDMLunITL destLun = (DDMLunITL)destRow[4];
                        if (!destLun.getInitator().equals(srcLun.getInitator()) || !destLun.getSwitch().equals(srcLun.getSwitch())) continue;
                        findMatch = true;
                        this._checkModel.setValueAt(Boolean.TRUE, i, 0);
                        break;
                    }
                    if (!findMatch) {
                        Util.errorMessage((Component)BrowserFrame.getInstance(), "Cannot find matching Destination path.");
                        this.setValueAt(Boolean.TRUE, this._selectedRow, c);
                    }
                } else {
                    Object[] destRow = (Object[])data.elementAt(r);
                    DDMLunITL destLun = (DDMLunITL)destRow[4];
                    Array srcData = this._checkModel.getData();
                    boolean findMatch = false;
                    for (int i = 0; i < srcData.size(); ++i) {
                        Object[] srcRow = (Object[])srcData.elementAt(i);
                        if (srcRow[0] != Boolean.TRUE) continue;
                        DDMLunITL srcLun = (DDMLunITL)srcRow[4];
                        if (!destLun.getInitator().equals(srcLun.getInitator()) || !srcLun.getSwitch().equals(destLun.getSwitch())) continue;
                        findMatch = true;
                        this._checkModel.setValueAt(Boolean.TRUE, i, 0);
                        break;
                    }
                    if (!findMatch) {
                        Util.errorMessage((Component)BrowserFrame.getInstance(), "The selected row has mismatch Host/Switch as the Source Path.");
                        this.setValueAt(Boolean.TRUE, this._selectedRow, c);
                    }
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }
}

