/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.jnm.ExternalTools;
import com.cisco.dcbu.lib.jnm.JnmMibEnum;
import com.cisco.dcbu.lib.jnm.SnmpKTable;
import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibEnum;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpCallbackIf;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpFetch;
import com.cisco.dcbu.lib.snmp.SnmpInt;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPDU;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpReportException;
import com.cisco.dcbu.lib.snmp.SnmpSession;
import com.cisco.dcbu.lib.snmp.SnmpString;
import com.cisco.dcbu.lib.snmp.SnmpVar;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.lib.ui.Util;
import com.cisco.dcbu.lib.ui.table.KTable;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.lib.util.NetUtil;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.gui.BrowserFrame;
import com.cisco.dcbu.sm.client.gui.DataView;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.San;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Switch;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.Timer;

public class SmCopyCfgTableModel
extends SmTableModel
implements ActionListener,
MouseListener {
    HashMap _peers2RowN = new HashMap();
    Array _peersToGetCopyStatus;
    Array _peersCopyStatusOK;
    int _nRunning2Startup;
    int _pending;
    SnmpPeer[] _peers;
    public static final int WAITING = 1;
    public static final int RUNNING = 2;
    public static final int SUCCESSFUL = 3;
    public static final int FAILED = 4;
    public static final int FAILCAUSE_CONFIGAPPLYFAILED = 7;
    public static final int FAILCAUSE_requestAborted = 9;
    VarBindList _ccStatusVB;
    int[] _ccCopyIndex;
    protected Timer _statusTimer = new Timer(5000, this);
    int _failureReasonClickedRow;
    boolean _anyInitialSetChange = false;
    static final String[] _headers = new String[]{"Switch", "Select", "Status", "FailureCause", "From", "To", "<html>xFTP Server<br>Address", "<html>xFTP Server<br>FileName", "Protocol", "<html>FTP/SFTP<br>UserName", "<html>FTP/SFTP<br>Password"};
    int _nElementsInRow;
    static final int SWITCH = 0;
    static final int TRANSFER = 1;
    static final int STATUS = 2;
    static final int FAILREASON = 3;
    static final int OFFSET = 4;
    static final int SRCTYPE = 0;
    static final int DSTTYPE = 1;
    static final int SERVERADR = 2;
    static final int FILENAME = 3;
    static final int PROTOCOL = 4;
    static final int USERNAME = 5;
    static final int PSWD = 6;
    static final int PROTOCOL_TFTP = 1;
    static final int PROTOCOL_FTP = 2;
    static final int PROTOCOL_SFTP = 5;
    static final int ConfigFileType_NetworkFile = 1;
    static final int ConfigFileType_Startup = 3;
    static final int ConfigFileType_Running = 4;
    static final int ConfigFileType_fabricStartupConfig = 6;
    public static final String[] _errorTableMibs = new String[]{"ccCopyErrorDeviceIpAddress", "ccCopyErrorDescription"};
    public static final int[] _startErrorTableOid = MibNode.get(_errorTableMibs[0]).getOid();
    public static final int[] _ccCopyServerAddressRev1Oid = MibNode.get("ccCopyServerAddressRev1").getOid();
    public static final int[] _ccCopyServerAddressTypeOid = MibNode.get("ccCopyServerAddressType").getOid();
    JCheckBox _allChkBox;

    public SmCopyCfgTableModel() {
        this._peers = San.getInstance().getSnmpPeers();
        this._peersCopyStatusOK = new Array();
        this._peersToGetCopyStatus = new Array();
        DataView dataView = BrowserFrame.getDataView();
        JPanel actPanel = new JPanel(new FlowLayout(0, 2, 2));
        this._allChkBox = new JCheckBox("All");
        this._allChkBox.setToolTipText("Select/De-Select All Switches");
        this._allChkBox.addActionListener(this);
        actPanel.add(this._allChkBox);
        JPanel newToolbar = new JPanel(new FlowLayout(2, 2, 2));
        newToolbar.add(actPanel);
        newToolbar.add(dataView.getDefaultButtonPanel());
        dataView.replaceButtonPanel(newToolbar);
    }

    @Override
    public void setAttr(String[] vars, String[] prefixes, int index, boolean isScalar) {
        this._isScalar = isScalar;
        this.build(vars, prefixes, 4);
        this._index = index;
        this._vars = vars;
    }

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        this._offset = offset;
        this._mibVars = mibVars;
        this._prefixes = prefixes;
        this._nElementsInRow = _headers.length;
        boolean[] editable = new boolean[this._nElementsInRow];
        editable[1] = true;
        this._mibNodes = new MibNode[this._nElementsInRow];
        for (int i = offset; i < this._nElementsInRow; ++i) {
            this._mibNodes[i] = MibNode.get(mibVars[i - offset]);
            editable[i] = this._mibNodes[i].isEditable();
            if (!editable[i] || this._isEditable) continue;
            this._isEditable = true;
        }
        this.setHeaders(_headers);
        this.setEditable(editable);
        this.setData(new Array());
        BrowserFrame.getTable().addMouseListener(this);
    }

    @Override
    public Array getTableVars(SmFilter[] invoker) throws SnmpException {
        SnmpPeer[] changedPeers = null;
        this._allChkBox.setSelected(false);
        if (invoker != null && invoker.length > 0) {
            changedPeers = new SnmpPeer[invoker.length];
            for (int i = 0; i < invoker.length; ++i) {
                changedPeers[i] = invoker[i].getSnmpPeer();
            }
        } else {
            changedPeers = ClientController.getInstance().getSelectedDomain().getSnmpPeers();
        }
        return this.getTableVars(changedPeers);
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        String tftpServer;
        block9: {
            this._responseData = new Array();
            this._peers = nodes;
            if (nodes == null) {
                return this._responseData;
            }
            this._allChkBox.setSelected(false);
            tftpServer = null;
            try {
                tftpServer = ClientController.getInstance().assertSession().getServerProperty("server.FileServerAddress");
                SnmpIpAddress.parse(tftpServer);
            }
            catch (Exception ex) {
                if (!SnmpSession.isTrace()) break block9;
                DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
            }
        }
        this._anyInitialSetChange = false;
        for (int i = 0; i < nodes.length; ++i) {
            String pswd;
            String userName;
            block10: {
                boolean peerSetChange;
                Object[] row = new Object[this._nElementsInRow + 1 + 1 + 1 + 1];
                row[row.length - 3] = "";
                row[row.length - 2] = null;
                row[row.length - 1] = null;
                this._responseData.addElement(row);
                row[0] = nodes[i];
                boolean bl = peerSetChange = nodes[i].getNumSets() > 0;
                if (peerSetChange && !this._anyInitialSetChange) {
                    this._anyInitialSetChange = true;
                }
                row[1] = peerSetChange ? Boolean.TRUE : Boolean.FALSE;
                row[4] = this.toCell(this._mibNodes[4], new SnmpInt(4), this._vars[0], this._responseData.size() - 1);
                row[5] = this.toCell(this._mibNodes[5], new SnmpInt(3), this._vars[1], this._responseData.size() - 1);
                try {
                    row[6] = tftpServer != null ? this.toCell(this._mibNodes[6], new SnmpIpAddress(tftpServer), this._vars[2], this._responseData.size() - 1) : this.toCell(this._mibNodes[6], new SnmpIpAddress(NetUtil.detectSourceAddress(nodes[i].getAddress()).getHostAddress()), this._vars[2], this._responseData.size() - 1);
                }
                catch (Exception ex) {
                    if (!SnmpSession.isTrace()) break block10;
                    DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                }
            }
            boolean isV3 = nodes[i].getVersion() == 3;
            SnmpString filename = new SnmpString(nodes[i] + "_cfg.txt");
            row[7] = this.toCell(this._mibNodes[7], filename, this._vars[3], this._responseData.size() - 1);
            row[8] = this.toCell(this._mibNodes[8], new SnmpInt(1), this._vars[4], this._responseData.size() - 1);
            if (isV3) {
                userName = nodes[i].getUserName();
                pswd = nodes[i].getAuthPassword();
            } else {
                userName = "";
                pswd = "";
            }
            row[9] = this.toCell(this._mibNodes[9], new SnmpString(userName), this._vars[5], this._responseData.size() - 1);
            row[10] = this.toCell(this._mibNodes[10], new SnmpString(pswd), this._vars[6], this._responseData.size() - 1);
        }
        return this._responseData;
    }

    @Override
    protected boolean ApplyBtnOn() {
        return this._anyInitialSetChange;
    }

    @Override
    public boolean applyChanges() throws Exception {
        Array data = this.getData();
        boolean bCheckErr = false;
        boolean bNeedtoSet = false;
        for (int i = 0; i < data.size(); ++i) {
            Object[] row = (Object[])data.elementAt(i);
            boolean isTransfer = (Boolean)row[1];
            if (!isTransfer) continue;
            bNeedtoSet = true;
            row[2] = "";
            row[3] = "";
            this.fireTableDataChanged();
            SnmpInt srcType = (SnmpInt)this.getChangedCell(i, 4);
            SnmpInt dstType = (SnmpInt)this.getChangedCell(i, 5);
            SnmpString fileName = (SnmpString)this.getChangedCell(i, 7);
            SnmpString userName = (SnmpString)this.getChangedCell(i, 9);
            SnmpString pswd = (SnmpString)this.getChangedCell(i, 10);
            SnmpInt protocol = (SnmpInt)this.getChangedCell(i, 8);
            StringBuffer strErr = new StringBuffer();
            if (srcType.getValue() == dstType.getValue()) {
                strErr.append("Source and Destination must be different types\n");
            }
            if (fileName.toString().equals("")) {
                strErr.append("Filename cannot be empty\n");
            }
            if (userName.toString().equals("") && protocol.getValue() != 1) {
                strErr.append("UserName cannot be empty\n");
            }
            if (pswd.toString().equals("") && protocol.getValue() != 1) {
                strErr.append("Password cannot be empty\n");
            }
            if (strErr.length() == 0) continue;
            bCheckErr = true;
            Util.errorMessage((Component)BrowserFrame.getInstance(), strErr.toString());
            break;
        }
        if (!bNeedtoSet) {
            Util.errorMessage((Component)BrowserFrame.getInstance(), "Please check the Select column for rows that you want to apply.");
            return false;
        }
        if (bCheckErr) {
            return false;
        }
        this._pending = 0;
        this._state = 5;
        this._peersToGetCopyStatus.clear();
        this._peersCopyStatusOK.clear();
        this._peers2RowN.clear();
        this._nRunning2Startup = 0;
        this._ccCopyIndex = new int[1];
        this._ccCopyIndex[0] = (int)(Math.random() * 2.14748364E8) + 1;
        this._ccStatusVB = new VarBindList();
        this._ccStatusVB.add(new SnmpVarBind(new SnmpOID(MibNode.get("ccCopyState").getOid(), this._ccCopyIndex)));
        this._ccStatusVB.add(new SnmpVarBind(new SnmpOID(MibNode.get("ccCopyFailCause").getOid(), this._ccCopyIndex)));
        boolean bSnmpSend = false;
        for (int i = 0; i < data.size(); ++i) {
            Object[] row = (Object[])data.elementAt(i);
            boolean isTransfer = (Boolean)row[1];
            if (!isTransfer) continue;
            SnmpInt srcType = (SnmpInt)this.getChangedCell(i, 4);
            SnmpInt dstType = (SnmpInt)this.getChangedCell(i, 5);
            int src = srcType.getValue();
            int dst = dstType.getValue();
            if (src == 4 && dst == 3) {
                ++this._nRunning2Startup;
            }
            SnmpPeer peer = (SnmpPeer)row[0];
            this._peers2RowN.put(peer, new Integer(i));
            SnmpPDU pdu = new SnmpPDU(-93, new VarBindList());
            pdu.addVar(new SnmpOID(MibNode.get("ccCopyEntryRowStatus").getOid(), this._ccCopyIndex), new SnmpInt(4));
            int varbindMaskIndex = 0;
            for (int j = this._offset; j < this._mibNodes.length; ++j) {
                SnmpInt protocol = (SnmpInt)this.getChangedCell(i, 8);
                if (this._mibNodes[j] == null || !this.isCellActive(i, j)) continue;
                ++varbindMaskIndex;
                if (j == 9 || j == 10) {
                    if (protocol.getValue() == 1) continue;
                    pdu.addVar(new SnmpOID(this._mibNodes[j].getOid(), this._ccCopyIndex), this.getChangedCell(i, j));
                    if (j != 10) continue;
                    pdu.setVarBindMask(new int[]{varbindMaskIndex});
                    continue;
                }
                if (j == 6) {
                    if (row[6] instanceof SnmpIpAddress) {
                        boolean isIPV6;
                        ClientController.getInstance();
                        Switch sw = ClientController.findFabricSwitchByIpAddress(peer.getAddress());
                        boolean bl = isIPV6 = ((SnmpIpAddress)row[6]).getValue().length == 16;
                        if (isIPV6 || sw.isVersionGreaterThanEqual("3.0(0)")) {
                            SnmpVar ipaddress = this.getChangedCell(i, j);
                            if (ipaddress instanceof SnmpIpAddress) {
                                ipaddress = new SnmpString(((SnmpIpAddress)this.getChangedCell(i, j)).getValue());
                            }
                            pdu.addVar(new SnmpOID(_ccCopyServerAddressTypeOid, this._ccCopyIndex), new SnmpInt(isIPV6 ? 2 : 1));
                            pdu.addVar(new SnmpOID(_ccCopyServerAddressRev1Oid, this._ccCopyIndex), ipaddress);
                            ++varbindMaskIndex;
                            continue;
                        }
                        pdu.addVar(new SnmpOID(this._mibNodes[j].getOid(), this._ccCopyIndex), this.getChangedCell(i, j));
                        continue;
                    }
                    pdu.addVar(new SnmpOID(this._mibNodes[j].getOid(), this._ccCopyIndex), this.getChangedCell(i, j));
                    continue;
                }
                pdu.addVar(new SnmpOID(this._mibNodes[j].getOid(), this._ccCopyIndex), this.getChangedCell(i, j));
            }
            ++this._pending;
            bSnmpSend = true;
            pdu.setIgnoreSetCount(true);
            peer.send(pdu, this);
        }
        if (bSnmpSend) {
            this.wait(this._peers);
        }
        this._statusTimer.start();
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this._statusTimer) {
            if (this._peersToGetCopyStatus.size() != 0) {
                this.pollSwitches();
                return;
            }
            this._statusTimer.stop();
        } else if (e.getSource() instanceof JCheckBox) {
            boolean bAll = ((JCheckBox)e.getSource()).isSelected();
            for (int rowN = 0; rowN < this._responseData.size(); ++rowN) {
                Object[] row = (Object[])this._responseData.elementAt(rowN);
                this.setValueAt(bAll ? Boolean.TRUE : Boolean.FALSE, rowN, 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pollSwitches() {
        this._state = 1;
        Array array = this._peersToGetCopyStatus;
        synchronized (array) {
            this._pending = this._peersToGetCopyStatus.size();
            for (int i = 0; i < this._peersToGetCopyStatus.size(); ++i) {
                SnmpPeer peer = (SnmpPeer)this._peersToGetCopyStatus.elementAt(i);
                SnmpPDU pdu = new SnmpPDU(-96, this._ccStatusVB);
                pdu.setRetries(0);
                try {
                    peer.send(pdu, this);
                    continue;
                }
                catch (SnmpException ex) {
                    // empty catch block
                }
            }
        }
        if (this._peersToGetCopyStatus.size() != 0) {
            this.wait(this._peers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void callback(SnmpSession session, int reqid, SnmpPDU pdu, boolean timedOut) {
        SnmpPeer[] iNteger;
        if (this._outScope) {
            return;
        }
        SnmpPeer peer = SnmpPeer.findPeer(pdu.getAddress());
        --this._pending;
        if (peer == null) {
            DefaultLogger._DefLogger.error((Object)("SmCopyCfgTableModel.callback peer==null pdu.getAddress()=" + pdu.getAddress()));
            StringBuffer sb = new StringBuffer();
            Iterator<Map.Entry<InetAddress, SnmpPeer>> it = SnmpPeer.getPeersIterator();
            int count = 0;
            while (it.hasNext()) {
                SnmpPeer aPeer = it.next().getValue();
                if (aPeer != null) {
                    sb.append("\t").append(aPeer.getAddress().getHostAddress()).append(": ").append(aPeer.getSession() == SnmpSession.getInstance() ? "UDP" : "TCP").append(", version=").append(aPeer.getVersion()).append(", timeout=").append(aPeer.getTimeout()).append(", retries=").append(aPeer.getRetries()).append(", delay=").append(aPeer.getAverageRoundTripDelay()).append(", numOfSETs=").append(aPeer.getNumSets());
                    if (aPeer.getVersion() == 3) {
                        sb.append(", userName=").append(aPeer.getUserName()).append(", authProt=").append(aPeer.getAuthProtocol()).append(", privProt=").append(aPeer.getPrivProtocol());
                    } else {
                        sb.append(", community=******");
                    }
                }
                sb.append(System.getProperty("line.separator"));
                ++count;
            }
            sb.insert(0, " peers:\n").insert(0, count);
            DefaultLogger._DefLogger.error((Object)sb.toString());
        } else if (this._peers2RowN == null) {
            DefaultLogger._DefLogger.error((Object)"SmCopyCfgTableModel.callback _peers2RowN==null");
        } else {
            iNteger = (SnmpPeer[])this._peers2RowN.get(peer);
            if (iNteger == null) {
                DefaultLogger._DefLogger.error((Object)"SmCopyCfgTableModel.callback iNteger==null");
            } else {
                int rowN = iNteger.intValue();
                Object[] row = (Object[])this.getData().elementAt(rowN);
                this.checkSnmpCallbackErr(peer, pdu, timedOut);
                if (pdu.getVariables().size() > 0 && pdu.getVariables().getVb(0).getOid().startsWith(_startErrorTableOid)) {
                    row[row.length - 1] = pdu.getVariables();
                    this.deleteRow(peer);
                } else if (this._state == 5) {
                    if (timedOut) {
                        row[2] = "Failed";
                        row[3] = "timedout";
                    } else if (pdu.getError() != 0) {
                        row[2] = "Failed";
                        row[3] = "setErr...";
                        Thread t = new Thread((Runnable)new SnmpCopyCfgSetErrorDetailRunnable(row, peer, pdu), "SnmpCopyCfgSetErrorDetailRunnable");
                        t.start();
                    } else {
                        row[2] = "inProgress";
                        Array t = this._peersToGetCopyStatus;
                        synchronized (t) {
                            this._peersToGetCopyStatus.addElement(peer);
                        }
                    }
                } else if (this._state == 1) {
                    if (timedOut) {
                        row[2] = "Failed";
                        row[3] = "timedout";
                        Array t = this._peersToGetCopyStatus;
                        synchronized (t) {
                            this._peersToGetCopyStatus.removeElement(peer);
                        }
                        this.deleteRow(peer);
                    } else if (pdu.getError() != 0) {
                        row[2] = "Failed";
                        row[3] = "getErr";
                        Array t = this._peersToGetCopyStatus;
                        synchronized (t) {
                            this._peersToGetCopyStatus.removeElement(peer);
                        }
                        this.deleteRow(peer);
                    } else if (pdu.getVariables().size() > 0) {
                        int state = pdu.getVariables().intValue(0);
                        if (state == 1 || state == 2) {
                            row[2] = "inProgress";
                        } else {
                            Object strReason;
                            int reason = pdu.getVariables().intValue(1);
                            if (state == 3) {
                                row[2] = "Success";
                                peer.resetNumSets();
                                DefaultLogger._DefLogger.debug((Object)("SAVE CONFIG peer reset = " + peer.toString() + " numsets = " + peer.getNumSets()));
                                this._peersCopyStatusOK.addElement(peer);
                            } else if (state == 4) {
                                row[2] = "Failed";
                                strReason = MibEnum.getLabel(MibNode.get("ccCopyFailCause").getEnums(), reason);
                                if (reason == 7 || reason == 9) {
                                    strReason = (String)strReason + "...";
                                    row[row.length - 2] = new Integer(reason);
                                }
                                row[3] = strReason;
                            }
                            strReason = this._peersToGetCopyStatus;
                            synchronized (strReason) {
                                this._peersToGetCopyStatus.removeElement(peer);
                            }
                            if (reason == 9) {
                                try {
                                    this.getErrorTable(peer);
                                }
                                catch (Exception ex) {
                                    DefaultLogger._DefLogger.error((Object)ex.getMessage(), (Throwable)ex);
                                }
                            }
                        }
                    }
                }
                this.fireTableDataChanged();
            }
        }
        if (this._pending <= 0) {
            try {
                iNteger = this._peers;
                synchronized (this._peers) {
                    this._peers.notifyAll();
                    // ** MonitorExit[iNteger] (shouldn't be in output)
                }
            }
            catch (IllegalMonitorStateException ex) {
                DefaultLogger._DefLogger.error((Object)ex);
            }
        }
        {
            return;
        }
    }

    void deleteRow(SnmpPeer peer) {
        this._state = -1;
        SnmpPDU ackpdu = new SnmpPDU(-93, new VarBindList());
        ackpdu.addVar(new SnmpOID(MibNode.get("ccCopyEntryRowStatus").getOid(), this._ccCopyIndex), new SnmpInt(6));
        ackpdu.setIgnoreSetCount(true);
        try {
            ++this._pending;
            peer.send(ackpdu, this);
        }
        catch (SnmpException ex) {
            DefaultLogger._DefLogger.error((Object)(peer + ":" + ex));
        }
    }

    void getErrorTable(SnmpPeer peer) throws SnmpException {
        SnmpFetch f = new SnmpFetch();
        int[] stopIndex = new int[]{this._ccCopyIndex[0] + 1};
        f.getBulk(peer, _errorTableMibs, this._ccCopyIndex, stopIndex, (SnmpCallbackIf)this);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        if (this._statusTimer != null) {
            this._statusTimer.stop();
        }
        BrowserFrame.getTable().removeMouseListener(this);
    }

    @Override
    public boolean isCellActive(int row, int col) {
        if (col == 3) {
            String status = (String)this.getValueAt(row, 2);
            return status == null || !status.equals("Success");
        }
        if (col >= 6) {
            int src = ((JnmMibEnum)this.getValueAt(row, 4)).getValue();
            int dst = ((JnmMibEnum)this.getValueAt(row, 5)).getValue();
            if (src == 3 && dst == 4 || src == 4 && dst == 3 || src == 4 && dst == 6) {
                return false;
            }
            if (col >= 9) {
                int protocol = ((JnmMibEnum)this.getValueAt(row, 8)).getValue();
                return protocol != 1;
            }
            return true;
        }
        return super.isCellActive(row, col);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        block10: {
            if (e.getSource() instanceof KTable && e.getClickCount() > 1) {
                Point p = e.getPoint();
                KTable t = (KTable)e.getSource();
                int r = t.rowAtPoint(p);
                int c = t.columnAtPoint(p);
                if (c == 3) {
                    this._failureReasonClickedRow = r;
                    Array data = this.getData();
                    Object[] row = (Object[])data.elementAt(r);
                    SnmpPeer peer = (SnmpPeer)row[0];
                    Integer reason = (Integer)row[row.length - 2];
                    String strFailReason = (String)row[3];
                    String errorReason = (String)row[row.length - 3];
                    if (strFailReason != null && strFailReason.startsWith("setErr")) {
                        BrowserFrame.getInstance();
                        JOptionPane.showMessageDialog(BrowserFrame.getDataView(), errorReason, "Error details", 1);
                    } else if (strFailReason != null && strFailReason.endsWith("..") && reason != null) {
                        int reasonCode = reason;
                        try {
                            if (reasonCode == 7) {
                                String strUrlLog = "http://" + peer.getAddress().getHostAddress() + "/configcopy.txt";
                                ExternalTools.openURL(strUrlLog);
                            } else if (reasonCode == 9) {
                                BrowserFrame.getInstance();
                                BrowserFrame.getDataView().details();
                            }
                        }
                        catch (Exception ex) {
                            if (!SnmpSession.isTrace()) break block10;
                            DefaultLogger._ExLogger.warn((Object)ex.getMessage(), (Throwable)ex);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    protected void performPostSorting() {
        this._peers2RowN.clear();
        Array data = this.getData();
        for (int i = 0; i < data.size(); ++i) {
            Object[] row = (Object[])data.elementAt(i);
            SnmpPeer node = (SnmpPeer)row[0];
            this._peers2RowN.put(node, new Integer(i));
        }
    }

    @Override
    protected boolean enableDetailButton(SnmpKTable table) {
        boolean selected;
        boolean bl = selected = this.getRowCount() > 0 && table.getSelectedRowCount() > 0;
        if (!selected) {
            return false;
        }
        int[] selRows = table.getSelectedRows();
        boolean failureIsRequestAbort = false;
        for (int i = 0; i < selRows.length; ++i) {
            Object[] row = (Object[])this.getData().elementAt(selRows[i]);
            String reason = (String)row[3];
            if (reason == null || !reason.startsWith(MibEnum.getLabel(MibNode.get("ccCopyFailCause").getEnums(), 9))) continue;
            failureIsRequestAbort = true;
            break;
        }
        return failureIsRequestAbort;
    }

    @Override
    protected String getEditTitle(SnmpKTable table) {
        Array data = this.getData();
        Object[] row = (Object[])data.elementAt(this._failureReasonClickedRow);
        SnmpPeer peer = (SnmpPeer)row[0];
        return peer + " RequestAborted Reason";
    }

    @Override
    protected int[] getEditIndex(int row) {
        return new int[]{0};
    }

    @Override
    protected boolean showDetailButton() {
        return false;
    }

    public int getFailureReasonClickedRow() {
        return this._failureReasonClickedRow;
    }

    class SnmpCopyCfgSetErrorDetailRunnable
    implements Runnable {
        SnmpPDU _errorPdu;
        SnmpPeer _peer;
        Object[] _row = null;

        SnmpCopyCfgSetErrorDetailRunnable(Object[] row, SnmpPeer peer, SnmpPDU pdu) {
            this._peer = peer;
            this._errorPdu = pdu;
            this._row = row;
        }

        @Override
        public void run() {
            String strErr = SnmpReportException.getError(this._errorPdu);
            String strErrorDetail = this._peer.getSnmpErrorDetail(strErr, this._errorPdu);
            this._row[this._row.length - 3] = strErrorDetail;
            DefaultLogger._DefLogger.error((Object)strErrorDetail);
        }
    }
}

