/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.mds.MibVariableFormat;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.dialogs.SmEthInterfaceTableModel;
import com.cisco.dcbu.sm.client.model.EthIsl;
import com.cisco.dcbu.sm.client.model.EthSwitch;
import com.cisco.dcbu.sm.client.model.Lan;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.common.model.EthPortBase;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class SmEthPCTableModel
extends SmEthInterfaceTableModel {
    String[] _labels = new String[]{"Switch", "Interface", "Description", "Members", "Oper Speed", "Admin Status", "Oper Status", "Last Change", "SwitchObj"};

    @Override
    protected Array getTableData() {
        MgmtDomainIf mgmtDomain = ClientController.getInstance().getSelectedDomain();
        List<EthPortBase> ports = this.getEthPorts(mgmtDomain);
        this._responseData = this.addPCInfo(ports);
        return this._responseData;
    }

    @Override
    protected List<EthPortBase> getEthPorts(MgmtDomainIf mgmtDomain) {
        ArrayList<EthPortBase> data = new ArrayList<EthPortBase>();
        if (mgmtDomain.isLAN() || mgmtDomain.isVlan()) {
            EthIsl[] isls;
            for (EthIsl isl : isls = mgmtDomain.getEthIsls()) {
                EthSwitch sw1 = (EthSwitch)isl.getSwitch1();
                EthSwitch sw2 = (EthSwitch)isl.getSwitch2();
                int port1 = isl.getIfIndex1();
                int port2 = isl.getIfIndex2();
                data.add(sw1.findEthPort(port1));
                data.add(sw2.findEthPort(port2));
            }
        }
        return data;
    }

    private Array addPCInfo(List<EthPortBase> ports) {
        Array<Object[]> data = new Array<Object[]>();
        for (EthPortBase port : ports) {
            Integer operStatus;
            if (port == null || !port.isChannel() || port.getIfType() != 53) continue;
            Object[] row = new Object[this._labels.length];
            EthSwitch sw = (EthSwitch)Lan.getInstance().findSwitchByPK(port.getSwitchPK());
            row[0] = sw.getName();
            row[1] = sw.ifIndexToName(port.getIfIndex());
            row[2] = port.getIfAlias();
            ArrayList<Integer> members = port.getChildren();
            StringBuffer portMem = new StringBuffer();
            for (int member : members) {
                portMem.append("," + sw.ifIndexToName(member));
            }
            String s = portMem.toString();
            if (s.startsWith(",")) {
                s = s.substring(1);
            }
            row[3] = s;
            row[4] = MibVariableFormat.speedBasic(port.getIfSpeed());
            Integer adminStatus = port.getIfAdminStatus();
            if (AdminStatus.containsKey(adminStatus)) {
                row[5] = AdminStatus.get(adminStatus);
            }
            if ((operStatus = Integer.valueOf(port.getIfOperMode())) < 3 && operStatus != adminStatus) {
                row[6] = "failure";
            } else if (OperStatus.containsKey(operStatus)) {
                row[6] = OperStatus.get(operStatus);
            }
            SimpleDateFormat f = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss");
            row[7] = f.format(new Date(port.getLastScanTime()));
            row[8] = sw;
            data.addElement(row);
        }
        return data;
    }
}

