/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.util.Array;
import com.cisco.dcbu.sm.client.ClientController;
import com.cisco.dcbu.sm.client.event.EventLog;
import com.cisco.dcbu.sm.client.event.EventLogListenerIf;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import com.cisco.dcbu.sm.client.model.Fabric;
import com.cisco.dcbu.sm.client.model.MgmtDomainIf;
import com.cisco.dcbu.sm.client.model.SmFilter;
import com.cisco.dcbu.sm.client.model.Switch;
import java.util.ArrayList;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class SmEventTableModel
extends SmTableModel
implements EventLogListenerIf {
    public static final String[] _Headers = EventLog._Headers;
    static final boolean[] _colEditable = EventLog._colEditable;
    MgmtDomainIf _mgmtDomain = null;
    protected Logger _logger = LogManager.getLogger(this.getClass());

    public SmEventTableModel() {
    }

    public SmEventTableModel(MgmtDomainIf mgmtDomain) {
        this._mgmtDomain = mgmtDomain;
    }

    @Override
    public Array getTableVars(SmFilter[] invoker) throws SnmpException {
        ArrayList<SnmpPeer> peers = new ArrayList<SnmpPeer>();
        for (int i = 0; i < invoker.length; ++i) {
            peers.add(invoker[i].getSnmpPeer());
        }
        return this.getVars(peers.toArray(new SnmpPeer[peers.size()]));
    }

    @Override
    public void setAttr(String[] vars, String[] prefixes, int index, boolean isScalar) {
        this._isScalar = isScalar;
        this.build(vars, prefixes, 0);
        this._index = index;
        this._vars = vars;
    }

    @Override
    public void build(String[] mibVars, String[] prefixes, int offset) {
        this._offset = offset;
        this._mibVars = mibVars;
        this._prefixes = prefixes;
        this.setHeaders(_Headers);
        this.setEditable(_colEditable);
        this._isEditable = true;
        this.setData(new Array());
    }

    @Override
    public Array getTableVars(SnmpPeer[] nodes) throws SnmpException {
        return this.getVars(nodes);
    }

    @Override
    public Array getVars(SnmpPeer[] nodes) throws SnmpException {
        this._responseData = new Array();
        if (this._mgmtDomain == null) {
            this._mgmtDomain = ClientController.getInstance().getSelectedDomain();
        }
        EventLog.getInstance();
        EventLog.addListener(this);
        this._responseData = EventLog.getInstance().getFilteredEvents(this._mgmtDomain);
        return this._responseData;
    }

    @Override
    public void cleanup() {
        super.cleanup();
        EventLog.getInstance();
        EventLog.removeListener(this);
    }

    @Override
    protected Object getDevicebject(Object[] rowData) {
        return rowData[EventLog.SWITCH];
    }

    @Override
    public synchronized void addEvent(Fabric fab, Switch sw, Object[] col) {
        Array data = this.getData();
        boolean insertEvent = false;
        if (this._mgmtDomain.isSan()) {
            insertEvent = true;
        } else if (this._mgmtDomain.isFabric() && fab != null && fab.equals(this._mgmtDomain)) {
            insertEvent = true;
        } else {
            Switch[] switches;
            for (Switch nextSw : switches = this._mgmtDomain.getSwitches()) {
                if (!nextSw.equals(sw)) continue;
                insertEvent = true;
                break;
            }
        }
        if (insertEvent) {
            data.insertElementAt(col, 0);
            this.fireTableRowsInserted(0, 0);
        }
    }

    @Override
    public synchronized void removeEvent(Fabric fab, Switch sw, Object[] rowToDelete) {
        Switch[] switches;
        Array data = this.getData();
        if (this._mgmtDomain.isFabric() && !fab.equals(this._mgmtDomain)) {
            return;
        }
        boolean isSwitchInDomain = false;
        for (Switch nextSw : switches = this._mgmtDomain.getSwitches()) {
            if (!nextSw.equals(sw)) continue;
            isSwitchInDomain = true;
            break;
        }
        if (!isSwitchInDomain) {
            return;
        }
        boolean eventRemoved = false;
        for (int rowIndex = 0; rowIndex < data.size(); ++rowIndex) {
            Object[] row = (Object[])data.elementAt(rowIndex);
            boolean foundEvent = true;
            for (int colIndex = 0; colIndex < row.length; ++colIndex) {
                if (row[colIndex] == null) {
                    if (rowToDelete[colIndex] == null) continue;
                    foundEvent = false;
                    break;
                }
                if (rowToDelete[colIndex] == null) {
                    foundEvent = false;
                    break;
                }
                if (row[colIndex].equals(rowToDelete[colIndex])) continue;
                foundEvent = false;
                break;
            }
            if (!foundEvent) continue;
            data.removeElementAt(rowIndex);
            eventRemoved = true;
            break;
        }
        if (eventRemoved) {
            this.fireTableDataChanged();
        }
    }
}

