/*
 * Decompiled with CFR 0.152.
 */
package com.cisco.dcbu.sm.client.dialogs;

import com.cisco.dcbu.lib.logging.DefaultLogger;
import com.cisco.dcbu.lib.snmp.MibNode;
import com.cisco.dcbu.lib.snmp.SnmpException;
import com.cisco.dcbu.lib.snmp.SnmpIpAddress;
import com.cisco.dcbu.lib.snmp.SnmpOID;
import com.cisco.dcbu.lib.snmp.SnmpPeer;
import com.cisco.dcbu.lib.snmp.SnmpVarBind;
import com.cisco.dcbu.lib.snmp.VarBindList;
import com.cisco.dcbu.sm.client.gui.SmTableModel;
import java.net.InetAddress;
import java.net.UnknownHostException;

public class SmEventTargetTableModel
extends SmTableModel {
    static final int ADDRESS_COL = 3;
    static final int TYPE_COL = 4;
    static final int TIMEOUT_COL = 5;
    static final int RETRY_COL = 6;

    @Override
    public boolean isCellActive(int row, int col) {
        if (col == 5 || col == 6) {
            Object o = this.getValueAt(row, 4);
            return o != null && o.toString() != null && o.toString().length() > 0 && o.toString().charAt(0) == 'i';
        }
        return super.isCellActive(row, col);
    }

    @Override
    public Object getCellDisplayString(SnmpPeer node, MibNode mibNode, VarBindList vbl, SnmpVarBind vb, String var, int row, int col, SnmpOID index, int indexOfVbl) {
        if (col == 3) {
            String s = (String)super.toCell(mibNode, vb.getVar(), var, row);
            s = s.substring(0, s.indexOf("/"));
            try {
                byte[] b = SnmpIpAddress.parse(s);
                InetAddress addr = InetAddress.getByAddress(b);
                s = addr.getHostName();
            }
            catch (UnknownHostException e) {
                DefaultLogger._DefLogger.debug((Object)e);
            }
            catch (SnmpException e) {
                DefaultLogger._DefLogger.debug((Object)e);
            }
            return s;
        }
        return super.toCell(mibNode, vb.getVar(), var, row);
    }

    @Override
    protected boolean isMIBVarCreatable(String mibName) {
        if (mibName.equals("snmpTargetAddrRowStatus")) {
            return false;
        }
        return super.isMIBVarCreatable(mibName);
    }
}

